/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import org.texboobcat.questory.Questory;
import org.texboobcat.questory.config.QuestoryConfig;
import org.texboobcat.questory.storage.StorageBackendFactory;
import org.texboobcat.questory.storage.backend.IPlayerProgressBackend;
import org.texboobcat.questory.storage.backend.ITeamStorageBackend;
import org.texboobcat.questory.storage.migration.BackupManager;
import org.texboobcat.questory.storage.migration.DataExporter;
import org.texboobcat.questory.storage.migration.StorageMigrator;

public class StorageCommands {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"questify").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"storage").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"info").executes(StorageCommands::showStorageInfo))).then(class_2170.method_9247((String)"migrate").then(class_2170.method_9244((String)"targetBackend", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            builder.suggest("json");
            builder.suggest("sqlite");
            builder.suggest("mysql");
            return builder.buildFuture();
        }).executes(StorageCommands::migrateStorage)))).then(class_2170.method_9247((String)"export").then(class_2170.method_9244((String)"targetPath", (ArgumentType)StringArgumentType.greedyString()).executes(StorageCommands::exportData)))).then(class_2170.method_9247((String)"import").then(class_2170.method_9244((String)"sourcePath", (ArgumentType)StringArgumentType.greedyString()).executes(StorageCommands::importData)))).then(class_2170.method_9247((String)"backup").executes(StorageCommands::createBackup))).then(class_2170.method_9247((String)"verify").executes(StorageCommands::verifyConnections))));
    }

    private static int showStorageInfo(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        QuestoryConfig config = QuestoryConfig.getInstance();
        source.method_9226(() -> class_2561.method_43470((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").method_27692(class_124.field_1065), false);
        source.method_9226(() -> class_2561.method_43470((String)"Storage Backend Information").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}), false);
        source.method_9226(() -> class_2561.method_43470((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").method_27692(class_124.field_1065), false);
        source.method_9226(() -> class_2561.method_43470((String)("Current Backend: " + config.storageType.toUpperCase())).method_27692(class_124.field_1054), false);
        switch (config.storageType.toLowerCase()) {
            case "sqlite": {
                source.method_9226(() -> class_2561.method_43470((String)("Database Path: " + config.sqliteDatabasePath)).method_27692(class_124.field_1068), false);
                break;
            }
            case "mysql": {
                source.method_9226(() -> class_2561.method_43470((String)("Host: " + config.mysqlHost + ":" + config.mysqlPort)).method_27692(class_124.field_1068), false);
                source.method_9226(() -> class_2561.method_43470((String)("Database: " + config.mysqlDatabase)).method_27692(class_124.field_1068), false);
                source.method_9226(() -> class_2561.method_43470((String)("Pool Size: " + config.mysqlPoolMinConnections + "-" + config.mysqlPoolMaxConnections)).method_27692(class_124.field_1068), false);
                break;
            }
            case "json": {
                source.method_9226(() -> class_2561.method_43470((String)"Storage: File-based JSON").method_27692(class_124.field_1068), false);
            }
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int migrateStorage(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        String targetBackend = StringArgumentType.getString(context, (String)"targetBackend").toLowerCase();
        if (!(targetBackend.equals("json") || targetBackend.equals("sqlite") || targetBackend.equals("mysql"))) {
            source.method_9213((class_2561)class_2561.method_43470((String)("Invalid backend: " + targetBackend + ". Must be 'json', 'sqlite', or 'mysql'")));
            return 0;
        }
        QuestoryConfig config = QuestoryConfig.getInstance();
        String currentBackend = config.storageType.toLowerCase();
        if (currentBackend.equals(targetBackend)) {
            source.method_9213((class_2561)class_2561.method_43470((String)("Already using " + targetBackend + " backend!")));
            return 0;
        }
        source.method_9226(() -> class_2561.method_43470((String)("Starting migration from " + currentBackend + " to " + targetBackend + "...")).method_27692(class_124.field_1054), true);
        try {
            Path dataPath = Questory.getDataPath();
            source.method_9226(() -> class_2561.method_43470((String)"Creating backup before migration...").method_27692(class_124.field_1054), false);
            BackupManager backupManager = new BackupManager(dataPath);
            Path backupFile = backupManager.createBackup(currentBackend);
            if (backupFile == null) {
                source.method_9213((class_2561)class_2561.method_43470((String)"Failed to create backup! Migration aborted."));
                return 0;
            }
            source.method_9226(() -> class_2561.method_43470((String)("Backup created: " + String.valueOf(backupFile.getFileName()))).method_27692(class_124.field_1060), false);
            IPlayerProgressBackend sourceProgress = StorageBackendFactory.createPlayerProgressBackend(config, dataPath);
            ITeamStorageBackend sourceTeams = StorageBackendFactory.createTeamStorageBackend(config, dataPath);
            String originalStorageType = config.storageType;
            config.storageType = targetBackend;
            try {
                IPlayerProgressBackend targetProgress = StorageBackendFactory.createPlayerProgressBackend(config, dataPath);
                ITeamStorageBackend targetTeams = StorageBackendFactory.createTeamStorageBackend(config, dataPath);
                source.method_9226(() -> class_2561.method_43470((String)"Migrating player progress...").method_27692(class_124.field_1054), false);
                boolean progressSuccess = StorageMigrator.migratePlayerProgress(sourceProgress, targetProgress, new MigrationProgressReporter(source, "players"));
                if (!progressSuccess) {
                    source.method_9213((class_2561)class_2561.method_43470((String)"Player progress migration failed! Check console for details."));
                    source.method_9226(() -> class_2561.method_43470((String)("Backup available at: " + String.valueOf(backupFile))).method_27692(class_124.field_1054), false);
                    int n = 0;
                    return n;
                }
                source.method_9226(() -> class_2561.method_43470((String)"Migrating teams...").method_27692(class_124.field_1054), false);
                boolean teamsSuccess = StorageMigrator.migrateTeams(sourceTeams, targetTeams, new MigrationProgressReporter(source, "teams"));
                if (!teamsSuccess) {
                    source.method_9213((class_2561)class_2561.method_43470((String)"Team migration failed! Check console for details."));
                    source.method_9226(() -> class_2561.method_43470((String)("Backup available at: " + String.valueOf(backupFile))).method_27692(class_124.field_1054), false);
                    int n = 0;
                    return n;
                }
                sourceProgress.disconnect();
                sourceTeams.disconnect();
                targetProgress.disconnect();
                targetTeams.disconnect();
                source.method_9226(() -> class_2561.method_43470((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").method_27692(class_124.field_1060), false);
                source.method_9226(() -> class_2561.method_43470((String)"Migration completed successfully!").method_27695(new class_124[]{class_124.field_1060, class_124.field_1067}), true);
                source.method_9226(() -> class_2561.method_43470((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").method_27692(class_124.field_1060), false);
                source.method_9226(() -> class_2561.method_43470((String)("IMPORTANT: Update your config file to set storageType to '" + targetBackend + "' and restart the server!")), false);
                source.method_9226(() -> class_2561.method_43470((String)("Backup available at: " + String.valueOf(backupFile))).method_27692(class_124.field_1080), false);
                int n = 1;
                return n;
            }
            finally {
                config.storageType = originalStorageType;
            }
        }
        catch (Exception e) {
            source.method_9213((class_2561)class_2561.method_43470((String)("Migration error: " + e.getMessage())).method_27692(class_124.field_1061));
            e.printStackTrace();
            return 0;
        }
    }

    private static int exportData(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        String targetPath = StringArgumentType.getString(context, (String)"targetPath");
        source.method_9226(() -> class_2561.method_43470((String)("Exporting data to: " + targetPath)).method_27692(class_124.field_1054), true);
        try {
            Path dataPath = Questory.getDataPath();
            Path exportDir = Paths.get(targetPath, new String[0]);
            QuestoryConfig config = QuestoryConfig.getInstance();
            IPlayerProgressBackend progressBackend = StorageBackendFactory.createPlayerProgressBackend(config, dataPath);
            ITeamStorageBackend teamBackend = StorageBackendFactory.createTeamStorageBackend(config, dataPath);
            boolean progressExported = DataExporter.exportPlayerProgress(progressBackend, exportDir);
            boolean teamsExported = DataExporter.exportTeams(teamBackend, exportDir);
            progressBackend.disconnect();
            teamBackend.disconnect();
            if (progressExported && teamsExported) {
                source.method_9226(() -> class_2561.method_43470((String)("Data exported successfully to: " + String.valueOf(exportDir))).method_27692(class_124.field_1060), true);
                return 1;
            }
            source.method_9213((class_2561)class_2561.method_43470((String)"Export failed! Check console for details."));
            return 0;
        }
        catch (Exception e) {
            source.method_9213((class_2561)class_2561.method_43470((String)("Export error: " + e.getMessage())).method_27692(class_124.field_1061));
            e.printStackTrace();
            return 0;
        }
    }

    private static int importData(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        String sourcePath = StringArgumentType.getString(context, (String)"sourcePath");
        source.method_9226(() -> class_2561.method_43470((String)("Importing data from: " + sourcePath)).method_27692(class_124.field_1054), true);
        try {
            Path dataPath = Questory.getDataPath();
            Path importDir = Paths.get(sourcePath, new String[0]);
            QuestoryConfig config = QuestoryConfig.getInstance();
            IPlayerProgressBackend progressBackend = StorageBackendFactory.createPlayerProgressBackend(config, dataPath);
            ITeamStorageBackend teamBackend = StorageBackendFactory.createTeamStorageBackend(config, dataPath);
            boolean progressImported = DataExporter.importPlayerProgress(progressBackend, importDir);
            boolean teamsImported = DataExporter.importTeams(teamBackend, importDir);
            progressBackend.disconnect();
            teamBackend.disconnect();
            if (progressImported && teamsImported) {
                source.method_9226(() -> class_2561.method_43470((String)("Data imported successfully from: " + String.valueOf(importDir))).method_27692(class_124.field_1060), true);
                return 1;
            }
            source.method_9213((class_2561)class_2561.method_43470((String)"Import failed! Check console for details."));
            return 0;
        }
        catch (Exception e) {
            source.method_9213((class_2561)class_2561.method_43470((String)("Import error: " + e.getMessage())).method_27692(class_124.field_1061));
            e.printStackTrace();
            return 0;
        }
    }

    private static int createBackup(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        try {
            Path dataPath = Questory.getDataPath();
            QuestoryConfig config = QuestoryConfig.getInstance();
            BackupManager backupManager = new BackupManager(dataPath);
            Path backupFile = backupManager.createBackup(config.storageType);
            if (backupFile != null) {
                source.method_9226(() -> class_2561.method_43470((String)("Backup created: " + String.valueOf(backupFile.getFileName()))).method_27692(class_124.field_1060), true);
                source.method_9226(() -> class_2561.method_43470((String)("Location: " + backupFile.toString())).method_27692(class_124.field_1080), false);
                return 1;
            }
            source.method_9213((class_2561)class_2561.method_43470((String)"Failed to create backup"));
            return 0;
        }
        catch (Exception e) {
            source.method_9213((class_2561)class_2561.method_43470((String)("Backup error: " + e.getMessage())).method_27692(class_124.field_1061));
            return 0;
        }
    }

    private static int verifyConnections(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        try {
            Path dataPath = Questory.getDataPath();
            QuestoryConfig config = QuestoryConfig.getInstance();
            source.method_9226(() -> class_2561.method_43470((String)"Verifying storage connections...").method_27692(class_124.field_1054), false);
            IPlayerProgressBackend progressBackend = StorageBackendFactory.createPlayerProgressBackend(config, dataPath);
            ITeamStorageBackend teamBackend = StorageBackendFactory.createTeamStorageBackend(config, dataPath);
            boolean progressHealthy = progressBackend.healthCheck();
            boolean teamsHealthy = teamBackend.healthCheck();
            source.method_9226(() -> class_2561.method_43470((String)("Player Progress Backend: " + (progressHealthy ? "\u2713 Healthy" : "\u2717 Unhealthy"))).method_27692(progressHealthy ? class_124.field_1060 : class_124.field_1061), false);
            source.method_9226(() -> class_2561.method_43470((String)("Team Storage Backend: " + (teamsHealthy ? "\u2713 Healthy" : "\u2717 Unhealthy"))).method_27692(teamsHealthy ? class_124.field_1060 : class_124.field_1061), false);
            progressBackend.disconnect();
            teamBackend.disconnect();
            return progressHealthy && teamsHealthy ? 1 : 0;
        }
        catch (Exception e) {
            source.method_9213((class_2561)class_2561.method_43470((String)("Verification error: " + e.getMessage())).method_27692(class_124.field_1061));
            e.printStackTrace();
            return 0;
        }
    }

    private static class MigrationProgressReporter
    implements StorageMigrator.MigrationProgressCallback {
        private final class_2168 source;
        private final String dataType;

        public MigrationProgressReporter(class_2168 source, String dataType) {
            this.source = source;
            this.dataType = dataType;
        }

        @Override
        public void onStart(int total) {
            this.source.method_9226(() -> class_2561.method_43470((String)("Starting migration of " + total + " " + this.dataType + "...")).method_27692(class_124.field_1054), false);
        }

        @Override
        public void onProgress(int current, int total) {
            int percentage = current * 100 / total;
            this.source.method_9226(() -> class_2561.method_43470((String)("Progress: " + current + "/" + total + " (" + percentage + "%)")).method_27692(class_124.field_1054), false);
        }

        @Override
        public void onComplete(int migrated, int errors) {
            if (errors == 0) {
                this.source.method_9226(() -> class_2561.method_43470((String)("\u2713 Successfully migrated " + migrated + " " + this.dataType)).method_27692(class_124.field_1060), false);
            } else {
                this.source.method_9226(() -> class_2561.method_43470((String)("\u26a0 Migrated " + migrated + " " + this.dataType + " with " + errors + " errors")).method_27692(class_124.field_1054), false);
            }
        }

        @Override
        public void onError(Exception e) {
            this.source.method_9213((class_2561)class_2561.method_43470((String)("Migration error: " + e.getMessage())).method_27692(class_124.field_1061));
        }
    }
}

