/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.events;

import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5138;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.texboobcat.questory.Questory;
import org.texboobcat.questory.api.events.QuestEventBus;
import org.texboobcat.questory.api.events.QuestPreStartEvent;
import org.texboobcat.questory.api.events.QuestProgressEvent;
import org.texboobcat.questory.api.events.QuestRequirementPreProgressEvent;
import org.texboobcat.questory.api.events.QuestStartedEvent;
import org.texboobcat.questory.config.QuestoryConfig;
import org.texboobcat.questory.manager.QuestManager;
import org.texboobcat.questory.manager.TriggerListenerManager;
import org.texboobcat.questory.network.NetworkManager;
import org.texboobcat.questory.network.ProgressSyncPacket;
import org.texboobcat.questory.quest.BiomeRequirement;
import org.texboobcat.questory.quest.DimensionRequirement;
import org.texboobcat.questory.quest.EquipItemRequirement;
import org.texboobcat.questory.quest.GenericTriggerRequirement;
import org.texboobcat.questory.quest.ItemRequirement;
import org.texboobcat.questory.quest.ItemTagRequirement;
import org.texboobcat.questory.quest.LocationRequirement;
import org.texboobcat.questory.quest.ObservationRequirement;
import org.texboobcat.questory.quest.Quest;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.quest.RegionRequirement;
import org.texboobcat.questory.quest.Requirement;
import org.texboobcat.questory.quest.StageRequirement;
import org.texboobcat.questory.quest.StructureRequirement;
import org.texboobcat.questory.quest.TimeRequirement;
import org.texboobcat.questory.quest.WeatherRequirement;

public class QuestEvents {
    private static final Map<UUID, LookCache> LOOK_CACHE = new HashMap<UUID, LookCache>();

    public static void onItemObtained(class_3222 player, class_1799 stack) {
        if (stack.method_7960()) {
            Questory.LOGGER.debug("[Questory Debug] onItemObtained called with empty stack");
            return;
        }
        class_2960 itemId = class_7923.field_41178.method_10221((Object)stack.method_7909());
        Questory.LOGGER.debug("[Questory Debug] onItemObtained: Player={}, Item={}, Count={}", (Object)player.method_5477().getString(), (Object)itemId, (Object)stack.method_7947());
        QuestManager.getInstance().trackItemProgress(player.method_5667(), itemId.toString(), stack.method_7947(), player);
        QuestManager.getInstance().trackItemTagProgress(player.method_5667(), itemId.toString(), stack.method_7947(), player);
    }

    public static void onItemCrafted(class_3222 player, class_1799 stack) {
        if (stack.method_7960()) {
            return;
        }
        QuestEvents.onItemsCrafted(player, stack, stack.method_7947());
    }

    public static void onItemsCrafted(class_3222 player, class_1799 stack, int totalCount) {
        if (stack.method_7960()) {
            return;
        }
        int amount = Math.max(1, totalCount);
        class_2960 itemId = class_7923.field_41178.method_10221((Object)stack.method_7909());
        if (QuestoryConfig.getInstance().debugMode) {
            Questory.LOGGER.debug("[Questory Debug] onItemsCrafted: Player={}, Item={}, Count={}", (Object)player.method_5477().getString(), (Object)itemId, (Object)amount);
        }
        QuestManager.getInstance().trackCraftingProgress(player.method_5667(), itemId.toString(), amount, player);
        class_1799 copy = stack.method_7972();
        copy.method_7939(amount);
        QuestEvents.onItemObtained(player, copy);
    }

    public static void onEntityKilled(class_3222 player, class_1309 entity) {
        class_2960 entityId = class_7923.field_41177.method_10221((Object)entity.method_5864());
        QuestManager.getInstance().trackEntityKillProgress(player.method_5667(), entityId.toString(), 1, player);
    }

    public static void onAdvancementEarned(class_3222 player, class_2960 advancementId) {
        QuestManager.getInstance().trackAdvancementProgress(player.method_5667(), advancementId.toString(), player);
    }

    public static void onPlayerDisconnect(class_3222 player) {
        QuestManager.getInstance().onPlayerDisconnect(player.method_5667());
        TriggerListenerManager.getInstance().onPlayerDisconnect(player.method_5667());
        try {
            LOOK_CACHE.remove(player.method_5667());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void onPlayerJoin(class_3222 player) {
        QuestManager.getInstance().onPlayerJoin(player);
        QuestManager manager = QuestManager.getInstance();
        QuestProgress progress = manager.getProgress(player.method_5667());
        for (Quest quest : manager.getAllQuests()) {
            if (progress.isQuestCompleted(quest.getId()) || !quest.isVisible(progress)) continue;
            for (Requirement req : quest.getRequirements()) {
                if (!(req instanceof GenericTriggerRequirement)) continue;
                GenericTriggerRequirement trigReq = (GenericTriggerRequirement)req;
                trigReq.startListening(player, quest.getId());
            }
        }
    }

    public static void onInventoryChanged(class_3222 player) {
        QuestManager manager = QuestManager.getInstance();
        QuestProgress progress = manager.getProgress(player.method_5667());
        boolean changed = false;
        for (Quest quest : manager.getAllQuests()) {
            if (progress.isQuestCompleted(quest.getId())) continue;
            for (Requirement req : quest.getRequirements()) {
                int existing;
                int before;
                int cap;
                int invCount;
                if (req instanceof ItemRequirement) {
                    ItemRequirement itemReq = (ItemRequirement)req;
                    invCount = QuestEvents.countItemInInventory(player, itemReq.getItem());
                    cap = Math.min(invCount, itemReq.getCount());
                    if (!itemReq.shouldConsume()) {
                        before = progress.getRequirementProgress(quest.getId(), req);
                        if (before == cap) continue;
                        progress.setRequirementProgress(quest.getId(), req, cap);
                        changed = true;
                        continue;
                    }
                    existing = progress.getRequirementProgress(quest.getId(), req);
                    if (cap <= existing) continue;
                    progress.setRequirementProgress(quest.getId(), req, cap);
                    changed = true;
                    continue;
                }
                if (!(req instanceof ItemTagRequirement)) continue;
                ItemTagRequirement tagReq = (ItemTagRequirement)req;
                invCount = QuestEvents.countItemTagInInventory(player, tagReq.getTag());
                cap = Math.min(invCount, tagReq.getCount());
                if (!tagReq.shouldConsume()) {
                    before = progress.getRequirementProgress(quest.getId(), req);
                    if (before == cap) continue;
                    progress.setRequirementProgress(quest.getId(), req, cap);
                    changed = true;
                    continue;
                }
                existing = progress.getRequirementProgress(quest.getId(), req);
                if (cap <= existing) continue;
                progress.setRequirementProgress(quest.getId(), req, cap);
                changed = true;
            }
        }
        if (changed) {
            NetworkManager.sendToClient(player, new ProgressSyncPacket(progress));
        }
    }

    private static int countItemInInventory(class_3222 player, String itemIdString) {
        class_2960 itemId = new class_2960(itemIdString);
        class_1792 item = (class_1792)class_7923.field_41178.method_10223(itemId);
        if (item == null) {
            return 0;
        }
        int total = 0;
        for (class_1799 stack : player.method_31548().field_7547) {
            if (stack.method_7960() || stack.method_7909() != item) continue;
            total += stack.method_7947();
        }
        return total;
    }

    private static int countItemTagInInventory(class_3222 player, String tagId) {
        class_6862 key = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960(tagId));
        int total = 0;
        for (class_1799 stack : player.method_31548().field_7547) {
            if (stack.method_7960() || !stack.method_31573(key)) continue;
            total += stack.method_7947();
        }
        return total;
    }

    public static void onStatisticChanged(class_3222 player, String statistic, int value) {
        QuestManager.getInstance().trackStatisticProgress(player.method_5667(), statistic, value, player);
    }

    public static void onEnvironmentTick(class_3222 player) {
        QuestManager manager = QuestManager.getInstance();
        QuestProgress progress = manager.getProgress(player.method_5667());
        boolean changed = false;
        class_3218 level = player.method_51469();
        class_2338 pos = player.method_24515();
        class_2378 biomeRegistry = level.method_30349().method_30530(class_7924.field_41236);
        class_2960 biomeId = biomeRegistry.method_10221((Object)((class_1959)level.method_23753(pos).comp_349()));
        String dimId = level.method_27983().method_29177().toString();
        long dayTime = level.method_8532() % 24000L;
        boolean isRaining = level.method_8419();
        boolean isThundering = level.method_8546();
        boolean needObsEntity = false;
        boolean needObsBlock = false;
        boolean needObsItemHand = false;
        boolean needObsItemEntity = false;
        QuestoryConfig cfg = QuestoryConfig.getInstance();
        if (cfg.observationEnabled && QuestManager.getInstance().hasObservationRequirements()) {
            Collection<Quest> questsForFlags = cfg.environmentOnlyVisibleQuests ? manager.getVisibleQuests(player.method_5667()) : manager.getAllQuests();
            for (Quest q : questsForFlags) {
                if (progress.isQuestCompleted(q.getId())) continue;
                for (Requirement r : q.getRequirements()) {
                    if (!(r instanceof ObservationRequirement)) continue;
                    ObservationRequirement or = (ObservationRequirement)r;
                    if (progress.getRequirementProgress(q.getId(), r) >= or.getTimer()) continue;
                    switch (String.valueOf(or.getObserveType())) {
                        case "entity": {
                            needObsEntity = true;
                            break;
                        }
                        case "block": {
                            needObsBlock = true;
                            break;
                        }
                        case "item_hand": {
                            needObsItemHand = true;
                            break;
                        }
                        case "item_entity": {
                            needObsItemEntity = true;
                        }
                    }
                }
            }
        }
        if (!cfg.observationEnabled) {
            needObsItemEntity = false;
            needObsItemHand = false;
            needObsBlock = false;
            needObsEntity = false;
        }
        double MAX_LOOK_DIST = Math.max(1.0, cfg.observationMaxLookDistance);
        class_1297 lookedEntity = null;
        class_2960 lookedEntityTypeId = null;
        class_2960 lookedBlockId = null;
        String handItemId = null;
        String lookedItemEntityItemId = null;
        if (needObsEntity || needObsBlock || needObsItemHand || needObsItemEntity) {
            LookCache cache = LOOK_CACHE.computeIfAbsent(player.method_5667(), k -> new LookCache());
            class_243 nowPos = player.method_5836(1.0f);
            class_243 nowDir = player.method_5828(1.0f);
            String nowHand = player.method_6047().method_7960() ? null : class_7923.field_41178.method_10221((Object)player.method_6047().method_7909()).toString();
            boolean posSame = cache.pos != null && cache.pos.method_1025(nowPos) < 1.0E-4;
            boolean dirSame = cache.dir != null && cache.dir.method_1025(nowDir) < 1.0E-4;
            boolean handSame = Objects.equals(cache.handItemId, nowHand);
            if (posSame && dirSame && handSame) {
                lookedEntityTypeId = cache.entityTypeId;
                lookedBlockId = cache.blockId;
                lookedItemEntityItemId = cache.itemEntityItemId;
                handItemId = cache.handItemId;
            } else {
                if (needObsEntity || needObsItemEntity) {
                    class_1542 ie;
                    class_1799 is;
                    lookedEntity = QuestEvents.getLookedEntity(player, MAX_LOOK_DIST);
                    class_2960 class_29602 = lookedEntityTypeId = lookedEntity != null ? class_7923.field_41177.method_10221((Object)lookedEntity.method_5864()) : null;
                    if (lookedEntity instanceof class_1542 && !(is = (ie = (class_1542)lookedEntity).method_6983()).method_7960()) {
                        lookedItemEntityItemId = class_7923.field_41178.method_10221((Object)is.method_7909()).toString();
                    }
                }
                if (needObsBlock) {
                    lookedBlockId = QuestEvents.getLookedBlock(level, player, MAX_LOOK_DIST);
                }
                handItemId = needObsItemHand ? nowHand : nowHand;
                cache.pos = nowPos;
                cache.dir = nowDir;
                cache.handItemId = handItemId;
                cache.entityTypeId = lookedEntityTypeId;
                cache.blockId = lookedBlockId;
                cache.itemEntityItemId = lookedItemEntityItemId;
            }
            if (needObsEntity || needObsItemEntity) {
                class_1542 ie2;
                class_1799 is2;
                lookedEntity = QuestEvents.getLookedEntity(player, MAX_LOOK_DIST);
                lookedEntityTypeId = lookedEntity != null ? class_7923.field_41177.method_10221((Object)lookedEntity.method_5864()) : null;
                lookedItemEntityItemId = null;
                if (lookedEntity instanceof class_1542 && !(is2 = (ie2 = (class_1542)lookedEntity).method_6983()).method_7960()) {
                    lookedItemEntityItemId = class_7923.field_41178.method_10221((Object)is2.method_7909()).toString();
                }
                cache.entityTypeId = lookedEntityTypeId;
                cache.itemEntityItemId = lookedItemEntityItemId;
            }
        }
        if (needObsEntity || needObsBlock || needObsItemHand || needObsItemEntity) {
            for (QuestManager.QuestRequirementRef ref : manager.getObservationRequirements()) {
                Requirement posSame;
                Quest quest = ref.quest;
                if (progress.isQuestCompleted(quest.getId()) || cfg.environmentOnlyVisibleQuests && !quest.isVisible(progress) || !((posSame = ref.requirement) instanceof ObservationRequirement)) continue;
                ObservationRequirement obsReq = (ObservationRequirement)posSame;
                int before = progress.getRequirementProgress(quest.getId(), ref.requirement);
                if (before >= obsReq.getTimer()) continue;
                boolean match = false;
                String target = obsReq.getTargetId();
                String type = obsReq.getObserveType();
                String normalized = QuestEvents.normalizeId(target);
                if ("entity".equalsIgnoreCase(type)) {
                    match = lookedEntityTypeId != null && QuestEvents.normalizeId(lookedEntityTypeId.toString()).equals(normalized);
                } else if ("block".equalsIgnoreCase(type)) {
                    match = lookedBlockId != null && QuestEvents.normalizeId(lookedBlockId.toString()).equals(normalized);
                } else if ("item_hand".equalsIgnoreCase(type)) {
                    match = handItemId != null && QuestEvents.normalizeId(handItemId).equals(normalized);
                } else if ("item_entity".equalsIgnoreCase(type)) {
                    boolean bl = match = lookedItemEntityItemId != null && QuestEvents.normalizeId(lookedItemEntityItemId).equals(normalized);
                }
                if (match) {
                    boolean anyBefore = QuestEvents.hasAnyProgress(progress, quest);
                    int increment = Math.max(1, cfg.observationScanIntervalTicks);
                    int now = Math.min(obsReq.getTimer(), before + increment);
                    if (now == before) continue;
                    progress.setRequirementProgress(quest.getId(), ref.requirement, now);
                    changed = true;
                    try {
                        QuestEventBus.post(new QuestProgressEvent(player, quest, ref.requirement, before, now));
                        if (!anyBefore && now > 0) {
                            QuestEventBus.post(new QuestStartedEvent(player, quest));
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (!QuestoryConfig.getInstance().debugMode) continue;
                    Questory.LOGGER.debug("[Questory Debug] Observation matched: type={}, target={}, lookedEntity={}, lookedBlock={}, hand={}, itemEntity={}, now={}/{}", (Object)type, (Object)target, lookedEntityTypeId != null ? lookedEntityTypeId : "null", lookedBlockId != null ? lookedBlockId : "null", (Object)handItemId, (Object)lookedItemEntityItemId, (Object)now, (Object)obsReq.getTimer());
                    continue;
                }
                if (!QuestoryConfig.getInstance().debugMode) continue;
                Questory.LOGGER.debug("[Questory Debug] Observation no match: type={}, target={}, lookedEntity={}, lookedBlock={}, hand={}, itemEntity={}", (Object)type, (Object)target, lookedEntityTypeId != null ? lookedEntityTypeId : "null", lookedBlockId != null ? lookedBlockId : "null", (Object)handItemId, (Object)lookedItemEntityItemId);
            }
        }
        Collection<Quest> mainQuestList = cfg.environmentOnlyVisibleQuests ? manager.getVisibleQuests(player.method_5667()) : manager.getAllQuests();
        for (Quest quest : mainQuestList) {
            if (progress.isQuestCompleted(quest.getId())) continue;
            for (Requirement req : quest.getRequirements()) {
                boolean dimOk;
                boolean anyBefore;
                boolean ok;
                if (req instanceof BiomeRequirement) {
                    BiomeRequirement biomeReq = (BiomeRequirement)req;
                    if (biomeReq.isTag()) {
                        class_6862 key = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)new class_2960(biomeReq.getBiomeId().substring(1)));
                        ok = level.method_23753(pos).method_40220(key);
                    } else {
                        ok = biomeId != null && biomeId.toString().equals(biomeReq.getBiomeId());
                    }
                    int before = progress.getRequirementProgress(quest.getId(), req);
                    anyBefore = QuestEvents.hasAnyProgress(progress, quest);
                    int now = ok ? 1 : 0;
                    if (before == now) continue;
                    if (now > before) {
                        try {
                            QuestRequirementPreProgressEvent pre = new QuestRequirementPreProgressEvent(player, quest, req, now - before);
                            QuestEventBus.post(pre);
                            if (pre.isCanceled()) continue;
                            if (!anyBefore && pre.getDelta() > 0) {
                                QuestPreStartEvent preStart = new QuestPreStartEvent(player, quest);
                                QuestEventBus.post(preStart);
                                if (preStart.isCanceled()) {
                                    continue;
                                }
                            }
                        }
                        catch (Throwable pre) {
                            // empty catch block
                        }
                    }
                    progress.setRequirementProgress(quest.getId(), req, now);
                    changed = true;
                    try {
                        QuestEventBus.post(new QuestProgressEvent(player, quest, req, before, now));
                        if (anyBefore || now <= 0) continue;
                        QuestEventBus.post(new QuestStartedEvent(player, quest));
                    }
                    catch (Throwable pre) {}
                    continue;
                }
                if (req instanceof DimensionRequirement) {
                    DimensionRequirement dimReq = (DimensionRequirement)req;
                    ok = dimId.equals(dimReq.getDimensionId());
                    int before = progress.getRequirementProgress(quest.getId(), req);
                    anyBefore = QuestEvents.hasAnyProgress(progress, quest);
                    int now = ok ? 1 : 0;
                    if (before == now) continue;
                    if (now > before) {
                        try {
                            QuestRequirementPreProgressEvent pre = new QuestRequirementPreProgressEvent(player, quest, req, now - before);
                            QuestEventBus.post(pre);
                            if (pre.isCanceled()) continue;
                            if (!anyBefore && pre.getDelta() > 0) {
                                QuestPreStartEvent preStart = new QuestPreStartEvent(player, quest);
                                QuestEventBus.post(preStart);
                                if (preStart.isCanceled()) {
                                    continue;
                                }
                            }
                        }
                        catch (Throwable pre) {
                            // empty catch block
                        }
                    }
                    progress.setRequirementProgress(quest.getId(), req, now);
                    changed = true;
                    try {
                        QuestEventBus.post(new QuestProgressEvent(player, quest, req, before, now));
                        if (anyBefore || now <= 0) continue;
                        QuestEventBus.post(new QuestStartedEvent(player, quest));
                    }
                    catch (Throwable pre) {}
                    continue;
                }
                if (req instanceof LocationRequirement) {
                    int r;
                    int dz;
                    int dy;
                    LocationRequirement locReq = (LocationRequirement)req;
                    dimOk = locReq.getDimension().equals(dimId);
                    if (!dimOk) continue;
                    int dx = pos.method_10263() - locReq.getX();
                    boolean ok2 = dx * dx + (dy = pos.method_10264() - locReq.getY()) * dy + (dz = pos.method_10260() - locReq.getZ()) * dz <= (r = locReq.getRange()) * r;
                    int before = progress.getRequirementProgress(quest.getId(), req);
                    boolean anyBefore2 = QuestEvents.hasAnyProgress(progress, quest);
                    int now = ok2 ? 1 : 0;
                    if (before == now) continue;
                    if (now > before) {
                        try {
                            QuestRequirementPreProgressEvent pre = new QuestRequirementPreProgressEvent(player, quest, req, now - before);
                            QuestEventBus.post(pre);
                            if (pre.isCanceled()) continue;
                            if (!anyBefore2 && pre.getDelta() > 0) {
                                QuestPreStartEvent preStart = new QuestPreStartEvent(player, quest);
                                QuestEventBus.post(preStart);
                                if (preStart.isCanceled()) {
                                    continue;
                                }
                            }
                        }
                        catch (Throwable pre) {
                            // empty catch block
                        }
                    }
                    progress.setRequirementProgress(quest.getId(), req, now);
                    changed = true;
                    try {
                        QuestEventBus.post(new QuestProgressEvent(player, quest, req, before, now));
                        if (anyBefore2 || now <= 0) continue;
                        QuestEventBus.post(new QuestStartedEvent(player, quest));
                    }
                    catch (Throwable pre) {}
                    continue;
                }
                if (req instanceof RegionRequirement) {
                    RegionRequirement regReq = (RegionRequirement)req;
                    dimOk = regReq.getDimension().equals(dimId);
                    boolean in = dimOk && pos.method_10263() >= regReq.getMinX() && pos.method_10263() <= regReq.getMaxX() && pos.method_10264() >= regReq.getMinY() && pos.method_10264() <= regReq.getMaxY() && pos.method_10260() >= regReq.getMinZ() && pos.method_10260() <= regReq.getMaxZ();
                    int before = progress.getRequirementProgress(quest.getId(), req);
                    boolean anyBefore3 = QuestEvents.hasAnyProgress(progress, quest);
                    int now = in ? 1 : 0;
                    if (before == now) continue;
                    if (now > before) {
                        try {
                            QuestRequirementPreProgressEvent pre = new QuestRequirementPreProgressEvent(player, quest, req, now - before);
                            QuestEventBus.post(pre);
                            if (pre.isCanceled()) continue;
                            if (!anyBefore3 && pre.getDelta() > 0) {
                                QuestPreStartEvent preStart = new QuestPreStartEvent(player, quest);
                                QuestEventBus.post(preStart);
                                if (preStart.isCanceled()) {
                                    continue;
                                }
                            }
                        }
                        catch (Throwable pre) {
                            // empty catch block
                        }
                    }
                    progress.setRequirementProgress(quest.getId(), req, now);
                    changed = true;
                    try {
                        QuestEventBus.post(new QuestProgressEvent(player, quest, req, before, now));
                        if (anyBefore3 || now <= 0) continue;
                        QuestEventBus.post(new QuestStartedEvent(player, quest));
                    }
                    catch (Throwable pre) {}
                    continue;
                }
                if (req instanceof TimeRequirement) {
                    long end;
                    TimeRequirement timeReq = (TimeRequirement)req;
                    long start = timeReq.getStart();
                    boolean inWindow = start <= (end = timeReq.getEnd()) ? dayTime >= start && dayTime <= end : dayTime >= start || dayTime <= end;
                    int before = progress.getRequirementProgress(quest.getId(), req);
                    boolean anyBefore4 = QuestEvents.hasAnyProgress(progress, quest);
                    int now = inWindow ? 1 : 0;
                    if (before == now) continue;
                    if (now > before) {
                        try {
                            QuestRequirementPreProgressEvent pre = new QuestRequirementPreProgressEvent(player, quest, req, now - before);
                            QuestEventBus.post(pre);
                            if (pre.isCanceled()) continue;
                            if (!anyBefore4 && pre.getDelta() > 0) {
                                QuestPreStartEvent preStart = new QuestPreStartEvent(player, quest);
                                QuestEventBus.post(preStart);
                                if (preStart.isCanceled()) {
                                    continue;
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    progress.setRequirementProgress(quest.getId(), req, now);
                    changed = true;
                    try {
                        QuestEventBus.post(new QuestProgressEvent(player, quest, req, before, now));
                        if (anyBefore4 || now <= 0) continue;
                        QuestEventBus.post(new QuestStartedEvent(player, quest));
                    }
                    catch (Throwable throwable) {}
                    continue;
                }
                if (req instanceof WeatherRequirement) {
                    WeatherRequirement weatherReq = (WeatherRequirement)req;
                    ok = switch (weatherReq.getMode()) {
                        default -> throw new IncompatibleClassChangeError();
                        case WeatherRequirement.Mode.CLEAR -> {
                            if (!isRaining && !isThundering) {
                                yield true;
                            }
                            yield false;
                        }
                        case WeatherRequirement.Mode.RAIN -> {
                            if (isRaining && !isThundering) {
                                yield true;
                            }
                            yield false;
                        }
                        case WeatherRequirement.Mode.THUNDER -> isThundering;
                    };
                    int before = progress.getRequirementProgress(quest.getId(), req);
                    anyBefore = QuestEvents.hasAnyProgress(progress, quest);
                    int now = ok ? 1 : 0;
                    if (before == now) continue;
                    if (now > before) {
                        try {
                            QuestRequirementPreProgressEvent pre = new QuestRequirementPreProgressEvent(player, quest, req, now - before);
                            QuestEventBus.post(pre);
                            if (pre.isCanceled()) continue;
                            if (!anyBefore && pre.getDelta() > 0) {
                                QuestPreStartEvent preStart = new QuestPreStartEvent(player, quest);
                                QuestEventBus.post(preStart);
                                if (preStart.isCanceled()) {
                                    continue;
                                }
                            }
                        }
                        catch (Throwable pre) {
                            // empty catch block
                        }
                    }
                    progress.setRequirementProgress(quest.getId(), req, now);
                    changed = true;
                    try {
                        QuestEventBus.post(new QuestProgressEvent(player, quest, req, before, now));
                        if (anyBefore || now <= 0) continue;
                        QuestEventBus.post(new QuestStartedEvent(player, quest));
                    }
                    catch (Throwable pre) {}
                    continue;
                }
                if (req instanceof StructureRequirement) {
                    StructureRequirement structReq = (StructureRequirement)req;
                    ok = false;
                    try {
                        class_5138 mgr = level.method_27056();
                        if (structReq.getStructureId().startsWith("#")) {
                            class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)new class_2960(structReq.getStructureId().substring(1)));
                            ok = mgr.method_41413(pos, tag).method_16657();
                        } else {
                            class_5321 key;
                            class_2378 structReg = level.method_30349().method_30530(class_7924.field_41246);
                            class_3195 structure = (class_3195)structReg.method_29107(key = class_5321.method_29179((class_5321)class_7924.field_41246, (class_2960)new class_2960(structReq.getStructureId())));
                            ok = structure != null && mgr.method_38854(pos, structure).method_16657();
                        }
                    }
                    catch (Throwable mgr) {
                        // empty catch block
                    }
                    int before = progress.getRequirementProgress(quest.getId(), req);
                    anyBefore = QuestEvents.hasAnyProgress(progress, quest);
                    int now = ok ? 1 : 0;
                    if (before == now) continue;
                    if (now > before) {
                        try {
                            QuestRequirementPreProgressEvent pre = new QuestRequirementPreProgressEvent(player, quest, req, now - before);
                            QuestEventBus.post(pre);
                            if (pre.isCanceled()) continue;
                            if (!anyBefore && pre.getDelta() > 0) {
                                QuestPreStartEvent preStart = new QuestPreStartEvent(player, quest);
                                QuestEventBus.post(preStart);
                                if (preStart.isCanceled()) {
                                    continue;
                                }
                            }
                        }
                        catch (Throwable pre) {
                            // empty catch block
                        }
                    }
                    progress.setRequirementProgress(quest.getId(), req, now);
                    changed = true;
                    try {
                        QuestEventBus.post(new QuestProgressEvent(player, quest, req, before, now));
                        if (anyBefore || now <= 0) continue;
                        QuestEventBus.post(new QuestStartedEvent(player, quest));
                    }
                    catch (Throwable pre) {}
                    continue;
                }
                if (req instanceof ObservationRequirement || !(req instanceof EquipItemRequirement)) continue;
                EquipItemRequirement equipReq = (EquipItemRequirement)req;
                if (player.field_6012 % cfg.equipmentCheckIntervalTicks != 0) continue;
                boolean allEquipped = equipReq.isEquipped((class_1657)player);
                int before = progress.getRequirementProgress(quest.getId(), req);
                anyBefore = QuestEvents.hasAnyProgress(progress, quest);
                int now = allEquipped ? equipReq.getEntries().size() : 0;
                if (before == now) continue;
                if (now > before) {
                    try {
                        QuestRequirementPreProgressEvent pre = new QuestRequirementPreProgressEvent(player, quest, req, now - before);
                        QuestEventBus.post(pre);
                        if (pre.isCanceled()) continue;
                        if (!anyBefore && pre.getDelta() > 0) {
                            QuestPreStartEvent preStart = new QuestPreStartEvent(player, quest);
                            QuestEventBus.post(preStart);
                            if (preStart.isCanceled()) {
                                continue;
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                progress.setRequirementProgress(quest.getId(), req, now);
                changed = true;
                try {
                    QuestEventBus.post(new QuestProgressEvent(player, quest, req, before, now));
                    if (anyBefore || now <= 0) continue;
                    QuestEventBus.post(new QuestStartedEvent(player, quest));
                }
                catch (Throwable throwable) {}
            }
            if (progress.isQuestCompleted(quest.getId()) || !quest.canComplete(progress)) continue;
            try {
                manager.notifyQuestReadyOnce(player, progress, quest);
            }
            catch (Throwable obsReq) {
                // empty catch block
            }
            if (!cfg.autoCompleteWhenRequirementsMet) continue;
            try {
                manager.completeQuest(player, quest.getId());
            }
            catch (Throwable t) {
                Questory.LOGGER.error("Auto-complete failed for quest {}: {}", (Object)quest.getId(), (Object)t.getMessage());
            }
        }
        if (changed) {
            NetworkManager.sendToClient(player, new ProgressSyncPacket(progress));
        }
    }

    private static boolean hasAnyProgress(QuestProgress progress, Quest quest) {
        for (Requirement r : quest.getRequirements()) {
            if (progress.getRequirementProgress(quest.getId(), r) <= 0) continue;
            return true;
        }
        return false;
    }

    public static void onStageChanged(class_3222 player, String stage, boolean added) {
        QuestManager manager = QuestManager.getInstance();
        QuestProgress progress = manager.getProgress(player.method_5667());
        boolean changed = false;
        for (Quest quest : manager.getAllQuests()) {
            if (progress.isQuestCompleted(quest.getId())) continue;
            for (Requirement req : quest.getRequirements()) {
                int newProgress;
                StageRequirement stageReq;
                if (!(req instanceof StageRequirement) || !(stageReq = (StageRequirement)req).getStage().equals(stage)) continue;
                int n = newProgress = added ? 1 : 0;
                int oldProgress = progress.getRequirementProgress(quest.getId(), req);
                if (oldProgress == newProgress) continue;
                boolean anyBefore = QuestEvents.hasAnyProgress(progress, quest);
                progress.setRequirementProgress(quest.getId(), req, newProgress);
                changed = true;
                try {
                    QuestEventBus.post(new QuestProgressEvent(player, quest, req, oldProgress, newProgress));
                    if (anyBefore || newProgress <= 0) continue;
                    QuestEventBus.post(new QuestStartedEvent(player, quest));
                }
                catch (Throwable throwable) {}
            }
        }
        if (changed) {
            NetworkManager.sendToClient(player, new ProgressSyncPacket(progress));
        }
    }

    private static class_1297 getLookedEntity(class_3222 player, double maxDistance) {
        class_238 aabb;
        class_243 eyePos = player.method_5836(1.0f);
        class_243 look = player.method_5828(1.0f);
        class_243 end = eyePos.method_1031(look.field_1352 * maxDistance, look.field_1351 * maxDistance, look.field_1350 * maxDistance);
        class_3966 ehr = class_1675.method_18075((class_1297)player, (class_243)eyePos, (class_243)end, (class_238)(aabb = player.method_5829().method_18804(look.method_1021(maxDistance)).method_1014(1.0)), e -> e != null && !e.method_7325() && e.method_5863() && e != player, (double)(maxDistance * maxDistance));
        if (ehr != null) {
            return ehr.method_17782();
        }
        double cosThreshold = 0.94;
        class_1297 best = null;
        double bestDist2 = Double.MAX_VALUE;
        for (class_1297 e2 : player.method_37908().method_8333((class_1297)player, aabb, ent -> ent != null && !ent.method_7325() && ent.method_5863() && ent != player)) {
            double cos;
            class_243 to = e2.method_5829().method_1005().method_1020(eyePos);
            double dist2 = to.method_1027();
            if (dist2 > maxDistance * maxDistance || !((cos = to.method_1029().method_1026(look)) >= 0.94) || !player.method_6057(e2) || !(dist2 < bestDist2)) continue;
            best = e2;
            bestDist2 = dist2;
        }
        return best;
    }

    private static class_2960 getLookedBlock(class_3218 level, class_3222 player, double maxDistance) {
        class_243 eyePos = player.method_5836(1.0f);
        class_243 look = player.method_5828(1.0f);
        class_243 end = eyePos.method_1031(look.field_1352 * maxDistance, look.field_1351 * maxDistance, look.field_1350 * maxDistance);
        class_3965 bhr = level.method_17742(new class_3959(eyePos, end, class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)player));
        if (bhr != null && bhr.method_17783() == class_239.class_240.field_1332) {
            class_2338 bpos = bhr.method_17777();
            class_2248 block = level.method_8320(bpos).method_26204();
            return class_7923.field_41175.method_10221((Object)block);
        }
        return null;
    }

    private static String normalizeId(String id) {
        if (id == null) {
            return "";
        }
        Object s = id.trim().toLowerCase(Locale.ROOT);
        if (((String)s).isEmpty()) {
            return s;
        }
        if (!((String)s).contains(":")) {
            if (((String)s).startsWith("minecraft")) {
                String path = ((String)s).substring("minecraft".length());
                if (path.startsWith("_") || path.startsWith("/")) {
                    path = path.substring(1);
                }
                s = "minecraft:" + path;
            } else {
                s = "minecraft:" + (String)s;
            }
        }
        return s;
    }

    private static class LookCache {
        class_243 pos;
        class_243 dir;
        String handItemId;
        class_2960 entityTypeId;
        class_2960 blockId;
        String itemEntityItemId;

        private LookCache() {
        }
    }
}

