/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.events;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5903;
import net.minecraft.class_5904;
import net.minecraft.class_5905;
import org.texboobcat.questory.client.gui.TextFormatter;
import org.texboobcat.questory.config.QuestoryConfig;
import org.texboobcat.questory.quest.Quest;
import org.texboobcat.questory.quest.Reward;

public class QuestNotifications {
    public static void notifyQuestUnlocked(class_3222 player, Quest quest) {
        QuestoryConfig config = QuestoryConfig.getInstance();
        if (!config.shouldNotify("unlock")) {
            return;
        }
        if (config.shouldShowChatMessage()) {
            player.method_43496((class_2561)class_2561.method_43470((String)"New Quest Available: ").method_27692(class_124.field_1065).method_10852(TextFormatter.parse(quest.getTitle())));
        }
        if (config.shouldPlaySound()) {
            player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14709, class_3419.field_15248, 0.5f, 1.0f);
        }
    }

    public static void notifyQuestReady(class_3222 player, Quest quest) {
        QuestoryConfig config = QuestoryConfig.getInstance();
        if (!config.shouldNotify("ready")) {
            return;
        }
        if (config.shouldShowChatMessage()) {
            player.method_43496((class_2561)class_2561.method_43470((String)"\u2713 Quest Complete: ").method_27695(new class_124[]{class_124.field_1060, class_124.field_1067}).method_10852(TextFormatter.parse(quest.getTitle())));
            player.method_43496((class_2561)class_2561.method_43470((String)("  Run /quest complete " + quest.getId() + " to claim rewards")).method_27692(class_124.field_1080));
        }
        if (config.shouldPlaySound()) {
            player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_15195, class_3419.field_15248, 0.7f, 1.0f);
        }
    }

    public static void notifyQuestClaimed(class_3222 player, Quest quest) {
        QuestoryConfig config = QuestoryConfig.getInstance();
        if (!config.shouldNotify("complete")) {
            return;
        }
        if (config.shouldShowTitle()) {
            player.field_13987.method_14364((class_2596)new class_5905(10, 40, 10));
            player.field_13987.method_14364((class_2596)new class_5903(TextFormatter.parse(quest.getTitle())));
            player.field_13987.method_14364((class_2596)new class_5904((class_2561)class_2561.method_43470((String)"Quest Complete!").method_27695(new class_124[]{class_124.field_1060, class_124.field_1067})));
        }
        if (config.shouldShowChatMessage()) {
            player.method_43496((class_2561)class_2561.method_43470((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").method_27692(class_124.field_1077));
            player.method_43496((class_2561)class_2561.method_43470((String)"Quest Completed: ").method_27695(new class_124[]{class_124.field_1060, class_124.field_1067}).method_10852(TextFormatter.parse(quest.getTitle())));
            if (!quest.getRewards().isEmpty()) {
                player.method_43496((class_2561)class_2561.method_43470((String)"Rewards:").method_27692(class_124.field_1065));
                for (Reward reward : quest.getRewards()) {
                    player.method_43496((class_2561)class_2561.method_43470((String)("  \u2713 " + reward.getDisplayString())).method_27692(class_124.field_1060));
                }
            }
            player.method_43496((class_2561)class_2561.method_43470((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").method_27692(class_124.field_1077));
        }
        if (config.shouldPlaySound()) {
            player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14709, class_3419.field_15248, 1.0f, 1.0f);
        }
    }

    public static void notifyProgress(class_3222 player, Quest quest, String progressText) {
        player.method_43496((class_2561)class_2561.method_43470((String)"Quest Progress: ").method_27692(class_124.field_1054).method_10852(TextFormatter.parse(quest.getTitle())));
        player.method_43496((class_2561)class_2561.method_43470((String)("  " + progressText)).method_27692(class_124.field_1080));
    }

    public static void notifyMissingPrerequisites(class_3222 player, Quest quest) {
        player.method_43496((class_2561)class_2561.method_43470((String)("Cannot start quest: " + quest.getTitle())).method_27692(class_124.field_1061));
        player.method_43496((class_2561)class_2561.method_43470((String)"  Complete prerequisite quests first").method_27692(class_124.field_1080));
    }

    public static void notifyQuestsUnlockedBatch(class_3222 player, List<Quest> quests) {
        QuestoryConfig config = QuestoryConfig.getInstance();
        if (!config.shouldNotify("unlock")) {
            return;
        }
        if (quests.isEmpty()) {
            return;
        }
        if (config.shouldShowChatMessage()) {
            player.method_43496((class_2561)class_2561.method_43470((String)"New Quests Available: ").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(quests.size())).method_27695(new class_124[]{class_124.field_1054, class_124.field_1067})));
            int limit = Math.min(5, quests.size());
            for (int i = 0; i < limit; ++i) {
                player.method_43496((class_2561)class_2561.method_43470((String)"  \u2022 ").method_27692(class_124.field_1080).method_10852(TextFormatter.parse(quests.get(i).getTitle())));
            }
            if (quests.size() > limit) {
                player.method_43496((class_2561)class_2561.method_43470((String)("  ... and " + (quests.size() - limit) + " more")).method_27692(class_124.field_1080));
            }
        }
        if (config.shouldPlaySound()) {
            player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14709, class_3419.field_15248, 0.5f, 1.0f);
        }
    }
}

