/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.fabric;

import com.mojang.brigadier.CommandDispatcher;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1309;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import org.texboobcat.questory.Questory;
import org.texboobcat.questory.commands.QuestCommands;
import org.texboobcat.questory.commands.StorageCommands;
import org.texboobcat.questory.commands.TeamCommands;
import org.texboobcat.questory.config.QuestoryConfig;
import org.texboobcat.questory.events.QuestEvents;
import org.texboobcat.questory.fabric.integration.GameStagesIntegrationFabric;
import org.texboobcat.questory.integration.GameStagesHelper;
import org.texboobcat.questory.integration.NoOpGameStagesHelper;
import org.texboobcat.questory.manager.DailyQuestManager;
import org.texboobcat.questory.manager.QuestManager;
import org.texboobcat.questory.team.TeamManager;

public final class QuestoryFabric
implements ModInitializer {
    public void onInitialize() {
        Questory.LOGGER.debug("[Questify Debug] Questory Fabric.onInitialize starting...");
        Questory.init();
        try {
            GameStagesHelper.setInstance(new GameStagesIntegrationFabric());
        }
        catch (Throwable e) {
            Questory.LOGGER.error("[Questory] Failed to initialize GameStages integration: {}", (Object)e.getMessage(), (Object)e);
            GameStagesHelper.setInstance(new NoOpGameStagesHelper());
        }
        Questory.initQuestSystem(FabricLoader.getInstance().getGameDir());
        Questory.LOGGER.debug("[Questify Debug] Quest system initialized");
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            Questory.LOGGER.debug("[Questify Debug] Server starting, reinitializing progress storage for world: {}", (Object)server.method_27050(class_5218.field_24188));
            QuestManager.getInstance().reinitializeProgressStorage(server.method_27050(class_5218.field_24188).resolve("data").resolve("questory"));
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            Questory.LOGGER.info("[Questory] Server stopping - saving team data...");
            try {
                QuestoryConfig cfg = QuestoryConfig.getInstance();
                if (cfg.teamSystemEnabled) {
                    TeamManager.getInstance().saveAll();
                    Questory.LOGGER.info("[Questory] Team data saved successfully");
                }
            }
            catch (Throwable t) {
                Questory.LOGGER.error("[Questory] Failed to save team data: {}", (Object)t.getMessage(), (Object)t);
            }
        });
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            QuestCommands.register((CommandDispatcher<class_2168>)dispatcher);
            TeamCommands.register((CommandDispatcher<class_2168>)dispatcher);
            StorageCommands.register((CommandDispatcher<class_2168>)dispatcher);
        });
        ServerLivingEntityEvents.AFTER_DEATH.register((entity, damageSource) -> {
            if (damageSource.method_5529() instanceof class_3222 && entity instanceof class_1309) {
                class_3222 player = (class_3222)damageSource.method_5529();
                class_1309 living = entity;
                QuestEvents.onEntityKilled(player, living);
            }
        });
        ServerPlayerEvents.AFTER_RESPAWN.register((oldPlayer, newPlayer, alive) -> QuestEvents.onInventoryChanged(newPlayer));
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> QuestEvents.onPlayerJoin(handler.method_32311()));
        Questory.LOGGER.debug("[Questify Debug] All event handlers registered");
        Questory.LOGGER.debug("[Questify Debug] Questory Fabric initialization complete!");
        int[] invScanTicker = new int[]{0};
        int[] envScanTicker = new int[]{0};
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            int interval;
            DailyQuestManager.getInstance().onServerTick(server);
            invScanTicker[0] = invScanTicker[0] + 1;
            if (invScanTicker[0] >= 5) {
                invScanTicker[0] = 0;
                for (class_3222 player : server.method_3760().method_14571()) {
                    QuestEvents.onInventoryChanged(player);
                }
            }
            if ((envScanTicker[0] = envScanTicker[0] + 1) >= (interval = Math.max(1, QuestoryConfig.getInstance().observationScanIntervalTicks))) {
                envScanTicker[0] = 0;
            }
            for (class_3222 player : server.method_3760().method_14571()) {
                int offset = (player.method_5667().hashCode() & Integer.MAX_VALUE) % interval;
                if (envScanTicker[0] != offset) continue;
                QuestEvents.onEnvironmentTick(player);
            }
        });
    }
}

