/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.fabric.client;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.jetbrains.annotations.NotNull;
import org.texboobcat.questory.Questory;
import org.texboobcat.questory.config.QuestoryConfig;
import org.texboobcat.questory.theme.QuestTheme;
import org.texboobcat.questory.theme.ThemeLoader;

public class ClientThemeReloadListener
implements SimpleSynchronousResourceReloadListener {
    private static final class_2960 THEME_RL = new class_2960("ftbquests", "ftb_quests_theme.txt");

    @NotNull
    public class_2960 getFabricId() {
        return new class_2960("questory", "client_theme_reload");
    }

    public void method_14491(class_3300 manager) {
        QuestoryConfig config = QuestoryConfig.getInstance();
        if (config.customThemeName != null && !config.customThemeName.trim().isEmpty()) {
            try {
                Path themesDir = Paths.get("config", "questory", "themes");
                Path customThemePath = themesDir.resolve(config.customThemeName.trim() + ".txt");
                if (Files.exists(customThemePath, new LinkOption[0])) {
                    QuestTheme theme;
                    QuestTheme.instance = theme = ThemeLoader.loadTheme(customThemePath);
                    QuestTheme.instance.clearCache();
                    Questory.LOGGER.info("[Questory] Loaded custom theme: {}", (Object)config.customThemeName);
                    return;
                }
                Questory.LOGGER.info("[Questory] Custom theme not found: {}, falling back to resource pack theme", (Object)customThemePath);
            }
            catch (Throwable t) {
                Questory.LOGGER.error("[Questory] Failed to load custom theme: {}", (Object)t.getMessage(), (Object)t);
            }
        }
        try {
            if (manager != null) {
                ArrayList<String> combined = new ArrayList<String>();
                for (class_3298 res : manager.method_14489(THEME_RL)) {
                    try (BufferedReader br = new BufferedReader(new InputStreamReader(res.method_14482(), StandardCharsets.UTF_8));){
                        combined.addAll(br.lines().collect(Collectors.toList()));
                        combined.add("");
                    }
                }
                if (!combined.isEmpty()) {
                    QuestTheme theme;
                    QuestTheme.instance = theme = ThemeLoader.parseTheme(combined);
                    QuestTheme.instance.clearCache();
                    Questory.LOGGER.info("[Questory] Loaded theme from ResourceManager: {}", (Object)THEME_RL);
                    return;
                }
            }
        }
        catch (Throwable t) {
            Questory.LOGGER.error("[Questory] Failed to load theme from ResourceManager: {}", (Object)t.getMessage(), (Object)t);
        }
        if (QuestTheme.instance == null) {
            QuestTheme.instance = ThemeLoader.createDefaultTheme();
        }
    }
}

