/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.theme.selector;

import org.texboobcat.questory.quest.Quest;
import org.texboobcat.questory.theme.selector.ThemeSelector;

public class TypeSelector
implements ThemeSelector {
    private final Kind kind;

    public TypeSelector(String type) {
        this.kind = TypeSelector.parse(type);
    }

    private static Kind parse(String type) {
        String t;
        return switch (t = type == null ? "" : type.trim().toLowerCase()) {
            case "chapter", "chapters" -> Kind.CHAPTER;
            default -> Kind.QUEST;
        };
    }

    @Override
    public boolean matches(Quest quest) {
        return switch (this.kind.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> true;
            case 1 -> quest != null && quest.getChapterId() != null && !quest.getChapterId().isEmpty();
        };
    }

    @Override
    public int getPriority() {
        return 50;
    }

    public String toString() {
        return "type:" + this.kind.name().toLowerCase();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof TypeSelector)) return false;
        TypeSelector other = (TypeSelector)obj;
        if (other.kind != this.kind) return false;
        return true;
    }

    public int hashCode() {
        return this.kind.hashCode();
    }

    public static enum Kind {
        QUEST,
        CHAPTER;

    }
}

