/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import org.texboobcat.questory.client.gui.QuestEditorScreen;
import org.texboobcat.questory.client.gui.TabPanel;
import org.texboobcat.questory.quest.Quest;

public class AdvancedTabPanel
extends TabPanel {
    private Button optionalBtn;
    private Button canRepeatBtn;
    private Button ignoreRewardBlockingBtn;
    private boolean optional = false;
    private String canRepeat = "default";
    private boolean ignoreRewardBlocking = false;
    private Button hideUntilDepsVisibleBtn;
    private Button hideUntilDepsCompleteBtn;
    private Button invisibleUntilCompletedBtn;
    private Button hideLockIconBtn;
    private boolean hideUntilDepsVisible = false;
    private boolean hideUntilDepsComplete = false;
    private boolean invisibleUntilCompleted = false;
    private boolean hideLockIcon = false;
    private EditBox minRequiredDepsField;
    private EditBox maxCompletableDepsField;
    private Button progressionModeBtn;
    private String progressionMode = "default";
    private EditBox minWidthField;
    private Button hideDependentLinesBtn;
    private boolean hideDependentLines = false;

    public AdvancedTabPanel(QuestEditorScreen editor, int x, int y, int w, int h) {
        super(editor, x, y, w, h);
        this.initWidgets();
    }

    private void initWidgets() {
        int fieldX = this.x + 160;
        int fieldY = this.y + 32;
        int btnW = 120;
        this.optionalBtn = Button.m_253074_((Component)Component.m_237113_((String)"Optional: No"), b -> {
            this.optional = !this.optional;
            this.optionalBtn.m_93666_((Component)Component.m_237113_((String)("Optional: " + (this.optional ? "Yes" : "No"))));
        }).m_252987_(fieldX, fieldY, btnW, 18).m_253136_();
        this.canRepeatBtn = Button.m_253074_((Component)Component.m_237113_((String)"Can Repeat: Default"), b -> {
            switch (this.canRepeat) {
                case "default": {
                    String string = "true";
                    break;
                }
                case "true": {
                    String string = "false";
                    break;
                }
                default: {
                    String string = this.canRepeat = "default";
                }
            }
            this.canRepeatBtn.m_93666_((Component)Component.m_237113_((String)("Can Repeat: " + (this.canRepeat.equals("default") ? "Default" : (this.canRepeat.equals("true") ? "Yes" : "No")))));
        }).m_252987_(fieldX, fieldY += 22, btnW + 40, 18).m_253136_();
        this.ignoreRewardBlockingBtn = Button.m_253074_((Component)Component.m_237113_((String)"Ignore Reward Blocking: No"), b -> {
            this.ignoreRewardBlocking = !this.ignoreRewardBlocking;
            this.ignoreRewardBlockingBtn.m_93666_((Component)Component.m_237113_((String)("Ignore Reward Blocking: " + (this.ignoreRewardBlocking ? "Yes" : "No"))));
        }).m_252987_(fieldX, fieldY += 22, btnW + 80, 18).m_253136_();
        this.hideUntilDepsVisibleBtn = Button.m_253074_((Component)Component.m_237113_((String)"Hide Until Deps Visible: No"), b -> {
            this.hideUntilDepsVisible = !this.hideUntilDepsVisible;
            this.hideUntilDepsVisibleBtn.m_93666_((Component)Component.m_237113_((String)("Hide Until Deps Visible: " + (this.hideUntilDepsVisible ? "Yes" : "No"))));
        }).m_252987_(fieldX, fieldY += 40, btnW + 80, 18).m_253136_();
        this.hideUntilDepsCompleteBtn = Button.m_253074_((Component)Component.m_237113_((String)"Hide Until Deps Complete: No"), b -> {
            this.hideUntilDepsComplete = !this.hideUntilDepsComplete;
            this.hideUntilDepsCompleteBtn.m_93666_((Component)Component.m_237113_((String)("Hide Until Deps Complete: " + (this.hideUntilDepsComplete ? "Yes" : "No"))));
        }).m_252987_(fieldX, fieldY += 22, btnW + 80, 18).m_253136_();
        this.invisibleUntilCompletedBtn = Button.m_253074_((Component)Component.m_237113_((String)"Invisible Until Completed: No"), b -> {
            this.invisibleUntilCompleted = !this.invisibleUntilCompleted;
            this.invisibleUntilCompletedBtn.m_93666_((Component)Component.m_237113_((String)("Invisible Until Completed: " + (this.invisibleUntilCompleted ? "Yes" : "No"))));
        }).m_252987_(fieldX, fieldY += 22, btnW + 80, 18).m_253136_();
        this.hideLockIconBtn = Button.m_253074_((Component)Component.m_237113_((String)"Hide Lock Icon: No"), b -> {
            this.hideLockIcon = !this.hideLockIcon;
            this.hideLockIconBtn.m_93666_((Component)Component.m_237113_((String)("Hide Lock Icon: " + (this.hideLockIcon ? "Yes" : "No"))));
        }).m_252987_(fieldX, fieldY += 22, btnW + 40, 18).m_253136_();
        this.minRequiredDepsField = this.createField(fieldX, fieldY += 40, 80, "0");
        this.maxCompletableDepsField = this.createField(fieldX, fieldY += 26, 80, "0");
        this.progressionModeBtn = Button.m_253074_((Component)Component.m_237113_((String)"Progression: Default"), b -> {
            this.progressionMode = switch (this.progressionMode) {
                case "default" -> "linear";
                case "linear" -> "flexible";
                default -> "default";
            };
            this.progressionModeBtn.m_93666_((Component)Component.m_237113_((String)("Progression: " + Character.toUpperCase(this.progressionMode.charAt(0)) + this.progressionMode.substring(1))));
        }).m_252987_(fieldX, fieldY += 26, btnW + 40, 18).m_253136_();
        this.minWidthField = this.createField(fieldX, fieldY += 40, 80, "0");
        this.hideDependentLinesBtn = Button.m_253074_((Component)Component.m_237113_((String)"Hide Dependent Lines: No"), b -> {
            this.hideDependentLines = !this.hideDependentLines;
            this.hideDependentLinesBtn.m_93666_((Component)Component.m_237113_((String)("Hide Dependent Lines: " + (this.hideDependentLines ? "Yes" : "No"))));
        }).m_252987_(fieldX, fieldY += 26, btnW + 80, 18).m_253136_();
    }

    @Override
    public void loadFromQuest(Quest quest) {
        this.optional = quest.isOptional();
        this.optionalBtn.m_93666_((Component)Component.m_237113_((String)("Optional: " + (this.optional ? "Yes" : "No"))));
        this.canRepeat = quest.getCanRepeat();
        this.canRepeatBtn.m_93666_((Component)Component.m_237113_((String)("Can Repeat: " + (this.canRepeat.equals("default") ? "Default" : (this.canRepeat.equals("true") ? "Yes" : "No")))));
        this.ignoreRewardBlocking = quest.isIgnoreRewardBlocking();
        this.ignoreRewardBlockingBtn.m_93666_((Component)Component.m_237113_((String)("Ignore Reward Blocking: " + (this.ignoreRewardBlocking ? "Yes" : "No"))));
        this.hideUntilDepsVisible = "true".equals(quest.getHideUntilDepsVisible());
        this.hideUntilDepsVisibleBtn.m_93666_((Component)Component.m_237113_((String)("Hide Until Deps Visible: " + (this.hideUntilDepsVisible ? "Yes" : "No"))));
        this.hideUntilDepsComplete = "true".equals(quest.getHideUntilDepsComplete());
        this.hideUntilDepsCompleteBtn.m_93666_((Component)Component.m_237113_((String)("Hide Until Deps Complete: " + (this.hideUntilDepsComplete ? "Yes" : "No"))));
        this.invisibleUntilCompleted = quest.isInvisibleUntilCompleted();
        this.invisibleUntilCompletedBtn.m_93666_((Component)Component.m_237113_((String)("Invisible Until Completed: " + (this.invisibleUntilCompleted ? "Yes" : "No"))));
        this.hideLockIcon = quest.isHideLockIcon();
        this.hideLockIconBtn.m_93666_((Component)Component.m_237113_((String)("Hide Lock Icon: " + (this.hideLockIcon ? "Yes" : "No"))));
        this.minRequiredDepsField.m_94144_(String.valueOf(quest.getMinRequiredDependencies()));
        this.maxCompletableDepsField.m_94144_(String.valueOf(quest.getMaxCompletableDeps()));
        this.progressionMode = quest.getProgressionMode();
        this.progressionModeBtn.m_93666_((Component)Component.m_237113_((String)("Progression: " + Character.toUpperCase(this.progressionMode.charAt(0)) + this.progressionMode.substring(1))));
        this.minWidthField.m_94144_(String.valueOf(quest.getMinWidth()));
        this.hideDependentLines = quest.isHideDependentLines();
        this.hideDependentLinesBtn.m_93666_((Component)Component.m_237113_((String)("Hide Dependent Lines: " + (this.hideDependentLines ? "Yes" : "No"))));
    }

    @Override
    public void saveToQuest(Quest quest) {
        quest.setOptional(this.optional);
        quest.setCanRepeat(this.canRepeat);
        quest.setIgnoreRewardBlocking(this.ignoreRewardBlocking);
        quest.setHideUntilDepsVisible(this.hideUntilDepsVisible ? "true" : "default");
        quest.setHideUntilDepsComplete(this.hideUntilDepsComplete ? "true" : "default");
        quest.setInvisibleUntilCompleted(this.invisibleUntilCompleted);
        quest.setHideLockIcon(this.hideLockIcon);
        try {
            quest.setMinRequiredDependencies(Integer.parseInt(this.minRequiredDepsField.m_94155_().trim()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            quest.setMaxCompletableDeps(Integer.parseInt(this.maxCompletableDepsField.m_94155_().trim()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        quest.setProgressionMode(this.progressionMode);
        try {
            quest.setMinWidth(Integer.parseInt(this.minWidthField.m_94155_().trim()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        quest.setHideDependentLines(this.hideDependentLines);
    }

    @Override
    public void render(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        int labelX = this.x + 12;
        int fieldX = this.x + 160;
        int fieldY = this.y + 12;
        g.m_280588_(this.x, this.y, this.x + this.w, this.y + this.h);
        g.m_280488_(this.getFont(), "\u00a7lQuest Behavior", labelX, fieldY, -86);
        this.optionalBtn.m_253211_(fieldY += 20);
        this.optionalBtn.m_88315_(g, mouseX, mouseY, partialTick);
        this.canRepeatBtn.m_253211_(fieldY += 22);
        this.canRepeatBtn.m_88315_(g, mouseX, mouseY, partialTick);
        this.ignoreRewardBlockingBtn.m_253211_(fieldY += 22);
        this.ignoreRewardBlockingBtn.m_88315_(g, mouseX, mouseY, partialTick);
        g.m_280488_(this.getFont(), "\u00a7lVisibility & Unlocking", labelX, fieldY += 28, -86);
        this.hideUntilDepsVisibleBtn.m_253211_(fieldY += 20);
        this.hideUntilDepsVisibleBtn.m_88315_(g, mouseX, mouseY, partialTick);
        this.hideUntilDepsCompleteBtn.m_253211_(fieldY += 22);
        this.hideUntilDepsCompleteBtn.m_88315_(g, mouseX, mouseY, partialTick);
        this.invisibleUntilCompletedBtn.m_253211_(fieldY += 22);
        this.invisibleUntilCompletedBtn.m_88315_(g, mouseX, mouseY, partialTick);
        this.hideLockIconBtn.m_253211_(fieldY += 22);
        this.hideLockIconBtn.m_88315_(g, mouseX, mouseY, partialTick);
        g.m_280488_(this.getFont(), "\u00a7lProgression Control", labelX, fieldY += 28, -86);
        g.m_280488_(this.getFont(), "Min Required Deps:", labelX, (fieldY += 20) + 5, -1);
        this.minRequiredDepsField.m_253211_(fieldY);
        this.minRequiredDepsField.m_88315_(g, mouseX, mouseY, partialTick);
        g.m_280488_(this.getFont(), "Max Completable Deps:", labelX, (fieldY += 26) + 5, -1);
        this.maxCompletableDepsField.m_253211_(fieldY);
        this.maxCompletableDepsField.m_88315_(g, mouseX, mouseY, partialTick);
        g.m_280488_(this.getFont(), "Progression Mode:", labelX, (fieldY += 26) + 5, -1);
        this.progressionModeBtn.m_253211_(fieldY);
        this.progressionModeBtn.m_88315_(g, mouseX, mouseY, partialTick);
        g.m_280488_(this.getFont(), "\u00a7lDisplay", labelX, fieldY += 28, -86);
        g.m_280488_(this.getFont(), "Min Width:", labelX, (fieldY += 20) + 5, -1);
        this.minWidthField.m_253211_(fieldY);
        this.minWidthField.m_88315_(g, mouseX, mouseY, partialTick);
        this.hideDependentLinesBtn.m_253211_(fieldY += 26);
        this.hideDependentLinesBtn.m_88315_(g, mouseX, mouseY, partialTick);
        g.m_280618_();
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.optionalBtn.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.canRepeatBtn.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.ignoreRewardBlockingBtn.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.hideUntilDepsVisibleBtn.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.hideUntilDepsCompleteBtn.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.invisibleUntilCompletedBtn.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.hideLockIconBtn.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.progressionModeBtn.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.hideDependentLinesBtn.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }
}

