/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import org.texboobcat.questory.client.gui.ChapterArtEditorScreen;
import org.texboobcat.questory.client.gui.ChapterTabPanel;
import org.texboobcat.questory.quest.ChapterData;

public class ChapterDefaultsTabPanel
extends ChapterTabPanel {
    private EditBox shapeField;
    private EditBox sizeField;
    private EditBox minWidthField;
    private Button hideLinesBtn;
    private boolean hideLines = false;

    public ChapterDefaultsTabPanel(ChapterArtEditorScreen editor, int x, int y, int w, int h) {
        super(editor, x, y, w, h);
        this.initWidgets();
    }

    private void initWidgets() {
        int fieldX = this.x + 180;
        int fieldY = this.y + 20;
        int fieldW = 150;
        this.shapeField = this.createField(fieldX, fieldY, fieldW, "square, circle, hexagon...");
        this.sizeField = this.createField(fieldX, fieldY += 26, 80, "1.0");
        this.minWidthField = this.createField(fieldX, fieldY += 26, 80, "0");
        this.hideLinesBtn = Button.m_253074_((Component)Component.m_237113_((String)"Hide Dependency Lines: No"), b -> this.toggleHideLines()).m_252987_(fieldX, fieldY += 30, 200, 20).m_253136_();
    }

    private void toggleHideLines() {
        this.hideLines = !this.hideLines;
        this.hideLinesBtn.m_93666_((Component)Component.m_237113_((String)("Hide Dependency Lines: " + (this.hideLines ? "Yes" : "No"))));
    }

    @Override
    public void loadFromChapter(ChapterData chapter) {
        this.shapeField.m_94144_(chapter.getDefaultQuestShape());
        this.sizeField.m_94144_(String.valueOf(chapter.getDefaultQuestSize()));
        this.minWidthField.m_94144_(String.valueOf(chapter.getDefaultMinWidth()));
        this.hideLines = chapter.isDefaultHideDependencyLines();
        this.hideLinesBtn.m_93666_((Component)Component.m_237113_((String)("Hide Dependency Lines: " + (this.hideLines ? "Yes" : "No"))));
    }

    @Override
    public void saveToChapter(ChapterData chapter) {
        chapter.setDefaultQuestShape(this.shapeField.m_94155_().trim());
        try {
            double size = Double.parseDouble(this.sizeField.m_94155_().trim());
            chapter.setDefaultQuestSize(Math.max(0.1, Math.min(5.0, size)));
        }
        catch (Exception size) {
            // empty catch block
        }
        try {
            int minWidth = Integer.parseInt(this.minWidthField.m_94155_().trim());
            chapter.setDefaultMinWidth(Math.max(0, minWidth));
        }
        catch (Exception exception) {
            // empty catch block
        }
        chapter.setDefaultHideDependencyLines(this.hideLines);
    }

    @Override
    public void render(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        int fieldX = this.x + 12;
        int fieldY = this.y + 20;
        int labelW = 160;
        g.m_280588_(this.x, this.y, this.x + this.w, this.y + this.h);
        g.m_280488_(this.getFont(), "\u00a7lDefault Quest Properties", fieldX, fieldY - 8, -86);
        g.m_280488_(this.getFont(), "\u00a77Applied to new quests in this chapter", fieldX, fieldY + 4, -5592406);
        g.m_280488_(this.getFont(), "Default Quest Shape:", fieldX, (fieldY += 20) + 5, -1);
        this.shapeField.m_253211_(fieldY);
        this.shapeField.m_252865_(fieldX + labelW);
        this.shapeField.m_88315_(g, mouseX, mouseY, partialTick);
        g.m_280488_(this.getFont(), "Default Quest Size:", fieldX, (fieldY += 26) + 5, -1);
        this.sizeField.m_253211_(fieldY);
        this.sizeField.m_252865_(fieldX + labelW);
        this.sizeField.m_88315_(g, mouseX, mouseY, partialTick);
        g.m_280488_(this.getFont(), "(0.5 - 3.0)", fieldX + labelW + 88, fieldY + 5, -7829368);
        g.m_280488_(this.getFont(), "Default Min Width:", fieldX, (fieldY += 26) + 5, -1);
        this.minWidthField.m_253211_(fieldY);
        this.minWidthField.m_252865_(fieldX + labelW);
        this.minWidthField.m_88315_(g, mouseX, mouseY, partialTick);
        g.m_280488_(this.getFont(), "(min panel width)", fieldX + labelW + 88, fieldY + 5, -7829368);
        g.m_280488_(this.getFont(), "Dependency Lines:", fieldX, (fieldY += 30) + 5, -1);
        this.hideLinesBtn.m_253211_(fieldY);
        this.hideLinesBtn.m_252865_(fieldX + labelW);
        this.hideLinesBtn.m_88315_(g, mouseX, mouseY, partialTick);
        g.m_280618_();
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.hideLinesBtn.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }
}

