/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.questory.client.gui.IconPickerScreen;
import org.texboobcat.questory.client.gui.QuestEditorScreen;
import org.texboobcat.questory.client.gui.TabPanel;
import org.texboobcat.questory.quest.Quest;

public class GeneralTabPanel
extends TabPanel {
    private EditBox idField;
    private EditBox titleField;
    private EditBox descField;
    private EditBox iconField;
    private Button iconBrowseBtn;
    private EditBox groupField;
    private EditBox tagsField;
    private EditBox xField;
    private EditBox yField;
    private EditBox shapeField;
    private EditBox sizeField;
    private EditBox iconScaleField;
    private Button hiddenBtn;
    private boolean hidden = false;

    public GeneralTabPanel(QuestEditorScreen editor, int x, int y, int w, int h) {
        super(editor, x, y, w, h);
        this.initWidgets();
    }

    private void initWidgets() {
        int fieldX = this.x + 12;
        int fieldY = this.y + 12 - this.scrollOffset;
        int fieldW = Math.min(400, this.w - 24);
        int labelW = 120;
        int inputW = fieldW - labelW - 8;
        this.idField = this.createField(fieldX + labelW, fieldY, inputW, "quest_id");
        this.titleField = this.createField(fieldX + labelW, fieldY += 26, inputW, "Quest Title");
        this.descField = this.createField(fieldX + labelW, fieldY += 26, inputW, "Enter quest description...");
        this.descField.m_94199_(500);
        int iconW = inputW - 80;
        this.iconField = this.createField(fieldX + labelW, fieldY += 70, iconW, "minecraft:writable_book");
        this.iconBrowseBtn = Button.m_253074_((Component)Component.m_237113_((String)"Browse..."), b -> this.openIconPicker()).m_252987_(fieldX + labelW + iconW + 4, fieldY, 76, 18).m_253136_();
        fieldY += 30;
        this.groupField = this.createField(fieldX + labelW, fieldY += 12, inputW, "default");
        this.tagsField = this.createField(fieldX + labelW, fieldY += 26, inputW, "comma, separated, tags");
        int halfW = (inputW - 4) / 2;
        this.xField = this.createField(fieldX + labelW, fieldY += 26, halfW, "0");
        this.yField = this.createField(fieldX + labelW + halfW + 4, fieldY, halfW, "0");
        fieldY += 30;
        this.shapeField = this.createField(fieldX + labelW, fieldY += 12, inputW, "square (or circle, hexagon...)");
        this.sizeField = this.createField(fieldX + labelW, fieldY += 26, 80, "1.0");
        this.iconScaleField = this.createField(fieldX + labelW, fieldY += 26, 80, "1.0");
        this.hiddenBtn = Button.m_253074_((Component)Component.m_237113_((String)"Hidden: No"), b -> this.toggleHidden()).m_252987_(fieldX + labelW, fieldY += 26, 120, 20).m_253136_();
    }

    private void toggleHidden() {
        this.hidden = !this.hidden;
        this.hiddenBtn.m_93666_((Component)Component.m_237113_((String)("Hidden: " + (this.hidden ? "Yes" : "No"))));
    }

    private void openIconPicker() {
        this.getMinecraft().m_91152_((Screen)new IconPickerScreen(this.editor, this.iconField.m_94155_(), result -> {
            this.iconField.m_94144_(result);
            this.getMinecraft().m_91152_((Screen)this.editor);
        }));
    }

    @Override
    public void loadFromQuest(Quest quest) {
        this.idField.m_94144_(quest.getId());
        this.titleField.m_94144_(quest.getTitle());
        this.descField.m_94144_(quest.getDescription());
        this.iconField.m_94144_(quest.getIcon());
        this.groupField.m_94144_(quest.getGroup());
        this.tagsField.m_94144_(String.join((CharSequence)", ", quest.getTags()));
        this.xField.m_94144_(String.valueOf(quest.getX()));
        this.yField.m_94144_(String.valueOf(quest.getY()));
        this.shapeField.m_94144_(quest.getShape().isEmpty() ? "" : quest.getShape());
        this.sizeField.m_94144_(String.valueOf(quest.getSize()));
        this.iconScaleField.m_94144_(String.valueOf(quest.getIconScale()));
        this.hidden = quest.isHidden();
        this.hiddenBtn.m_93666_((Component)Component.m_237113_((String)("Hidden: " + (this.hidden ? "Yes" : "No"))));
    }

    @Override
    public void saveToQuest(Quest quest) {
        String[] tags;
        quest.setTitle(this.titleField.m_94155_().trim().isEmpty() ? quest.getId() : this.titleField.m_94155_().trim());
        quest.setDescription(this.descField.m_94155_());
        quest.setIcon(this.iconField.m_94155_().trim().isEmpty() ? "minecraft:writable_book" : this.iconField.m_94155_().trim());
        quest.setGroup(this.groupField.m_94155_().trim().isEmpty() ? "default" : this.groupField.m_94155_().trim());
        quest.getTags().clear();
        for (String tag : tags = this.tagsField.m_94155_().split(",")) {
            String t = tag.trim();
            if (t.isEmpty()) continue;
            quest.addTag(t);
        }
        try {
            quest.setX(Integer.parseInt(this.xField.m_94155_().trim()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            quest.setY(Integer.parseInt(this.yField.m_94155_().trim()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        quest.setShape(this.shapeField.m_94155_().trim());
        try {
            double size = Double.parseDouble(this.sizeField.m_94155_().trim());
            quest.setSize(Math.max(0.1, Math.min(5.0, size)));
        }
        catch (Exception size) {
            // empty catch block
        }
        try {
            double scale = Double.parseDouble(this.iconScaleField.m_94155_().trim());
            quest.setIconScale(Math.max(0.1, Math.min(3.0, scale)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        quest.setHidden(this.hidden);
    }

    @Override
    public void render(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        int fieldX = this.x + 12;
        int fieldY = this.y + 12 - this.scrollOffset;
        int labelW = 120;
        g.m_280588_(this.x, this.y, this.x + this.w, this.y + this.h);
        g.m_280488_(this.getFont(), "\u00a7lIdentity", fieldX, fieldY - 8, -86);
        g.m_280488_(this.getFont(), "ID:", fieldX, (fieldY += 12) + 5, -1);
        this.idField.m_253211_(fieldY);
        this.idField.m_88315_(g, mouseX, mouseY, partialTick);
        g.m_280488_(this.getFont(), "Title:", fieldX, (fieldY += 26) + 5, -1);
        this.titleField.m_253211_(fieldY);
        this.titleField.m_88315_(g, mouseX, mouseY, partialTick);
        g.m_280488_(this.getFont(), "Description:", fieldX, (fieldY += 26) + 5, -1);
        this.descField.m_253211_(fieldY);
        this.descField.m_88315_(g, mouseX, mouseY, partialTick);
        g.m_280488_(this.getFont(), "Icon:", fieldX, (fieldY += 70) + 5, -1);
        this.iconField.m_253211_(fieldY);
        this.iconField.m_88315_(g, mouseX, mouseY, partialTick);
        this.iconBrowseBtn.m_253211_(fieldY);
        this.iconBrowseBtn.m_88315_(g, mouseX, mouseY, partialTick);
        fieldY += 30;
        g.m_280488_(this.getFont(), "\u00a7lOrganization", fieldX, fieldY += 4, -86);
        g.m_280488_(this.getFont(), "Group/Chapter:", fieldX, (fieldY += 12) + 5, -1);
        this.groupField.m_253211_(fieldY);
        this.groupField.m_88315_(g, mouseX, mouseY, partialTick);
        g.m_280488_(this.getFont(), "Tags:", fieldX, (fieldY += 26) + 5, -1);
        this.tagsField.m_253211_(fieldY);
        this.tagsField.m_88315_(g, mouseX, mouseY, partialTick);
        g.m_280488_(this.getFont(), "Position:", fieldX, (fieldY += 26) + 5, -1);
        g.m_280488_(this.getFont(), "X:", fieldX + labelW, fieldY + 5, -3355444);
        this.xField.m_253211_(fieldY);
        this.xField.m_88315_(g, mouseX, mouseY, partialTick);
        int halfW = (Math.min(400, this.w - 24) - labelW - 8 - 4) / 2;
        g.m_280488_(this.getFont(), "Y:", fieldX + labelW + halfW + 4, fieldY + 5, -3355444);
        this.yField.m_253211_(fieldY);
        this.yField.m_88315_(g, mouseX, mouseY, partialTick);
        fieldY += 30;
        g.m_280488_(this.getFont(), "\u00a7lAppearance", fieldX, fieldY += 4, -86);
        g.m_280488_(this.getFont(), "Shape:", fieldX, (fieldY += 12) + 5, -1);
        this.shapeField.m_253211_(fieldY);
        this.shapeField.m_88315_(g, mouseX, mouseY, partialTick);
        g.m_280488_(this.getFont(), "Size:", fieldX, (fieldY += 26) + 5, -1);
        this.sizeField.m_253211_(fieldY);
        this.sizeField.m_88315_(g, mouseX, mouseY, partialTick);
        g.m_280488_(this.getFont(), "(0.5 - 3.0)", fieldX + labelW + 88, fieldY + 5, -7829368);
        g.m_280488_(this.getFont(), "Icon Scale:", fieldX, (fieldY += 26) + 5, -1);
        this.iconScaleField.m_253211_(fieldY);
        this.iconScaleField.m_88315_(g, mouseX, mouseY, partialTick);
        g.m_280488_(this.getFont(), "(0.5 - 2.0)", fieldX + labelW + 88, fieldY + 5, -7829368);
        g.m_280488_(this.getFont(), "Visibility:", fieldX, (fieldY += 26) + 5, -1);
        this.hiddenBtn.m_253211_(fieldY);
        this.hiddenBtn.m_88315_(g, mouseX, mouseY, partialTick);
        g.m_280618_();
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.iconBrowseBtn.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.hiddenBtn.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }
}

