/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.questory.client.ClientQuestManager;
import org.texboobcat.questory.client.gui.AdvancedTabPanel;
import org.texboobcat.questory.client.gui.DependenciesTabPanel;
import org.texboobcat.questory.client.gui.GeneralTabPanel;
import org.texboobcat.questory.client.gui.PreviewTabPanel;
import org.texboobcat.questory.client.gui.RequirementsTabPanel;
import org.texboobcat.questory.client.gui.RewardsTabPanel;
import org.texboobcat.questory.network.NetworkManager;
import org.texboobcat.questory.network.QuestCreateRequestPacket;
import org.texboobcat.questory.network.QuestDeleteRequestPacket;
import org.texboobcat.questory.network.QuestUpdateRequestPacket;
import org.texboobcat.questory.quest.Quest;
import org.texboobcat.questory.validation.QuestValidator;

public class QuestEditorScreen
extends Screen {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final int SIDEBAR_W = 240;
    private static final int TAB_H = 24;
    private static final int HEADER_H = 32;
    private static final int FOOTER_H = 36;
    private static final int PAD = 8;
    private final Screen parent;
    private Quest workingQuest;
    private String originalId;
    private Tab activeTab = Tab.GENERAL;
    private EditBox searchBox;
    private List<Quest> filtered = new ArrayList<Quest>();
    private int listScroll = 0;
    private GeneralTabPanel generalTab;
    private DependenciesTabPanel dependenciesTab;
    private RequirementsTabPanel requirementsTab;
    private RewardsTabPanel rewardsTab;
    private AdvancedTabPanel advancedTab;
    private PreviewTabPanel previewTab;
    private Button tabGeneralBtn;
    private Button tabDepsBtn;
    private Button tabReqsBtn;
    private Button tabRwdsBtn;
    private Button tabAdvBtn;
    private Button tabPreviewBtn;
    private Button newBtn;
    private Button saveBtn;
    private Button deleteBtn;
    private Button closeBtn;

    public QuestEditorScreen(Screen parent) {
        super((Component)Component.m_237113_((String)"Quest Editor"));
        this.parent = parent;
    }

    public Font getFont() {
        return this.f_96547_;
    }

    public Minecraft getMinecraft() {
        return this.f_96541_;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.searchBox = new EditBox(this.f_96547_, 8, 8, 224, 18, (Component)Component.m_237113_((String)"Search"));
        this.searchBox.m_257771_((Component)Component.m_237113_((String)"Search quests..."));
        this.m_142416_((GuiEventListener)this.searchBox);
        int tabX = 248;
        int tabY = 8;
        int tabW = 90;
        this.tabGeneralBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"General"), b -> this.switchTab(Tab.GENERAL)).m_252987_(tabX, tabY, tabW, 22).m_253136_());
        this.tabDepsBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Dependencies"), b -> this.switchTab(Tab.DEPENDENCIES)).m_252987_(tabX += tabW + 2, tabY, tabW + 20, 22).m_253136_());
        this.tabReqsBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Requirements"), b -> this.switchTab(Tab.REQUIREMENTS)).m_252987_(tabX += tabW + 22, tabY, tabW + 20, 22).m_253136_());
        this.tabRwdsBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Rewards"), b -> this.switchTab(Tab.REWARDS)).m_252987_(tabX += tabW + 22, tabY, tabW, 22).m_253136_());
        this.tabAdvBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Advanced"), b -> this.switchTab(Tab.ADVANCED)).m_252987_(tabX += tabW + 2, tabY, tabW, 22).m_253136_());
        this.tabPreviewBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Preview"), b -> this.switchTab(Tab.PREVIEW)).m_252987_(tabX += tabW + 2, tabY, tabW - 10, 22).m_253136_());
        int footerY = this.f_96544_ - 36 + 8;
        int btnX = 248;
        this.newBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"New"), b -> this.createNew()).m_252987_(btnX, footerY, 60, 20).m_253136_());
        this.saveBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Save"), b -> this.save()).m_252987_(btnX += 64, footerY, 60, 20).m_253136_());
        this.deleteBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Delete"), b -> this.delete()).m_252987_(btnX += 64, footerY, 60, 20).m_253136_());
        int closeX = this.f_96543_ - 8 - 60;
        this.closeBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Close"), b -> this.f_96541_.m_91152_(this.parent)).m_252987_(closeX, footerY, 60, 20).m_253136_());
        this.initTabPanels();
        this.reloadQuestList();
        if (!this.filtered.isEmpty()) {
            this.selectQuest(this.filtered.get(0));
        } else {
            this.createNew();
        }
    }

    private void initTabPanels() {
        int contentX = 248;
        int contentY = 40;
        int contentW = this.f_96543_ - contentX - 8;
        int contentH = this.f_96544_ - contentY - 36 - 8;
        this.generalTab = new GeneralTabPanel(this, contentX, contentY, contentW, contentH);
        this.dependenciesTab = new DependenciesTabPanel(this, contentX, contentY, contentW, contentH);
        this.requirementsTab = new RequirementsTabPanel(this, contentX, contentY, contentW, contentH);
        this.rewardsTab = new RewardsTabPanel(this, contentX, contentY, contentW, contentH);
        this.advancedTab = new AdvancedTabPanel(this, contentX, contentY, contentW, contentH);
        this.previewTab = new PreviewTabPanel(this, contentX, contentY, contentW, contentH);
    }

    private void switchTab(Tab tab) {
        if (this.activeTab == tab) {
            return;
        }
        this.saveCurrentTabToQuest();
        this.activeTab = tab;
        this.loadTabFromQuest();
    }

    private void saveCurrentTabToQuest() {
        if (this.workingQuest == null) {
            return;
        }
        switch (this.activeTab.ordinal()) {
            case 0: {
                this.generalTab.saveToQuest(this.workingQuest);
                break;
            }
            case 1: {
                this.dependenciesTab.saveToQuest(this.workingQuest);
                break;
            }
            case 2: {
                this.requirementsTab.saveToQuest(this.workingQuest);
                break;
            }
            case 3: {
                this.rewardsTab.saveToQuest(this.workingQuest);
                break;
            }
            case 4: {
                this.advancedTab.saveToQuest(this.workingQuest);
            }
        }
    }

    private void loadTabFromQuest() {
        if (this.workingQuest == null) {
            return;
        }
        switch (this.activeTab.ordinal()) {
            case 0: {
                this.generalTab.loadFromQuest(this.workingQuest);
                break;
            }
            case 1: {
                this.dependenciesTab.loadFromQuest(this.workingQuest);
                break;
            }
            case 2: {
                this.requirementsTab.loadFromQuest(this.workingQuest);
                break;
            }
            case 3: {
                this.rewardsTab.loadFromQuest(this.workingQuest);
                break;
            }
            case 4: {
                this.advancedTab.loadFromQuest(this.workingQuest);
                break;
            }
            case 5: {
                this.previewTab.loadFromQuest(this.workingQuest);
            }
        }
    }

    private void reloadQuestList() {
        String query = this.searchBox.m_94155_().trim().toLowerCase();
        ArrayList<Quest> all = new ArrayList<Quest>(ClientQuestManager.getInstance().getAllQuests());
        all.sort((a, b) -> a.getTitle().compareToIgnoreCase(b.getTitle()));
        this.filtered = query.isEmpty() ? all : all.stream().filter(q -> q.getId().toLowerCase().contains(query) || q.getTitle().toLowerCase().contains(query) || q.getGroup().toLowerCase().contains(query)).collect(Collectors.toList());
    }

    private void selectQuest(Quest quest) {
        this.saveCurrentTabToQuest();
        this.workingQuest = quest;
        this.originalId = quest.getId();
        this.loadTabFromQuest();
    }

    private void createNew() {
        this.saveCurrentTabToQuest();
        this.workingQuest = new Quest("new_quest_" + System.currentTimeMillis(), "New Quest", "");
        this.originalId = null;
        this.activeTab = Tab.GENERAL;
        this.loadTabFromQuest();
    }

    private void save() {
        block9: {
            if (this.workingQuest == null) {
                return;
            }
            this.saveCurrentTabToQuest();
            HashMap<String, Quest> allQuests = new HashMap<String, Quest>();
            for (Quest q : ClientQuestManager.getInstance().getAllQuests()) {
                allQuests.put(q.getId(), q);
            }
            allQuests.put(this.workingQuest.getId(), this.workingQuest);
            QuestValidator.ValidationResult validation = QuestValidator.validate(this.workingQuest, allQuests);
            if (!validation.isValid()) {
                if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                    this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)("\u00a7cValidation errors: " + String.join((CharSequence)", ", validation.getErrors()))));
                }
                return;
            }
            try {
                JsonObject json = this.workingQuest.toJson();
                String payload = GSON.toJson((JsonElement)json);
                if (this.originalId == null || this.originalId.isEmpty()) {
                    NetworkManager.sendToServer(new QuestCreateRequestPacket(payload));
                } else {
                    NetworkManager.sendToServer(new QuestUpdateRequestPacket(this.originalId, payload));
                }
                if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                    this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a7aQuest saved successfully"));
                }
                this.originalId = this.workingQuest.getId();
            }
            catch (Exception e) {
                if (this.f_96541_ == null || this.f_96541_.f_91074_ == null) break block9;
                this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)("\u00a7cSave failed: " + e.getMessage())));
            }
        }
    }

    private void delete() {
        if (this.originalId == null || this.originalId.isEmpty()) {
            return;
        }
        NetworkManager.sendToServer(new QuestDeleteRequestPacket(this.originalId));
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a7aQuest deletion requested"));
        }
        this.createNew();
    }

    public void m_88315_(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(g);
        g.m_280509_(0, 0, 240, this.f_96544_, -804253680);
        int listTop = 32;
        int listBottom = this.f_96544_ - 8;
        g.m_280509_(8, listTop, 232, listBottom, -534765536);
        this.renderQuestList(g, mouseX, mouseY);
        int contentX = 248;
        int contentY = 40;
        int contentW = this.f_96543_ - contentX - 8;
        int contentH = this.f_96544_ - contentY - 36 - 8;
        g.m_280509_(contentX, contentY, contentX + contentW, contentY + contentH, -535291880);
        this.renderActiveTab(g, mouseX, mouseY, partialTick);
        super.m_88315_(g, mouseX, mouseY, partialTick);
        g.m_280430_(this.f_96547_, this.f_96539_, 248, -4, -1);
    }

    private void renderQuestList(GuiGraphics g, int mouseX, int mouseY) {
        this.reloadQuestList();
        int listX = 8;
        int listTop = 32;
        int listW = 224;
        int listBottom = this.f_96544_ - 8;
        int lineH = 16;
        g.m_280588_(listX, listTop, listX + listW, listBottom);
        int maxLines = Math.max(1, (listBottom - listTop) / lineH);
        this.listScroll = Math.max(0, Math.min(this.listScroll, Math.max(0, this.filtered.size() - maxLines)));
        for (int i = 0; i < Math.min(maxLines, this.filtered.size() - this.listScroll); ++i) {
            boolean hover;
            Quest q = this.filtered.get(this.listScroll + i);
            int y = listTop + 2 + i * lineH;
            boolean selected = this.workingQuest != null && this.workingQuest.getId().equals(q.getId());
            boolean bl = hover = mouseX >= listX && mouseX <= listX + listW && mouseY >= y && mouseY < y + lineH;
            if (selected) {
                g.m_280509_(listX, y - 1, listX + listW, y + lineH - 1, -12952966);
            } else if (hover) {
                g.m_280509_(listX, y - 1, listX + listW, y + lineH - 1, -14013910);
            }
            Object label = q.getTitle();
            if (this.f_96547_.m_92895_((String)label) > listW - 4) {
                label = this.f_96547_.m_92834_((String)label, listW - 10) + "...";
            }
            g.m_280488_(this.f_96547_, (String)label, listX + 2, y, -1);
        }
        g.m_280618_();
    }

    private void renderActiveTab(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        switch (this.activeTab.ordinal()) {
            case 0: {
                this.generalTab.render(g, mouseX, mouseY, partialTick);
                break;
            }
            case 1: {
                this.dependenciesTab.render(g, mouseX, mouseY, partialTick);
                break;
            }
            case 2: {
                this.requirementsTab.render(g, mouseX, mouseY, partialTick);
                break;
            }
            case 3: {
                this.rewardsTab.render(g, mouseX, mouseY, partialTick);
                break;
            }
            case 4: {
                this.advancedTab.render(g, mouseX, mouseY, partialTick);
                break;
            }
            case 5: {
                this.previewTab.render(g, mouseX, mouseY, partialTick);
            }
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean tabHandled;
        int relY;
        int index;
        int listX = 8;
        int listTop = 32;
        int listW = 224;
        int listBottom = this.f_96544_ - 8;
        int lineH = 16;
        if (mouseX >= (double)listX && mouseX <= (double)(listX + listW) && mouseY >= (double)listTop && mouseY < (double)listBottom && (index = this.listScroll + (relY = (int)mouseY - listTop - 2) / lineH) >= 0 && index < this.filtered.size()) {
            this.selectQuest(this.filtered.get(index));
            return true;
        }
        switch (this.activeTab.ordinal()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 0: {
                boolean bl = this.generalTab.mouseClicked(mouseX, mouseY, button);
                break;
            }
            case 1: {
                boolean bl = this.dependenciesTab.mouseClicked(mouseX, mouseY, button);
                break;
            }
            case 2: {
                boolean bl = this.requirementsTab.mouseClicked(mouseX, mouseY, button);
                break;
            }
            case 3: {
                boolean bl = this.rewardsTab.mouseClicked(mouseX, mouseY, button);
                break;
            }
            case 4: {
                boolean bl = this.advancedTab.mouseClicked(mouseX, mouseY, button);
                break;
            }
            case 5: {
                boolean bl = tabHandled = this.previewTab.mouseClicked(mouseX, mouseY, button);
            }
        }
        if (tabHandled) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        boolean tabHandled;
        int listX = 8;
        int listTop = 32;
        int listW = 224;
        int listBottom = this.f_96544_ - 8;
        if (mouseX >= (double)listX && mouseX <= (double)(listX + listW) && mouseY >= (double)listTop && mouseY < (double)listBottom) {
            this.listScroll = (int)Math.max(0.0, (double)this.listScroll - Math.signum(delta) * 3.0);
            return true;
        }
        switch (this.activeTab.ordinal()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 0: {
                boolean bl = this.generalTab.mouseScrolled(mouseX, mouseY, delta);
                break;
            }
            case 1: {
                boolean bl = this.dependenciesTab.mouseScrolled(mouseX, mouseY, delta);
                break;
            }
            case 2: {
                boolean bl = this.requirementsTab.mouseScrolled(mouseX, mouseY, delta);
                break;
            }
            case 3: {
                boolean bl = this.rewardsTab.mouseScrolled(mouseX, mouseY, delta);
                break;
            }
            case 4: {
                boolean bl = this.advancedTab.mouseScrolled(mouseX, mouseY, delta);
                break;
            }
            case 5: {
                boolean bl = tabHandled = this.previewTab.mouseScrolled(mouseX, mouseY, delta);
            }
        }
        if (tabHandled) {
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_7043_() {
        return false;
    }

    private static enum Tab {
        GENERAL,
        DEPENDENCIES,
        REQUIREMENTS,
        REWARDS,
        ADVANCED,
        PREVIEW;

    }
}

