/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.questory.client.gui.QuestEditorScreen;
import org.texboobcat.questory.client.gui.RequirementEditorScreen;
import org.texboobcat.questory.client.gui.RequirementTypePickerScreen;
import org.texboobcat.questory.client.gui.TabPanel;
import org.texboobcat.questory.quest.AdvancementRequirement;
import org.texboobcat.questory.quest.BiomeRequirement;
import org.texboobcat.questory.quest.CommandRequirement;
import org.texboobcat.questory.quest.CraftingRequirement;
import org.texboobcat.questory.quest.CurrencyRequirement;
import org.texboobcat.questory.quest.CustomRequirement;
import org.texboobcat.questory.quest.DimensionRequirement;
import org.texboobcat.questory.quest.EnergyRequirement;
import org.texboobcat.questory.quest.EntityKillRequirement;
import org.texboobcat.questory.quest.FluidRequirement;
import org.texboobcat.questory.quest.ItemRequirement;
import org.texboobcat.questory.quest.ItemTagRequirement;
import org.texboobcat.questory.quest.LocationRequirement;
import org.texboobcat.questory.quest.ObservationRequirement;
import org.texboobcat.questory.quest.Quest;
import org.texboobcat.questory.quest.RegionRequirement;
import org.texboobcat.questory.quest.Requirement;
import org.texboobcat.questory.quest.StageRequirement;
import org.texboobcat.questory.quest.StatisticRequirement;
import org.texboobcat.questory.quest.StructureRequirement;
import org.texboobcat.questory.quest.TimeRequirement;
import org.texboobcat.questory.quest.WeatherRequirement;
import org.texboobcat.questory.quest.XpRequirement;

public class RequirementsTabPanel
extends TabPanel {
    private List<Requirement> requirements = new ArrayList<Requirement>();
    private int selectedIndex = -1;
    private int listScroll = 0;
    private Button addBtn;
    private Button editBtn;
    private Button removeBtn;
    private Button moveUpBtn;
    private Button moveDownBtn;
    private Button sequentialBtn;
    private boolean sequential = false;

    public RequirementsTabPanel(QuestEditorScreen editor, int x, int y, int w, int h) {
        super(editor, x, y, w, h);
        this.initWidgets();
    }

    private void initWidgets() {
        int btnY = this.y + this.h - 32;
        this.addBtn = Button.m_253074_((Component)Component.m_237113_((String)"+ Add"), b -> this.openAddDialog()).m_252987_(this.x + 12, btnY, 60, 20).m_253136_();
        this.editBtn = Button.m_253074_((Component)Component.m_237113_((String)"Edit"), b -> this.openEditDialog()).m_252987_(this.x + 76, btnY, 60, 20).m_253136_();
        this.removeBtn = Button.m_253074_((Component)Component.m_237113_((String)"Remove"), b -> this.removeSelected()).m_252987_(this.x + 140, btnY, 70, 20).m_253136_();
        this.moveUpBtn = Button.m_253074_((Component)Component.m_237113_((String)"\u2191"), b -> this.moveUp()).m_252987_(this.x + 214, btnY, 30, 20).m_253136_();
        this.moveDownBtn = Button.m_253074_((Component)Component.m_237113_((String)"\u2193"), b -> this.moveDown()).m_252987_(this.x + 248, btnY, 30, 20).m_253136_();
        this.sequentialBtn = Button.m_253074_((Component)Component.m_237113_((String)"Sequential: No"), b -> this.toggleSequential()).m_252987_(this.x + this.w - 150, btnY, 140, 20).m_253136_();
    }

    private void toggleSequential() {
        this.sequential = !this.sequential;
        this.sequentialBtn.m_93666_((Component)Component.m_237113_((String)("Sequential: " + (this.sequential ? "Yes" : "No"))));
    }

    private void openAddDialog() {
        this.getMinecraft().m_91152_((Screen)new RequirementTypePickerScreen(this.editor, type -> {
            Requirement req = this.createRequirementOfType((String)type);
            if (req != null) {
                this.requirements.add(req);
            }
            this.getMinecraft().m_91152_((Screen)this.editor);
        }));
    }

    private Requirement createRequirementOfType(String type) {
        return switch (type) {
            case "item" -> new ItemRequirement("minecraft:dirt", 1);
            case "kill" -> new EntityKillRequirement("minecraft:zombie", 10);
            case "location" -> new LocationRequirement(0, 64, 0, 10, "minecraft:overworld");
            case "xp" -> new XpRequirement(100L, false);
            case "advancement" -> new AdvancementRequirement("minecraft:story/mine_stone");
            case "biome" -> new BiomeRequirement("minecraft:plains");
            case "dimension" -> new DimensionRequirement("minecraft:the_nether");
            case "crafting" -> new CraftingRequirement("minecraft:crafting_table", 1);
            case "fluid" -> new FluidRequirement("minecraft:water", 1000L);
            case "energy" -> new EnergyRequirement(10000L);
            case "currency" -> new CurrencyRequirement("coins", 100L);
            case "statistic" -> new StatisticRequirement("minecraft:walk_one_cm", 100000);
            case "custom" -> new CustomRequirement("custom_task", "Complete custom task", 1L);
            case "command" -> new CommandRequirement("cmd_" + System.currentTimeMillis(), "Triggered by command");
            case "time" -> new TimeRequirement(0L, 12000L);
            case "weather" -> new WeatherRequirement(WeatherRequirement.Mode.CLEAR);
            case "structure" -> new StructureRequirement("minecraft:village");
            case "stage" -> new StageRequirement("stage_name");
            case "region" -> new RegionRequirement("minecraft:overworld", 0, 0, 0, 100, 100, 100);
            case "observation" -> new ObservationRequirement("minecraft:cow", "entity", 100);
            case "item_tag" -> new ItemTagRequirement("#minecraft:logs", 64);
            default -> null;
        };
    }

    private void openEditDialog() {
        if (this.selectedIndex >= 0 && this.selectedIndex < this.requirements.size()) {
            Requirement req = this.requirements.get(this.selectedIndex);
            this.getMinecraft().m_91152_((Screen)new RequirementEditorScreen(this.editor, req, updated -> {
                this.requirements.set(this.selectedIndex, (Requirement)updated);
                this.getMinecraft().m_91152_((Screen)this.editor);
            }));
        }
    }

    private void removeSelected() {
        if (this.selectedIndex >= 0 && this.selectedIndex < this.requirements.size()) {
            this.requirements.remove(this.selectedIndex);
            this.selectedIndex = -1;
        }
    }

    private void moveUp() {
        if (this.selectedIndex > 0) {
            Requirement temp = this.requirements.get(this.selectedIndex);
            this.requirements.set(this.selectedIndex, this.requirements.get(this.selectedIndex - 1));
            this.requirements.set(this.selectedIndex - 1, temp);
            --this.selectedIndex;
        }
    }

    private void moveDown() {
        if (this.selectedIndex >= 0 && this.selectedIndex < this.requirements.size() - 1) {
            Requirement temp = this.requirements.get(this.selectedIndex);
            this.requirements.set(this.selectedIndex, this.requirements.get(this.selectedIndex + 1));
            this.requirements.set(this.selectedIndex + 1, temp);
            ++this.selectedIndex;
        }
    }

    @Override
    public void loadFromQuest(Quest quest) {
        this.requirements.clear();
        this.requirements.addAll(quest.getRequirements());
        this.sequential = "true".equals(quest.getRequireSequentialTasks());
        this.sequentialBtn.m_93666_((Component)Component.m_237113_((String)("Sequential: " + (this.sequential ? "Yes" : "No"))));
        this.selectedIndex = -1;
        this.listScroll = 0;
    }

    @Override
    public void saveToQuest(Quest quest) {
        quest.getRequirements().clear();
        quest.getRequirements().addAll(this.requirements);
        quest.setRequireSequentialTasks(this.sequential ? "true" : "default");
    }

    @Override
    public void render(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        int listX = this.x + 12;
        int listY = this.y + 12;
        int listW = this.w - 24;
        int listH = this.h - 60;
        g.m_280488_(this.getFont(), "\u00a7lRequirements (" + this.requirements.size() + ")", listX, listY, -86);
        g.m_280509_(listX, listY += 20, listX + listW, listY + (listH -= 20), -803200992);
        g.m_280588_(listX, listY, listX + listW, listY + listH);
        int lineH = 40;
        int maxVisible = Math.max(1, listH / lineH);
        this.listScroll = Math.max(0, Math.min(this.listScroll, Math.max(0, this.requirements.size() - maxVisible)));
        for (int i = 0; i < Math.min(maxVisible, this.requirements.size() - this.listScroll); ++i) {
            boolean hover;
            int index = this.listScroll + i;
            Requirement req = this.requirements.get(index);
            int itemY = listY + 4 + i * lineH;
            boolean selected = index == this.selectedIndex;
            boolean bl = hover = mouseX >= listX && mouseX <= listX + listW && mouseY >= itemY && mouseY < itemY + lineH;
            if (selected) {
                g.m_280509_(listX + 2, itemY, listX + listW - 2, itemY + lineH - 2, -12952966);
            } else if (hover) {
                g.m_280509_(listX + 2, itemY, listX + listW - 2, itemY + lineH - 2, -14013910);
            }
            String typeLabel = "[" + req.getType().toUpperCase() + "]";
            String summary = this.getRequirementSummary(req);
            g.m_280488_(this.getFont(), index + 1 + ". " + typeLabel + " " + summary, listX + 8, itemY + 4, -1);
            String details = this.getRequirementDetails(req);
            g.m_280488_(this.getFont(), "  \u2514\u2500 " + details, listX + 12, itemY + 18, -3355444);
        }
        g.m_280618_();
        this.addBtn.m_88315_(g, mouseX, mouseY, partialTick);
        this.editBtn.f_93623_ = this.selectedIndex >= 0;
        this.editBtn.m_88315_(g, mouseX, mouseY, partialTick);
        this.removeBtn.f_93623_ = this.selectedIndex >= 0;
        this.removeBtn.m_88315_(g, mouseX, mouseY, partialTick);
        this.moveUpBtn.f_93623_ = this.selectedIndex > 0;
        this.moveUpBtn.m_88315_(g, mouseX, mouseY, partialTick);
        this.moveDownBtn.f_93623_ = this.selectedIndex >= 0 && this.selectedIndex < this.requirements.size() - 1;
        this.moveDownBtn.m_88315_(g, mouseX, mouseY, partialTick);
        this.sequentialBtn.m_88315_(g, mouseX, mouseY, partialTick);
    }

    private String getRequirementSummary(Requirement req) {
        if (req instanceof ItemRequirement) {
            ItemRequirement ir = (ItemRequirement)req;
            return "Collect " + ir.getCount() + " " + ir.getItem();
        }
        if (req instanceof EntityKillRequirement) {
            EntityKillRequirement kr = (EntityKillRequirement)req;
            return "Kill " + kr.getCount() + " " + kr.getEntity();
        }
        if (req instanceof LocationRequirement) {
            LocationRequirement lr = (LocationRequirement)req;
            return "Reach location";
        }
        if (req instanceof XpRequirement) {
            XpRequirement xr = (XpRequirement)req;
            return "Collect " + xr.getAmount() + " " + (xr.isLevels() ? "levels" : "XP");
        }
        if (req instanceof AdvancementRequirement) {
            AdvancementRequirement ar = (AdvancementRequirement)req;
            return "Complete advancement";
        }
        if (req instanceof BiomeRequirement) {
            BiomeRequirement br = (BiomeRequirement)req;
            return "Visit biome";
        }
        if (req instanceof DimensionRequirement) {
            DimensionRequirement dr = (DimensionRequirement)req;
            return "Enter dimension";
        }
        if (req instanceof CraftingRequirement) {
            CraftingRequirement cr = (CraftingRequirement)req;
            return "Craft " + cr.getCount() + " " + cr.getItem();
        }
        return req.getType() + " requirement";
    }

    private String getRequirementDetails(Requirement req) {
        if (req instanceof ItemRequirement) {
            ItemRequirement ir = (ItemRequirement)req;
            return "Item: " + ir.getItem() + " | Count: " + ir.getCount() + " | Consume: " + (ir.shouldConsume() ? "Yes" : "No");
        }
        if (req instanceof EntityKillRequirement) {
            EntityKillRequirement kr = (EntityKillRequirement)req;
            return "Entity: " + kr.getEntity() + " | Count: " + kr.getCount();
        }
        if (req instanceof LocationRequirement) {
            LocationRequirement lr = (LocationRequirement)req;
            return "X: " + lr.getX() + ", Y: " + lr.getY() + ", Z: " + lr.getZ() + " | Range: " + lr.getRange() + " | Dim: " + lr.getDimension();
        }
        if (req instanceof XpRequirement) {
            XpRequirement xr = (XpRequirement)req;
            return "Amount: " + xr.getAmount() + " | Type: " + (xr.isLevels() ? "Levels" : "Points");
        }
        if (req instanceof AdvancementRequirement) {
            AdvancementRequirement ar = (AdvancementRequirement)req;
            return "Advancement: " + ar.getAdvancement();
        }
        if (req instanceof BiomeRequirement) {
            BiomeRequirement br = (BiomeRequirement)req;
            return "Biome: " + br.getBiomeId() + (br.isTag() ? " (tag)" : "");
        }
        if (req instanceof DimensionRequirement) {
            DimensionRequirement dr = (DimensionRequirement)req;
            return "Dimension: " + dr.getDimensionId();
        }
        if (req instanceof CraftingRequirement) {
            CraftingRequirement cr = (CraftingRequirement)req;
            return "Item: " + cr.getItem() + " | Count: " + cr.getCount();
        }
        return "Type: " + req.getType();
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.addBtn.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.editBtn.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.removeBtn.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.moveUpBtn.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.moveDownBtn.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.sequentialBtn.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        int listX = this.x + 12;
        int listY = this.y + 32;
        int listW = this.w - 24;
        int listH = this.h - 80;
        if (mouseX >= (double)listX && mouseX <= (double)(listX + listW) && mouseY >= (double)listY && mouseY < (double)(listY + listH)) {
            int lineH = 40;
            int index = this.listScroll + ((int)mouseY - listY - 4) / lineH;
            if (index >= 0 && index < this.requirements.size()) {
                this.selectedIndex = index;
                if (button == 0 && mouseY - (double)listY - 4.0 - (double)((index - this.listScroll) * lineH) < (double)lineH) {
                    return true;
                }
            }
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        int listX = this.x + 12;
        int listY = this.y + 32;
        int listW = this.w - 24;
        int listH = this.h - 80;
        if (mouseX >= (double)listX && mouseX <= (double)(listX + listW) && mouseY >= (double)listY && mouseY < (double)(listY + listH)) {
            this.listScroll = (int)Math.max(0.0, (double)this.listScroll - Math.signum(delta));
            return true;
        }
        return false;
    }
}

