/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.questory.client.gui.QuestEditorScreen;
import org.texboobcat.questory.client.gui.RewardEditorScreen;
import org.texboobcat.questory.client.gui.RewardTypePickerScreen;
import org.texboobcat.questory.client.gui.TabPanel;
import org.texboobcat.questory.quest.AdvancementReward;
import org.texboobcat.questory.quest.ChoiceReward;
import org.texboobcat.questory.quest.CommandReward;
import org.texboobcat.questory.quest.CurrencyReward;
import org.texboobcat.questory.quest.ItemReward;
import org.texboobcat.questory.quest.LootReward;
import org.texboobcat.questory.quest.Quest;
import org.texboobcat.questory.quest.RandomReward;
import org.texboobcat.questory.quest.Reward;
import org.texboobcat.questory.quest.StageReward;
import org.texboobcat.questory.quest.TitleReward;
import org.texboobcat.questory.quest.ToastReward;
import org.texboobcat.questory.quest.XpLevelsReward;
import org.texboobcat.questory.quest.XpReward;

public class RewardsTabPanel
extends TabPanel {
    private List<Reward> rewards = new ArrayList<Reward>();
    private int selectedIndex = -1;
    private int listScroll = 0;
    private Button addBtn;
    private Button editBtn;
    private Button removeBtn;
    private Button moveUpBtn;
    private Button moveDownBtn;

    public RewardsTabPanel(QuestEditorScreen editor, int x, int y, int w, int h) {
        super(editor, x, y, w, h);
        this.initWidgets();
    }

    private void initWidgets() {
        int btnY = this.y + this.h - 32;
        this.addBtn = Button.m_253074_((Component)Component.m_237113_((String)"+ Add"), b -> this.openAddDialog()).m_252987_(this.x + 12, btnY, 60, 20).m_253136_();
        this.editBtn = Button.m_253074_((Component)Component.m_237113_((String)"Edit"), b -> this.openEditDialog()).m_252987_(this.x + 76, btnY, 60, 20).m_253136_();
        this.removeBtn = Button.m_253074_((Component)Component.m_237113_((String)"Remove"), b -> this.removeSelected()).m_252987_(this.x + 140, btnY, 70, 20).m_253136_();
        this.moveUpBtn = Button.m_253074_((Component)Component.m_237113_((String)"\u2191"), b -> this.moveUp()).m_252987_(this.x + 214, btnY, 30, 20).m_253136_();
        this.moveDownBtn = Button.m_253074_((Component)Component.m_237113_((String)"\u2193"), b -> this.moveDown()).m_252987_(this.x + 248, btnY, 30, 20).m_253136_();
    }

    private void openAddDialog() {
        this.getMinecraft().m_91152_((Screen)new RewardTypePickerScreen(this.editor, type -> {
            Reward reward = this.createRewardOfType((String)type);
            if (reward != null) {
                this.rewards.add(reward);
            }
            this.getMinecraft().m_91152_((Screen)this.editor);
        }));
    }

    private Reward createRewardOfType(String type) {
        return switch (type) {
            case "item" -> new ItemReward("minecraft:diamond", 1);
            case "xp" -> new XpReward(100, false);
            case "command" -> new CommandReward("/say {player} completed quest!", "Command Reward");
            case "loot" -> new LootReward("minecraft:chests/simple_dungeon");
            case "choice" -> new ChoiceReward("reward_table_1");
            case "random" -> new RandomReward("reward_table_1", 1);
            case "currency" -> new CurrencyReward("coins", 100L);
            case "advancement" -> new AdvancementReward("minecraft:story/mine_stone", null);
            case "stage" -> new StageReward("stage_name", false);
            case "title" -> new TitleReward("Quest Complete!", "Great job!");
            case "toast" -> new ToastReward("Achievement", "You earned a reward!");
            case "xp_levels" -> new XpLevelsReward(5);
            default -> null;
        };
    }

    private void openEditDialog() {
        if (this.selectedIndex >= 0 && this.selectedIndex < this.rewards.size()) {
            Reward reward = this.rewards.get(this.selectedIndex);
            this.getMinecraft().m_91152_((Screen)new RewardEditorScreen(this.editor, reward, updated -> {
                this.rewards.set(this.selectedIndex, (Reward)updated);
                this.getMinecraft().m_91152_((Screen)this.editor);
            }));
        }
    }

    private void removeSelected() {
        if (this.selectedIndex >= 0 && this.selectedIndex < this.rewards.size()) {
            this.rewards.remove(this.selectedIndex);
            this.selectedIndex = -1;
        }
    }

    private void moveUp() {
        if (this.selectedIndex > 0) {
            Reward temp = this.rewards.get(this.selectedIndex);
            this.rewards.set(this.selectedIndex, this.rewards.get(this.selectedIndex - 1));
            this.rewards.set(this.selectedIndex - 1, temp);
            --this.selectedIndex;
        }
    }

    private void moveDown() {
        if (this.selectedIndex >= 0 && this.selectedIndex < this.rewards.size() - 1) {
            Reward temp = this.rewards.get(this.selectedIndex);
            this.rewards.set(this.selectedIndex, this.rewards.get(this.selectedIndex + 1));
            this.rewards.set(this.selectedIndex + 1, temp);
            ++this.selectedIndex;
        }
    }

    @Override
    public void loadFromQuest(Quest quest) {
        this.rewards.clear();
        this.rewards.addAll(quest.getRewards());
        this.selectedIndex = -1;
        this.listScroll = 0;
    }

    @Override
    public void saveToQuest(Quest quest) {
        quest.getRewards().clear();
        quest.getRewards().addAll(this.rewards);
    }

    @Override
    public void render(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        int listX = this.x + 12;
        int listY = this.y + 12;
        int listW = this.w - 24;
        int listH = this.h - 60;
        g.m_280488_(this.getFont(), "\u00a7lRewards (" + this.rewards.size() + ")", listX, listY, -86);
        g.m_280509_(listX, listY += 20, listX + listW, listY + (listH -= 20), -803200992);
        g.m_280588_(listX, listY, listX + listW, listY + listH);
        int lineH = 36;
        int maxVisible = Math.max(1, listH / lineH);
        this.listScroll = Math.max(0, Math.min(this.listScroll, Math.max(0, this.rewards.size() - maxVisible)));
        for (int i = 0; i < Math.min(maxVisible, this.rewards.size() - this.listScroll); ++i) {
            boolean hover;
            int index = this.listScroll + i;
            Reward reward = this.rewards.get(index);
            int itemY = listY + 4 + i * lineH;
            boolean selected = index == this.selectedIndex;
            boolean bl = hover = mouseX >= listX && mouseX <= listX + listW && mouseY >= itemY && mouseY < itemY + lineH;
            if (selected) {
                g.m_280509_(listX + 2, itemY, listX + listW - 2, itemY + lineH - 2, -12952966);
            } else if (hover) {
                g.m_280509_(listX + 2, itemY, listX + listW - 2, itemY + lineH - 2, -14013910);
            }
            String typeLabel = "[" + reward.getType().toUpperCase() + "]";
            String summary = this.getRewardSummary(reward);
            g.m_280488_(this.getFont(), index + 1 + ". " + typeLabel + " " + summary, listX + 8, itemY + 4, -1);
            String details = this.getRewardDetails(reward);
            g.m_280488_(this.getFont(), "  \u2514\u2500 " + details, listX + 12, itemY + 18, -3355444);
        }
        g.m_280618_();
        this.addBtn.m_88315_(g, mouseX, mouseY, partialTick);
        this.editBtn.f_93623_ = this.selectedIndex >= 0;
        this.editBtn.m_88315_(g, mouseX, mouseY, partialTick);
        this.removeBtn.f_93623_ = this.selectedIndex >= 0;
        this.removeBtn.m_88315_(g, mouseX, mouseY, partialTick);
        this.moveUpBtn.f_93623_ = this.selectedIndex > 0;
        this.moveUpBtn.m_88315_(g, mouseX, mouseY, partialTick);
        this.moveDownBtn.f_93623_ = this.selectedIndex >= 0 && this.selectedIndex < this.rewards.size() - 1;
        this.moveDownBtn.m_88315_(g, mouseX, mouseY, partialTick);
    }

    private String getRewardSummary(Reward reward) {
        if (reward instanceof ItemReward) {
            ItemReward ir = (ItemReward)reward;
            return ir.getCount() + "x " + ir.getItem();
        }
        if (reward instanceof XpReward) {
            XpReward xr = (XpReward)reward;
            return xr.getAmount() + " " + (xr.isLevels() ? "Levels" : "XP");
        }
        if (reward instanceof CommandReward) {
            CommandReward cr = (CommandReward)reward;
            return cr.getDisplayName();
        }
        if (reward instanceof LootReward) {
            LootReward lr = (LootReward)reward;
            return "Loot: " + lr.getLootTable();
        }
        if (reward instanceof ChoiceReward) {
            ChoiceReward chr = (ChoiceReward)reward;
            return "Choice from table";
        }
        if (reward instanceof CurrencyReward) {
            CurrencyReward cur = (CurrencyReward)reward;
            return cur.getAmount() + " " + cur.getCurrencyId();
        }
        return reward.getType() + " reward";
    }

    private String getRewardDetails(Reward reward) {
        if (reward instanceof ItemReward) {
            ItemReward ir = (ItemReward)reward;
            return "Item: " + ir.getItem() + " | Count: " + ir.getCount();
        }
        if (reward instanceof XpReward) {
            XpReward xr = (XpReward)reward;
            return "Amount: " + xr.getAmount() + " | Type: " + (xr.isLevels() ? "Levels" : "Points");
        }
        if (reward instanceof CommandReward) {
            CommandReward cr = (CommandReward)reward;
            return "Command: " + cr.getCommand();
        }
        if (reward instanceof LootReward) {
            LootReward lr = (LootReward)reward;
            return "Table: " + lr.getLootTable();
        }
        if (reward instanceof CurrencyReward) {
            CurrencyReward cur = (CurrencyReward)reward;
            return "Currency: " + cur.getCurrencyId() + " | Amount: " + cur.getAmount();
        }
        return "Type: " + reward.getType();
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.addBtn.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.editBtn.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.removeBtn.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.moveUpBtn.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.moveDownBtn.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        int listX = this.x + 12;
        int listY = this.y + 32;
        int listW = this.w - 24;
        int listH = this.h - 80;
        if (mouseX >= (double)listX && mouseX <= (double)(listX + listW) && mouseY >= (double)listY && mouseY < (double)(listY + listH)) {
            int lineH = 36;
            int index = this.listScroll + ((int)mouseY - listY - 4) / lineH;
            if (index >= 0 && index < this.rewards.size()) {
                this.selectedIndex = index;
            }
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        int listX = this.x + 12;
        int listY = this.y + 32;
        int listW = this.w - 24;
        int listH = this.h - 80;
        if (mouseX >= (double)listX && mouseX <= (double)(listX + listW) && mouseY >= (double)listY && mouseY < (double)(listY + listH)) {
            this.listScroll = (int)Math.max(0.0, (double)this.listScroll - Math.signum(delta));
            return true;
        }
        return false;
    }
}

