/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.questory.client.gui.NewThemeEditorScreen;

class SelectorEditorScreen
extends Screen {
    private final Screen parent;
    private final List<NewThemeEditorScreen.SelectorEntry> entries;
    private final List<String> keys;
    private final Function<String, String> keyToLabel;
    private int listScroll = 0;
    private EditBox selectorBox;
    private EditBox valueBox;
    private String selectedKey = null;
    private int selectedIndex = -1;
    private int keyListScroll = 0;
    private EditBox keySearch;

    protected SelectorEditorScreen(Screen parent, List<NewThemeEditorScreen.SelectorEntry> entries, List<String> keys, Function<String, String> keyToLabel) {
        super((Component)Component.m_237113_((String)"Selectors"));
        this.parent = parent;
        this.entries = entries;
        this.keys = keys;
        this.keyToLabel = keyToLabel;
    }

    protected void m_7856_() {
        super.m_7856_();
        int by = this.f_96544_ - 28;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Add"), b -> {
            NewThemeEditorScreen.SelectorEntry se = new NewThemeEditorScreen.SelectorEntry();
            se.selector = "type:quest";
            se.values = new HashMap<String, String>();
            this.entries.add(se);
            this.selectedIndex = this.entries.size() - 1;
        }).m_252987_(8, by, 40, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Remove"), b -> {
            if (this.selectedIndex >= 0 && this.selectedIndex < this.entries.size()) {
                this.entries.remove(this.selectedIndex);
                this.selectedIndex = -1;
            }
        }).m_252987_(52, by, 60, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Close"), b -> this.f_96541_.m_91152_(this.parent)).m_252987_(this.f_96543_ - 70, by, 60, 20).m_253136_());
        this.selectorBox = new EditBox(this.f_96547_, this.f_96543_ / 2 - 140, 8, 280, 18, (Component)Component.m_237113_((String)"selector"));
        this.selectorBox.m_257771_((Component)Component.m_237113_((String)"e.g., type:quest or #tag or chapter:id"));
        this.m_142416_((GuiEventListener)this.selectorBox);
        this.valueBox = new EditBox(this.f_96547_, this.f_96543_ / 2 - 140, 30, 280, 18, (Component)Component.m_237113_((String)"value"));
        this.valueBox.m_257771_((Component)Component.m_237113_((String)"Select key, enter value, right-click to add"));
        this.m_142416_((GuiEventListener)this.valueBox);
        this.keySearch = new EditBox(this.f_96547_, this.f_96543_ - 230, 8, 220, 18, (Component)Component.m_237113_((String)"Search keys"));
        this.keySearch.m_257771_((Component)Component.m_237113_((String)"Filter property keys..."));
        this.m_142416_((GuiEventListener)this.keySearch);
    }

    public void m_88315_(GuiGraphics g, int mx, int my, float p) {
        NewThemeEditorScreen.SelectorEntry e;
        this.m_280273_(g);
        super.m_88315_(g, mx, my, p);
        int listX = 8;
        int listY = 8;
        int listW = this.f_96543_ / 2 - 160;
        int listH = this.f_96544_ - 40;
        g.m_280509_(listX, listY, listX + listW, listY + listH, -803200992);
        int lineH = 16;
        int max = Math.max(1, (listH - 8) / lineH);
        int start = Math.max(0, Math.min(this.listScroll, Math.max(0, this.entries.size() - max)));
        for (int i = 0; i < Math.min(max, this.entries.size() - start); ++i) {
            int y = listY + 4 + i * lineH;
            int idx = start + i;
            NewThemeEditorScreen.SelectorEntry e2 = this.entries.get(idx);
            int col = idx == this.selectedIndex ? -10845953 : -1;
            g.m_280488_(this.f_96547_, e2.selector == null ? "" : e2.selector, listX + 4, y, col);
        }
        int keyX = this.f_96543_ - 230;
        int keyY = 30;
        int keyW = 220;
        int keyH = this.f_96544_ - 60;
        g.m_280509_(keyX, keyY, keyX + keyW, keyH + keyY, -803200992);
        ArrayList<String> filtered = new ArrayList<String>();
        String q = this.keySearch.m_94155_().trim().toLowerCase();
        for (String k : this.keys) {
            if (!q.isEmpty() && !k.toLowerCase().contains(q) && !this.keyToLabel.apply(k).toLowerCase().contains(q)) continue;
            filtered.add(k);
        }
        int kmax = Math.max(1, (keyH - 8) / lineH);
        int kstart = Math.max(0, Math.min(this.keyListScroll, Math.max(0, filtered.size() - kmax)));
        for (int i = 0; i < Math.min(kmax, filtered.size() - kstart); ++i) {
            int y = keyY + 4 + i * lineH;
            String k = (String)filtered.get(kstart + i);
            int col = k.equals(this.selectedKey) ? -10845953 : -1;
            g.m_280488_(this.f_96547_, this.keyToLabel.apply(k), keyX + 4, y, col);
        }
        int cx = this.f_96543_ / 2 - 140;
        int cy = 56;
        int cw = 280;
        int ch = this.f_96544_ - 88;
        g.m_280509_(cx, cy, cx + cw, cy + ch, -804122094);
        g.m_280488_(this.f_96547_, "Selected Entry", cx + 4, cy - 12, -86);
        NewThemeEditorScreen.SelectorEntry selectorEntry = e = this.selectedIndex >= 0 && this.selectedIndex < this.entries.size() ? this.entries.get(this.selectedIndex) : null;
        if (e != null) {
            this.selectorBox.m_94144_(e.selector == null ? "" : e.selector);
            int vy = cy + 4;
            g.m_280488_(this.f_96547_, "Properties:", cx + 4, vy, -1);
            vy += 12;
            int count = 0;
            for (Map.Entry<String, String> kv : e.values.entrySet()) {
                g.m_280488_(this.f_96547_, kv.getKey() + ": " + kv.getValue(), cx + 6, vy, -2236963);
                vy += 12;
                if (++count <= 20) continue;
                break;
            }
        }
    }

    public boolean m_6375_(double mx, double my, int btn) {
        int listX = 8;
        int listY = 8;
        int listW = this.f_96543_ / 2 - 160;
        int listH = this.f_96544_ - 40;
        int lineH = 16;
        if (mx >= (double)listX && mx <= (double)(listX + listW) && my >= (double)listY && my <= (double)(listY + listH)) {
            int max = Math.max(1, (listH - 8) / lineH);
            int start = Math.max(0, Math.min(this.listScroll, Math.max(0, this.entries.size() - max)));
            int row = ((int)my - (listY + 4)) / lineH;
            int idx = start + row;
            if (row >= 0 && idx >= 0 && idx < this.entries.size()) {
                this.selectedIndex = idx;
                return true;
            }
        }
        int keyX = this.f_96543_ - 230;
        int keyY = 30;
        int keyW = 220;
        int keyH = this.f_96544_ - 60;
        if (mx >= (double)keyX && mx <= (double)(keyX + keyW) && my >= (double)keyY && my <= (double)(keyY + keyH)) {
            ArrayList<String> filtered = new ArrayList<String>();
            String q = this.keySearch.m_94155_().trim().toLowerCase();
            for (String k : this.keys) {
                if (!q.isEmpty() && !k.toLowerCase().contains(q) && !this.keyToLabel.apply(k).toLowerCase().contains(q)) continue;
                filtered.add(k);
            }
            int kmax = Math.max(1, (keyH - 8) / lineH);
            int kstart = Math.max(0, Math.min(this.keyListScroll, Math.max(0, filtered.size() - kmax)));
            int row = ((int)my - (keyY + 4)) / lineH;
            int idx = kstart + row;
            if (row >= 0 && idx >= 0 && idx < filtered.size()) {
                this.selectedKey = (String)filtered.get(idx);
                return true;
            }
        }
        if (btn == 1 && this.selectedIndex >= 0 && this.selectedIndex < this.entries.size() && this.selectedKey != null) {
            NewThemeEditorScreen.SelectorEntry e = this.entries.get(this.selectedIndex);
            e.selector = this.selectorBox.m_94155_();
            String v = this.valueBox.m_94155_();
            if (v != null) {
                e.values.put(this.selectedKey, v);
            }
            return true;
        }
        return super.m_6375_(mx, my, btn);
    }

    public boolean m_6050_(double mx, double my, double d) {
        int listX = 8;
        int listY = 8;
        int listW = this.f_96543_ / 2 - 160;
        int listH = this.f_96544_ - 40;
        int lineH = 16;
        if (mx >= (double)listX && mx <= (double)(listX + listW) && my >= (double)listY && my <= (double)(listY + listH)) {
            this.listScroll = (int)Math.max(0.0, (double)this.listScroll - Math.signum(d));
            return true;
        }
        int keyX = this.f_96543_ - 230;
        int keyY = 30;
        int keyW = 220;
        int keyH = this.f_96544_ - 60;
        if (mx >= (double)keyX && mx <= (double)(keyX + keyW) && my >= (double)keyY && my <= (double)(keyY + keyH)) {
            this.keyListScroll = (int)Math.max(0.0, (double)this.keyListScroll - Math.signum(d));
            return true;
        }
        return super.m_6050_(mx, my, d);
    }

    public boolean m_7043_() {
        return false;
    }
}

