/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import org.texboobcat.questory.Questory;
import org.texboobcat.questory.config.QuestoryConfig;
import org.texboobcat.questory.importer.FTBQuestImporter;
import org.texboobcat.questory.manager.DailyQuestManager;
import org.texboobcat.questory.manager.QuestManager;
import org.texboobcat.questory.network.NetworkManager;
import org.texboobcat.questory.network.OpenGuiPacket;
import org.texboobcat.questory.quest.Quest;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.quest.Requirement;
import org.texboobcat.questory.quest.Reward;
import org.texboobcat.questory.storage.QuestStorage;
import org.texboobcat.questory.validation.QuestValidator;

public class QuestCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"quest").then(Commands.m_82127_((String)"list").executes(QuestCommands::listQuests))).then(Commands.m_82127_((String)"info").then(Commands.m_82129_((String)"questId", (ArgumentType)StringArgumentType.string()).executes(QuestCommands::showQuestInfo)))).then(Commands.m_82127_((String)"progress").executes(QuestCommands::showProgress))).then(Commands.m_82127_((String)"complete").then(Commands.m_82129_((String)"questId", (ArgumentType)StringArgumentType.string()).executes(QuestCommands::completeQuest)))).then(Commands.m_82127_((String)"reset").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"questId", (ArgumentType)StringArgumentType.string()).requires(source -> source.m_6761_(2))).executes(QuestCommands::resetQuest)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"reload").requires(source -> source.m_6761_(2))).executes(QuestCommands::reloadQuests))).then(Commands.m_82127_((String)"track").then(Commands.m_82129_((String)"type", (ArgumentType)StringArgumentType.string()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"id", (ArgumentType)StringArgumentType.string()).requires(source -> source.m_6761_(2))).executes(QuestCommands::trackProgress))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"import").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"ftb").requires(source -> source.m_6761_(2))).executes(QuestCommands::importFTBQuestsAuto)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"path", (ArgumentType)StringArgumentType.greedyString()).requires(source -> source.m_6761_(2))).executes(QuestCommands::importFTBQuests)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"ftb-clean").requires(source -> source.m_6761_(2))).executes(QuestCommands::cleanFTBQuests)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"validate").requires(source -> source.m_6761_(2))).executes(QuestCommands::validateQuests))).then(Commands.m_82127_((String)"config").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"reload").requires(source -> source.m_6761_(2))).executes(QuestCommands::reloadConfig)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"daily").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"status").executes(ctx -> {
            String s = DailyQuestManager.getInstance().getStatusSummary();
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)s).m_130940_(ChatFormatting.YELLOW), false);
            return 1;
        }))).then(Commands.m_82127_((String)"reload").executes(ctx -> {
            boolean ok = DailyQuestManager.getInstance().reload();
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)(ok ? "Daily reloaded" : "Daily reload failed")).m_130940_(ok ? ChatFormatting.GREEN : ChatFormatting.RED), true);
            if (ok) {
                MinecraftServer server = ((CommandSourceStack)ctx.getSource()).m_81377_();
                QuestManager qm = QuestManager.getInstance();
                for (ServerPlayer sp : server.m_6846_().m_11314_()) {
                    qm.onPlayerJoin(sp);
                }
            }
            return ok ? 1 : 0;
        }))).then(Commands.m_82127_((String)"enable").executes(ctx -> {
            DailyQuestManager.getInstance().setEnabled(true);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"Daily enabled").m_130940_(ChatFormatting.GREEN), true);
            return 1;
        }))).then(Commands.m_82127_((String)"disable").executes(ctx -> {
            DailyQuestManager.getInstance().setEnabled(false);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"Daily disabled").m_130940_(ChatFormatting.YELLOW), true);
            return 1;
        }))).then(Commands.m_82127_((String)"seturl").then(Commands.m_82129_((String)"url", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            String url = StringArgumentType.getString((CommandContext)ctx, (String)"url");
            DailyQuestManager.getInstance().setRemoteUrl(url);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"Daily URL set").m_130940_(ChatFormatting.GREEN), true);
            return 1;
        }))))).then(Commands.m_82127_((String)"gui").executes(QuestCommands::openGui)));
    }

    private static int cleanFTBQuests(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        QuestManager manager = QuestManager.getInstance();
        int removed = 0;
        ArrayList<String> toRemove = new ArrayList<String>();
        for (Quest q : manager.getAllQuests()) {
            if (!q.getId().startsWith("ftb_")) continue;
            toRemove.add(q.getId());
        }
        for (String id : toRemove) {
            manager.unregisterQuest(id);
            ++removed;
        }
        int removedCount = removed;
        source.m_288197_(() -> Component.m_237113_((String)("Removed " + removedCount + " imported FTB quests")).m_130940_(ChatFormatting.YELLOW), true);
        manager.reload();
        return removed;
    }

    private static int listQuests(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        QuestManager manager = QuestManager.getInstance();
        List<Quest> visibleQuests = manager.getVisibleQuests(player.m_20148_());
        QuestProgress progress = manager.getProgress(player.m_20148_());
        player.m_213846_((Component)Component.m_237113_((String)"=== Your Quests ===").m_130940_(ChatFormatting.GOLD));
        for (Quest quest : visibleQuests) {
            boolean completed = progress.isQuestCompleted(quest.getId());
            String status = completed ? "\u2713" : " ";
            ChatFormatting color = completed ? ChatFormatting.GREEN : ChatFormatting.WHITE;
            player.m_213846_((Component)Component.m_237113_((String)("[" + status + "] " + quest.getTitle() + " (" + quest.getId() + ")")).m_130940_(color));
        }
        player.m_213846_((Component)Component.m_237113_((String)("Total: " + visibleQuests.size() + " quests")).m_130940_(ChatFormatting.GRAY));
        return visibleQuests.size();
    }

    private static int showQuestInfo(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        String questId = StringArgumentType.getString(context, (String)"questId");
        QuestManager manager = QuestManager.getInstance();
        Quest quest = manager.getQuest(questId);
        if (quest == null) {
            player.m_213846_((Component)Component.m_237113_((String)("Quest not found: " + questId)).m_130940_(ChatFormatting.RED));
            return 0;
        }
        QuestProgress progress = manager.getProgress(player.m_20148_());
        player.m_213846_((Component)Component.m_237113_((String)("=== " + quest.getTitle() + " ===")).m_130940_(ChatFormatting.GOLD));
        player.m_213846_((Component)Component.m_237113_((String)quest.getDescription()).m_130940_(ChatFormatting.WHITE));
        player.m_213846_((Component)Component.m_237113_((String)""));
        player.m_213846_((Component)Component.m_237113_((String)"Requirements:").m_130940_(ChatFormatting.YELLOW));
        for (Requirement req : quest.getRequirements()) {
            String progressText = req.getProgressDisplay(progress, questId);
            player.m_213846_((Component)Component.m_237113_((String)("  - " + progressText)).m_130940_(ChatFormatting.WHITE));
        }
        player.m_213846_((Component)Component.m_237113_((String)""));
        player.m_213846_((Component)Component.m_237113_((String)"Rewards:").m_130940_(ChatFormatting.YELLOW));
        for (Reward reward : quest.getRewards()) {
            player.m_213846_((Component)Component.m_237113_((String)("  - " + reward.getDisplayString())).m_130940_(ChatFormatting.GREEN));
        }
        player.m_213846_((Component)Component.m_237113_((String)""));
        if (progress.isQuestCompleted(questId)) {
            player.m_213846_((Component)Component.m_237113_((String)"Status: Completed \u2713").m_130940_(ChatFormatting.GREEN));
        } else if (quest.canComplete(progress)) {
            player.m_213846_((Component)Component.m_237113_((String)"Status: Ready to complete!").m_130940_(ChatFormatting.GREEN));
        } else if (quest.areRequirementsMet(progress)) {
            player.m_213846_((Component)Component.m_237113_((String)"Status: Requirements met, but dependencies not satisfied").m_130940_(ChatFormatting.YELLOW));
        } else {
            player.m_213846_((Component)Component.m_237113_((String)"Status: In progress").m_130940_(ChatFormatting.YELLOW));
        }
        return 1;
    }

    private static int showProgress(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        QuestManager manager = QuestManager.getInstance();
        QuestProgress progress = manager.getProgress(player.m_20148_());
        Collection<Quest> allQuests = manager.getAllQuests();
        int completed = progress.getCompletedQuests().size();
        player.m_213846_((Component)Component.m_237113_((String)"=== Quest Progress ===").m_130940_(ChatFormatting.GOLD));
        player.m_213846_((Component)Component.m_237113_((String)("Completed: " + completed + "/" + allQuests.size())).m_130940_(ChatFormatting.WHITE));
        List<Quest> completable = manager.getCompletableQuests(player.m_20148_());
        if (!completable.isEmpty()) {
            player.m_213846_((Component)Component.m_237113_((String)""));
            player.m_213846_((Component)Component.m_237113_((String)("Ready to complete (" + completable.size() + "):")).m_130940_(ChatFormatting.GREEN));
            for (Quest quest : completable) {
                player.m_213846_((Component)Component.m_237113_((String)("  - " + quest.getTitle())).m_130940_(ChatFormatting.WHITE));
            }
        }
        return 1;
    }

    private static int completeQuest(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        String questId = StringArgumentType.getString(context, (String)"questId");
        QuestManager manager = QuestManager.getInstance();
        if (manager.completeQuest(player, questId)) {
            Quest quest = manager.getQuest(questId);
            player.m_213846_((Component)Component.m_237113_((String)("Quest completed: " + quest.getTitle())).m_130940_(ChatFormatting.GREEN));
            return 1;
        }
        player.m_213846_((Component)Component.m_237113_((String)("Cannot complete quest: " + questId)).m_130940_(ChatFormatting.RED));
        return 0;
    }

    private static int importFTBQuestsAuto(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Path configPath = Questory.getConfigPath();
        List<Path> candidates = List.of(configPath.resolve("fabric").resolve("ftbquests"), configPath.resolve("neoforge").resolve("ftbquests"), configPath.resolve("forge").resolve("ftbquests"), configPath.resolve("ftbquests"));
        Path detected = null;
        for (Path p : candidates) {
            if (!Files.exists(p, new LinkOption[0])) continue;
            boolean hasQuests = Files.exists(p.resolve("quests"), new LinkOption[0]);
            boolean hasSNBT = false;
            try (Stream<Path> s2 = Files.walk(p, 2, new FileVisitOption[0]);){
                hasSNBT = s2.anyMatch(pp -> pp.toString().endsWith(".snbt"));
            }
            catch (Exception s2) {
                // empty catch block
            }
            if (!hasQuests && !hasSNBT) continue;
            detected = p;
            break;
        }
        if (detected == null) {
            source.m_81352_((Component)Component.m_237113_((String)"Could not auto-detect FTB Quests folder under config/. Provide a path: /quest import ftb <path>"));
            return 0;
        }
        Path detectedPath = detected;
        source.m_288197_(() -> Component.m_237113_((String)("Auto-detected FTB Quests at: " + String.valueOf(detectedPath))).m_130940_(ChatFormatting.YELLOW), true);
        try {
            FTBQuestImporter importer = new FTBQuestImporter(detected, new QuestStorage(Questory.getDataPath()));
            FTBQuestImporter.ImportResult result = importer.importFromFTBQuests();
            if (result.success) {
                source.m_288197_(() -> Component.m_237113_((String)("Successfully imported " + result.questCount + " quests!")).m_130940_(ChatFormatting.GREEN), true);
                for (String logLine : result.log) {
                    source.m_288197_(() -> Component.m_237113_((String)("  " + logLine)).m_130940_(ChatFormatting.GRAY), false);
                }
                QuestManager.getInstance().reload();
                return result.questCount;
            }
            source.m_81352_((Component)Component.m_237113_((String)"Import failed! Check console for details."));
            return 0;
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)("Import error: " + e.getMessage())).m_130940_(ChatFormatting.RED));
            e.printStackTrace();
            return 0;
        }
    }

    private static int resetQuest(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        String questId = StringArgumentType.getString(context, (String)"questId");
        QuestManager manager = QuestManager.getInstance();
        QuestProgress progress = manager.getProgress(player.m_20148_());
        progress.resetQuest(questId);
        player.m_213846_((Component)Component.m_237113_((String)("Quest reset: " + questId)).m_130940_(ChatFormatting.YELLOW));
        return 1;
    }

    private static int reloadQuests(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        QuestManager.getInstance().reload();
        source.m_288197_(() -> Component.m_237113_((String)"Reloaded quest system").m_130940_(ChatFormatting.GREEN), true);
        return 1;
    }

    private static int trackProgress(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        String type = StringArgumentType.getString(context, (String)"type");
        String id = StringArgumentType.getString(context, (String)"id");
        QuestManager manager = QuestManager.getInstance();
        switch (type.toLowerCase()) {
            case "item": {
                manager.trackItemProgress(player.m_20148_(), id, 1);
                break;
            }
            case "craft": {
                manager.trackCraftingProgress(player.m_20148_(), id, 1);
                break;
            }
            case "kill": {
                manager.trackEntityKillProgress(player.m_20148_(), id, 1);
                break;
            }
            case "advancement": {
                manager.trackAdvancementProgress(player.m_20148_(), id);
                break;
            }
            case "command": {
                manager.trackCommandProgress(player.m_20148_(), id);
                break;
            }
            default: {
                player.m_213846_((Component)Component.m_237113_((String)("Unknown tracking type: " + type)).m_130940_(ChatFormatting.RED));
                return 0;
            }
        }
        player.m_213846_((Component)Component.m_237113_((String)("Tracked progress: " + type + " - " + id)).m_130940_(ChatFormatting.GREEN));
        return 1;
    }

    private static int importFTBQuests(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String pathString = StringArgumentType.getString(context, (String)"path");
        source.m_288197_(() -> Component.m_237113_((String)("Starting FTB Quests import from: " + pathString)).m_130940_(ChatFormatting.YELLOW), true);
        try {
            Path ftbPath = Paths.get(pathString, new String[0]);
            FTBQuestImporter importer = new FTBQuestImporter(ftbPath, new QuestStorage(Questory.getDataPath()));
            FTBQuestImporter.ImportResult result = importer.importFromFTBQuests();
            if (result.success) {
                source.m_288197_(() -> Component.m_237113_((String)("Successfully imported " + result.questCount + " quests!")).m_130940_(ChatFormatting.GREEN), true);
                for (String logLine : result.log) {
                    source.m_288197_(() -> Component.m_237113_((String)("  " + logLine)).m_130940_(ChatFormatting.GRAY), false);
                }
                QuestManager.getInstance().reload();
                return result.questCount;
            }
            source.m_81352_((Component)Component.m_237113_((String)"Import failed! Check console for details."));
            return 0;
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)("Import error: " + e.getMessage())).m_130940_(ChatFormatting.RED));
            e.printStackTrace();
            return 0;
        }
    }

    private static int validateQuests(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        source.m_288197_(() -> Component.m_237113_((String)"Validating all quests...").m_130940_(ChatFormatting.YELLOW), true);
        QuestManager manager = QuestManager.getInstance();
        Map<String, QuestValidator.ValidationResult> results = QuestValidator.validateAll(manager.getAllQuests().stream().collect(Collectors.toMap(Quest::getId, q -> q)));
        int totalQuests = results.size();
        int validQuests = (int)results.values().stream().filter(r -> r.isValid()).count();
        int questsWithWarnings = (int)results.values().stream().filter(r -> r.hasWarnings()).count();
        int invalidQuests = totalQuests - validQuests;
        source.m_288197_(() -> Component.m_237113_((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").m_130940_(ChatFormatting.GOLD), false);
        source.m_288197_(() -> Component.m_237113_((String)"Quest Validation Results").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}), false);
        source.m_288197_(() -> Component.m_237113_((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").m_130940_(ChatFormatting.GOLD), false);
        source.m_288197_(() -> Component.m_237113_((String)("Total Quests: " + totalQuests)), false);
        source.m_288197_(() -> Component.m_237113_((String)("Valid: " + validQuests)).m_130940_(ChatFormatting.GREEN), false);
        source.m_288197_(() -> Component.m_237113_((String)("Invalid: " + invalidQuests)).m_130940_(invalidQuests > 0 ? ChatFormatting.RED : ChatFormatting.GREEN), false);
        source.m_288197_(() -> Component.m_237113_((String)("With Warnings: " + questsWithWarnings)).m_130940_(questsWithWarnings > 0 ? ChatFormatting.YELLOW : ChatFormatting.GREEN), false);
        for (Map.Entry<String, QuestValidator.ValidationResult> entry : results.entrySet()) {
            QuestValidator.ValidationResult result = entry.getValue();
            if (result.isValid() && !result.hasWarnings()) continue;
            source.m_288197_(() -> Component.m_237113_((String)("\n" + result.getSummary())).m_130940_(ChatFormatting.WHITE), false);
        }
        return validQuests;
    }

    private static int reloadConfig(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        try {
            QuestoryConfig.reload(Questory.getConfigPath());
            source.m_288197_(() -> Component.m_237113_((String)"Config reloaded successfully").m_130940_(ChatFormatting.GREEN), true);
            return 1;
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)("Failed to reload config: " + e.getMessage())).m_130940_(ChatFormatting.RED));
            return 0;
        }
    }

    private static int openGui(CommandContext<CommandSourceStack> context) {
        try {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            NetworkManager.sendToClient(player, new OpenGuiPacket());
            return 1;
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Failed to open GUI: " + e.getMessage())).m_130940_(ChatFormatting.RED));
            return 0;
        }
    }
}

