/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.events;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.texboobcat.questory.api.events.QuestEventBus;
import org.texboobcat.questory.api.events.QuestProgressEvent;
import org.texboobcat.questory.api.events.QuestStartedEvent;
import org.texboobcat.questory.manager.QuestManager;
import org.texboobcat.questory.network.NetworkManager;
import org.texboobcat.questory.network.ProgressSyncPacket;
import org.texboobcat.questory.quest.BiomeRequirement;
import org.texboobcat.questory.quest.DimensionRequirement;
import org.texboobcat.questory.quest.ItemRequirement;
import org.texboobcat.questory.quest.ItemTagRequirement;
import org.texboobcat.questory.quest.LocationRequirement;
import org.texboobcat.questory.quest.Quest;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.quest.RegionRequirement;
import org.texboobcat.questory.quest.Requirement;
import org.texboobcat.questory.quest.StructureRequirement;
import org.texboobcat.questory.quest.TimeRequirement;
import org.texboobcat.questory.quest.WeatherRequirement;

public class QuestEvents {
    public static void onItemObtained(ServerPlayer player, ItemStack stack) {
        if (stack.m_41619_()) {
            System.out.println("[Questory Debug] onItemObtained called with empty stack");
            return;
        }
        ResourceLocation itemId = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_());
        System.out.println("[Questory Debug] onItemObtained: Player=" + player.m_7755_().getString() + ", Item=" + String.valueOf(itemId) + ", Count=" + stack.m_41613_());
        QuestManager.getInstance().trackItemProgress(player.m_20148_(), itemId.toString(), stack.m_41613_(), player);
    }

    public static void onItemCrafted(ServerPlayer player, ItemStack stack) {
        if (stack.m_41619_()) {
            return;
        }
        ResourceLocation itemId = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_());
        QuestManager.getInstance().trackCraftingProgress(player.m_20148_(), itemId.toString(), stack.m_41613_(), player);
        QuestEvents.onItemObtained(player, stack);
    }

    public static void onEntityKilled(ServerPlayer player, LivingEntity entity) {
        ResourceLocation entityId = BuiltInRegistries.f_256780_.m_7981_((Object)entity.m_6095_());
        QuestManager.getInstance().trackEntityKillProgress(player.m_20148_(), entityId.toString(), 1, player);
    }

    public static void onAdvancementEarned(ServerPlayer player, ResourceLocation advancementId) {
        QuestManager.getInstance().trackAdvancementProgress(player.m_20148_(), advancementId.toString(), player);
    }

    public static void onPlayerDisconnect(ServerPlayer player) {
        QuestManager.getInstance().onPlayerDisconnect(player.m_20148_());
    }

    public static void onPlayerJoin(ServerPlayer player) {
        QuestManager.getInstance().onPlayerJoin(player);
    }

    public static void onInventoryChanged(ServerPlayer player) {
        QuestManager manager = QuestManager.getInstance();
        QuestProgress progress = manager.getProgress(player.m_20148_());
        boolean changed = false;
        for (Quest quest : manager.getAllQuests()) {
            if (progress.isQuestCompleted(quest.getId())) continue;
            for (Requirement req : quest.getRequirements()) {
                int existing;
                int before;
                int cap;
                int invCount;
                if (req instanceof ItemRequirement) {
                    ItemRequirement itemReq = (ItemRequirement)req;
                    invCount = QuestEvents.countItemInInventory(player, itemReq.getItem());
                    cap = Math.min(invCount, itemReq.getCount());
                    if (!itemReq.shouldConsume()) {
                        before = progress.getRequirementProgress(quest.getId(), req);
                        if (before == cap) continue;
                        progress.setRequirementProgress(quest.getId(), req, cap);
                        changed = true;
                        continue;
                    }
                    existing = progress.getRequirementProgress(quest.getId(), req);
                    if (cap <= existing) continue;
                    progress.setRequirementProgress(quest.getId(), req, cap);
                    changed = true;
                    continue;
                }
                if (!(req instanceof ItemTagRequirement)) continue;
                ItemTagRequirement tagReq = (ItemTagRequirement)req;
                invCount = QuestEvents.countItemTagInInventory(player, tagReq.getTag());
                cap = Math.min(invCount, tagReq.getCount());
                if (!tagReq.shouldConsume()) {
                    before = progress.getRequirementProgress(quest.getId(), req);
                    if (before == cap) continue;
                    progress.setRequirementProgress(quest.getId(), req, cap);
                    changed = true;
                    continue;
                }
                existing = progress.getRequirementProgress(quest.getId(), req);
                if (cap <= existing) continue;
                progress.setRequirementProgress(quest.getId(), req, cap);
                changed = true;
            }
        }
        if (changed) {
            NetworkManager.sendToClient(player, new ProgressSyncPacket(progress));
        }
    }

    private static int countItemInInventory(ServerPlayer player, String itemIdString) {
        ResourceLocation itemId = new ResourceLocation(itemIdString);
        Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(itemId);
        if (item == null) {
            return 0;
        }
        int total = 0;
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (stack.m_41619_() || stack.m_41720_() != item) continue;
            total += stack.m_41613_();
        }
        return total;
    }

    private static int countItemTagInInventory(ServerPlayer player, String tagId) {
        TagKey key = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation(tagId));
        int total = 0;
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (stack.m_41619_() || !stack.m_204117_(key)) continue;
            total += stack.m_41613_();
        }
        return total;
    }

    public static void onStatisticChanged(ServerPlayer player, String statistic, int value) {
        QuestManager.getInstance().trackStatisticProgress(player.m_20148_(), statistic, value, player);
    }

    public static void onEnvironmentTick(ServerPlayer player) {
        QuestManager manager = QuestManager.getInstance();
        QuestProgress progress = manager.getProgress(player.m_20148_());
        boolean changed = false;
        ServerLevel level = player.m_284548_();
        BlockPos pos = player.m_20183_();
        Registry biomeRegistry = level.m_9598_().m_175515_(Registries.f_256952_);
        ResourceLocation biomeId = biomeRegistry.m_7981_((Object)((Biome)level.m_204166_(pos).m_203334_()));
        String dimId = level.m_46472_().m_135782_().toString();
        long dayTime = level.m_46468_() % 24000L;
        boolean isRaining = level.m_46471_();
        boolean isThundering = level.m_46470_();
        for (Quest quest : manager.getAllQuests()) {
            if (progress.isQuestCompleted(quest.getId())) continue;
            for (Requirement req : quest.getRequirements()) {
                boolean dimOk;
                boolean anyBefore;
                boolean ok;
                if (req instanceof BiomeRequirement) {
                    BiomeRequirement biomeReq = (BiomeRequirement)req;
                    if (biomeReq.isTag()) {
                        TagKey key = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation(biomeReq.getBiomeId().substring(1)));
                        ok = level.m_204166_(pos).m_203656_(key);
                    } else {
                        ok = biomeId != null && biomeId.toString().equals(biomeReq.getBiomeId());
                    }
                    int before = progress.getRequirementProgress(quest.getId(), req);
                    anyBefore = QuestEvents.hasAnyProgress(progress, quest);
                    int now = ok ? 1 : 0;
                    if (before == now) continue;
                    progress.setRequirementProgress(quest.getId(), req, now);
                    changed = true;
                    try {
                        QuestEventBus.post(new QuestProgressEvent(player, quest, req, before, now));
                        if (anyBefore || now <= 0) continue;
                        QuestEventBus.post(new QuestStartedEvent(player, quest));
                    }
                    catch (Throwable throwable) {}
                    continue;
                }
                if (req instanceof DimensionRequirement) {
                    DimensionRequirement dimReq = (DimensionRequirement)req;
                    ok = dimId.equals(dimReq.getDimensionId());
                    int before = progress.getRequirementProgress(quest.getId(), req);
                    anyBefore = QuestEvents.hasAnyProgress(progress, quest);
                    int now = ok ? 1 : 0;
                    if (before == now) continue;
                    progress.setRequirementProgress(quest.getId(), req, now);
                    changed = true;
                    try {
                        QuestEventBus.post(new QuestProgressEvent(player, quest, req, before, now));
                        if (anyBefore || now <= 0) continue;
                        QuestEventBus.post(new QuestStartedEvent(player, quest));
                    }
                    catch (Throwable throwable) {}
                    continue;
                }
                if (req instanceof LocationRequirement) {
                    int r;
                    int dz;
                    int dy;
                    LocationRequirement locReq = (LocationRequirement)req;
                    dimOk = locReq.getDimension().equals(dimId);
                    if (!dimOk) continue;
                    int dx = pos.m_123341_() - locReq.getX();
                    boolean ok2 = dx * dx + (dy = pos.m_123342_() - locReq.getY()) * dy + (dz = pos.m_123343_() - locReq.getZ()) * dz <= (r = locReq.getRange()) * r;
                    int before = progress.getRequirementProgress(quest.getId(), req);
                    boolean anyBefore2 = QuestEvents.hasAnyProgress(progress, quest);
                    int now = ok2 ? 1 : 0;
                    if (before == now) continue;
                    progress.setRequirementProgress(quest.getId(), req, now);
                    changed = true;
                    try {
                        QuestEventBus.post(new QuestProgressEvent(player, quest, req, before, now));
                        if (anyBefore2 || now <= 0) continue;
                        QuestEventBus.post(new QuestStartedEvent(player, quest));
                    }
                    catch (Throwable throwable) {}
                    continue;
                }
                if (req instanceof RegionRequirement) {
                    RegionRequirement regReq = (RegionRequirement)req;
                    dimOk = regReq.getDimension().equals(dimId);
                    boolean in = dimOk && pos.m_123341_() >= regReq.getMinX() && pos.m_123341_() <= regReq.getMaxX() && pos.m_123342_() >= regReq.getMinY() && pos.m_123342_() <= regReq.getMaxY() && pos.m_123343_() >= regReq.getMinZ() && pos.m_123343_() <= regReq.getMaxZ();
                    int before = progress.getRequirementProgress(quest.getId(), req);
                    boolean anyBefore3 = QuestEvents.hasAnyProgress(progress, quest);
                    int now2 = in ? 1 : 0;
                    if (before == now2) continue;
                    progress.setRequirementProgress(quest.getId(), req, now2);
                    changed = true;
                    try {
                        QuestEventBus.post(new QuestProgressEvent(player, quest, req, before, now2));
                        if (anyBefore3 || now2 <= 0) continue;
                        QuestEventBus.post(new QuestStartedEvent(player, quest));
                    }
                    catch (Throwable ok2) {}
                    continue;
                }
                if (req instanceof TimeRequirement) {
                    long end;
                    TimeRequirement timeReq = (TimeRequirement)req;
                    long start = timeReq.getStart();
                    boolean inWindow = start <= (end = timeReq.getEnd()) ? dayTime >= start && dayTime <= end : dayTime >= start || dayTime <= end;
                    int before = progress.getRequirementProgress(quest.getId(), req);
                    boolean anyBefore4 = QuestEvents.hasAnyProgress(progress, quest);
                    int now = inWindow ? 1 : 0;
                    if (before == now) continue;
                    progress.setRequirementProgress(quest.getId(), req, now);
                    changed = true;
                    try {
                        QuestEventBus.post(new QuestProgressEvent(player, quest, req, before, now));
                        if (anyBefore4 || now <= 0) continue;
                        QuestEventBus.post(new QuestStartedEvent(player, quest));
                    }
                    catch (Throwable throwable) {}
                    continue;
                }
                if (req instanceof WeatherRequirement) {
                    WeatherRequirement weatherReq = (WeatherRequirement)req;
                    ok = switch (weatherReq.getMode()) {
                        default -> throw new IncompatibleClassChangeError();
                        case WeatherRequirement.Mode.CLEAR -> {
                            if (!isRaining && !isThundering) {
                                yield true;
                            }
                            yield false;
                        }
                        case WeatherRequirement.Mode.RAIN -> {
                            if (isRaining && !isThundering) {
                                yield true;
                            }
                            yield false;
                        }
                        case WeatherRequirement.Mode.THUNDER -> isThundering;
                    };
                    int before = progress.getRequirementProgress(quest.getId(), req);
                    anyBefore = QuestEvents.hasAnyProgress(progress, quest);
                    int now = ok ? 1 : 0;
                    if (before == now) continue;
                    progress.setRequirementProgress(quest.getId(), req, now);
                    changed = true;
                    try {
                        QuestEventBus.post(new QuestProgressEvent(player, quest, req, before, now));
                        if (anyBefore || now <= 0) continue;
                        QuestEventBus.post(new QuestStartedEvent(player, quest));
                    }
                    catch (Throwable now2) {}
                    continue;
                }
                if (!(req instanceof StructureRequirement)) continue;
                StructureRequirement structReq = (StructureRequirement)req;
                ok = false;
                try {
                    StructureManager mgr = level.m_215010_();
                    if (structReq.getStructureId().startsWith("#")) {
                        TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256944_, (ResourceLocation)new ResourceLocation(structReq.getStructureId().substring(1)));
                        ok = mgr.m_220491_(pos, tag).m_73603_();
                    } else {
                        ResourceKey key;
                        Registry structReg = level.m_9598_().m_175515_(Registries.f_256944_);
                        Structure structure = (Structure)structReg.m_6246_(key = ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)new ResourceLocation(structReq.getStructureId())));
                        ok = structure != null && mgr.m_220524_(pos, structure).m_73603_();
                    }
                }
                catch (Throwable mgr) {
                    // empty catch block
                }
                int before = progress.getRequirementProgress(quest.getId(), req);
                anyBefore = QuestEvents.hasAnyProgress(progress, quest);
                int now = ok ? 1 : 0;
                if (before == now) continue;
                progress.setRequirementProgress(quest.getId(), req, now);
                changed = true;
                try {
                    QuestEventBus.post(new QuestProgressEvent(player, quest, req, before, now));
                    if (anyBefore || now <= 0) continue;
                    QuestEventBus.post(new QuestStartedEvent(player, quest));
                }
                catch (Throwable throwable) {}
            }
        }
        if (changed) {
            NetworkManager.sendToClient(player, new ProgressSyncPacket(progress));
        }
    }

    private static boolean hasAnyProgress(QuestProgress progress, Quest quest) {
        for (Requirement r : quest.getRequirements()) {
            if (progress.getRequirementProgress(quest.getId(), r) <= 0) continue;
            return true;
        }
        return false;
    }
}

