/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.quest;

import com.google.gson.JsonObject;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.texboobcat.questory.quest.Reward;

public class CommandReward
extends Reward {
    private String command;
    private String displayName;

    public CommandReward(String command, String displayName) {
        super("command");
        this.command = command;
        this.displayName = displayName;
    }

    public String getCommand() {
        return this.command;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public void grant(ServerPlayer player) {
        String processedCommand = this.command.replace("{player}", player.m_36316_().getName()).replace("{uuid}", player.m_20149_()).replace("{x}", String.valueOf((int)player.m_20185_())).replace("{y}", String.valueOf((int)player.m_20186_())).replace("{z}", String.valueOf((int)player.m_20189_()));
        CommandSourceStack source = new CommandSourceStack((CommandSource)player, player.m_20182_(), player.m_20155_(), player.m_284548_(), 4, player.m_7755_().getString(), player.m_5446_(), player.f_8924_, (Entity)player);
        try {
            player.f_8924_.m_129892_().m_230957_(source, processedCommand);
        }
        catch (Exception e) {
            System.err.println("Failed to execute reward command: " + processedCommand);
            e.printStackTrace();
        }
    }

    @Override
    public String getDisplayString() {
        return this.displayName != null ? this.displayName : "Execute Command";
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", this.type);
        json.addProperty("command", this.command);
        if (this.displayName != null) {
            json.addProperty("displayName", this.displayName);
        }
        return json;
    }

    public static CommandReward fromJson(JsonObject json) {
        String command = json.get("command").getAsString();
        String displayName = json.has("displayName") ? json.get("displayName").getAsString() : null;
        return new CommandReward(command, displayName);
    }
}

