/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client;

import com.mojang.blaze3d.platform.Window;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import org.texboobcat.questory.client.ClientConfig;
import org.texboobcat.questory.client.gui.UiScalePopupScreen;

public final class UiScaleUtil {
    private static final Set<String> shownContexts = new HashSet<String>();

    private UiScaleUtil() {
    }

    public static void warnIfEditorScaleNotOne(Screen screen, String contextKey) {
        try {
            if (screen == null) {
                return;
            }
            Minecraft mc = Minecraft.m_91087_();
            if (mc == null || mc.f_91074_ == null || mc.m_91268_() == null) {
                return;
            }
            if (ClientConfig.isSuppressUiScaleEditorWarning()) {
                return;
            }
            if (screen.getClass().getName().endsWith("UiScalePopupScreen")) {
                return;
            }
            if (contextKey == null || contextKey.isEmpty()) {
                contextKey = screen.getClass().getSimpleName();
            }
            if (shownContexts.contains(contextKey)) {
                return;
            }
            Window window = mc.m_91268_();
            int scaledW = Math.max(1, window.m_85445_());
            int rawW = Math.max(1, window.m_85441_());
            double scale = (double)rawW / (double)scaledW;
            int approx = (int)Math.round(scale);
            if (approx >= 3) {
                shownContexts.add(contextKey);
                mc.m_91152_((Screen)new UiScalePopupScreen(screen, contextKey));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

