/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import org.texboobcat.questory.client.ClientQuestManager;
import org.texboobcat.questory.client.gui.QuestEditorScreen;
import org.texboobcat.questory.client.gui.TabPanel;
import org.texboobcat.questory.quest.ChapterData;
import org.texboobcat.questory.quest.Quest;
import org.texboobcat.questory.quest.QuestProgress;

public class DependenciesTabPanel
extends TabPanel {
    private List<Quest> availableQuests = new ArrayList<Quest>();
    private Set<String> selectedDeps = new HashSet<String>();
    private int availableScroll = 0;
    private String searchQuery = "";
    private EditBox searchBox;
    private static final Pattern TOKEN_PATTERN = Pattern.compile("\"([^\"]*)\"|(\\S+)");
    private String lastSearchQueryCache = null;
    private List<Term> cachedTerms = Collections.emptyList();
    private Button addBtn;
    private Button removeBtn;
    private Button clearBtn;
    private Button modeAllBtn;
    private Button modeOneBtn;
    private Button modeStartedBtn;
    private String depMode = "all_completed";
    private int minRequired = 0;
    private int maxCompletable = 0;
    private boolean hideLines = false;
    private String lineStyle = "solid";

    public DependenciesTabPanel(QuestEditorScreen editor, int x, int y, int w, int h) {
        super(editor, x, y, w, h);
        this.initWidgets();
    }

    private void initWidgets() {
        int searchW = this.w / 2 - 20 - 8;
        this.searchBox = new EditBox(this.editor.getMinecraft().f_91062_, this.x + 16, this.y + 32, searchW, 16, (Component)Component.m_237113_((String)"Search"));
        this.searchBox.m_257771_((Component)Component.m_237113_((String)"Search quests (id,title,group,chapter,tags). Use tag: or #tag"));
        this.searchBox.m_94151_(text -> {
            this.searchQuery = text.toLowerCase();
            this.lastSearchQueryCache = null;
        });
        this.fields.add(this.searchBox);
        int btnY = this.y + this.h - 32;
        this.addBtn = Button.m_253074_((Component)Component.m_237113_((String)"Add Selected \u2192"), b -> this.addSelectedDeps()).m_252987_(this.x + 12, btnY, 120, 20).m_253136_();
        this.removeBtn = Button.m_253074_((Component)Component.m_237113_((String)"\u2190 Remove"), b -> this.removeSelectedDeps()).m_252987_(this.x + 140, btnY, 100, 20).m_253136_();
        this.clearBtn = Button.m_253074_((Component)Component.m_237113_((String)"Clear All"), b -> this.clearAllDeps()).m_252987_(this.x + 248, btnY, 80, 20).m_253136_();
        int modeX = this.x + this.w - 400;
        int modeY = this.y + 12;
        this.modeAllBtn = Button.m_253074_((Component)Component.m_237113_((String)"All Complete"), b -> this.setDepMode("all_completed")).m_252987_(modeX, modeY, 100, 18).m_253136_();
        this.modeOneBtn = Button.m_253074_((Component)Component.m_237113_((String)"One Complete"), b -> this.setDepMode("one_completed")).m_252987_(modeX + 104, modeY, 100, 18).m_253136_();
        this.modeStartedBtn = Button.m_253074_((Component)Component.m_237113_((String)"All Started"), b -> this.setDepMode("all_started")).m_252987_(modeX + 208, modeY, 90, 18).m_253136_();
    }

    private void setDepMode(String mode) {
        this.depMode = mode;
    }

    private void addSelectedDeps() {
    }

    private void removeSelectedDeps() {
    }

    private void clearAllDeps() {
        this.selectedDeps.clear();
    }

    @Override
    public void loadFromQuest(Quest quest) {
        this.availableQuests = new ArrayList<Quest>(ClientQuestManager.getInstance().getAllQuests());
        this.availableQuests.removeIf(q -> q.getId().equals(quest.getId()));
        this.selectedDeps.clear();
        this.selectedDeps.addAll(quest.getDependencies());
        this.depMode = quest.getDependencyRequirement();
        this.minRequired = quest.getMinRequiredDependencies();
        this.maxCompletable = quest.getMaxCompletableDeps();
        this.hideLines = quest.isHideDependencyLines();
        this.lineStyle = quest.getLineStyle();
    }

    @Override
    public void saveToQuest(Quest quest) {
        quest.getDependencies().clear();
        quest.getDependencies().addAll(this.selectedDeps);
        quest.setDependencyRequirement(this.depMode);
        quest.setMinRequiredDependencies(this.minRequired);
        quest.setMaxCompletableDeps(this.maxCompletable);
        quest.setHideDependencyLines(this.hideLines);
        quest.setLineStyle(this.lineStyle);
    }

    @Override
    public void render(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        int leftW = this.w / 2 - 20;
        int rightW = this.w / 2 - 20;
        int leftX = this.x + 12;
        int rightX = this.x + this.w / 2 + 8;
        int listY = this.y + 54;
        int listH = this.h - 104;
        g.m_280509_(leftX, listY, leftX + leftW, listY + listH, -803200992);
        g.m_280488_(this.getFont(), "\u00a7lAvailable Quests", leftX, this.y + 12, -86);
        int searchW = this.w / 2 - 20 - 8;
        this.searchBox.m_264152_(this.x + 16, this.y + 32);
        this.searchBox.m_88315_(g, mouseX, mouseY, partialTick);
        this.renderAvailableList(g, leftX, listY, leftW, listH, mouseX, mouseY);
        g.m_280509_(rightX, listY, rightX + rightW, listY + listH, -803200992);
        g.m_280488_(this.getFont(), "\u00a7lSelected Dependencies", rightX, this.y + 12, -86);
        this.renderSelectedList(g, rightX, listY, rightW, listH, mouseX, mouseY);
        int modeX = this.x + this.w - 400;
        int modeY = this.y + 12;
        g.m_280488_(this.getFont(), "Dependency Mode:", modeX - 120, modeY + 5, -1);
        this.modeAllBtn.m_88315_(g, mouseX, mouseY, partialTick);
        this.modeOneBtn.m_88315_(g, mouseX, mouseY, partialTick);
        this.modeStartedBtn.m_88315_(g, mouseX, mouseY, partialTick);
        this.addBtn.m_88315_(g, mouseX, mouseY, partialTick);
        this.removeBtn.m_88315_(g, mouseX, mouseY, partialTick);
        this.clearBtn.m_88315_(g, mouseX, mouseY, partialTick);
    }

    private void renderAvailableList(GuiGraphics g, int lx, int ly, int lw, int lh, int mx, int my) {
        g.m_280588_(lx, ly, lx + lw, ly + lh);
        int lineH = 16;
        int y = ly + 4;
        List<Quest> filteredQuests = this.getFilteredAvailableQuests();
        for (Quest q : filteredQuests) {
            if (y > ly + lh) break;
            boolean inDeps = this.selectedDeps.contains(q.getId());
            String label = (inDeps ? "\u2713 " : "  ") + q.getTitle();
            g.m_280488_(this.getFont(), label, lx + 4, y, inDeps ? -7798904 : -1);
            y += lineH;
        }
        g.m_280618_();
    }

    private void renderSelectedList(GuiGraphics g, int rx, int ry, int rw, int rh, int mx, int my) {
        g.m_280588_(rx, ry, rx + rw, ry + rh);
        int lineH = 16;
        int y = ry + 4;
        for (String depId : this.selectedDeps) {
            if (y > ry + rh) break;
            Quest dep = ClientQuestManager.getInstance().getQuest(depId);
            String label = dep != null ? dep.getTitle() : depId;
            g.m_280488_(this.getFont(), "\u2192 " + label, rx + 4, y, -1);
            y += lineH;
        }
        g.m_280618_();
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int searchW = this.w / 2 - 20 - 8;
        this.searchBox.m_264152_(this.x + 16, this.y + 32);
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (this.addBtn.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.removeBtn.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.clearBtn.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.modeAllBtn.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.modeOneBtn.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.modeStartedBtn.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        int leftX = this.x + 12;
        int leftW = this.w / 2 - 20;
        int listY = this.y + 54;
        int listH = this.h - 104;
        if (mouseX >= (double)leftX && mouseX <= (double)(leftX + leftW) && mouseY >= (double)listY && mouseY < (double)(listY + listH)) {
            List<Quest> filteredQuests = this.getFilteredAvailableQuests();
            int index = ((int)mouseY - listY - 4) / 16;
            if (index >= 0 && index < filteredQuests.size()) {
                Quest q = filteredQuests.get(index);
                if (this.selectedDeps.contains(q.getId())) {
                    this.selectedDeps.remove(q.getId());
                } else {
                    this.selectedDeps.add(q.getId());
                }
                return true;
            }
        }
        return false;
    }

    private List<Quest> getFilteredAvailableQuests() {
        String query;
        String raw = this.searchBox != null ? this.searchBox.m_94155_() : this.searchQuery;
        String string = query = raw == null ? "" : raw.trim().toLowerCase();
        if (query.isEmpty()) {
            return this.availableQuests;
        }
        HashMap<String, String> chapterIdToTitle = new HashMap<String, String>();
        for (ChapterData cd : ClientQuestManager.getInstance().getAllChapters()) {
            if (cd == null || cd.getId() == null) continue;
            chapterIdToTitle.put(cd.getId().toLowerCase(), cd.getTitle() == null ? "" : cd.getTitle());
        }
        if (!query.equals(this.lastSearchQueryCache)) {
            ArrayList<String> tokens = new ArrayList<String>();
            Matcher m = TOKEN_PATTERN.matcher(query);
            while (m.find()) {
                String t = m.group(1) != null ? m.group(1) : m.group(2);
                if (t == null || t.isBlank()) continue;
                tokens.add(t.trim());
            }
            ArrayList<Term> terms = new ArrayList<Term>();
            for (String t : tokens) {
                if (t.startsWith("#")) {
                    String v = t.substring(1);
                    if (v.isBlank()) continue;
                    terms.add(new Term("tag", v));
                    continue;
                }
                int idx = t.indexOf(58);
                if (idx > 0) {
                    String key = t.substring(0, idx);
                    String val = t.substring(idx + 1);
                    if (key.equals("g")) {
                        key = "group";
                    } else if (key.equals("t")) {
                        key = "tag";
                    } else if (key.equals("c") || key.equals("chap") || key.equals("chapterid")) {
                        key = "chapter";
                    } else if (key.equals("name")) {
                        key = "title";
                    }
                    terms.add(new Term(key, val));
                    continue;
                }
                terms.add(new Term("any", t));
            }
            this.cachedTerms = terms;
            this.lastSearchQueryCache = query;
        }
        QuestProgress progress = ClientQuestManager.getInstance().getProgress();
        return this.availableQuests.stream().filter(q -> {
            String ct;
            String id = q.getId() == null ? "" : q.getId().toLowerCase();
            String title = q.getTitle() == null ? "" : q.getTitle().toLowerCase();
            String group = q.getGroup() == null ? "" : q.getGroup().toLowerCase();
            String cid = q.getChapterId();
            String chapterTitle = "";
            if (cid != null && (ct = (String)chapterIdToTitle.get(cid.toLowerCase())) != null) {
                chapterTitle = ct.toLowerCase();
            }
            List<String> tagsLower = q.getTags() == null ? Collections.emptyList() : q.getTags().stream().map(String::toLowerCase).collect(Collectors.toList());
            boolean isCompleted = progress != null && progress.isQuestCompleted(q.getId());
            boolean isVisible = progress == null || q.isVisible(progress);
            boolean isOptional = q.isOptional();
            block43: for (Term term : this.cachedTerms) {
                String key = term.key;
                String v = term.value;
                switch (key) {
                    case "id": {
                        if (id.contains(v)) continue block43;
                        return false;
                    }
                    case "title": {
                        if (title.contains(v)) continue block43;
                        return false;
                    }
                    case "group": {
                        if (group.contains(v)) continue block43;
                        return false;
                    }
                    case "chapter": {
                        boolean ok = !chapterTitle.isEmpty() && chapterTitle.contains(v) || cid != null && cid.toLowerCase().contains(v);
                        if (ok) continue block43;
                        return false;
                    }
                    case "tag": {
                        boolean ok = false;
                        for (String t2 : tagsLower) {
                            if (!t2.contains(v)) continue;
                            ok = true;
                            break;
                        }
                        if (ok) continue block43;
                        return false;
                    }
                    case "is": {
                        switch (v) {
                            case "completed": 
                            case "complete": 
                            case "done": {
                                if (isCompleted) break;
                                return false;
                            }
                            case "incomplete": 
                            case "uncompleted": 
                            case "pending": 
                            case "todo": {
                                if (!isCompleted) break;
                                return false;
                            }
                            case "visible": 
                            case "shown": {
                                if (isVisible) break;
                                return false;
                            }
                            case "hidden": 
                            case "invisible": {
                                if (!isVisible) break;
                                return false;
                            }
                            case "optional": 
                            case "opt": {
                                if (isOptional) break;
                                return false;
                            }
                            case "required": 
                            case "mandatory": {
                                if (!isOptional) break;
                                return false;
                            }
                        }
                        break;
                    }
                    case "any": {
                        boolean ok;
                        boolean bl = ok = id.contains(v) || title.contains(v) || group.contains(v) || !chapterTitle.isEmpty() && chapterTitle.contains(v);
                        if (!ok) {
                            for (String t2 : tagsLower) {
                                if (!t2.contains(v)) continue;
                                ok = true;
                                break;
                            }
                        }
                        if (ok) continue block43;
                        return false;
                    }
                    default: {
                        boolean ok;
                        boolean bl = ok = id.contains(v) || title.contains(v) || group.contains(v) || !chapterTitle.isEmpty() && chapterTitle.contains(v);
                        if (!ok) {
                            for (String t2 : tagsLower) {
                                if (!t2.contains(v)) continue;
                                ok = true;
                                break;
                            }
                        }
                        if (ok) continue block43;
                        return false;
                    }
                }
            }
            return true;
        }).collect(Collectors.toList());
    }

    private static class Term {
        final String key;
        final String value;

        Term(String k, String v) {
            this.key = k;
            this.value = v;
        }
    }
}

