/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class FormattedTextWithImages {
    private final Component textComponent;
    private final List<ImageElement> images;

    public FormattedTextWithImages(Component textComponent, List<ImageElement> images) {
        this.textComponent = textComponent;
        this.images = images != null ? images : new ArrayList();
    }

    public Component getTextComponent() {
        return this.textComponent;
    }

    public List<ImageElement> getImages() {
        return this.images;
    }

    public boolean hasImages() {
        return !this.images.isEmpty();
    }

    public static class ImageElement {
        private final String path;
        private final int width;
        private final int height;
        private final String align;
        private final int lineIndex;

        public ImageElement(String path, int width, int height, String align, int lineIndex) {
            this.path = path;
            this.width = width;
            this.height = height;
            this.align = align != null ? align : "center";
            this.lineIndex = lineIndex;
        }

        public String getPath() {
            return this.path;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public String getAlign() {
            return this.align;
        }

        public int getLineIndex() {
            return this.lineIndex;
        }

        public ResourceLocation getResourceLocation() {
            try {
                if (this.path.contains(":")) {
                    return new ResourceLocation(this.path);
                }
                return new ResourceLocation("minecraft", this.path);
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

