/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.texboobcat.questory.client.gui.NewThemeEditorScreen;
import org.texboobcat.questory.client.gui.QuestIconRenderer;

class IconPickerScreen
extends Screen {
    private final Screen parent;
    private final Consumer<String> onOk;
    private String initial;
    private EditBox pathBox;
    private EditBox tileBox;
    private EditBox colorBox;
    private EditBox searchBox;
    private List<ResourceLocation> resources = new ArrayList<ResourceLocation>();
    private List<ResourceLocation> filtered = new ArrayList<ResourceLocation>();
    private List<String> availableNamespaces = new ArrayList<String>();
    private int listScroll = 0;
    private int namespaceScroll = 0;
    private String nsFilter = "all";
    private ResourceLocation selectedRL = null;
    private boolean seqMode = false;
    private Button seqToggleBtn;
    private EditBox intervalBox;
    private Button addCurrentBtn;
    private Button addFromPathBtn;
    private Button removeLastBtn;
    private Button clearBtn;
    private List<String> frames = new ArrayList<String>();
    private static final int PAD = 12;
    private static final int TOP_H = 24;
    private static final int BOTTOM_H = 34;
    private int browserX;
    private int browserY;
    private int browserW;
    private int browserH;
    private int rightX;
    private int rightY;
    private int rightW;
    private int rightH;

    protected IconPickerScreen(Screen parent, String seed, Consumer<String> onOk) {
        super((Component)Component.m_237113_((String)"Icon Browser"));
        this.parent = parent;
        this.initial = seed == null ? "" : seed;
        this.onOk = onOk;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.browserX = 12;
        this.browserY = 82;
        this.browserW = (int)((double)(this.f_96543_ - 36) * 0.6);
        this.browserH = this.f_96544_ - this.browserY - 34 - 12;
        this.rightX = this.browserX + this.browserW + 12;
        this.rightY = 36;
        this.rightW = this.f_96543_ - this.rightX - 12;
        this.rightH = this.f_96544_ - this.rightY - 34 - 12;
        this.searchBox = new EditBox(this.f_96547_, this.browserX, 36, this.browserW, 18, (Component)Component.m_237113_((String)"Search textures..."));
        this.searchBox.m_94199_(200);
        this.searchBox.m_94144_("");
        this.searchBox.m_257771_((Component)Component.m_237113_((String)"Type to filter textures..."));
        this.m_142416_((GuiEventListener)this.searchBox);
        int fy = this.rightY + 110;
        this.pathBox = new EditBox(this.f_96547_, this.rightX, fy, this.rightW, 18, (Component)Component.m_237113_((String)"Path"));
        this.pathBox.m_94199_(500);
        this.pathBox.m_94144_(IconPickerScreen.extractPath(this.initial));
        this.pathBox.m_257771_((Component)Component.m_237113_((String)"namespace:path or item:id or tag:id"));
        this.m_142416_((GuiEventListener)this.pathBox);
        this.tileBox = new EditBox(this.f_96547_, this.rightX, fy += 24, (this.rightW - 4) / 2, 18, (Component)Component.m_237113_((String)"tile_size"));
        this.tileBox.m_94199_(10);
        this.tileBox.m_94144_(IconPickerScreen.extractModifier(this.initial, "tile_size"));
        this.tileBox.m_257771_((Component)Component.m_237113_((String)"Optional tile size"));
        this.m_142416_((GuiEventListener)this.tileBox);
        this.colorBox = new EditBox(this.f_96547_, this.rightX + (this.rightW + 4) / 2, fy, (this.rightW - 4) / 2, 18, (Component)Component.m_237113_((String)"color"));
        this.colorBox.m_94199_(20);
        this.colorBox.m_94144_(IconPickerScreen.extractModifier(this.initial, "color"));
        this.colorBox.m_257771_((Component)Component.m_237113_((String)"Optional tint #AARRGGBB"));
        this.m_142416_((GuiEventListener)this.colorBox);
        int seqY = this.rightY + 86;
        this.seqToggleBtn = Button.m_253074_((Component)Component.m_237113_((String)"Sequence: Off"), b -> {
            this.seqMode = !this.seqMode;
            this.seqToggleBtn.m_93666_((Component)Component.m_237113_((String)(this.seqMode ? "Sequence: On" : "Sequence: Off")));
        }).m_252987_(this.rightX, seqY, 120, 18).m_253136_();
        this.m_142416_((GuiEventListener)this.seqToggleBtn);
        this.intervalBox = new EditBox(this.f_96547_, this.rightX + 126, seqY, 40, 18, (Component)Component.m_237113_((String)"ticks"));
        this.intervalBox.m_94144_("20");
        try {
            this.intervalBox.m_257771_((Component)Component.m_237113_((String)"ticks"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.m_142416_((GuiEventListener)this.intervalBox);
        this.addCurrentBtn = Button.m_253074_((Component)Component.m_237113_((String)"+Current"), b -> {
            if (this.selectedRL != null) {
                this.frames.add("texture:" + this.selectedRL.m_135827_() + ":" + this.selectedRL.m_135815_());
            }
        }).m_252987_(this.rightX + 170, seqY, 68, 18).m_253136_();
        this.m_142416_((GuiEventListener)this.addCurrentBtn);
        this.addFromPathBtn = Button.m_253074_((Component)Component.m_237113_((String)"+Path"), b -> {
            String p = IconPickerScreen.extractPath(this.pathBox.m_94155_().trim());
            if (!p.isEmpty()) {
                Object s = p.startsWith("texture:") ? p : "texture:" + p;
                this.frames.add((String)s);
            }
        }).m_252987_(this.rightX + 240, seqY, 44, 18).m_253136_();
        this.removeLastBtn = Button.m_253074_((Component)Component.m_237113_((String)"-Last"), b -> {
            if (!this.frames.isEmpty()) {
                this.frames.remove(this.frames.size() - 1);
            }
        }).m_252987_(this.rightX + 288, seqY, 44, 18).m_253136_();
        this.m_142416_((GuiEventListener)this.removeLastBtn);
        this.clearBtn = Button.m_253074_((Component)Component.m_237113_((String)"Clear"), b -> this.frames.clear()).m_252987_(this.rightX + 336, seqY, 44, 18).m_253136_();
        this.m_142416_((GuiEventListener)this.clearBtn);
        int bx = this.f_96543_ / 2 - 60;
        int by = this.f_96544_ - 34 + 6;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"OK"), b -> {
            String result;
            if (this.seqMode && !this.frames.isEmpty()) {
                int interval;
                try {
                    interval = Math.max(1, Integer.parseInt(this.intervalBox.m_94155_().trim()));
                }
                catch (Exception e) {
                    interval = 20;
                }
                StringBuilder sb = new StringBuilder("rotate:").append(interval).append('|');
                for (int i = 0; i < this.frames.size(); ++i) {
                    if (i > 0) {
                        sb.append('|');
                    }
                    sb.append(this.frames.get(i));
                }
                result = sb.toString();
            } else {
                result = this.build();
            }
            if (!this.validateResource(result) && this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a7eWarning: texture not found"));
            }
            this.onOk.accept(result);
            this.f_96541_.m_91152_(this.parent);
        }).m_252987_(bx, by, 56, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Cancel"), b -> this.f_96541_.m_91152_(this.parent)).m_252987_(bx + 60, by, 56, 20).m_253136_());
        this.loadResources();
        this.updateFiltered();
    }

    private void loadResources() {
        try {
            ResourceManager rm = Minecraft.m_91087_().m_91098_();
            Map map = rm.m_214159_("textures", rl -> rl.m_135815_().endsWith(".png"));
            this.resources = new ArrayList(map.keySet());
            Collections.sort(this.resources, (a, b) -> a.toString().compareTo(b.toString()));
            HashSet<String> namespaces = new HashSet<String>();
            for (ResourceLocation rl2 : this.resources) {
                namespaces.add(rl2.m_135827_());
            }
            this.availableNamespaces = new ArrayList<String>(namespaces);
            Collections.sort(this.availableNamespaces);
            this.availableNamespaces.remove("minecraft");
            this.availableNamespaces.remove("ftbquests");
            this.availableNamespaces.add(0, "minecraft");
            if (namespaces.contains("ftbquests")) {
                this.availableNamespaces.add(1, "ftbquests");
            }
        }
        catch (Throwable t) {
            this.resources = Collections.emptyList();
            this.availableNamespaces = List.of("minecraft");
        }
    }

    private void updateFiltered() {
        this.filtered.clear();
        String q = this.searchBox == null ? "" : this.searchBox.m_94155_().trim().toLowerCase();
        for (ResourceLocation rl : this.resources) {
            boolean qok;
            boolean bl = qok = q.isEmpty() || rl.toString().toLowerCase().contains(q);
            if (!qok) continue;
            String ns = rl.m_135827_();
            boolean nsok = this.nsFilter.equals("all") || ns.equals(this.nsFilter);
            if (!nsok) continue;
            this.filtered.add(rl);
        }
        this.listScroll = 0;
    }

    private boolean validateResource(String value) {
        try {
            String v = value.trim();
            if (v.isEmpty() || v.startsWith("item:") || v.startsWith("tag:") || v.equals("builtin")) {
                return true;
            }
            String rlStr = IconPickerScreen.extractPath(v);
            ResourceLocation rl = new ResourceLocation(rlStr);
            ResourceManager rm = Minecraft.m_91087_().m_91098_();
            Optional opt = rm.m_213713_(rl);
            if (opt.isPresent()) {
                return true;
            }
            if (!rl.m_135815_().startsWith("textures/")) {
                rl = new ResourceLocation(rl.m_135827_(), "textures/" + rl.m_135815_());
                return rm.m_213713_(rl).isPresent();
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String build() {
        String c;
        String p = this.pathBox.m_94155_().trim();
        ArrayList<CallSite> mods = new ArrayList<CallSite>();
        String t = this.tileBox.m_94155_().trim();
        if (!t.isEmpty()) {
            mods.add((CallSite)((Object)("tile_size=" + t)));
        }
        if (!(c = this.colorBox.m_94155_().trim()).isEmpty()) {
            mods.add((CallSite)((Object)("color=" + c)));
        }
        if (mods.isEmpty()) {
            return p;
        }
        StringBuilder sb = new StringBuilder(p);
        for (String string : mods) {
            sb.append("; ").append(string);
        }
        return sb.toString();
    }

    private static String extractPath(String s) {
        if (s == null) {
            return "";
        }
        int semi = s.indexOf(59);
        return semi < 0 ? s.trim() : s.substring(0, semi).trim();
    }

    private static String extractModifier(String s, String k) {
        if (s == null) {
            return "";
        }
        int idx = s.indexOf(k + "=");
        if (idx < 0) {
            return "";
        }
        String sub = s.substring(idx + k.length() + 1).trim();
        int semi = sub.indexOf(59);
        return (semi < 0 ? sub : sub.substring(0, semi)).trim();
    }

    public void m_88315_(GuiGraphics g, int mx, int my, float p) {
        block26: {
            String ns;
            int btnW;
            this.m_280273_(g);
            g.m_280430_(this.f_96547_, this.f_96539_, 12, 12, -1);
            if (this.searchBox != null && this.m_7222_() == this.searchBox) {
                String q = this.searchBox.m_94155_().trim().toLowerCase();
                this.updateFiltered();
            }
            int tabsY = 58;
            int tabsH = 18;
            int tabsX = this.browserX;
            int tabsW = this.browserW;
            g.m_280509_(tabsX, tabsY, tabsX + tabsW, tabsY + tabsH, -15066598);
            int btnX = tabsX + 2 - this.namespaceScroll;
            g.m_280509_(btnX, tabsY, btnX + 40, tabsY + tabsH, this.nsFilter.equals("all") ? -12952966 : -14013910);
            g.m_280488_(this.f_96547_, "All", btnX + 4, tabsY + 5, -1);
            btnX += 44;
            Iterator<String> iterator = this.availableNamespaces.iterator();
            while (iterator.hasNext() && btnX + (btnW = this.f_96547_.m_92895_(ns = iterator.next()) + 8) <= tabsX + tabsW + this.namespaceScroll) {
                if (btnX >= tabsX) {
                    g.m_280509_(btnX, tabsY, btnX + btnW, tabsY + tabsH, this.nsFilter.equals(ns) ? -12952966 : -14013910);
                    g.m_280488_(this.f_96547_, ns, btnX + 4, tabsY + 5, -1);
                }
                btnX += btnW + 4;
            }
            if (this.namespaceScroll > 0) {
                g.m_280488_(this.f_96547_, "\u25c0", tabsX + 2, tabsY + 5, -22016);
            }
            if (btnX > tabsX + tabsW + this.namespaceScroll) {
                g.m_280488_(this.f_96547_, "\u25b6", tabsX + tabsW - 12, tabsY + 5, -22016);
            }
            g.m_280509_(this.browserX, this.browserY, this.browserX + this.browserW, this.browserY + this.browserH, -535818224);
            int lineH = 18;
            int visibleLines = Math.max(1, this.browserH / lineH);
            int maxScroll = Math.max(0, this.filtered.size() - visibleLines);
            this.listScroll = Math.max(0, Math.min(this.listScroll, maxScroll));
            g.m_280588_(this.browserX, this.browserY, this.browserX + this.browserW, this.browserY + this.browserH);
            for (int i = 0; i < visibleLines && this.listScroll + i < this.filtered.size(); ++i) {
                ResourceLocation rl = this.filtered.get(this.listScroll + i);
                int y = this.browserY + i * lineH;
                boolean hover = mx >= this.browserX && mx <= this.browserX + this.browserW && my >= y && my < y + lineH;
                boolean selected = rl.equals((Object)this.selectedRL);
                if (selected) {
                    g.m_280509_(this.browserX, y, this.browserX + this.browserW, y + lineH, -12952966);
                } else if (hover) {
                    g.m_280509_(this.browserX, y, this.browserX + this.browserW, y + lineH, -14013910);
                }
                try {
                    g.m_280163_(rl, this.browserX + 2, y + 1, 0.0f, 0.0f, 16, 16, 16, 16);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                Object txt = rl.toString();
                if (this.f_96547_.m_92895_((String)txt) > this.browserW - 24) {
                    txt = ((String)txt).substring(0, Math.max(0, (this.browserW - 24) / 6)) + "...";
                }
                g.m_280488_(this.f_96547_, (String)txt, this.browserX + 22, y + 5, -1);
            }
            g.m_280618_();
            g.m_280509_(this.rightX, this.rightY, this.rightX + this.rightW, this.rightY + this.rightH, -535818224);
            g.m_280488_(this.f_96547_, "Preview:", this.rightX + 4, this.rightY + 4, -5592321);
            if (this.selectedRL != null || this.seqMode && !this.frames.isEmpty()) {
                int px = this.rightX + this.rightW / 2 - 32;
                int py = this.rightY + 24;
                try {
                    g.m_280509_(px - 2, py - 2, px + 66, py + 66, -12566464);
                    if (this.seqMode && !this.frames.isEmpty()) {
                        int interval;
                        try {
                            interval = Math.max(1, Integer.parseInt(this.intervalBox.m_94155_().trim()));
                        }
                        catch (Exception e) {
                            interval = 20;
                        }
                        StringBuilder sb = new StringBuilder("rotate:").append(interval).append('|');
                        for (int i = 0; i < this.frames.size(); ++i) {
                            if (i > 0) {
                                sb.append('|');
                            }
                            sb.append(this.frames.get(i));
                        }
                        QuestIconRenderer.render(g, sb.toString(), px, py, 64, false, false);
                        break block26;
                    }
                    if (this.selectedRL != null) {
                        g.m_280163_(this.selectedRL, px, py, 0.0f, 0.0f, 64, 64, 64, 64);
                    }
                }
                catch (Throwable interval) {
                    // empty catch block
                }
            }
        }
        int recentY = this.rightY + 100;
        g.m_280488_(this.f_96547_, "Recent:", this.rightX + 4, recentY, -5592321);
        List<String> rec = NewThemeEditorScreen.getRecentIconsSnapshot();
        int ry = recentY + 12;
        for (int i = 0; i < Math.min(5, rec.size()); ++i) {
            Object s = rec.get(i);
            if (this.f_96547_.m_92895_((String)s) > this.rightW - 8) {
                s = ((String)s).substring(0, Math.max(0, (this.rightW - 8) / 6)) + "...";
            }
            g.m_280488_(this.f_96547_, (String)s, this.rightX + 6, ry, -3355444);
            ry += 10;
        }
        if (this.seqMode) {
            int ly = recentY + 70;
            g.m_280488_(this.f_96547_, "Frames:", this.rightX + 4, ly, -5592321);
            int shown = Math.min(this.frames.size(), Math.max(2, (this.rightH - ((ly += 12) - this.rightY) - 40) / 10));
            for (int i = 0; i < shown; ++i) {
                Object s = this.frames.get(i);
                if (this.f_96547_.m_92895_((String)s) > this.rightW - 8) {
                    s = ((String)s).substring(0, Math.max(0, (this.rightW - 8) / 6)) + "...";
                }
                g.m_280488_(this.f_96547_, i + 1 + ". " + (String)s, this.rightX + 6, ly, -3355444);
                ly += 10;
            }
        }
        super.m_88315_(g, mx, my, p);
    }

    public boolean m_6375_(double mx, double my, int btn) {
        int lineH;
        int row;
        int idx;
        int tabsY = 58;
        int tabsH = 18;
        if (my >= (double)tabsY && my <= (double)(tabsY + tabsH) && mx >= (double)this.browserX && mx <= (double)(this.browserX + this.browserW)) {
            int btnX = this.browserX + 2 - this.namespaceScroll;
            if (mx >= (double)btnX && mx <= (double)(btnX + 40)) {
                this.nsFilter = "all";
                this.updateFiltered();
                return true;
            }
            btnX += 44;
            for (String ns : this.availableNamespaces) {
                int btnW = this.f_96547_.m_92895_(ns) + 8;
                if (btnX >= this.browserX && mx >= (double)btnX && mx <= (double)(btnX + btnW)) {
                    this.nsFilter = ns;
                    this.updateFiltered();
                    return true;
                }
                btnX += btnW + 4;
            }
        }
        if (mx >= (double)this.browserX && mx <= (double)(this.browserX + this.browserW) && my >= (double)this.browserY && my <= (double)(this.browserY + this.browserH) && (idx = this.listScroll + (row = (int)((my - (double)this.browserY) / (double)(lineH = 18)))) >= 0 && idx < this.filtered.size()) {
            this.selectedRL = this.filtered.get(idx);
            this.pathBox.m_94144_(this.selectedRL.m_135827_() + ":" + this.selectedRL.m_135815_());
            return true;
        }
        return super.m_6375_(mx, my, btn);
    }

    public boolean m_6050_(double mx, double my, double d) {
        int tabsY = 58;
        int tabsH = 18;
        if (my >= (double)tabsY && my <= (double)(tabsY + tabsH) && mx >= (double)this.browserX && mx <= (double)(this.browserX + this.browserW)) {
            this.namespaceScroll = (int)Math.max(0.0, (double)this.namespaceScroll - Math.signum(d) * 20.0);
            return true;
        }
        if (mx >= (double)this.browserX && mx <= (double)(this.browserX + this.browserW) && my >= (double)this.browserY && my <= (double)(this.browserY + this.browserH)) {
            this.listScroll = (int)Math.max(0.0, (double)this.listScroll - Math.signum(d) * 3.0);
            return true;
        }
        return super.m_6050_(mx, my, d);
    }

    public boolean m_7043_() {
        return false;
    }
}

