/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.texboobcat.questory.client.ClientQuestManager;
import org.texboobcat.questory.client.UiScaleUtil;
import org.texboobcat.questory.client.gui.AdvancedTabPanel;
import org.texboobcat.questory.client.gui.DependenciesTabPanel;
import org.texboobcat.questory.client.gui.GeneralTabPanel;
import org.texboobcat.questory.client.gui.PreviewTabPanel;
import org.texboobcat.questory.client.gui.RequirementsTabPanel;
import org.texboobcat.questory.client.gui.RewardsTabPanel;
import org.texboobcat.questory.client.gui.TeamTabPanel;
import org.texboobcat.questory.client.gui.TextFormatter;
import org.texboobcat.questory.network.NetworkManager;
import org.texboobcat.questory.network.QuestCreateRequestPacket;
import org.texboobcat.questory.network.QuestDeleteRequestPacket;
import org.texboobcat.questory.network.QuestUpdateRequestPacket;
import org.texboobcat.questory.quest.ChapterData;
import org.texboobcat.questory.quest.Quest;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.validation.QuestValidator;

public class QuestEditorScreen
extends Screen {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final int SIDEBAR_W = 240;
    private static final int TAB_H = 24;
    private static final int HEADER_H = 32;
    private static final int FOOTER_H = 36;
    private static final int PAD = 8;
    private static final Pattern TOKEN_PATTERN = Pattern.compile("\"([^\"]*)\"|(\\S+)");
    private final Screen parent;
    private Quest workingQuest;
    private String originalId;
    private boolean isDirty = false;
    private final Map<String, Quest> unsavedQuestCache = new HashMap<String, Quest>();
    private Tab activeTab = Tab.GENERAL;
    private EditBox searchBox;
    private List<Quest> filtered = new ArrayList<Quest>();
    private int listScroll = 0;
    private String lastSearchQueryCache = null;
    private List<Term> cachedTerms = Collections.emptyList();
    private GeneralTabPanel generalTab;
    private DependenciesTabPanel dependenciesTab;
    private RequirementsTabPanel requirementsTab;
    private RewardsTabPanel rewardsTab;
    private TeamTabPanel teamTab;
    private AdvancedTabPanel advancedTab;
    private PreviewTabPanel previewTab;
    private Button tabGeneralBtn;
    private Button tabDepsBtn;
    private Button tabReqsBtn;
    private Button tabRwdsBtn;
    private Button tabTeamBtn;
    private Button tabAdvBtn;
    private Button tabPreviewBtn;
    private Button newBtn;
    private Button saveBtn;
    private Button deleteBtn;
    private Button closeBtn;
    private Button saveAllBtn;
    private boolean deleteConfirmPending = false;
    private long deleteConfirmTime = 0L;

    public QuestEditorScreen(Screen parent) {
        super((Component)Component.m_237113_((String)"Quest Editor"));
        this.parent = parent;
    }

    public Font getFont() {
        return this.f_96547_;
    }

    public Minecraft getMinecraft() {
        return this.f_96541_;
    }

    public Quest getWorkingQuest() {
        return this.workingQuest;
    }

    protected void m_7856_() {
        super.m_7856_();
        UiScaleUtil.warnIfEditorScaleNotOne(this, "quest_editor");
        System.out.println("[QuestEditor] ============ init() START ============");
        System.out.println("[QuestEditor] init() called. workingQuest: " + (String)(this.workingQuest != null ? this.workingQuest.getId() + " / " + this.workingQuest.getTitle() : "null"));
        System.out.println("[QuestEditor] workingQuest object reference: " + String.valueOf(this.workingQuest != null ? Integer.valueOf(System.identityHashCode(this.workingQuest)) : "null"));
        System.out.println("[QuestEditor] originalId: " + this.originalId);
        this.searchBox = new EditBox(this.f_96547_, 8, 8, 224, 18, (Component)Component.m_237113_((String)"Search"));
        this.searchBox.m_257771_((Component)Component.m_237113_((String)"Search quests (id,title,group,chapter,tags). Use tag: or #tag"));
        this.searchBox.m_94151_(s -> {
            this.listScroll = 0;
            this.lastSearchQueryCache = null;
        });
        this.m_142416_((GuiEventListener)this.searchBox);
        int tabX = 248;
        int tabY = 8;
        int tabW = 90;
        this.tabGeneralBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"General"), b -> this.switchTab(Tab.GENERAL)).m_252987_(tabX, tabY, tabW, 22).m_253136_());
        this.tabDepsBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Dependencies"), b -> this.switchTab(Tab.DEPENDENCIES)).m_252987_(tabX += tabW + 2, tabY, tabW + 20, 22).m_253136_());
        this.tabReqsBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Requirements"), b -> this.switchTab(Tab.REQUIREMENTS)).m_252987_(tabX += tabW + 22, tabY, tabW + 20, 22).m_253136_());
        this.tabRwdsBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Rewards"), b -> this.switchTab(Tab.REWARDS)).m_252987_(tabX += tabW + 22, tabY, tabW, 22).m_253136_());
        this.tabTeamBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Team"), b -> this.switchTab(Tab.TEAM)).m_252987_(tabX += tabW + 2, tabY, 60, 22).m_253136_());
        this.tabAdvBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Advanced"), b -> this.switchTab(Tab.ADVANCED)).m_252987_(tabX += 62, tabY, tabW, 22).m_253136_());
        this.tabPreviewBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Preview"), b -> this.switchTab(Tab.PREVIEW)).m_252987_(tabX += tabW + 2, tabY, tabW - 10, 22).m_253136_());
        int footerY = this.f_96544_ - 36 + 8;
        int btnX = 248;
        this.newBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"New"), b -> this.createNew()).m_252987_(btnX, footerY, 60, 20).m_253136_());
        this.saveBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Save"), b -> this.save()).m_252987_(btnX += 64, footerY, 60, 20).m_253136_());
        this.saveAllBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Save All"), b -> this.saveAll()).m_252987_(btnX += 64, footerY, 70, 20).m_253136_());
        this.deleteBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Delete"), b -> this.onDeleteClick()).m_252987_(btnX += 74, footerY, 60, 20).m_253136_());
        int closeX = this.f_96543_ - 8 - 60;
        this.closeBtn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Close"), b -> this.f_96541_.m_91152_(this.parent)).m_252987_(closeX, footerY, 60, 20).m_253136_());
        this.m_7522_(null);
        this.updateSaveAllButton();
        System.out.println("[QuestEditor] About to initialize tab panels. Current workingQuest rewards: " + String.valueOf(this.workingQuest != null ? Integer.valueOf(this.workingQuest.getRewards().size()) : "null"));
        this.initTabPanels();
        this.reloadQuestList();
        if (this.workingQuest != null) {
            System.out.println("[QuestEditor] Re-init with existing workingQuest: " + this.workingQuest.getId() + " / " + this.workingQuest.getTitle() + ", Rewards: " + this.workingQuest.getRewards().size());
            this.loadTabFromQuest();
        } else if (!this.filtered.isEmpty()) {
            this.workingQuest = this.filtered.get(0);
            this.originalId = this.workingQuest.getId();
            this.isDirty = false;
            System.out.println("[QuestEditor] Initial quest load: " + this.workingQuest.getId() + " / " + this.workingQuest.getTitle() + ", Rewards: " + this.workingQuest.getRewards().size());
            this.loadTabFromQuest();
        } else {
            this.createNew();
        }
        System.out.println("[QuestEditor] ============ init() END ============");
    }

    private void initTabPanels() {
        int contentX = 248;
        int contentY = 40;
        int contentW = this.f_96543_ - contentX - 8;
        int contentH = this.f_96544_ - contentY - 36 - 8;
        System.out.println("[QuestEditor] initTabPanels() - Creating NEW tab panel instances!");
        this.generalTab = new GeneralTabPanel(this, contentX, contentY, contentW, contentH);
        this.dependenciesTab = new DependenciesTabPanel(this, contentX, contentY, contentW, contentH);
        this.requirementsTab = new RequirementsTabPanel(this, contentX, contentY, contentW, contentH);
        this.rewardsTab = new RewardsTabPanel(this, contentX, contentY, contentW, contentH);
        this.teamTab = new TeamTabPanel(this, contentX, contentY, contentW, contentH);
        this.advancedTab = new AdvancedTabPanel(this, contentX, contentY, contentW, contentH);
        this.previewTab = new PreviewTabPanel(this, contentX, contentY, contentW, contentH);
    }

    private void switchTab(Tab tab) {
        if (this.activeTab == tab) {
            return;
        }
        System.out.println("[QuestEditor] switchTab() from " + String.valueOf((Object)this.activeTab) + " to " + String.valueOf((Object)tab));
        this.saveCurrentTabToQuest();
        this.activeTab = tab;
        this.loadTabFromQuest();
    }

    public void saveCurrentTabToQuest() {
        if (this.workingQuest == null) {
            System.out.println("[QuestEditor] saveCurrentTabToQuest() - workingQuest is NULL!");
            return;
        }
        this.isDirty = true;
        System.out.println("[QuestEditor] saveCurrentTabToQuest() - Tab: " + String.valueOf((Object)this.activeTab) + ", Quest BEFORE: " + this.workingQuest.getId() + " / " + this.workingQuest.getTitle());
        System.out.println("[QuestEditor] Quest object reference BEFORE: " + System.identityHashCode(this.workingQuest));
        if (this.activeTab == Tab.GENERAL && this.originalId == null) {
            String newId = this.generalTab.getIdFieldValue();
            if (!this.workingQuest.getId().equals(newId)) {
                System.out.println("[QuestEditor] NEW quest ID change detected: " + this.workingQuest.getId() + " -> " + newId);
                System.out.println("[QuestEditor] Creating new Quest object with updated ID to preserve changes");
                Quest updatedQuest = new Quest(newId, this.workingQuest.getTitle(), this.workingQuest.getDescription());
                this.copyQuestData(this.workingQuest, updatedQuest);
                System.out.println("[QuestEditor] Old quest reference: " + System.identityHashCode(this.workingQuest));
                this.workingQuest = updatedQuest;
                System.out.println("[QuestEditor] New quest reference: " + System.identityHashCode(this.workingQuest));
            }
        }
        switch (this.activeTab.ordinal()) {
            case 0: {
                this.generalTab.saveToQuest(this.workingQuest);
                break;
            }
            case 1: {
                this.dependenciesTab.saveToQuest(this.workingQuest);
                break;
            }
            case 2: {
                this.requirementsTab.saveToQuest(this.workingQuest);
                break;
            }
            case 3: {
                this.rewardsTab.saveToQuest(this.workingQuest);
                break;
            }
            case 4: {
                this.teamTab.saveToQuest(this.workingQuest);
                break;
            }
            case 5: {
                this.advancedTab.saveToQuest(this.workingQuest);
            }
        }
        System.out.println("[QuestEditor] saveCurrentTabToQuest() - Quest AFTER: " + this.workingQuest.getId() + " / " + this.workingQuest.getTitle());
    }

    private void copyQuestData(Quest from, Quest to) {
        to.setTitle(from.getTitle());
        to.setDescription(from.getDescription());
        to.setIcon(from.getIcon());
        to.setHidden(from.isHidden());
        to.setGroup(from.getGroup());
        to.setChapterId(from.getChapterId());
        to.setX(from.getX());
        to.setY(from.getY());
        to.setHideDependencyLines(from.isHideDependencyLines());
        to.setHideDependentLines(from.isHideDependentLines());
        to.setIconScale(from.getIconScale());
        to.setLineStyle(from.getLineStyle());
        to.getDependencies().clear();
        to.getDependencies().addAll(from.getDependencies());
        to.getRequirements().clear();
        to.getRequirements().addAll(from.getRequirements());
        to.getRewards().clear();
        to.getRewards().addAll(from.getRewards());
        to.getTags().clear();
        to.getTags().addAll(from.getTags());
        to.setShape(from.getShape());
        to.setSize(from.getSize());
        to.setOptional(from.isOptional());
        to.setMinWidth(from.getMinWidth());
        to.setCanRepeat(from.getCanRepeat());
        to.setDependencyRequirement(from.getDependencyRequirement());
        to.setMinRequiredDependencies(from.getMinRequiredDependencies());
        to.setMaxCompletableDeps(from.getMaxCompletableDeps());
        to.setProgressionMode(from.getProgressionMode());
        to.setRequireSequentialTasks(from.getRequireSequentialTasks());
        to.setInvisibleUntilCompleted(from.isInvisibleUntilCompleted());
        to.setInvisibleUntilTasks(from.getInvisibleUntilTasks());
        to.setHideTextUntilComplete(from.getHideTextUntilComplete());
        to.setHideDetailsUntilStartable(from.getHideDetailsUntilStartable());
        to.setHideUntilDepsVisible(from.getHideUntilDepsVisible());
        to.setHideUntilDepsComplete(from.getHideUntilDepsComplete());
        to.setDisableJEI(from.getDisableJEI());
        to.setHideLockIcon(from.isHideLockIcon());
        to.setGuidePage(from.getGuidePage());
        to.setIgnoreRewardBlocking(from.isIgnoreRewardBlocking());
    }

    private void loadTabFromQuest() {
        if (this.workingQuest == null) {
            System.out.println("[QuestEditor] loadTabFromQuest() - workingQuest is NULL!");
            return;
        }
        System.out.println("[QuestEditor] loadTabFromQuest() called for tab: " + String.valueOf((Object)this.activeTab) + ", Quest: " + this.workingQuest.getId() + " / " + this.workingQuest.getTitle() + ", Rewards: " + this.workingQuest.getRewards().size());
        switch (this.activeTab.ordinal()) {
            case 0: {
                this.generalTab.loadFromQuest(this.workingQuest);
                break;
            }
            case 1: {
                this.dependenciesTab.loadFromQuest(this.workingQuest);
                break;
            }
            case 2: {
                this.requirementsTab.loadFromQuest(this.workingQuest);
                break;
            }
            case 3: {
                this.rewardsTab.loadFromQuest(this.workingQuest);
                break;
            }
            case 4: {
                this.teamTab.loadFromQuest(this.workingQuest);
                break;
            }
            case 5: {
                this.advancedTab.loadFromQuest(this.workingQuest);
                break;
            }
            case 6: {
                this.previewTab.loadFromQuest(this.workingQuest);
            }
        }
    }

    private void reloadQuestList() {
        String raw = this.searchBox.m_94155_();
        String query = raw == null ? "" : raw.trim().toLowerCase();
        ArrayList<Quest> all = new ArrayList<Quest>(ClientQuestManager.getInstance().getAllQuests());
        all.sort((a, b) -> a.getTitle().compareToIgnoreCase(b.getTitle()));
        if (query.isEmpty()) {
            this.filtered = all;
            return;
        }
        HashMap<String, String> chapterIdToTitle = new HashMap<String, String>();
        for (ChapterData cd : ClientQuestManager.getInstance().getAllChapters()) {
            if (cd == null || cd.getId() == null) continue;
            chapterIdToTitle.put(cd.getId().toLowerCase(), cd.getTitle() == null ? "" : cd.getTitle());
        }
        if (!query.equals(this.lastSearchQueryCache)) {
            ArrayList<String> tokens = new ArrayList<String>();
            Matcher m = TOKEN_PATTERN.matcher(query);
            while (m.find()) {
                String t = m.group(1) != null ? m.group(1) : m.group(2);
                if (t == null || t.isBlank()) continue;
                tokens.add(t.trim());
            }
            ArrayList<Term> terms = new ArrayList<Term>();
            for (String t : tokens) {
                if (t.startsWith("#")) {
                    String v = t.substring(1);
                    if (v.isBlank()) continue;
                    terms.add(new Term("tag", v));
                    continue;
                }
                int idx = t.indexOf(58);
                if (idx > 0) {
                    String key = t.substring(0, idx);
                    String val = t.substring(idx + 1);
                    if (key.equals("g")) {
                        key = "group";
                    } else if (key.equals("t")) {
                        key = "tag";
                    } else if (key.equals("c") || key.equals("chap") || key.equals("chapterid")) {
                        key = "chapter";
                    } else if (key.equals("name")) {
                        key = "title";
                    }
                    terms.add(new Term(key, val));
                    continue;
                }
                terms.add(new Term("any", t));
            }
            this.cachedTerms = terms;
            this.lastSearchQueryCache = query;
        }
        QuestProgress progress = ClientQuestManager.getInstance().getProgress();
        this.filtered = all.stream().filter(q -> {
            String ct;
            String id = q.getId() == null ? "" : q.getId().toLowerCase();
            String title = q.getTitle() == null ? "" : q.getTitle().toLowerCase();
            String group = q.getGroup() == null ? "" : q.getGroup().toLowerCase();
            String cid = q.getChapterId();
            String chapterTitle = "";
            if (cid != null && (ct = (String)chapterIdToTitle.get(cid.toLowerCase())) != null) {
                chapterTitle = ct.toLowerCase();
            }
            List<String> tagsLower = q.getTags() == null ? Collections.emptyList() : q.getTags().stream().map(s -> s.toLowerCase()).collect(Collectors.toList());
            boolean isCompleted = progress != null && progress.isQuestCompleted(q.getId());
            boolean isVisible = progress == null || q.isVisible(progress);
            boolean isOptional = q.isOptional();
            block43: for (Term term : this.cachedTerms) {
                String key = term.key;
                String v = term.value;
                switch (key) {
                    case "id": {
                        if (id.contains(v)) continue block43;
                        return false;
                    }
                    case "title": {
                        if (title.contains(v)) continue block43;
                        return false;
                    }
                    case "group": {
                        if (group.contains(v)) continue block43;
                        return false;
                    }
                    case "chapter": {
                        boolean ok = !chapterTitle.isEmpty() && chapterTitle.contains(v) || cid != null && cid.toLowerCase().contains(v);
                        if (ok) continue block43;
                        return false;
                    }
                    case "tag": {
                        boolean ok = false;
                        for (String t2 : tagsLower) {
                            if (!t2.contains(v)) continue;
                            ok = true;
                            break;
                        }
                        if (ok) continue block43;
                        return false;
                    }
                    case "is": {
                        switch (v) {
                            case "completed": 
                            case "complete": 
                            case "done": {
                                if (isCompleted) break;
                                return false;
                            }
                            case "incomplete": 
                            case "uncompleted": 
                            case "pending": 
                            case "todo": {
                                if (!isCompleted) break;
                                return false;
                            }
                            case "visible": 
                            case "shown": {
                                if (isVisible) break;
                                return false;
                            }
                            case "hidden": 
                            case "invisible": {
                                if (!isVisible) break;
                                return false;
                            }
                            case "optional": 
                            case "opt": {
                                if (isOptional) break;
                                return false;
                            }
                            case "required": 
                            case "mandatory": {
                                if (!isOptional) break;
                                return false;
                            }
                        }
                        break;
                    }
                    case "any": {
                        boolean ok;
                        boolean bl = ok = id.contains(v) || title.contains(v) || group.contains(v) || !chapterTitle.isEmpty() && chapterTitle.contains(v);
                        if (!ok) {
                            for (String t2 : tagsLower) {
                                if (!t2.contains(v)) continue;
                                ok = true;
                                break;
                            }
                        }
                        if (ok) continue block43;
                        return false;
                    }
                    default: {
                        boolean ok;
                        boolean bl = ok = id.contains(v) || title.contains(v) || group.contains(v) || !chapterTitle.isEmpty() && chapterTitle.contains(v);
                        if (!ok) {
                            for (String t2 : tagsLower) {
                                if (!t2.contains(v)) continue;
                                ok = true;
                                break;
                            }
                        }
                        if (ok) continue block43;
                        return false;
                    }
                }
            }
            return true;
        }).collect(Collectors.toList());
    }

    private void selectQuest(Quest quest) {
        System.out.println("[QuestEditor] selectQuest() called - Switching from " + (this.workingQuest != null ? this.workingQuest.getId() : "null") + " to " + quest.getId());
        System.out.println("[QuestEditor] selectQuest() - Current originalId: " + this.originalId + ", isDirty: " + this.isDirty);
        this.deleteConfirmPending = false;
        if (this.deleteBtn != null) {
            this.deleteBtn.m_93666_((Component)Component.m_237113_((String)"Delete"));
        }
        if (this.workingQuest != null && this.isDirty) {
            this.saveCurrentTabToQuest();
            String cacheKey = this.originalId != null && !this.originalId.isEmpty() ? this.originalId : this.workingQuest.getId();
            this.unsavedQuestCache.put(cacheKey, this.workingQuest);
            System.out.println("[QuestEditor] Cached quest (dirty): " + cacheKey + " (Title: " + this.workingQuest.getTitle() + ")");
        } else if (this.workingQuest != null) {
            System.out.println("[QuestEditor] Quest not dirty, skipping cache: " + this.workingQuest.getId());
        }
        String targetCacheKey = quest.getId();
        if (this.unsavedQuestCache.containsKey(targetCacheKey)) {
            this.workingQuest = this.unsavedQuestCache.get(targetCacheKey);
            this.isDirty = true;
            System.out.println("[QuestEditor] Restored quest from cache: " + this.workingQuest.getId() + " (Title: " + this.workingQuest.getTitle() + ") - marked as dirty");
        } else {
            this.workingQuest = quest;
            this.isDirty = false;
        }
        this.originalId = quest.getId();
        System.out.println("[QuestEditor] Selected quest: " + quest.getId() + ", Rewards: " + quest.getRewards().size());
        this.loadTabFromQuest();
        this.updateSaveAllButton();
    }

    private void createNew() {
        System.out.println("[QuestEditor] createNew() called - Current working quest: " + (String)(this.workingQuest != null ? this.workingQuest.getId() + " / " + this.workingQuest.getTitle() : "null"));
        System.out.println("[QuestEditor] createNew() - originalId: " + this.originalId + ", isDirty: " + this.isDirty);
        this.deleteConfirmPending = false;
        if (this.deleteBtn != null) {
            this.deleteBtn.m_93666_((Component)Component.m_237113_((String)"Delete"));
        }
        if (this.workingQuest != null && this.isDirty) {
            this.saveCurrentTabToQuest();
            String cacheKey = this.originalId != null && !this.originalId.isEmpty() ? this.originalId : this.workingQuest.getId();
            this.unsavedQuestCache.put(cacheKey, this.workingQuest);
            System.out.println("[QuestEditor] Cached quest before creating new: " + cacheKey + " (Title: " + this.workingQuest.getTitle() + ")");
        }
        Quest newQuest = new Quest("new_quest_" + System.currentTimeMillis(), "New Quest", "");
        System.out.println("[QuestEditor] createNew() - Created new quest: " + newQuest.getId());
        this.workingQuest = newQuest;
        this.originalId = null;
        this.isDirty = true;
        this.activeTab = Tab.GENERAL;
        this.loadTabFromQuest();
        this.updateSaveAllButton();
    }

    private void updateSaveAllButton() {
        if (this.saveAllBtn != null) {
            int unsavedCount = this.unsavedQuestCache.size();
            if (this.isDirty && this.workingQuest != null) {
                String cacheKey;
                String string = cacheKey = this.originalId != null && !this.originalId.isEmpty() ? this.originalId : this.workingQuest.getId();
                if (!this.unsavedQuestCache.containsKey(cacheKey)) {
                    ++unsavedCount;
                }
            }
            boolean bl = this.saveAllBtn.f_93623_ = unsavedCount > 0;
            if (unsavedCount > 0) {
                this.saveAllBtn.m_93666_((Component)Component.m_237113_((String)("Save All (" + unsavedCount + ")")));
            } else {
                this.saveAllBtn.m_93666_((Component)Component.m_237113_((String)"Save All"));
            }
        }
    }

    private void saveAll() {
        if (this.unsavedQuestCache.isEmpty()) {
            return;
        }
        System.out.println("[QuestEditor] saveAll() - Saving " + this.unsavedQuestCache.size() + " quests");
        if (this.workingQuest != null) {
            this.saveCurrentTabToQuest();
            String cacheKey = this.originalId != null && !this.originalId.isEmpty() ? this.originalId : this.workingQuest.getId();
            this.unsavedQuestCache.put(cacheKey, this.workingQuest);
        }
        int successCount = 0;
        int failCount = 0;
        for (Map.Entry<String, Quest> entry : new ArrayList<Map.Entry<String, Quest>>(this.unsavedQuestCache.entrySet())) {
            String questId = entry.getKey();
            Quest quest = entry.getValue();
            try {
                JsonObject json = quest.toJson();
                String payload = GSON.toJson((JsonElement)json);
                Quest existingQuest = ClientQuestManager.getInstance().getQuest(questId);
                if (existingQuest == null) {
                    NetworkManager.sendToServer(new QuestCreateRequestPacket(payload));
                } else {
                    NetworkManager.sendToServer(new QuestUpdateRequestPacket(questId, payload));
                }
                this.unsavedQuestCache.remove(questId);
                ++successCount;
                System.out.println("[QuestEditor] Saved quest: " + questId);
            }
            catch (Exception e) {
                ++failCount;
                System.out.println("[QuestEditor] Failed to save quest " + questId + ": " + e.getMessage());
            }
        }
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            if (failCount == 0) {
                this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)("\u00a7aSuccessfully saved " + successCount + " quest(s)")));
            } else {
                this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)("\u00a7eSaved " + successCount + " quest(s), " + failCount + " failed")));
            }
        }
        this.updateSaveAllButton();
    }

    private void save() {
        if (this.workingQuest == null) {
            return;
        }
        this.saveCurrentTabToQuest();
        String cacheKey = this.originalId != null && !this.originalId.isEmpty() ? this.originalId : this.workingQuest.getId();
        System.out.println("[QuestEditor] Preparing to save quest: " + this.workingQuest.getId() + " (cache key: " + cacheKey + ")");
        HashMap<String, Quest> allQuests = new HashMap<String, Quest>();
        for (Quest q : ClientQuestManager.getInstance().getAllQuests()) {
            allQuests.put(q.getId(), q);
        }
        allQuests.put(this.workingQuest.getId(), this.workingQuest);
        QuestValidator.ValidationResult validation = QuestValidator.validate(this.workingQuest, allQuests);
        if (!validation.isValid()) {
            if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)("\u00a7cValidation errors: " + String.join((CharSequence)", ", validation.getErrors()))));
            }
            return;
        }
        try {
            JsonObject json = this.workingQuest.toJson();
            String payload = GSON.toJson((JsonElement)json);
            if (this.originalId == null || this.originalId.isEmpty()) {
                NetworkManager.sendToServer(new QuestCreateRequestPacket(payload));
            } else {
                NetworkManager.sendToServer(new QuestUpdateRequestPacket(this.originalId, payload));
            }
            if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a7aQuest saved successfully"));
            }
            this.originalId = this.workingQuest.getId();
            this.unsavedQuestCache.remove(cacheKey);
            this.isDirty = false;
            System.out.println("[QuestEditor] Quest saved successfully, removed from cache: " + cacheKey);
            this.updateSaveAllButton();
        }
        catch (Exception e) {
            if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)("\u00a7cSave failed: " + e.getMessage())));
            }
            System.out.println("[QuestEditor] Save failed, quest remains in cache: " + e.getMessage());
        }
    }

    private void onDeleteClick() {
        if (this.originalId == null || this.originalId.isEmpty()) {
            return;
        }
        if (!this.deleteConfirmPending) {
            this.deleteConfirmPending = true;
            this.deleteConfirmTime = System.currentTimeMillis();
            this.deleteBtn.m_93666_((Component)Component.m_237113_((String)"\u00a7cConfirm?"));
            if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a7eClick Delete again to confirm"));
            }
        } else {
            this.delete();
        }
    }

    private void delete() {
        NetworkManager.sendToServer(new QuestDeleteRequestPacket(this.originalId));
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a7aQuest deletion requested"));
        }
        this.deleteConfirmPending = false;
        this.deleteBtn.m_93666_((Component)Component.m_237113_((String)"Delete"));
        this.createNew();
    }

    public void m_88315_(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(g);
        if (this.deleteConfirmPending && System.currentTimeMillis() - this.deleteConfirmTime > 3000L) {
            this.deleteConfirmPending = false;
            this.deleteBtn.m_93666_((Component)Component.m_237113_((String)"Delete"));
        }
        g.m_280509_(0, 0, 240, this.f_96544_, -804253680);
        int unsavedCount = this.unsavedQuestCache.size();
        if (this.isDirty && this.workingQuest != null) {
            String cacheKey;
            String string = cacheKey = this.originalId != null && !this.originalId.isEmpty() ? this.originalId : this.workingQuest.getId();
            if (!this.unsavedQuestCache.containsKey(cacheKey)) {
                ++unsavedCount;
            }
        }
        if (unsavedCount > 0) {
            String unsavedText = unsavedCount + " unsaved";
            int textW = this.f_96547_.m_92895_(unsavedText);
            int textX = 232 - textW;
            int textY = 36;
            g.m_280509_(textX - 4, textY - 2, textX + textW + 4, textY + 10, -1442840576);
            g.m_280488_(this.f_96547_, unsavedText, textX, textY, -22016);
        }
        int listTop = 32;
        int listBottom = this.f_96544_ - 8;
        g.m_280509_(8, listTop, 232, listBottom, -534765536);
        this.renderQuestList(g, mouseX, mouseY);
        this.updateSaveAllButton();
        int contentX = 248;
        int contentY = 40;
        int contentW = this.f_96543_ - contentX - 8;
        int contentH = this.f_96544_ - contentY - 36 - 8;
        g.m_280509_(contentX, contentY, contentX + contentW, contentY + contentH, -535291880);
        this.renderActiveTab(g, mouseX, mouseY, partialTick);
        super.m_88315_(g, mouseX, mouseY, partialTick);
        g.m_280430_(this.f_96547_, this.f_96539_, 248, -4, -1);
        int sbX = 8;
        int sbY = 8;
        int sbW = 224;
        int sbH = 18;
        if (mouseX >= sbX && mouseX <= sbX + sbW && mouseY >= sbY && mouseY <= sbY + sbH) {
            String[] lines = new String[]{"Search tips:", "id:, title:, group:, chapter:", "tag:<t> or #<t>", "is:completed|incomplete|visible|hidden|optional|required", "use \"phrases\""};
            int tw = 0;
            for (String s : lines) {
                tw = Math.max(tw, this.f_96547_.m_92895_(s));
            }
            int th = 6 + lines.length * 10 + 4;
            int tx = sbX + sbW + 8;
            int ty = sbY;
            if (tx + tw + 10 > this.f_96543_) {
                tx = Math.max(8, this.f_96543_ - tw - 12);
            }
            if (ty + th > this.f_96544_) {
                ty = Math.max(8, this.f_96544_ - th - 4);
            }
            g.m_280168_().m_85836_();
            g.m_280168_().m_252880_(0.0f, 0.0f, 400.0f);
            g.m_280509_(tx - 2, ty - 2, tx + tw + 8, ty + th, -268435456);
            g.m_280509_(tx - 2, ty - 2, tx + tw + 8, ty - 1, -11890462);
            int yy = ty + 2;
            for (String s : lines) {
                g.m_280488_(this.f_96547_, s, tx + 2, yy, -1);
                yy += 10;
            }
            g.m_280168_().m_85849_();
        }
    }

    private void renderQuestList(GuiGraphics g, int mouseX, int mouseY) {
        this.reloadQuestList();
        int listX = 8;
        int listTop = 32;
        int listW = 224;
        int listBottom = this.f_96544_ - 8;
        int lineH = 16;
        g.m_280588_(listX, listTop, listX + listW, listBottom);
        int maxLines = Math.max(1, (listBottom - listTop) / lineH);
        this.listScroll = Math.max(0, Math.min(this.listScroll, Math.max(0, this.filtered.size() - maxLines)));
        for (int i = 0; i < Math.min(maxLines, this.filtered.size() - this.listScroll); ++i) {
            boolean hasUnsavedChanges;
            Quest q = this.filtered.get(this.listScroll + i);
            int y = listTop + 2 + i * lineH;
            boolean selected = this.workingQuest != null && this.workingQuest.getId().equals(q.getId());
            boolean hover = mouseX >= listX && mouseX <= listX + listW && mouseY >= y && mouseY < y + lineH;
            boolean bl = hasUnsavedChanges = this.unsavedQuestCache.containsKey(q.getId()) || selected && this.isDirty;
            if (selected) {
                g.m_280509_(listX, y - 1, listX + listW, y + lineH - 1, -12952966);
            } else if (hover) {
                g.m_280509_(listX, y - 1, listX + listW, y + lineH - 1, -14013910);
            }
            String title = q.getTitle();
            Component formattedTitle = TextFormatter.parse(title);
            Object label = hasUnsavedChanges ? Component.m_237113_((String)"* ").m_130938_(style -> style.m_178520_(-22016)).m_7220_(formattedTitle) : formattedTitle;
            int maxWidth = listW - 4;
            if (this.f_96547_.m_92852_((FormattedText)label) > maxWidth) {
                String plainText = label.getString();
                String truncated = this.f_96547_.m_92834_(plainText, listW - 16) + "...";
                label = Component.m_237113_((String)truncated);
                if (hasUnsavedChanges) {
                    label = label.m_6881_().m_130938_(style -> style.m_178520_(-22016));
                }
            }
            g.m_280430_(this.f_96547_, label, listX + 2, y, -1);
        }
        g.m_280618_();
    }

    private void renderActiveTab(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        switch (this.activeTab.ordinal()) {
            case 0: {
                this.generalTab.render(g, mouseX, mouseY, partialTick);
                break;
            }
            case 1: {
                this.dependenciesTab.render(g, mouseX, mouseY, partialTick);
                break;
            }
            case 2: {
                this.requirementsTab.render(g, mouseX, mouseY, partialTick);
                break;
            }
            case 3: {
                this.rewardsTab.render(g, mouseX, mouseY, partialTick);
                break;
            }
            case 4: {
                this.teamTab.render(g, mouseX, mouseY, partialTick);
                break;
            }
            case 5: {
                this.advancedTab.render(g, mouseX, mouseY, partialTick);
                break;
            }
            case 6: {
                this.previewTab.render(g, mouseX, mouseY, partialTick);
            }
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int relY;
        int index;
        boolean tabHandled;
        if (super.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        switch (this.activeTab.ordinal()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 0: {
                boolean bl = this.generalTab.mouseClicked(mouseX, mouseY, button);
                break;
            }
            case 1: {
                boolean bl = this.dependenciesTab.mouseClicked(mouseX, mouseY, button);
                break;
            }
            case 2: {
                boolean bl = this.requirementsTab.mouseClicked(mouseX, mouseY, button);
                break;
            }
            case 3: {
                boolean bl = this.rewardsTab.mouseClicked(mouseX, mouseY, button);
                break;
            }
            case 4: {
                boolean bl = this.teamTab.mouseClicked(mouseX, mouseY, button);
                break;
            }
            case 5: {
                boolean bl = this.advancedTab.mouseClicked(mouseX, mouseY, button);
                break;
            }
            case 6: {
                boolean bl = tabHandled = this.previewTab.mouseClicked(mouseX, mouseY, button);
            }
        }
        if (tabHandled) {
            this.searchBox.m_93692_(false);
            return true;
        }
        int listX = 8;
        int listTop = 32;
        int listW = 224;
        int listBottom = this.f_96544_ - 8;
        int lineH = 16;
        if (mouseX >= (double)listX && mouseX <= (double)(listX + listW) && mouseY >= (double)listTop && mouseY < (double)listBottom && (index = this.listScroll + (relY = (int)mouseY - listTop - 2) / lineH) >= 0 && index < this.filtered.size()) {
            this.selectQuest(this.filtered.get(index));
            return true;
        }
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        boolean tabHandled;
        int listX = 8;
        int listTop = 32;
        int listW = 224;
        int listBottom = this.f_96544_ - 8;
        if (mouseX >= (double)listX && mouseX <= (double)(listX + listW) && mouseY >= (double)listTop && mouseY < (double)listBottom) {
            this.listScroll = (int)Math.max(0.0, (double)this.listScroll - Math.signum(delta) * 3.0);
            return true;
        }
        switch (this.activeTab.ordinal()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 0: {
                boolean bl = this.generalTab.mouseScrolled(mouseX, mouseY, delta);
                break;
            }
            case 1: {
                boolean bl = this.dependenciesTab.mouseScrolled(mouseX, mouseY, delta);
                break;
            }
            case 2: {
                boolean bl = this.requirementsTab.mouseScrolled(mouseX, mouseY, delta);
                break;
            }
            case 3: {
                boolean bl = this.rewardsTab.mouseScrolled(mouseX, mouseY, delta);
                break;
            }
            case 4: {
                boolean bl = this.teamTab.mouseScrolled(mouseX, mouseY, delta);
                break;
            }
            case 5: {
                boolean bl = this.advancedTab.mouseScrolled(mouseX, mouseY, delta);
                break;
            }
            case 6: {
                boolean bl = tabHandled = this.previewTab.mouseScrolled(mouseX, mouseY, delta);
            }
        }
        if (tabHandled) {
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        boolean tabHandled;
        if (keyCode == 257) {
            boolean anyFieldFocused = false;
            if (this.searchBox != null && this.searchBox.m_93696_()) {
                anyFieldFocused = true;
            }
            if (!anyFieldFocused) {
                switch (this.activeTab.ordinal()) {
                    case 0: {
                        boolean bl = this.generalTab.getFields().stream().anyMatch(f -> f.m_93696_());
                        break;
                    }
                    case 1: {
                        boolean bl = this.dependenciesTab.getFields().stream().anyMatch(f -> f.m_93696_());
                        break;
                    }
                    case 2: {
                        boolean bl = this.requirementsTab.getFields().stream().anyMatch(f -> f.m_93696_());
                        break;
                    }
                    case 3: {
                        boolean bl = this.rewardsTab.getFields().stream().anyMatch(f -> f.m_93696_());
                        break;
                    }
                    case 4: {
                        boolean bl = this.teamTab.getFields().stream().anyMatch(f -> f.m_93696_());
                        break;
                    }
                    case 5: {
                        boolean bl = this.advancedTab.getFields().stream().anyMatch(f -> f.m_93696_());
                        break;
                    }
                    default: {
                        boolean bl = anyFieldFocused = false;
                    }
                }
            }
            if (anyFieldFocused) {
                return true;
            }
        }
        block8 : switch (this.activeTab.ordinal()) {
            case 0: {
                boolean bl;
                for (EditBox field : this.generalTab.getFields()) {
                    if (!field.m_7933_(keyCode, scanCode, modifiers)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
                break;
            }
            case 1: {
                boolean bl;
                for (EditBox field : this.dependenciesTab.getFields()) {
                    if (!field.m_7933_(keyCode, scanCode, modifiers)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
                break;
            }
            case 2: {
                boolean bl;
                for (EditBox field : this.requirementsTab.getFields()) {
                    if (!field.m_7933_(keyCode, scanCode, modifiers)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
                break;
            }
            case 3: {
                boolean bl;
                for (EditBox field : this.rewardsTab.getFields()) {
                    if (!field.m_7933_(keyCode, scanCode, modifiers)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
                break;
            }
            case 5: {
                boolean bl;
                for (EditBox field : this.advancedTab.getFields()) {
                    if (!field.m_7933_(keyCode, scanCode, modifiers)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
                break;
            }
            default: {
                boolean bl = tabHandled = false;
            }
        }
        if (tabHandled) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char chr, int modifiers) {
        boolean tabHandled;
        block0 : switch (this.activeTab.ordinal()) {
            case 0: {
                boolean bl;
                for (EditBox field : this.generalTab.getFields()) {
                    if (!field.m_5534_(chr, modifiers)) continue;
                    bl = true;
                    break block0;
                }
                bl = false;
                break;
            }
            case 1: {
                boolean bl;
                for (EditBox field : this.dependenciesTab.getFields()) {
                    if (!field.m_5534_(chr, modifiers)) continue;
                    bl = true;
                    break block0;
                }
                bl = false;
                break;
            }
            case 2: {
                boolean bl;
                for (EditBox field : this.requirementsTab.getFields()) {
                    if (!field.m_5534_(chr, modifiers)) continue;
                    bl = true;
                    break block0;
                }
                bl = false;
                break;
            }
            case 3: {
                boolean bl;
                for (EditBox field : this.rewardsTab.getFields()) {
                    if (!field.m_5534_(chr, modifiers)) continue;
                    bl = true;
                    break block0;
                }
                bl = false;
                break;
            }
            case 5: {
                boolean bl;
                for (EditBox field : this.advancedTab.getFields()) {
                    if (!field.m_5534_(chr, modifiers)) continue;
                    bl = true;
                    break block0;
                }
                bl = false;
                break;
            }
            default: {
                boolean bl = tabHandled = false;
            }
        }
        if (tabHandled) {
            return true;
        }
        return super.m_5534_(chr, modifiers);
    }

    public boolean m_7043_() {
        return false;
    }

    private static enum Tab {
        GENERAL,
        DEPENDENCIES,
        REQUIREMENTS,
        REWARDS,
        TEAM,
        ADVANCED,
        PREVIEW;

    }

    private static class Term {
        final String key;
        final String value;

        Term(String k, String v) {
            this.key = k;
            this.value = v;
        }
    }
}

