/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.texboobcat.questory.client.rendering.ThemeIconRenderer;
import org.texboobcat.questory.theme.property.ThemeProperties;

public class QuestIconRenderer {
    private static final Map<ResourceLocation, Entity> ENTITY_CACHE = new HashMap<ResourceLocation, Entity>();
    private static Level LAST_LEVEL = null;
    private static final Map<String, ParsedRotate> ROTATE_CACHE = new HashMap<String, ParsedRotate>();

    public static void render(GuiGraphics graphics, String iconSpec, int x, int y, int size) {
        QuestIconRenderer.render(graphics, iconSpec, x, y, size, false, false);
    }

    public static void render(GuiGraphics graphics, String iconSpec, int x, int y, int size, boolean hovered, boolean selected) {
        try {
            if ((Integer)ThemeProperties.FORCE_THEME_ICON.get() == 1) {
                ThemeIconRenderer.draw(graphics, ThemeProperties.ICON, x, y, size, size);
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (iconSpec == null || iconSpec.isEmpty()) {
            try {
                ThemeIconRenderer.draw(graphics, ThemeProperties.ICON, x, y, size, size);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return;
        }
        try {
            if (iconSpec.startsWith("rotate:")) {
                Minecraft mc;
                ParsedRotate pr = ROTATE_CACHE.get(iconSpec);
                if (pr == null) {
                    String body = iconSpec.substring("rotate:".length());
                    int interval = 20;
                    int firstSep = body.indexOf(124);
                    ArrayList<String> children = new ArrayList<String>();
                    if (firstSep >= 0) {
                        try {
                            interval = Integer.parseInt(body.substring(0, firstSep).trim());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        String rest = body.substring(firstSep + 1);
                        for (String part : rest.split("\\|")) {
                            String s = part.trim();
                            if (s.isEmpty()) continue;
                            children.add(s);
                        }
                    } else {
                        for (String part : body.split("\\|")) {
                            String s = part.trim();
                            if (s.isEmpty()) continue;
                            children.add(s);
                        }
                    }
                    if (children.isEmpty()) {
                        return;
                    }
                    pr = new ParsedRotate(Math.max(1, interval), children);
                    ROTATE_CACHE.put(iconSpec, pr);
                }
                long time = (mc = Minecraft.m_91087_()) != null && mc.f_91073_ != null ? mc.f_91073_.m_46467_() : 0L;
                int idx = (int)(time / (long)Math.max(1, pr.interval) % (long)pr.children.size());
                QuestIconRenderer.render(graphics, pr.children.get(idx), x, y, size, hovered, selected);
                return;
            }
            if (iconSpec.startsWith("entity:")) {
                String raw = iconSpec.substring("entity:".length()).trim();
                int semi = raw.indexOf(59);
                String idStr = semi >= 0 ? raw.substring(0, semi).trim() : raw;
                HashMap<String, String> mods = new HashMap<String, String>();
                if (semi >= 0) {
                    String rest = raw.substring(semi + 1);
                    for (String part : rest.split(";")) {
                        int eq;
                        String p = part.trim();
                        if (p.isEmpty() || (eq = p.indexOf(61)) <= 0) continue;
                        mods.put(p.substring(0, eq).trim().toLowerCase(Locale.ROOT), p.substring(eq + 1).trim());
                    }
                }
                QuestIconRenderer.renderEntityIcon(graphics, new ResourceLocation(idStr), x, y, size, hovered, selected, mods);
                return;
            }
            if (iconSpec.startsWith("texture:")) {
                String rlStr = iconSpec.substring("texture:".length());
                String namespace = "minecraft";
                Object path = rlStr;
                if (rlStr.contains(":")) {
                    String[] parts = rlStr.split(":", 2);
                    namespace = parts[0];
                    path = parts[1];
                }
                if (!((String)path).startsWith("textures/")) {
                    path = "textures/" + (String)path;
                }
                if (!((String)path).endsWith(".png")) {
                    path = (String)path + ".png";
                }
                ResourceLocation rl = new ResourceLocation(namespace, (String)path);
                graphics.m_280163_(rl, x, y, 0.0f, 0.0f, size, size, size, size);
                return;
            }
            ResourceLocation itemId = new ResourceLocation(iconSpec);
            Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(itemId);
            if (item != null) {
                ItemStack stack = new ItemStack((ItemLike)item);
                float scale = Math.max(0.125f, (float)size / 16.0f);
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_252880_((float)x, (float)y, 0.0f);
                graphics.m_280168_().m_85841_(scale, scale, 1.0f);
                graphics.m_280480_(stack, 0, 0);
                graphics.m_280168_().m_85849_();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void renderEntityIcon(GuiGraphics graphics, ResourceLocation entityId, int x, int y, int size, boolean hovered, boolean selected, Map<String, String> mods) {
        Entity entity;
        Minecraft mc = Minecraft.m_91087_();
        if (mc == null || mc.f_91073_ == null) {
            return;
        }
        if (LAST_LEVEL != mc.f_91073_) {
            ENTITY_CACHE.clear();
            LAST_LEVEL = mc.f_91073_;
        }
        if ((entity = ENTITY_CACHE.get(entityId)) == null) {
            EntityType type = (EntityType)BuiltInRegistries.f_256780_.m_7745_(entityId);
            if (type == null) {
                return;
            }
            try {
                entity = type.m_20615_((Level)mc.f_91073_);
            }
            catch (Throwable t) {
                return;
            }
            if (entity == null) {
                return;
            }
            ENTITY_CACHE.put(entityId, entity);
        }
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.f_20883_ = 180.0f;
            living.m_146922_(180.0f);
            living.m_146926_(0.0f);
        }
        double baseFit = (Double)ThemeProperties.ENTITY_ICON_BASE_FIT.get();
        double minScale = (Double)ThemeProperties.ENTITY_ICON_MIN_SCALE.get();
        double maxScale = (Double)ThemeProperties.ENTITY_ICON_MAX_SCALE.get();
        double spinSpeed = (Double)ThemeProperties.ENTITY_ICON_SPIN_SPEED.get();
        double bobAmp = (Double)ThemeProperties.ENTITY_ICON_BOB_AMPLITUDE.get();
        double bobSpeed = (Double)ThemeProperties.ENTITY_ICON_BOB_SPEED.get();
        if (mods != null && !mods.isEmpty()) {
            baseFit = QuestIconRenderer.getDoubleMod(mods, "fit", baseFit);
            minScale = QuestIconRenderer.getDoubleMod(mods, "min", minScale);
            maxScale = QuestIconRenderer.getDoubleMod(mods, "max", maxScale);
            spinSpeed = QuestIconRenderer.getDoubleMod(mods, "spin", spinSpeed);
            bobAmp = QuestIconRenderer.getDoubleMod(mods, "bob", bobAmp);
            bobSpeed = QuestIconRenderer.getDoubleMod(mods, "bob_speed", bobSpeed);
        }
        if (hovered) {
            spinSpeed *= 1.5;
            bobAmp *= 1.25;
        }
        if (selected) {
            spinSpeed *= 1.5;
            bobAmp *= 1.25;
        }
        float bw = Math.max(0.6f, entity.m_20205_());
        float bh = Math.max(0.6f, entity.m_20206_());
        float maxDim = Math.max(bw, bh);
        float scale = (float)((double)size * baseFit / (double)Math.max(0.1f, maxDim));
        scale = (float)Mth.m_14008_((double)scale, (double)minScale, (double)maxScale);
        PoseStack pose = graphics.m_280168_();
        pose.m_85836_();
        double t = (double)((float)mc.f_91073_.m_46467_() + mc.m_91296_()) * bobSpeed;
        double bob = bobAmp > 0.0 ? Math.sin(t * 0.1) * bobAmp : 0.0;
        pose.m_85837_((double)((float)x + (float)size / 2.0f), (double)((float)y + (float)size * 0.9f) - bob, 50.0);
        pose.m_85841_(scale, scale, -scale);
        float spin = (float)(spinSpeed * (double)(mc.f_91073_.m_46467_() % 360L));
        if (spinSpeed != 0.0) {
            pose.m_252781_(Axis.f_252436_.m_252977_(spin));
        }
        pose.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        EntityRenderDispatcher dispatcher = mc.m_91290_();
        try {
            dispatcher.m_114468_(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        MultiBufferSource.BufferSource buffer = mc.m_91269_().m_110104_();
        try {
            dispatcher.m_114384_(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, pose, (MultiBufferSource)buffer, 0xF000F0);
            buffer.m_109911_();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            dispatcher.m_114468_(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        pose.m_85849_();
    }

    private static double getDoubleMod(Map<String, String> mods, String key, double def) {
        try {
            String v = mods.get(key);
            if (v == null || v.isEmpty()) {
                return def;
            }
            double d = Double.parseDouble(v);
            switch (key) {
                case "fit": {
                    return Mth.m_14008_((double)d, (double)0.1, (double)2.0);
                }
                case "min": {
                    return Mth.m_14008_((double)d, (double)0.1, (double)200.0);
                }
                case "max": {
                    return Mth.m_14008_((double)d, (double)0.1, (double)200.0);
                }
                case "spin": {
                    return Mth.m_14008_((double)d, (double)0.0, (double)20.0);
                }
                case "bob": {
                    return Mth.m_14008_((double)d, (double)0.0, (double)16.0);
                }
                case "bob_speed": {
                    return Mth.m_14008_((double)d, (double)0.1, (double)10.0);
                }
            }
            return d;
        }
        catch (Exception ignored) {
            return def;
        }
    }

    private static class ParsedRotate {
        final int interval;
        final List<String> children;

        ParsedRotate(int interval, List<String> children) {
            this.interval = interval;
            this.children = children;
        }
    }
}

