/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import org.texboobcat.questory.client.ClientTeamManager;
import org.texboobcat.questory.client.gui.ConfirmationDialog;
import org.texboobcat.questory.client.gui.TeamInviteDialog;
import org.texboobcat.questory.client.gui.TransferOwnershipDialog;
import org.texboobcat.questory.network.NetworkManager;
import org.texboobcat.questory.network.TeamActionPacket;
import org.texboobcat.questory.network.TeamSettingsPacket;
import org.texboobcat.questory.team.QuestTeam;

public class TeamManagementScreen
extends Screen {
    private static final int WINDOW_WIDTH = 260;
    private static final int WINDOW_HEIGHT = 220;
    private final Screen parent;
    private int leftPos;
    private int topPos;
    private TeamTab currentTab = TeamTab.INFO;
    private Button infoTabButton;
    private Button membersTabButton;
    private Button invitesTabButton;
    private Button settingsTabButton;
    private Button leaveButton;
    private Button closeButton;
    private Button inviteButton;
    private List<MemberEntry> memberEntries = new ArrayList<MemberEntry>();
    private int memberListScroll = 0;
    private Button transferOwnershipButton;
    private Button disbandTeamButton;
    private EditBox maxMembersField;
    private Button saveMaxMembersButton;

    public TeamManagementScreen(Screen parent) {
        super((Component)Component.m_237113_((String)"Team Management"));
        this.parent = parent;
    }

    protected void m_7856_() {
        this.leftPos = (this.f_96543_ - 260) / 2;
        this.topPos = (this.f_96544_ - 220) / 2;
        int tabY = this.topPos + 30;
        int tabWidth = 60;
        this.infoTabButton = Button.m_253074_((Component)Component.m_237113_((String)"Info"), btn -> this.switchTab(TeamTab.INFO)).m_252987_(this.leftPos + 5, tabY, tabWidth, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.infoTabButton);
        this.membersTabButton = Button.m_253074_((Component)Component.m_237113_((String)"Members"), btn -> this.switchTab(TeamTab.MEMBERS)).m_252987_(this.leftPos + 5 + tabWidth + 2, tabY, tabWidth, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.membersTabButton);
        this.invitesTabButton = Button.m_253074_((Component)Component.m_237113_((String)"Invites"), btn -> this.switchTab(TeamTab.INVITES)).m_252987_(this.leftPos + 5 + (tabWidth + 2) * 2, tabY, tabWidth, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.invitesTabButton);
        this.settingsTabButton = Button.m_253074_((Component)Component.m_237113_((String)"Settings"), btn -> this.switchTab(TeamTab.SETTINGS)).m_252987_(this.leftPos + 5 + (tabWidth + 2) * 3, tabY, tabWidth, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.settingsTabButton);
        this.leaveButton = Button.m_253074_((Component)Component.m_237113_((String)"Leave"), btn -> this.leaveTeam()).m_252987_(this.leftPos + 260 - 80, this.topPos + 5, 35, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.leaveButton);
        this.closeButton = Button.m_253074_((Component)Component.m_237113_((String)"X"), btn -> this.m_7379_()).m_252987_(this.leftPos + 260 - 40, this.topPos + 5, 35, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.closeButton);
        this.inviteButton = Button.m_253074_((Component)Component.m_237113_((String)"Invite Player"), btn -> this.openInviteDialog()).m_252987_(this.leftPos + 10, this.topPos + 220 - 30, 100, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.inviteButton);
        this.initSettingsWidgets();
        this.updateButtonStates();
    }

    private void initSettingsWidgets() {
        int contentY;
        int settingsX = this.leftPos + 10;
        int titleY = contentY = this.topPos + 55;
        int ownerLabelY = titleY + 20;
        int ownerButtonY = ownerLabelY + 12;
        int maxLabelY = ownerButtonY + 23;
        int maxFieldY = maxLabelY + 12;
        int dangerLabelY = maxFieldY + 28;
        int disbandButtonY = dangerLabelY + 12;
        this.transferOwnershipButton = Button.m_253074_((Component)Component.m_237113_((String)"Transfer Ownership..."), btn -> this.transferOwnership()).m_252987_(settingsX, ownerButtonY, 150, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.transferOwnershipButton);
        this.maxMembersField = new EditBox(this.f_96547_, settingsX, maxFieldY, 60, 20, (Component)Component.m_237113_((String)"Max Members"));
        this.maxMembersField.m_94199_(2);
        this.maxMembersField.m_94144_("10");
        this.maxMembersField.m_94151_(this::onMaxMembersChanged);
        this.m_7787_((GuiEventListener)this.maxMembersField);
        this.saveMaxMembersButton = Button.m_253074_((Component)Component.m_237113_((String)"Save"), btn -> this.saveMaxMembers()).m_252987_(settingsX + 65, maxFieldY, 45, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.saveMaxMembersButton);
        this.disbandTeamButton = Button.m_253074_((Component)Component.m_237113_((String)"Disband Team"), btn -> this.disbandTeam()).m_252987_(settingsX, disbandButtonY, 150, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.disbandTeamButton);
        this.loadTeamSettings();
        this.updateSettingsVisibility();
    }

    private void updateSettingsVisibility() {
        boolean showSettings;
        this.transferOwnershipButton.f_93624_ = showSettings = this.currentTab == TeamTab.SETTINGS && ClientTeamManager.getInstance().isTeamOwner();
        this.maxMembersField.m_94194_(showSettings);
        this.saveMaxMembersButton.f_93624_ = showSettings;
        this.disbandTeamButton.f_93624_ = showSettings;
    }

    private void loadTeamSettings() {
        QuestTeam team = ClientTeamManager.getInstance().getCurrentTeam();
        if (team != null && team.getSettings() != null) {
            this.maxMembersField.m_94144_(String.valueOf(team.getSettings().getMaxMembers()));
        }
    }

    private void onMaxMembersChanged(String value) {
        if (!value.isEmpty() && !value.matches("\\d+")) {
            value = value.replaceAll("[^\\d]", "");
            this.maxMembersField.m_94144_(value);
        }
    }

    private void switchTab(TeamTab tab) {
        this.currentTab = tab;
        this.updateButtonStates();
        this.updateSettingsVisibility();
    }

    private void updateButtonStates() {
        this.infoTabButton.f_93623_ = this.currentTab != TeamTab.INFO;
        this.membersTabButton.f_93623_ = this.currentTab != TeamTab.MEMBERS;
        this.invitesTabButton.f_93623_ = this.currentTab != TeamTab.INVITES;
        this.settingsTabButton.f_93623_ = this.currentTab != TeamTab.SETTINGS;
        boolean inTeam = ClientTeamManager.getInstance().isInTeam();
        boolean isOwner = ClientTeamManager.getInstance().isTeamOwner();
        this.leaveButton.f_93623_ = inTeam;
        boolean bl = this.inviteButton.f_93623_ = inTeam && isOwner;
        if (this.transferOwnershipButton != null) {
            this.transferOwnershipButton.f_93623_ = isOwner;
        }
        if (this.disbandTeamButton != null) {
            this.disbandTeamButton.f_93623_ = isOwner;
        }
        if (this.maxMembersField != null) {
            this.maxMembersField.m_94186_(isOwner);
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        graphics.m_280509_(this.leftPos, this.topPos, this.leftPos + 260, this.topPos + 220, -872415232);
        graphics.m_280509_(this.leftPos, this.topPos, this.leftPos + 260, this.topPos + 28, -14540254);
        String teamName = ClientTeamManager.getInstance().getTeamName();
        if (teamName != null) {
            graphics.m_280488_(this.f_96547_, "Team: " + teamName, this.leftPos + 5, this.topPos + 10, 0xFFFFFF);
        } else {
            graphics.m_280488_(this.f_96547_, "No Team", this.leftPos + 5, this.topPos + 10, 0x888888);
        }
        this.renderTabContent(graphics, mouseX, mouseY);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
    }

    private void renderTabContent(GuiGraphics graphics, int mouseX, int mouseY) {
        int contentX = this.leftPos + 10;
        int contentY = this.topPos + 55;
        int contentWidth = 240;
        int contentHeight = 130;
        switch (this.currentTab.ordinal()) {
            case 0: {
                this.renderInfoTab(graphics, contentX, contentY, contentWidth, contentHeight);
                break;
            }
            case 1: {
                this.renderMembersTab(graphics, contentX, contentY, contentWidth, contentHeight);
                break;
            }
            case 2: {
                this.renderInvitesTab(graphics, contentX, contentY, contentWidth, contentHeight);
                break;
            }
            case 3: {
                this.renderSettingsTab(graphics, contentX, contentY, contentWidth, contentHeight);
            }
        }
    }

    private void renderInfoTab(GuiGraphics graphics, int x, int y, int width, int height) {
        QuestTeam team = ClientTeamManager.getInstance().getCurrentTeam();
        if (team == null) {
            graphics.m_280488_(this.f_96547_, "You are not in a team", x, y, 0x888888);
            graphics.m_280488_(this.f_96547_, "Create or join a team to", x, y + 15, 0x888888);
            graphics.m_280488_(this.f_96547_, "complete quests together!", x, y + 30, 0x888888);
            return;
        }
        int lineY = y;
        graphics.m_280488_(this.f_96547_, "\u00a7eTeam: \u00a7f" + team.getTeamName(), x, lineY, 0xFFFFFF);
        String ownerName = this.getPlayerName(team.getOwner());
        graphics.m_280488_(this.f_96547_, "\u00a7eOwner: \u00a7f" + ownerName, x, lineY += 15, 0xFFFFFF);
        graphics.m_280488_(this.f_96547_, "\u00a7eMembers: \u00a7f" + team.getMemberCount() + "/10", x, lineY += 15, 0xFFFFFF);
        lineY += 15;
        int pendingRewards = ClientTeamManager.getInstance().getPendingRewardCount();
        if (pendingRewards > 0) {
            graphics.m_280488_(this.f_96547_, "\u00a76Pending Rewards: \u00a7f" + pendingRewards, x, lineY, 0xFFFFFF);
            lineY += 15;
        }
        graphics.m_280488_(this.f_96547_, "\u00a77Complete quests with your", x, lineY += 10, 0x888888);
        graphics.m_280488_(this.f_96547_, "\u00a77team to share progress and", x, lineY += 12, 0x888888);
        graphics.m_280488_(this.f_96547_, "\u00a77earn rewards together!", x, lineY += 12, 0x888888);
    }

    private void renderMembersTab(GuiGraphics graphics, int x, int y, int width, int height) {
        QuestTeam team = ClientTeamManager.getInstance().getCurrentTeam();
        if (team == null) {
            graphics.m_280488_(this.f_96547_, "Not in a team", x, y, 0x888888);
            return;
        }
        int lineY = y;
        for (UUID memberId : team.getMembers()) {
            if (lineY > y + height - 20) break;
            String name = this.getPlayerName(memberId);
            boolean isOwner = memberId.equals(team.getOwner());
            boolean isOnline = this.isPlayerOnline(memberId);
            String status = isOnline ? "\u00a7a\u25cf" : "\u00a77\u25cf";
            String role = isOwner ? " \u00a76[Owner]" : "";
            graphics.m_280488_(this.f_96547_, status + " \u00a7f" + name + role, x, lineY, 0xFFFFFF);
            lineY += 18;
        }
    }

    private void renderInvitesTab(GuiGraphics graphics, int x, int y, int width, int height) {
        int pendingInvites = ClientTeamManager.getInstance().getPendingInviteCount();
        if (pendingInvites == 0) {
            graphics.m_280488_(this.f_96547_, "No pending invites", x, y + 35, 0x888888);
        } else {
            graphics.m_280488_(this.f_96547_, "\u00a7ePending Invites: \u00a7f" + pendingInvites, x, y + 35, 0xFFFFFF);
            graphics.m_280488_(this.f_96547_, "\u00a77Use /questory team accept", x, y + 50, 0x888888);
            graphics.m_280488_(this.f_96547_, "\u00a77to join a team", x, y + 62, 0x888888);
        }
    }

    private void renderSettingsTab(GuiGraphics graphics, int x, int y, int width, int height) {
        QuestTeam team = ClientTeamManager.getInstance().getCurrentTeam();
        boolean isOwner = ClientTeamManager.getInstance().isTeamOwner();
        if (team == null) {
            graphics.m_280488_(this.f_96547_, "Not in a team", x, y, 0x888888);
            return;
        }
        int lineY = y;
        if (!isOwner) {
            graphics.m_280488_(this.f_96547_, "\u00a7eTeam Settings", x, lineY, 0xFFFFFF);
            graphics.m_280488_(this.f_96547_, "\u00a77Only the team owner can", x, lineY += 20, 0x888888);
            graphics.m_280488_(this.f_96547_, "\u00a77modify team settings.", x, lineY += 12, 0x888888);
            return;
        }
        graphics.m_280488_(this.f_96547_, "\u00a7eTeam Settings", x, lineY, 0xFFFFFF);
        graphics.m_280488_(this.f_96547_, "\u00a76Team Owner:", x, lineY += 20, 0xFFFFFF);
        graphics.m_280488_(this.f_96547_, "\u00a76Max Members:", x, (lineY += 32) + 3, 0xFFFFFF);
        graphics.m_280488_(this.f_96547_, "\u00a7c\u00a7lDanger Zone:", x, (lineY += 40) + 3, 0xFF5555);
        graphics.m_280488_(this.f_96547_, "\u00a77This cannot be undone!", x, (lineY += 32) + 5, 0x888888);
    }

    private void saveMaxMembers() {
        block5: {
            try {
                int maxMembers = Integer.parseInt(this.maxMembersField.m_94155_());
                if (maxMembers < 1 || maxMembers > 100) {
                    if (this.f_96541_.f_91074_ != null) {
                        this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a7c[Questory] Max members must be between 1 and 100"));
                    }
                    return;
                }
                TeamSettingsPacket packet = TeamSettingsPacket.setMaxMembers(maxMembers);
                NetworkManager.sendToServer(packet);
                if (this.f_96541_.f_91074_ != null) {
                    this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a7a[Questory] Updating team settings..."));
                }
            }
            catch (NumberFormatException e) {
                if (this.f_96541_.f_91074_ == null) break block5;
                this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a7c[Questory] Invalid number"));
            }
        }
    }

    private void leaveTeam() {
        if (ClientTeamManager.getInstance().isInTeam()) {
            TeamActionPacket packet = TeamActionPacket.leave();
            NetworkManager.sendToServer(packet);
            this.m_7379_();
        }
    }

    private void openInviteDialog() {
        this.f_96541_.m_91152_((Screen)new TeamInviteDialog(this));
    }

    private void transferOwnership() {
        this.f_96541_.m_91152_((Screen)new TransferOwnershipDialog(this));
    }

    private void disbandTeam() {
        QuestTeam team = ClientTeamManager.getInstance().getCurrentTeam();
        if (team == null) {
            return;
        }
        String message = "Are you sure you want to disband team '" + team.getTeamName() + "'? All members will be removed and all team progress will be lost. This cannot be undone!";
        this.f_96541_.m_91152_((Screen)new ConfirmationDialog(this, "Disband Team", message, "Disband", "Cancel", this::sendDisbandPacket, true));
    }

    private void sendDisbandPacket() {
        TeamSettingsPacket packet = TeamSettingsPacket.disbandTeam();
        NetworkManager.sendToServer(packet);
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    private String getPlayerName(UUID playerId) {
        Player player = Minecraft.m_91087_().f_91073_.m_46003_(playerId);
        if (player != null) {
            return player.m_7755_().getString();
        }
        return playerId.toString().substring(0, 8);
    }

    private boolean isPlayerOnline(UUID playerId) {
        return Minecraft.m_91087_().f_91073_.m_46003_(playerId) != null;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.currentTab == TeamTab.SETTINGS && this.maxMembersField != null && this.maxMembersField.m_93696_() && this.maxMembersField.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.currentTab == TeamTab.SETTINGS && this.maxMembersField != null && this.maxMembersField.m_93696_() && this.maxMembersField.m_5534_(codePoint, modifiers)) {
            return true;
        }
        return super.m_5534_(codePoint, modifiers);
    }

    public boolean m_7043_() {
        return false;
    }

    static enum TeamTab {
        INFO,
        MEMBERS,
        INVITES,
        SETTINGS;

    }

    static class MemberEntry {
        UUID playerId;
        String name;
        boolean isOwner;
        boolean isOnline;

        MemberEntry(UUID playerId, String name, boolean isOwner, boolean isOnline) {
            this.playerId = playerId;
            this.name = name;
            this.isOwner = isOwner;
            this.isOnline = isOnline;
        }
    }
}

