/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import org.texboobcat.questory.config.QuestoryConfig;
import org.texboobcat.questory.team.PendingRewardManager;
import org.texboobcat.questory.team.QuestTeam;
import org.texboobcat.questory.team.TeamManager;

public class TeamCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"questory").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"team").then(Commands.m_82127_((String)"create").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string()).executes(ctx -> TeamCommands.createTeam((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"name")))))).then(Commands.m_82127_((String)"invite").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> TeamCommands.invitePlayer((CommandContext<CommandSourceStack>)ctx, EntityArgument.m_91474_((CommandContext)ctx, (String)"player")))))).then(Commands.m_82127_((String)"accept").executes(TeamCommands::acceptInvite))).then(Commands.m_82127_((String)"decline").executes(TeamCommands::declineInvite))).then(Commands.m_82127_((String)"leave").executes(TeamCommands::leaveTeam))).then(Commands.m_82127_((String)"kick").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> TeamCommands.kickPlayer((CommandContext<CommandSourceStack>)ctx, EntityArgument.m_91474_((CommandContext)ctx, (String)"player")))))).then(Commands.m_82127_((String)"info").executes(TeamCommands::showTeamInfo))).then(Commands.m_82127_((String)"list").executes(TeamCommands::listTeams))).then(Commands.m_82127_((String)"rewards").executes(TeamCommands::checkPendingRewards))));
    }

    private static int createTeam(CommandContext<CommandSourceStack> ctx, String name) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        QuestoryConfig cfg = QuestoryConfig.getInstance();
        if (!cfg.teamSystemEnabled) {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7c[Questory] Team system is disabled"));
            return 0;
        }
        if (TeamManager.getInstance().getPlayerTeamId(player.m_20148_()) != null) {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7c[Questory] You are already in a team! Use /questory team leave first."));
            return 0;
        }
        QuestTeam team = TeamManager.getInstance().createTeam(name, player.m_20148_());
        if (team == null) {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7c[Questory] Team creation is disabled or failed"));
            return 0;
        }
        player.m_213846_((Component)Component.m_237113_((String)("\u00a7a[Questory] Team '" + name + "' created successfully!")));
        return 1;
    }

    private static int invitePlayer(CommandContext<CommandSourceStack> ctx, ServerPlayer target) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        UUID teamId = TeamManager.getInstance().getPlayerTeamId(player.m_20148_());
        if (teamId == null) {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7c[Questory] You are not in a team"));
            return 0;
        }
        if (!TeamManager.getInstance().isTeamOwner(player.m_20148_(), teamId)) {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7c[Questory] Only the team owner can invite players"));
            return 0;
        }
        if (TeamManager.getInstance().invitePlayer(teamId, target.m_20148_())) {
            player.m_213846_((Component)Component.m_237113_((String)("\u00a7a[Questory] Invited " + target.m_7755_().getString() + " to your team")));
            target.m_213846_((Component)Component.m_237113_((String)"\u00a7e[Questory] You have been invited to join a team! Use /questory team accept"));
            return 1;
        }
        player.m_213846_((Component)Component.m_237113_((String)"\u00a7c[Questory] Failed to invite player (already in a team?)"));
        return 0;
    }

    private static int acceptInvite(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        Set<UUID> invites = TeamManager.getInstance().getPendingInvites(player.m_20148_());
        if (invites.isEmpty()) {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7c[Questory] You have no pending team invites"));
            return 0;
        }
        UUID teamId = invites.iterator().next();
        if (TeamManager.getInstance().acceptInvite(player.m_20148_(), teamId)) {
            String teamName = TeamManager.getInstance().getTeamName(teamId);
            player.m_213846_((Component)Component.m_237113_((String)("\u00a7a[Questory] You joined the team: " + teamName)));
            for (UUID memberId : TeamManager.getInstance().getTeamMembers(teamId)) {
                ServerPlayer member;
                if (memberId.equals(player.m_20148_()) || (member = player.m_20194_().m_6846_().m_11259_(memberId)) == null) continue;
                member.m_213846_((Component)Component.m_237113_((String)("\u00a7e[Questory] " + player.m_7755_().getString() + " joined the team!")));
            }
            return 1;
        }
        player.m_213846_((Component)Component.m_237113_((String)"\u00a7c[Questory] Failed to join team (team full?)"));
        return 0;
    }

    private static int declineInvite(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        Set<UUID> invites = TeamManager.getInstance().getPendingInvites(player.m_20148_());
        if (invites.isEmpty()) {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7c[Questory] You have no pending team invites"));
            return 0;
        }
        UUID teamId = invites.iterator().next();
        if (TeamManager.getInstance().declineInvite(player.m_20148_(), teamId)) {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7a[Questory] Declined team invite"));
            return 1;
        }
        return 0;
    }

    private static int leaveTeam(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        UUID teamId = TeamManager.getInstance().getPlayerTeamId(player.m_20148_());
        if (teamId == null) {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7c[Questory] You are not in a team"));
            return 0;
        }
        String teamName = TeamManager.getInstance().getTeamName(teamId);
        if (TeamManager.getInstance().leaveTeam(player.m_20148_())) {
            player.m_213846_((Component)Component.m_237113_((String)("\u00a7a[Questory] You left the team: " + teamName)));
            for (UUID memberId : TeamManager.getInstance().getTeamMembers(teamId)) {
                ServerPlayer member = player.m_20194_().m_6846_().m_11259_(memberId);
                if (member == null) continue;
                member.m_213846_((Component)Component.m_237113_((String)("\u00a7e[Questory] " + player.m_7755_().getString() + " left the team")));
            }
            return 1;
        }
        return 0;
    }

    private static int kickPlayer(CommandContext<CommandSourceStack> ctx, ServerPlayer target) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        UUID teamId = TeamManager.getInstance().getPlayerTeamId(player.m_20148_());
        if (teamId == null) {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7c[Questory] You are not in a team"));
            return 0;
        }
        if (TeamManager.getInstance().kickPlayer(teamId, target.m_20148_(), player.m_20148_())) {
            player.m_213846_((Component)Component.m_237113_((String)("\u00a7a[Questory] Kicked " + target.m_7755_().getString() + " from the team")));
            target.m_213846_((Component)Component.m_237113_((String)"\u00a7c[Questory] You were kicked from the team"));
            return 1;
        }
        player.m_213846_((Component)Component.m_237113_((String)"\u00a7c[Questory] Failed to kick player (not owner or player not in team?)"));
        return 0;
    }

    private static int showTeamInfo(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        UUID teamId = TeamManager.getInstance().getPlayerTeamId(player.m_20148_());
        if (teamId == null) {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7c[Questory] You are not in a team"));
            return 0;
        }
        String teamName = TeamManager.getInstance().getTeamName(teamId);
        Set<UUID> members = TeamManager.getInstance().getTeamMembers(teamId);
        boolean isOwner = TeamManager.getInstance().isTeamOwner(player.m_20148_(), teamId);
        player.m_213846_((Component)Component.m_237113_((String)"\u00a76=== Team Info ==="));
        player.m_213846_((Component)Component.m_237113_((String)("\u00a7eName: \u00a7f" + teamName)));
        player.m_213846_((Component)Component.m_237113_((String)("\u00a7eMembers: \u00a7f" + members.size())));
        player.m_213846_((Component)Component.m_237113_((String)("\u00a7eYour Role: \u00a7f" + (isOwner ? "Owner" : "Member"))));
        player.m_213846_((Component)Component.m_237113_((String)"\u00a7eMembers:"));
        for (UUID memberId : members) {
            ServerPlayer member = player.m_20194_().m_6846_().m_11259_(memberId);
            String status = member != null ? "\u00a7aOnline" : "\u00a77Offline";
            String name = member != null ? member.m_7755_().getString() : memberId.toString();
            boolean memberIsOwner = TeamManager.getInstance().isTeamOwner(memberId, teamId);
            player.m_213846_((Component)Component.m_237113_((String)("  \u00a7f- " + name + " " + status + (memberIsOwner ? " \u00a76[Owner]" : ""))));
        }
        return 1;
    }

    private static int listTeams(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        Collection<QuestTeam> teams = TeamManager.getInstance().getAllTeams();
        if (teams.isEmpty()) {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7e[Questory] No teams exist yet"));
            return 0;
        }
        player.m_213846_((Component)Component.m_237113_((String)"\u00a76=== All Teams ==="));
        for (QuestTeam team : teams) {
            player.m_213846_((Component)Component.m_237113_((String)("\u00a7f- " + team.getTeamName() + " \u00a77(" + team.getMemberCount() + " members)")));
        }
        return 1;
    }

    private static int checkPendingRewards(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        QuestoryConfig cfg = QuestoryConfig.getInstance();
        if (!cfg.teamSystemEnabled) {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7c[Questory] Team system is disabled"));
            return 0;
        }
        PendingRewardManager pendingMgr = PendingRewardManager.getInstance();
        int count = pendingMgr.getPendingRewardCount(player.m_20148_());
        if (count > 0) {
            player.m_213846_((Component)Component.m_237113_((String)("\u00a7e[Questory] You have \u00a7f" + count + " \u00a7epending team rewards")));
            player.m_213846_((Component)Component.m_237113_((String)"\u00a77They will be automatically granted on your next login"));
        } else {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7a[Questory] You have no pending team rewards"));
        }
        return 1;
    }
}

