/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.forge;

import com.mojang.brigadier.CommandDispatcher;
import dev.architectury.platform.forge.EventBuses;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.texboobcat.questory.Questory;
import org.texboobcat.questory.commands.QuestCommands;
import org.texboobcat.questory.commands.TeamCommands;
import org.texboobcat.questory.config.QuestoryConfig;
import org.texboobcat.questory.events.QuestEvents;
import org.texboobcat.questory.forge.client.QuestoryForgeClient;
import org.texboobcat.questory.forge.integration.GameStagesIntegrationForge;
import org.texboobcat.questory.integration.GameStagesHelper;
import org.texboobcat.questory.integration.NoOpGameStagesHelper;
import org.texboobcat.questory.manager.DailyQuestManager;
import org.texboobcat.questory.team.TeamManager;

@Mod(value="questory")
public final class QuestoryForge {
    private int invScanTicker = 0;
    private int envScanTicker = 0;

    public QuestoryForge() {
        EventBuses.registerModEventBus((String)"questory", (IEventBus)FMLJavaModLoadingContext.get().getModEventBus());
        Questory.init();
        try {
            GameStagesHelper.setInstance(new GameStagesIntegrationForge());
        }
        catch (Throwable e) {
            System.err.println("[Questify] Failed to initialize GameStages integration: " + e.getMessage());
            GameStagesHelper.setInstance(new NoOpGameStagesHelper());
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> QuestoryForgeClient.init());
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> Questory.initQuestSystem(FMLPaths.GAMEDIR.get()));
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        QuestCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        TeamCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            QuestEvents.onItemCrafted(player2, event.getCrafting());
        }
    }

    @SubscribeEvent
    public void onItemPickup(PlayerEvent.ItemPickupEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            QuestEvents.onItemObtained(player2, event.getStack());
        }
    }

    @SubscribeEvent
    public void onEntityKilled(LivingDeathEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            QuestEvents.onEntityKilled(player, event.getEntity());
        }
    }

    @SubscribeEvent
    public void onAdvancementEarned(AdvancementEvent.AdvancementEarnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            QuestEvents.onAdvancementEarned(player2, event.getAdvancement().m_138327_());
        }
    }

    @SubscribeEvent
    public void onPlayerDisconnect(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            QuestEvents.onPlayerDisconnect(player2);
        }
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            QuestEvents.onPlayerJoin(player2);
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.getServer() != null) {
            DailyQuestManager.getInstance().onServerTick(event.getServer());
            try {
                int interval;
                if (++this.invScanTicker >= 5) {
                    this.invScanTicker = 0;
                    for (ServerPlayer player : event.getServer().m_6846_().m_11314_()) {
                        QuestEvents.onInventoryChanged(player);
                    }
                }
                if (++this.envScanTicker >= (interval = Math.max(1, QuestoryConfig.getInstance().observationScanIntervalTicks))) {
                    this.envScanTicker = 0;
                }
                for (ServerPlayer player : event.getServer().m_6846_().m_11314_()) {
                    int offset = (player.m_20148_().hashCode() & Integer.MAX_VALUE) % interval;
                    if (this.envScanTicker != offset) continue;
                    QuestEvents.onEnvironmentTick(player);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        System.out.println("[Questify] Server stopping - saving team data...");
        try {
            QuestoryConfig cfg = QuestoryConfig.getInstance();
            if (cfg.teamSystemEnabled) {
                TeamManager.getInstance().saveAll();
                System.out.println("[Questify] Team data saved successfully");
            }
        }
        catch (Throwable t) {
            System.err.println("[Questify] Failed to save team data: " + t.getMessage());
            t.printStackTrace();
        }
    }
}

