/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.manager;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import org.texboobcat.questory.Questory;
import org.texboobcat.questory.config.QuestoryConfig;
import org.texboobcat.questory.manager.QuestManager;
import org.texboobcat.questory.network.DailyDataSyncPacket;
import org.texboobcat.questory.network.NetworkManager;
import org.texboobcat.questory.quest.Quest;
import org.texboobcat.questory.quest.QuestProgress;

public class DailyQuestManager {
    private static DailyQuestManager instance;
    private Path dataPath;
    private Path dailyDir;
    private Path dailyHistoryDir;
    private QuestManager questManager;
    private String currentDailyId = "";
    private long lastFetchMillis = 0L;
    private long nextIntervalCheckMs = 0L;
    private String lastRolloverProcessedDate = "";
    private String lastBroadcastDailyId = "";
    private String currentTitle = "";
    private String currentValidFrom = "";
    private String currentValidUntil = "";
    private String currentRolloverTz = "";
    private String currentCompletionMode = "";
    private int currentMinQuestsToComplete = -1;

    public static DailyQuestManager getInstance() {
        if (instance == null) {
            instance = new DailyQuestManager();
        }
        return instance;
    }

    private DailyQuestManager() {
    }

    public void init(Path dataPath, QuestManager qm) {
        this.dataPath = dataPath;
        this.questManager = qm;
        QuestoryConfig cfg = QuestoryConfig.getInstance();
        String dirOverride = cfg.dailyDataDirNameOverride != null && !cfg.dailyDataDirNameOverride.isBlank() ? cfg.dailyDataDirNameOverride : "daily";
        this.dailyDir = dataPath.resolve(dirOverride);
        this.dailyHistoryDir = this.dailyDir.resolve("history");
        try {
            Files.createDirectories(this.dailyDir, new FileAttribute[0]);
            Files.createDirectories(this.dailyHistoryDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            System.err.println("[Questory] Failed to create daily directories: " + e.getMessage());
        }
        if (cfg.dailyEnable && cfg.dailyFetchOnWorldLoad) {
            this.reload();
            this.scheduleNextInterval();
        }
    }

    public boolean reload() {
        QuestoryConfig cfg = QuestoryConfig.getInstance();
        if (!cfg.dailyEnable) {
            System.out.println("[Questory] Daily system disabled in config");
            return false;
        }
        Optional<JsonObject> payload = this.fetchRemote(cfg);
        if (payload.isEmpty()) {
            System.err.println("[Questory] Daily fetch failed; applying offline fallback: " + cfg.dailyOfflineFallback);
            return this.applyOfflineFallback();
        }
        return this.applyPayload(payload.get(), true);
    }

    public String getStatusSummary() {
        QuestoryConfig cfg = QuestoryConfig.getInstance();
        return "Daily {enabled=" + cfg.dailyEnable + ", id=" + (this.currentDailyId == null ? "" : this.currentDailyId) + ", url=" + cfg.dailyRemoteUrl + ", lastFetchMs=" + this.lastFetchMillis + "}";
    }

    public void setEnabled(boolean enabled) {
        QuestoryConfig cfg = QuestoryConfig.getInstance();
        cfg.dailyEnable = enabled;
        QuestoryConfig.save(Questory.getConfigPath());
        if (enabled) {
            this.reload();
            this.scheduleNextInterval();
        }
    }

    public void setRemoteUrl(String url) {
        QuestoryConfig cfg = QuestoryConfig.getInstance();
        cfg.dailyRemoteUrl = url == null ? "" : url.trim();
        QuestoryConfig.save(Questory.getConfigPath());
    }

    public void onQuestCompleted(ServerPlayer player, Quest quest) {
        try {
            String mode;
            boolean isDaily;
            if (quest == null) {
                return;
            }
            QuestoryConfig cfg = QuestoryConfig.getInstance();
            if (!cfg.dailyEnable) {
                return;
            }
            boolean bl = isDaily = quest.getTags().contains(cfg.dailyTagKey) || quest.getId() != null && quest.getId().startsWith(cfg.dailyPrefixQuestIds);
            if (!isDaily) {
                return;
            }
            QuestProgress pm = this.questManager.getProgress(player.m_20148_());
            if (pm.hasCompletedDaily(this.currentDailyId)) {
                return;
            }
            int completed = 0;
            int total = 0;
            for (Quest q : this.questManager.getAllQuests()) {
                boolean qDaily;
                boolean bl2 = qDaily = q.getTags().contains(cfg.dailyTagKey) || q.getId() != null && q.getId().startsWith(cfg.dailyPrefixQuestIds + this.currentDailyId + "_");
                if (!qDaily) continue;
                ++total;
                if (!pm.isQuestCompleted(q.getId())) continue;
                ++completed;
            }
            int minRequired = this.currentMinQuestsToComplete >= 0 ? this.currentMinQuestsToComplete : cfg.dailyMinQuestsToComplete;
            String string = mode = this.currentCompletionMode != null && !this.currentCompletionMode.isBlank() ? this.currentCompletionMode : cfg.dailyCompletionMode;
            int required = minRequired > 0 ? Math.min(minRequired, total) : ("ANY".equalsIgnoreCase(mode) ? 1 : total);
            if (completed >= required && total > 0) {
                pm.markDailyCompleted(this.currentDailyId);
                this.questManager.saveAll();
                player.m_213846_((Component)Component.m_237113_((String)("Daily completed: " + this.currentDailyId + " (" + completed + "/" + total + ")")).m_130940_(ChatFormatting.GOLD));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onServerTick() {
        this.onServerTick(null);
    }

    private Optional<JsonObject> fetchRemote(QuestoryConfig cfg) {
        if (cfg.dailyRemoteUrl == null || cfg.dailyRemoteUrl.isBlank()) {
            return Optional.empty();
        }
        HttpClient client = HttpClient.newBuilder().connectTimeout(Duration.ofMillis(Math.max(1000, cfg.dailyHttpTimeoutMs))).build();
        ArrayList<String> urls = new ArrayList<String>();
        urls.add(cfg.dailyRemoteUrl);
        if (cfg.dailyBackupUrls != null) {
            urls.addAll(cfg.dailyBackupUrls);
        }
        Throwable lastEx = null;
        int attempts = Math.max(1, cfg.dailyRetryCount + 1);
        for (String url : urls) {
            for (int i = 0; i < attempts; ++i) {
                try {
                    HttpRequest req = HttpRequest.newBuilder(URI.create(url)).timeout(Duration.ofMillis(Math.max(1000, cfg.dailyHttpTimeoutMs))).header("Accept", "application/json").GET().build();
                    HttpResponse<String> resp = client.send(req, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
                    if (resp.statusCode() < 200 || resp.statusCode() >= 300) continue;
                    JsonObject root = JsonParser.parseString((String)resp.body()).getAsJsonObject();
                    return Optional.of(root);
                }
                catch (Exception e) {
                    lastEx = e;
                }
            }
        }
        if (lastEx != null) {
            lastEx.printStackTrace();
        }
        return Optional.empty();
    }

    private boolean applyOfflineFallback() {
        QuestoryConfig cfg = QuestoryConfig.getInstance();
        String mode = String.valueOf(cfg.dailyOfflineFallback).toLowerCase();
        try {
            Path current = this.dailyDir.resolve("current.json");
            if (mode.equals("use_cache") && Files.exists(current, new LinkOption[0])) {
                long ttlMs;
                long ageMs;
                if (cfg.dailyCacheTtlMinutes > 0 && (ageMs = System.currentTimeMillis() - Files.getLastModifiedTime(current, new LinkOption[0]).toMillis()) > (ttlMs = (long)cfg.dailyCacheTtlMinutes * 60000L)) {
                    System.err.println("[Questory] Cached daily expired");
                    return false;
                }
                String s = Files.readString(current);
                JsonObject json = JsonParser.parseString((String)s).getAsJsonObject();
                boolean ok = this.applyPayload(json, false);
                if (ok) {
                    this.scheduleNextInterval();
                }
                return ok;
            }
            if (mode.equals("keep_previous")) {
                System.out.println("[Questory] Keeping previous daily quests active");
                return true;
            }
        }
        catch (Exception e) {
            System.err.println("[Questory] Offline fallback failed: " + e.getMessage());
        }
        return false;
    }

    private boolean applyPayload(JsonObject payload, boolean writeCache) {
        try {
            if (payload == null) {
                return false;
            }
            if (!payload.has("daily_id")) {
                System.err.println("[Questory] Daily payload missing 'daily_id'");
                return false;
            }
            String dailyId = payload.get("daily_id").getAsString();
            if (Objects.equals(dailyId, this.currentDailyId)) {
                System.out.println("[Questory] Daily already applied: " + dailyId);
                return true;
            }
            this.unregisterPreviousDaily();
            QuestoryConfig cfg = QuestoryConfig.getInstance();
            String groupName = payload.has("group") && !payload.get("group").getAsString().isBlank() ? payload.get("group").getAsString() : cfg.dailyGroupName;
            this.currentTitle = payload.has("title") ? payload.get("title").getAsString() : "";
            this.currentValidFrom = payload.has("valid_from") ? payload.get("valid_from").getAsString() : "";
            this.currentValidUntil = payload.has("valid_until") ? payload.get("valid_until").getAsString() : "";
            this.currentRolloverTz = payload.has("rollover_tz") ? payload.get("rollover_tz").getAsString() : "";
            this.currentCompletionMode = cfg.dailyCompletionMode;
            this.currentMinQuestsToComplete = cfg.dailyMinQuestsToComplete;
            if (payload.has("completionMode") && !payload.get("completionMode").getAsString().isBlank()) {
                this.currentCompletionMode = payload.get("completionMode").getAsString();
            }
            if (payload.has("minQuestsToComplete")) {
                try {
                    this.currentMinQuestsToComplete = Math.max(0, payload.get("minQuestsToComplete").getAsInt());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            int applied = 0;
            if (payload.has("quests")) {
                JsonArray arr = payload.getAsJsonArray("quests");
                int limit = cfg.dailyMaxActiveQuests > 0 ? Math.min(cfg.dailyMaxActiveQuests, arr.size()) : arr.size();
                for (int i = 0; i < limit; ++i) {
                    JsonArray tags;
                    JsonObject qj = arr.get(i).getAsJsonObject();
                    String localId = qj.has("id") ? qj.get("id").getAsString() : "q" + i;
                    String finalId = cfg.dailyPrefixQuestIds + dailyId + "_" + localId;
                    qj.addProperty("id", finalId);
                    if (!qj.has("group") || qj.get("group").getAsString().isBlank()) {
                        qj.addProperty("group", groupName);
                    }
                    if (qj.has("tags") && qj.get("tags").isJsonArray()) {
                        tags = qj.get("tags").getAsJsonArray();
                    } else {
                        tags = new JsonArray();
                        qj.add("tags", (JsonElement)tags);
                    }
                    tags.add(cfg.dailyTagKey);
                    Quest quest = Quest.fromJson(qj);
                    quest.addTag(cfg.dailyTagKey);
                    quest.setGroup(groupName);
                    this.questManager.registerQuest(quest);
                    ++applied;
                }
            }
            this.currentDailyId = dailyId;
            this.lastFetchMillis = System.currentTimeMillis();
            this.scheduleNextInterval();
            this.updateRolloverMarker();
            if (writeCache) {
                try {
                    Files.writeString(this.dailyDir.resolve("current.json"), (CharSequence)payload.toString(), new OpenOption[0]);
                    Files.writeString(this.dailyHistoryDir.resolve(dailyId + ".json"), (CharSequence)payload.toString(), new OpenOption[0]);
                }
                catch (IOException e) {
                    System.err.println("[Questory] Failed to save daily cache: " + e.getMessage());
                }
            }
            System.out.println("[Questory] Applied daily " + dailyId + " with " + applied + " quests");
            return true;
        }
        catch (Exception e) {
            System.err.println("[Questory] Failed to apply daily payload: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    private void unregisterPreviousDaily() {
        try {
            QuestoryConfig cfg = QuestoryConfig.getInstance();
            List toRemove = this.questManager.getAllQuests().stream().filter(q -> q.getTags().contains(cfg.dailyTagKey)).collect(Collectors.toList());
            for (Quest q2 : toRemove) {
                this.questManager.unregisterQuest(q2.getId());
            }
            if (!toRemove.isEmpty()) {
                System.out.println("[Questory] Unregistered " + toRemove.size() + " previous daily quests");
            }
        }
        catch (Exception e) {
            System.err.println("[Questory] Failed to unregister previous dailies: " + e.getMessage());
        }
    }

    public String getCurrentDailyId() {
        return this.currentDailyId;
    }

    public ZoneId getConfiguredZone() {
        try {
            String tz = QuestoryConfig.getInstance().dailyTimeZone;
            return ZoneId.of(tz == null || tz.isBlank() ? "UTC" : tz);
        }
        catch (Exception e) {
            return ZoneId.of("UTC");
        }
    }

    public void onServerTick(MinecraftServer server) {
        QuestoryConfig cfg = QuestoryConfig.getInstance();
        if (!cfg.dailyEnable) {
            return;
        }
        long now = System.currentTimeMillis();
        if (cfg.dailyFetchIntervalMinutes > 0 && now >= this.nextIntervalCheckMs) {
            String before = this.currentDailyId;
            this.reload();
            this.scheduleNextInterval();
            if (server != null && !DailyQuestManager.isEmpty(this.currentDailyId) && !this.currentDailyId.equals(before)) {
                for (ServerPlayer sp : server.m_6846_().m_11314_()) {
                    this.questManager.onPlayerJoin(sp);
                }
                this.lastBroadcastDailyId = this.currentDailyId;
            }
        }
        try {
            ZonedDateTime roll;
            ZoneId zone = this.getConfiguredZone();
            int hour = Math.max(0, Math.min(23, cfg.dailyRolloverHour));
            ZonedDateTime nowZ = ZonedDateTime.now(zone);
            String today = nowZ.toLocalDate().toString();
            if (!today.equals(this.lastRolloverProcessedDate) && (nowZ.isAfter(roll = nowZ.withHour(hour).withMinute(0).withSecond(0).withNano(0)) || nowZ.isEqual(roll))) {
                String before = this.currentDailyId;
                this.reload();
                this.lastRolloverProcessedDate = today;
                this.scheduleNextInterval();
                if (server != null && !DailyQuestManager.isEmpty(this.currentDailyId) && !this.currentDailyId.equals(before)) {
                    for (ServerPlayer sp : server.m_6846_().m_11314_()) {
                        this.questManager.onPlayerJoin(sp);
                    }
                    this.lastBroadcastDailyId = this.currentDailyId;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void scheduleNextInterval() {
        QuestoryConfig cfg = QuestoryConfig.getInstance();
        if (cfg.dailyFetchIntervalMinutes > 0) {
            this.nextIntervalCheckMs = System.currentTimeMillis() + (long)cfg.dailyFetchIntervalMinutes * 60000L;
        }
    }

    private void updateRolloverMarker() {
        try {
            String today;
            ZoneId zone = this.getConfiguredZone();
            this.lastRolloverProcessedDate = today = ZonedDateTime.now(zone).toLocalDate().toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getCurrentTitle() {
        return this.currentTitle;
    }

    public String getCurrentValidFrom() {
        return this.currentValidFrom;
    }

    public String getCurrentValidUntil() {
        return this.currentValidUntil;
    }

    public String getCurrentRolloverTz() {
        if (this.currentRolloverTz != null && !this.currentRolloverTz.isBlank()) {
            return this.currentRolloverTz;
        }
        return QuestoryConfig.getInstance().dailyTimeZone;
    }

    public void broadcastDailyMeta(MinecraftServer server) {
        if (server == null) {
            return;
        }
        QuestoryConfig cfg = QuestoryConfig.getInstance();
        if (!cfg.dailyEnable) {
            return;
        }
        DailyDataSyncPacket packet = new DailyDataSyncPacket(this.getCurrentDailyId(), this.getCurrentTitle(), this.getCurrentValidFrom(), this.getCurrentValidUntil(), this.getCurrentRolloverTz());
        for (ServerPlayer sp : server.m_6846_().m_11314_()) {
            NetworkManager.sendToClient(sp, packet);
        }
    }

    private static boolean isEmpty(String s) {
        return s == null || s.isBlank();
    }
}

