/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.network;

import dev.architectury.networking.NetworkChannel;
import dev.architectury.networking.NetworkManager;
import dev.architectury.utils.Env;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.texboobcat.questory.network.ChapterDataSyncPacket;
import org.texboobcat.questory.network.ChapterDataUpdateRequestPacket;
import org.texboobcat.questory.network.ConfigSyncPacket;
import org.texboobcat.questory.network.DailyDataSyncPacket;
import org.texboobcat.questory.network.GroupTreeSyncPacket;
import org.texboobcat.questory.network.OpenGuiPacket;
import org.texboobcat.questory.network.ProgressSyncPacket;
import org.texboobcat.questory.network.QuestCompleteRequestPacket;
import org.texboobcat.questory.network.QuestCreateRequestPacket;
import org.texboobcat.questory.network.QuestDeleteRequestPacket;
import org.texboobcat.questory.network.QuestPositionUpdatePacket;
import org.texboobcat.questory.network.QuestSyncPacket;
import org.texboobcat.questory.network.QuestUpdateRequestPacket;
import org.texboobcat.questory.network.RequirementCompletePacket;
import org.texboobcat.questory.network.TeamActionPacket;
import org.texboobcat.questory.network.TeamCreatePacket;
import org.texboobcat.questory.network.TeamSettingsPacket;
import org.texboobcat.questory.network.TeamSyncPacket;

public class NetworkManager {
    public static final ResourceLocation QUEST_SYNC_PACKET = new ResourceLocation("questory", "quest_sync");
    public static final ResourceLocation PROGRESS_SYNC_PACKET = new ResourceLocation("questory", "progress_sync");
    public static final ResourceLocation CHAPTER_DATA_SYNC_PACKET = new ResourceLocation("questory", "chapter_data_sync");
    public static final ResourceLocation GROUP_TREE_SYNC_PACKET = new ResourceLocation("questory", "group_tree_sync");
    public static final ResourceLocation DAILY_DATA_SYNC_PACKET = new ResourceLocation("questory", "daily_data_sync");
    public static final ResourceLocation QUEST_COMPLETE_PACKET = new ResourceLocation("questory", "quest_complete");
    public static final ResourceLocation OPEN_GUI_PACKET = new ResourceLocation("questory", "open_gui");
    public static final ResourceLocation CONFIG_SYNC_PACKET = new ResourceLocation("questory", "config_sync");
    private static final NetworkChannel CHANNEL = NetworkChannel.create((ResourceLocation)new ResourceLocation("questory", "main"));

    public static void init() {
        CHANNEL.register(QuestSyncPacket.class, QuestSyncPacket::encode, QuestSyncPacket::decode, NetworkManager::handleQuestSync);
        CHANNEL.register(ProgressSyncPacket.class, ProgressSyncPacket::encode, ProgressSyncPacket::decode, NetworkManager::handleProgressSync);
        CHANNEL.register(ChapterDataSyncPacket.class, ChapterDataSyncPacket::encode, ChapterDataSyncPacket::decode, NetworkManager::handleChapterDataSync);
        CHANNEL.register(GroupTreeSyncPacket.class, GroupTreeSyncPacket::encode, GroupTreeSyncPacket::decode, NetworkManager::handleGroupTreeSync);
        CHANNEL.register(DailyDataSyncPacket.class, DailyDataSyncPacket::encode, DailyDataSyncPacket::decode, NetworkManager::handleDailyDataSync);
        CHANNEL.register(ConfigSyncPacket.class, ConfigSyncPacket::encode, ConfigSyncPacket::decode, NetworkManager::handleConfigSync);
        CHANNEL.register(OpenGuiPacket.class, OpenGuiPacket::encode, OpenGuiPacket::decode, NetworkManager::handleOpenGui);
        CHANNEL.register(QuestCompleteRequestPacket.class, QuestCompleteRequestPacket::encode, QuestCompleteRequestPacket::decode, NetworkManager::handleQuestCompleteRequest);
        CHANNEL.register(RequirementCompletePacket.class, RequirementCompletePacket::encode, RequirementCompletePacket::decode, NetworkManager::handleRequirementComplete);
        CHANNEL.register(QuestPositionUpdatePacket.class, QuestPositionUpdatePacket::encode, QuestPositionUpdatePacket::decode, NetworkManager::handleQuestPositionUpdate);
        CHANNEL.register(QuestCreateRequestPacket.class, QuestCreateRequestPacket::encode, QuestCreateRequestPacket::decode, NetworkManager::handleQuestCreateRequest);
        CHANNEL.register(QuestUpdateRequestPacket.class, QuestUpdateRequestPacket::encode, QuestUpdateRequestPacket::decode, NetworkManager::handleQuestUpdateRequest);
        CHANNEL.register(QuestDeleteRequestPacket.class, QuestDeleteRequestPacket::encode, QuestDeleteRequestPacket::decode, NetworkManager::handleQuestDeleteRequest);
        CHANNEL.register(ChapterDataUpdateRequestPacket.class, ChapterDataUpdateRequestPacket::encode, ChapterDataUpdateRequestPacket::decode, NetworkManager::handleChapterDataUpdateRequest);
        CHANNEL.register(TeamSyncPacket.class, TeamSyncPacket::encode, TeamSyncPacket::decode, NetworkManager::handleTeamSync);
        CHANNEL.register(TeamCreatePacket.class, TeamCreatePacket::encode, TeamCreatePacket::decode, NetworkManager::handleTeamCreate);
        CHANNEL.register(TeamActionPacket.class, TeamActionPacket::encode, TeamActionPacket::decode, NetworkManager::handleTeamAction);
        CHANNEL.register(TeamSettingsPacket.class, TeamSettingsPacket::encode, TeamSettingsPacket::decode, NetworkManager::handleTeamSettings);
        System.out.println("[Questory] Network handlers registered");
    }

    private static void handleGroupTreeSync(GroupTreeSyncPacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> {
            if (context.getEnvironment() == Env.CLIENT) {
                packet.handle();
            }
        });
    }

    private static void handleChapterDataSync(ChapterDataSyncPacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> {
            if (context.getEnvironment() == Env.CLIENT) {
                packet.handle();
            }
        });
    }

    public static void sendToClient(ServerPlayer player, Object packet) {
        CHANNEL.sendToPlayer(player, packet);
    }

    public static void sendToServer(Object packet) {
        CHANNEL.sendToServer(packet);
    }

    private static void handleQuestSync(QuestSyncPacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> {
            if (context.getEnvironment() == Env.CLIENT) {
                packet.handle();
            }
        });
    }

    private static void handleProgressSync(ProgressSyncPacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> {
            if (context.getEnvironment() == Env.CLIENT) {
                packet.handle();
            }
        });
    }

    private static void handleOpenGui(OpenGuiPacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> {
            if (context.getEnvironment() == Env.CLIENT) {
                packet.handle();
            }
        });
    }

    private static void handleDailyDataSync(DailyDataSyncPacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> {
            if (context.getEnvironment() == Env.CLIENT) {
                packet.handle();
            }
        });
    }

    private static void handleConfigSync(ConfigSyncPacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(packet::handle);
    }

    private static void handleQuestCompleteRequest(QuestCompleteRequestPacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> {
            Player patt0$temp;
            if (context.getEnvironment() == Env.SERVER && (patt0$temp = context.getPlayer()) instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                packet.handle(player);
            }
        });
    }

    private static void handleRequirementComplete(RequirementCompletePacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> {
            Player patt0$temp;
            if (context.getEnvironment() == Env.SERVER && (patt0$temp = context.getPlayer()) instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                packet.handle(player);
            }
        });
    }

    private static void handleQuestPositionUpdate(QuestPositionUpdatePacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> {
            Player patt0$temp;
            if (context.getEnvironment() == Env.SERVER && (patt0$temp = context.getPlayer()) instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                packet.handle(player);
            }
        });
    }

    private static void handleQuestCreateRequest(QuestCreateRequestPacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> {
            Player patt0$temp;
            if (context.getEnvironment() == Env.SERVER && (patt0$temp = context.getPlayer()) instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                packet.handle(player);
            }
        });
    }

    private static void handleQuestUpdateRequest(QuestUpdateRequestPacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> {
            Player patt0$temp;
            if (context.getEnvironment() == Env.SERVER && (patt0$temp = context.getPlayer()) instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                packet.handle(player);
            }
        });
    }

    private static void handleQuestDeleteRequest(QuestDeleteRequestPacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> {
            Player patt0$temp;
            if (context.getEnvironment() == Env.SERVER && (patt0$temp = context.getPlayer()) instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                packet.handle(player);
            }
        });
    }

    private static void handleChapterDataUpdateRequest(ChapterDataUpdateRequestPacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> {
            Player patt0$temp;
            if (context.getEnvironment() == Env.SERVER && (patt0$temp = context.getPlayer()) instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                packet.handle(player);
            }
        });
    }

    private static void handleTeamSync(TeamSyncPacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> {
            if (context.getEnvironment() == Env.CLIENT) {
                packet.handle();
            }
        });
    }

    private static void handleTeamCreate(TeamCreatePacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> {
            Player patt0$temp;
            if (context.getEnvironment() == Env.SERVER && (patt0$temp = context.getPlayer()) instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                packet.handle(player);
            }
        });
    }

    private static void handleTeamAction(TeamActionPacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> {
            Player patt0$temp;
            if (context.getEnvironment() == Env.SERVER && (patt0$temp = context.getPlayer()) instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                packet.handle(player);
            }
        });
    }

    private static void handleTeamSettings(TeamSettingsPacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> {
            Player patt0$temp;
            if (context.getEnvironment() == Env.SERVER && (patt0$temp = context.getPlayer()) instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                packet.handle(player);
            }
        });
    }
}

