/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.quest;

import com.google.gson.JsonObject;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.quest.Requirement;

public class CurrencyRequirement
extends Requirement {
    private String currencyId;
    private long amount;

    public CurrencyRequirement(String currencyId, long amount) {
        super("currency_req");
        this.currencyId = currencyId;
        this.amount = amount;
    }

    public String getCurrencyId() {
        return this.currencyId;
    }

    public long getAmount() {
        return this.amount;
    }

    public void setCurrencyId(String currencyId) {
        this.currencyId = currencyId;
    }

    public void setAmount(long amount) {
        this.amount = amount;
    }

    @Override
    public boolean isMet(QuestProgress progress, String questId) {
        return (long)progress.getRequirementProgress(questId, this) >= this.amount;
    }

    @Override
    public String getProgressDisplay(QuestProgress progress, String questId) {
        long current = progress.getRequirementProgress(questId, this);
        return current + "/" + this.amount + " " + this.currencyId;
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", "currency_req");
        json.addProperty("currency", this.currencyId);
        json.addProperty("amount", (Number)this.amount);
        return json;
    }

    public static CurrencyRequirement fromJson(JsonObject json) {
        String currency = json.get("currency").getAsString();
        long amount = json.get("amount").getAsLong();
        return new CurrencyRequirement(currency, amount);
    }
}

