/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.team;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.team.TeamProgressMode;
import org.texboobcat.questory.team.TeamRewardMode;

public class QuestTeam {
    private final UUID teamId;
    private String teamName;
    private UUID owner;
    private final Set<UUID> members;
    private final Map<String, QuestProgress> sharedProgress;
    private TeamSettings settings;
    private final long createdTime;

    public QuestTeam(UUID teamId, String teamName, UUID owner) {
        this.teamId = teamId;
        this.teamName = teamName;
        this.owner = owner;
        this.members = new HashSet<UUID>();
        this.members.add(owner);
        this.sharedProgress = new HashMap<String, QuestProgress>();
        this.settings = new TeamSettings();
        this.createdTime = System.currentTimeMillis();
    }

    public UUID getTeamId() {
        return this.teamId;
    }

    public String getTeamName() {
        return this.teamName;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public Set<UUID> getMembers() {
        return new HashSet<UUID>(this.members);
    }

    public TeamSettings getSettings() {
        return this.settings;
    }

    public long getCreatedTime() {
        return this.createdTime;
    }

    public void setTeamName(String name) {
        this.teamName = name;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    public boolean addMember(UUID playerId) {
        return this.members.add(playerId);
    }

    public boolean removeMember(UUID playerId) {
        if (playerId.equals(this.owner)) {
            return false;
        }
        return this.members.remove(playerId);
    }

    public boolean isMember(UUID playerId) {
        return this.members.contains(playerId);
    }

    public boolean isOwner(UUID playerId) {
        return this.owner.equals(playerId);
    }

    public int getMemberCount() {
        return this.members.size();
    }

    public QuestProgress getSharedProgress(String questId) {
        return this.sharedProgress.get(questId);
    }

    public void setSharedProgress(String questId, QuestProgress progress) {
        this.sharedProgress.put(questId, progress);
    }

    public Map<String, QuestProgress> getAllSharedProgress() {
        return new HashMap<String, QuestProgress>(this.sharedProgress);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("teamId", this.teamId.toString());
        json.addProperty("teamName", this.teamName);
        json.addProperty("owner", this.owner.toString());
        json.addProperty("createdTime", (Number)this.createdTime);
        JsonArray membersArray = new JsonArray();
        for (UUID member : this.members) {
            membersArray.add(member.toString());
        }
        json.add("members", (JsonElement)membersArray);
        json.add("settings", (JsonElement)this.settings.toJson());
        JsonObject progressObj = new JsonObject();
        for (Map.Entry<String, QuestProgress> entry : this.sharedProgress.entrySet()) {
            progressObj.add(entry.getKey(), (JsonElement)entry.getValue().toJson());
        }
        json.add("sharedProgress", (JsonElement)progressObj);
        return json;
    }

    public static QuestTeam fromJson(JsonObject json) {
        UUID teamId = UUID.fromString(json.get("teamId").getAsString());
        String teamName = json.get("teamName").getAsString();
        UUID owner = UUID.fromString(json.get("owner").getAsString());
        QuestTeam team = new QuestTeam(teamId, teamName, owner);
        if (json.has("members")) {
            JsonArray membersArray = json.getAsJsonArray("members");
            team.members.clear();
            for (JsonElement element : membersArray) {
                team.members.add(UUID.fromString(element.getAsString()));
            }
        }
        if (json.has("settings")) {
            team.settings = TeamSettings.fromJson(json.getAsJsonObject("settings"));
        }
        if (json.has("sharedProgress")) {
            JsonObject progressObj = json.getAsJsonObject("sharedProgress");
            for (Map.Entry entry : progressObj.entrySet()) {
                QuestProgress progress = QuestProgress.fromJson(((JsonElement)entry.getValue()).getAsJsonObject());
                team.sharedProgress.put((String)entry.getKey(), progress);
            }
        }
        return team;
    }

    public static class TeamSettings {
        private TeamProgressMode defaultProgressMode = TeamProgressMode.SHARED;
        private TeamRewardMode defaultRewardMode = TeamRewardMode.SHARED;
        private boolean autoAcceptInvites = false;
        private int maxMembers = 10;

        public TeamProgressMode getDefaultProgressMode() {
            return this.defaultProgressMode;
        }

        public TeamRewardMode getDefaultRewardMode() {
            return this.defaultRewardMode;
        }

        public boolean isAutoAcceptInvites() {
            return this.autoAcceptInvites;
        }

        public int getMaxMembers() {
            return this.maxMembers;
        }

        public void setDefaultProgressMode(TeamProgressMode mode) {
            this.defaultProgressMode = mode;
        }

        public void setDefaultRewardMode(TeamRewardMode mode) {
            this.defaultRewardMode = mode;
        }

        public void setAutoAcceptInvites(boolean auto) {
            this.autoAcceptInvites = auto;
        }

        public void setMaxMembers(int max) {
            this.maxMembers = Math.max(1, Math.min(max, 100));
        }

        public JsonObject toJson() {
            JsonObject json = new JsonObject();
            json.addProperty("defaultProgressMode", this.defaultProgressMode.name());
            json.addProperty("defaultRewardMode", this.defaultRewardMode.name());
            json.addProperty("autoAcceptInvites", Boolean.valueOf(this.autoAcceptInvites));
            json.addProperty("maxMembers", (Number)this.maxMembers);
            return json;
        }

        public static TeamSettings fromJson(JsonObject json) {
            TeamSettings settings = new TeamSettings();
            if (json.has("defaultProgressMode")) {
                try {
                    settings.defaultProgressMode = TeamProgressMode.valueOf(json.get("defaultProgressMode").getAsString());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (json.has("defaultRewardMode")) {
                try {
                    settings.defaultRewardMode = TeamRewardMode.valueOf(json.get("defaultRewardMode").getAsString());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (json.has("autoAcceptInvites")) {
                settings.autoAcceptInvites = json.get("autoAcceptInvites").getAsBoolean();
            }
            if (json.has("maxMembers")) {
                settings.maxMembers = json.get("maxMembers").getAsInt();
            }
            return settings;
        }
    }
}

