/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import org.texboobcat.questory.client.gui.FormattedTextWithImages;

public class ImageRenderer {
    public static int renderImage(GuiGraphics graphics, FormattedTextWithImages.ImageElement imageElement, int x, int y, int maxWidth) {
        ResourceLocation texture = imageElement.getResourceLocation();
        if (texture == null) {
            return 0;
        }
        int width = imageElement.getWidth();
        int height = imageElement.getHeight();
        int renderX = x;
        String align = imageElement.getAlign();
        if ("center".equals(align)) {
            renderX = x + (maxWidth - width) / 2;
        } else if ("right".equals(align)) {
            renderX = x + maxWidth - width;
        }
        try {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
            RenderSystem.enableBlend();
            graphics.m_280163_(texture, renderX, y, 0.0f, 0.0f, width, height, width, height);
            RenderSystem.disableBlend();
        }
        catch (Exception e) {
            return 0;
        }
        return height;
    }

    public static int renderAllImages(GuiGraphics graphics, FormattedTextWithImages formatted, int x, int startY, int maxWidth, int lineHeight) {
        if (!formatted.hasImages()) {
            return 0;
        }
        int totalImageHeight = 0;
        boolean currentLine = false;
        int currentY = startY;
        for (FormattedTextWithImages.ImageElement image : formatted.getImages()) {
            int imageY = startY + image.getLineIndex() * lineHeight + totalImageHeight;
            int imageHeight = ImageRenderer.renderImage(graphics, image, x, imageY, maxWidth);
            totalImageHeight += imageHeight;
            if (imageHeight <= 0) continue;
            totalImageHeight += 4;
        }
        return totalImageHeight;
    }
}

