/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.texboobcat.questory.client.ClientConfig;
import org.texboobcat.questory.client.ClientQuestManager;
import org.texboobcat.questory.client.gui.QuestIconRenderer;
import org.texboobcat.questory.client.gui.TextFormatter;
import org.texboobcat.questory.config.QuestoryConfig;
import org.texboobcat.questory.quest.Quest;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.quest.Requirement;

public class QuestHudOverlay {
    private static final int MAX_TRACKED_QUESTS = 5;
    private static final int PANEL_WIDTH = 240;
    private static final int COMPACT_PANEL_WIDTH = 200;
    private static final int ICON_SIZE = 16;
    private static final int COMPACT_ICON_SIZE = 12;
    private static final Map<String, Long> questAddTimes = new HashMap<String, Long>();
    private static final long FADE_IN_DURATION = 300L;

    public static void render(GuiGraphics graphics, float partialTick) {
        int startX;
        QuestoryConfig config = QuestoryConfig.getInstance();
        if (!config.showProgressPercentage && !config.useColoredMessages) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91066_.f_92063_) {
            return;
        }
        ClientQuestManager manager = ClientQuestManager.getInstance();
        QuestProgress progress = manager.getProgress();
        if (progress == null) {
            return;
        }
        Set<String> pinnedQuests = ClientConfig.getTrackedQuests();
        if (pinnedQuests.isEmpty()) {
            return;
        }
        String position = ClientConfig.getHudPosition();
        float scale = ClientConfig.getHudScale();
        boolean compact = ClientConfig.isHudCompactMode();
        int offsetX = ClientConfig.getHudOffsetX();
        int offsetY = ClientConfig.getHudOffsetY();
        int screenWidth = mc.m_91268_().m_85445_();
        int screenHeight = mc.m_91268_().m_85446_();
        int panelWidth = compact ? 200 : 240;
        int startY = switch (position) {
            case "TOP_RIGHT" -> {
                startX = screenWidth - panelWidth - offsetX;
                yield offsetY;
            }
            case "BOTTOM_LEFT" -> {
                startX = offsetX;
                yield screenHeight - offsetY;
            }
            case "BOTTOM_RIGHT" -> {
                startX = screenWidth - panelWidth - offsetX;
                yield screenHeight - offsetY;
            }
            default -> {
                startX = offsetX;
                yield offsetY;
            }
        };
        PoseStack pose = graphics.m_280168_();
        pose.m_85836_();
        if (position.contains("RIGHT")) {
            pose.m_252880_((float)(startX + panelWidth), (float)startY, 0.0f);
            pose.m_85841_(scale, scale, 1.0f);
            pose.m_252880_((float)(-(startX + panelWidth)), (float)(-startY), 0.0f);
        } else {
            pose.m_252880_((float)startX, (float)startY, 0.0f);
            pose.m_85841_(scale, scale, 1.0f);
            pose.m_252880_((float)(-startX), (float)(-startY), 0.0f);
        }
        ArrayList<String> toRemove = new ArrayList<String>();
        int rendered = 0;
        int currentY = startY;
        boolean bottomAnchored = position.contains("BOTTOM");
        ArrayList<Quest> questsToRender = new ArrayList<Quest>();
        for (String string : pinnedQuests) {
            if (rendered >= 5) break;
            Quest quest = manager.getQuest(string);
            if (quest == null || progress.isQuestCompleted(string)) {
                toRemove.add(string);
                continue;
            }
            questsToRender.add(quest);
            ++rendered;
        }
        if (bottomAnchored) {
            Collections.reverse(questsToRender);
            int totalHeight = 0;
            for (Quest q : questsToRender) {
                totalHeight += QuestHudOverlay.getQuestHeight(q, progress, compact) + 4;
            }
            currentY -= totalHeight;
        }
        for (Quest quest : questsToRender) {
            QuestHudOverlay.renderTrackedQuest(graphics, quest, progress, startX, currentY, panelWidth, compact);
            currentY += QuestHudOverlay.getQuestHeight(quest, progress, compact) + 4;
        }
        pose.m_85849_();
        for (String string : toRemove) {
            ClientConfig.setQuestTracked(string, false);
            questAddTimes.remove(string);
        }
    }

    private static void renderTrackedQuest(GuiGraphics graphics, Quest quest, QuestProgress progress, int x, int y, int width, boolean compact) {
        Minecraft mc = Minecraft.m_91087_();
        int height = QuestHudOverlay.getQuestHeight(quest, progress, compact);
        int opacity = ClientConfig.getHudOpacity();
        int alpha = (int)((float)opacity * 2.55f);
        float fadeAlpha = 1.0f;
        if (questAddTimes.containsKey(quest.getId())) {
            long elapsed = System.currentTimeMillis() - questAddTimes.get(quest.getId());
            if (elapsed < 300L) {
                fadeAlpha = (float)elapsed / 300.0f;
            }
        } else {
            questAddTimes.put(quest.getId(), System.currentTimeMillis());
        }
        int finalAlpha = (int)((float)alpha * fadeAlpha);
        int bgColor = finalAlpha << 24 | 0x1A1A1A;
        int borderColor = finalAlpha << 24 | 0x3A3A3A;
        graphics.m_280509_(x - 1, y - 1, x + width + 1, y + height + 1, borderColor);
        graphics.m_280509_(x, y, x + width, y + height, bgColor);
        int iconSize = compact ? 12 : 16;
        int padding = compact ? 4 : 6;
        int currentY = y + padding;
        if (ClientConfig.isHudShowIcons() && quest.getIcon() != null) {
            try {
                QuestIconRenderer.render(graphics, quest.getIcon(), x + padding, currentY, iconSize);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int titleX = ClientConfig.isHudShowIcons() ? x + padding + iconSize + 4 : x + padding;
        String rawTitle = quest.getTitle();
        Component formattedTitle = TextFormatter.parseToComponent(rawTitle);
        if (compact && mc.f_91062_.m_92852_((FormattedText)formattedTitle) > width - (titleX - x) - padding) {
            Object plainTitle = TextFormatter.stripTags(TextFormatter.convertMinecraftCodesToTags(rawTitle));
            plainTitle = mc.f_91062_.m_92834_((String)plainTitle, width - (titleX - x) - padding - 10) + "...";
            formattedTitle = Component.m_237113_((String)plainTitle);
        }
        graphics.m_280614_(mc.f_91062_, formattedTitle, titleX, currentY + (compact ? 2 : 4), 0xFFFFFF | finalAlpha << 24, true);
        currentY += iconSize + (compact ? 4 : 6);
        boolean showProgressBars = ClientConfig.isHudShowProgressBars();
        for (Requirement req : quest.getRequirements()) {
            Component formattedText;
            int availableWidth;
            boolean isMet = req.isMet(progress, quest.getId());
            String displayText = req.getProgressDisplay(progress, quest.getId());
            if (compact) {
                String prefix = isMet ? "\u2713" : "\u25cb";
                int color = isMet ? finalAlpha << 24 | 0x55FF55 : finalAlpha << 24 | 0xCCCCCC;
                availableWidth = width - padding * 2 - 4 - mc.f_91062_.m_92895_(prefix + " ");
                formattedText = TextFormatter.parseToComponent(displayText);
                Object plainText = formattedText.getString();
                if (mc.f_91062_.m_92895_((String)plainText) > availableWidth) {
                    plainText = mc.f_91062_.m_92837_((String)plainText, availableWidth - 10, false) + "...";
                    formattedText = Component.m_237113_((String)plainText);
                }
                graphics.m_280488_(mc.f_91062_, prefix + " ", x + padding + 2, currentY, color);
                graphics.m_280430_(mc.f_91062_, formattedText, x + padding + 2 + mc.f_91062_.m_92895_(prefix + " "), currentY, color);
                currentY += 10;
                continue;
            }
            int baseColor = isMet ? 0x55FF55 : 0xFFFFFF;
            String prefix = isMet ? "\u2713 " : "";
            availableWidth = width - padding * 2 - 4;
            formattedText = TextFormatter.parseToComponent(displayText);
            String plainForWrapping = prefix + formattedText.getString();
            List<String> lines = QuestHudOverlay.wrapText(mc, plainForWrapping, availableWidth, 2);
            for (String line : lines) {
                graphics.m_280488_(mc.f_91062_, line, x + padding + 2, currentY, finalAlpha << 24 | baseColor);
                currentY += 10;
            }
            if (showProgressBars && !isMet) {
                int current = progress.getRequirementProgress(quest.getId(), req);
                int target = QuestHudOverlay.extractTargetFromDisplay(displayText);
                if (target > 0 && current < target) {
                    float progressPct = Math.min(1.0f, (float)current / (float)target);
                    int barWidth = width - padding * 2 - 4;
                    int barHeight = 3;
                    int barX = x + padding + 2;
                    int barY = currentY;
                    int barBg = finalAlpha << 24 | 0x333333;
                    graphics.m_280509_(barX, barY, barX + barWidth, barY + barHeight, barBg);
                    int fillWidth = (int)((float)barWidth * progressPct);
                    int progressColor = isMet ? finalAlpha << 24 | 0x55FF55 : finalAlpha << 24 | 0xFFAA00;
                    graphics.m_280509_(barX, barY, barX + fillWidth, barY + barHeight, progressColor);
                    currentY += barHeight + 2;
                }
            }
            currentY += 2;
        }
    }

    private static int getQuestHeight(Quest quest, QuestProgress progress, boolean compact) {
        int iconSize = compact ? 12 : 16;
        int padding = compact ? 4 : 6;
        int height = padding * 2 + iconSize + (compact ? 4 : 6);
        int panelWidth = compact ? 200 : 240;
        Minecraft mc = Minecraft.m_91087_();
        int reqCount = quest.getRequirements().size();
        if (compact) {
            height += reqCount * 10;
        } else {
            boolean showProgressBars = ClientConfig.isHudShowProgressBars();
            int availableWidth = panelWidth - padding * 2 - 4;
            for (Requirement req : quest.getRequirements()) {
                int target;
                String displayText = req.getProgressDisplay(progress, quest.getId());
                String prefix = req.isMet(progress, quest.getId()) ? "\u2713 " : "";
                List<String> lines = QuestHudOverlay.wrapText(mc, prefix + displayText, availableWidth, 2);
                height += lines.size() * 10;
                if (showProgressBars && !req.isMet(progress, quest.getId()) && (target = QuestHudOverlay.extractTargetFromDisplay(displayText)) > 0) {
                    height += 5;
                }
                height += 2;
            }
        }
        return height + 2;
    }

    private static String truncateText(Minecraft mc, String text, int maxWidth) {
        int progressWidth;
        int ellipsisWidth;
        int availableForText;
        if (mc.f_91062_.m_92895_(text) <= maxWidth) {
            return text;
        }
        String progressPattern = "\\d+/\\d+";
        Pattern pattern = Pattern.compile(progressPattern);
        Matcher matcher = pattern.matcher(text);
        Object progressPart = "";
        if (matcher.find()) {
            progressPart = " " + matcher.group();
        }
        if ((availableForText = maxWidth - (ellipsisWidth = mc.f_91062_.m_92895_("...")) - (progressWidth = mc.f_91062_.m_92895_((String)progressPart))) <= 0) {
            return ((String)progressPart).isEmpty() ? "..." : progressPart;
        }
        String mainText = text;
        if (!((String)progressPart).isEmpty()) {
            mainText = text.replace(((String)progressPart).trim(), "").trim();
        }
        String truncated = mc.f_91062_.m_92837_(mainText, availableForText, false).trim();
        return truncated + "..." + (String)progressPart;
    }

    private static List<String> wrapText(Minecraft mc, String text, int maxWidth, int maxLines) {
        ArrayList<String> lines = new ArrayList<String>();
        if (mc.f_91062_.m_92895_(text) <= maxWidth) {
            lines.add(text);
            return lines;
        }
        String[] words = text.split(" ");
        StringBuilder currentLine = new StringBuilder();
        for (String word : words) {
            String testLine;
            String string = testLine = currentLine.length() == 0 ? word : String.valueOf(currentLine) + " " + word;
            if (mc.f_91062_.m_92895_(testLine) <= maxWidth) {
                if (currentLine.length() > 0) {
                    currentLine.append(" ");
                }
                currentLine.append(word);
                continue;
            }
            if (currentLine.length() > 0) {
                lines.add(currentLine.toString());
                currentLine = new StringBuilder(word);
            } else {
                String truncated = mc.f_91062_.m_92837_(word, maxWidth - mc.f_91062_.m_92895_("..."), false);
                lines.add(truncated + "...");
            }
            if (lines.size() < maxLines - 1 || currentLine.length() <= 0) continue;
            StringBuilder remaining = new StringBuilder(currentLine.toString());
            for (int i = words.length - 1; i >= 0; --i) {
                if (remaining.toString().contains(words[i])) continue;
                String test = String.valueOf(remaining) + " " + words[i];
                if (mc.f_91062_.m_92895_(test) <= maxWidth) {
                    remaining.append(" ").append(words[i]);
                    continue;
                }
                remaining.append("...");
                break;
            }
            lines.add(remaining.toString());
            return lines;
        }
        if (currentLine.length() > 0) {
            lines.add(currentLine.toString());
        }
        return lines;
    }

    private static int extractTargetFromDisplay(String displayText) {
        if (displayText == null) {
            return 0;
        }
        int slashIndex = displayText.indexOf(47);
        if (slashIndex > 0 && slashIndex < displayText.length() - 1) {
            int endIndex;
            for (endIndex = slashIndex + 1; endIndex < displayText.length() && Character.isDigit(displayText.charAt(endIndex)); ++endIndex) {
            }
            if (endIndex > slashIndex + 1) {
                try {
                    return Integer.parseInt(displayText.substring(slashIndex + 1, endIndex));
                }
                catch (NumberFormatException e) {
                    return 0;
                }
            }
        }
        return 0;
    }

    public static void trackQuest(String questId) {
        ClientConfig.setQuestTracked(questId, true);
    }

    public static void untrackQuest(String questId) {
        ClientConfig.setQuestTracked(questId, false);
    }

    public static void clearTracked() {
        for (String questId : ClientConfig.getTrackedQuests()) {
            ClientConfig.setQuestTracked(questId, false);
        }
    }

    public static List<String> getTrackedQuests() {
        return new ArrayList<String>(ClientConfig.getTrackedQuests());
    }
}

