/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import dev.architectury.platform.Platform;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.questory.client.ClientTeamManager;
import org.texboobcat.questory.client.gui.TeamJoinScreen;
import org.texboobcat.questory.network.NetworkManager;
import org.texboobcat.questory.network.TeamCreatePacket;
import org.texboobcat.questory.team.QuestTeam;

public class TeamCreationScreen
extends Screen {
    private static final int WINDOW_WIDTH = 320;
    private int windowHeight;
    private static final int UI_MARGIN = 16;
    private static final int UI_FIELD_HEIGHT = 20;
    private final Screen parent;
    private int leftPos;
    private int topPos;
    private EditBox teamNameBox;
    private EditBox descriptionBox;
    private EditBox colorHexBox;
    private Button createButton;
    private Button cancelButton;
    private Button joinTeamButton;
    private String errorMessage = null;
    private boolean showFtbExtras = false;
    private int nameY;
    private int descY;
    private int colorY;

    public TeamCreationScreen(Screen parent) {
        super((Component)Component.m_237113_((String)"Create Team"));
        this.parent = parent;
    }

    private boolean isExtrasEnabled() {
        return Platform.isModLoaded((String)"ftbteams");
    }

    protected void m_7856_() {
        this.showFtbExtras = this.isExtrasEnabled();
        this.windowHeight = this.showFtbExtras ? 300 : 200;
        this.leftPos = (this.f_96543_ - 320) / 2;
        this.topPos = (this.f_96544_ - this.windowHeight) / 2;
        int margin = 16;
        int fieldWidth = 288;
        int fieldHeight = 20;
        int gap = 32;
        int labelOffset = 20;
        this.nameY = this.topPos + 62;
        this.teamNameBox = new EditBox(this.f_96547_, this.leftPos + 16, this.nameY, 288, 20, (Component)Component.m_237113_((String)"Team Name"));
        this.teamNameBox.m_94199_(32);
        this.teamNameBox.m_257771_((Component)Component.m_237113_((String)"Enter team name..."));
        this.teamNameBox.m_94151_(this::onNameChanged);
        this.m_7787_((GuiEventListener)this.teamNameBox);
        this.m_264313_((GuiEventListener)this.teamNameBox);
        if (this.showFtbExtras) {
            this.descY = this.nameY + 20 + 32;
            this.descriptionBox = new EditBox(this.f_96547_, this.leftPos + 16, this.descY, 288, 20, (Component)Component.m_237113_((String)"Description"));
            this.descriptionBox.m_94199_(120);
            this.descriptionBox.m_257771_((Component)Component.m_237113_((String)"Optional description..."));
            this.m_7787_((GuiEventListener)this.descriptionBox);
            this.colorY = this.descY + 20 + 32;
            this.colorHexBox = new EditBox(this.f_96547_, this.leftPos + 16, this.colorY, 288, 20, (Component)Component.m_237113_((String)"Color Hex"));
            this.colorHexBox.m_94199_(7);
            this.colorHexBox.m_257771_((Component)Component.m_237113_((String)"Optional color, e.g. #FF8800"));
            this.m_7787_((GuiEventListener)this.colorHexBox);
        } else {
            this.descriptionBox = null;
            this.colorHexBox = null;
            this.colorY = -1;
            this.descY = -1;
        }
        this.createButton = Button.m_253074_((Component)Component.m_237113_((String)"Create"), btn -> this.createTeam()).m_252987_(this.leftPos + 16, this.topPos + this.windowHeight - 48, 150, 22).m_253136_();
        this.m_142416_((GuiEventListener)this.createButton);
        this.createButton.f_93623_ = false;
        this.cancelButton = Button.m_253074_((Component)Component.m_237113_((String)"Cancel"), btn -> this.m_7379_()).m_252987_(this.leftPos + 320 - 166, this.topPos + this.windowHeight - 48, 150, 22).m_253136_();
        this.m_142416_((GuiEventListener)this.cancelButton);
        this.joinTeamButton = Button.m_253074_((Component)Component.m_237113_((String)"Join Team"), btn -> this.openJoinTeamScreen()).m_252987_(this.leftPos + 16, this.topPos + this.windowHeight - 80, 288, 22).m_253136_();
        this.m_142416_((GuiEventListener)this.joinTeamButton);
        this.updateJoinButtonState();
    }

    private void updateJoinButtonState() {
        ClientTeamManager clientMgr = ClientTeamManager.getInstance();
        boolean hasPendingInvites = clientMgr.hasPendingInvites();
        this.joinTeamButton.f_93623_ = true;
        if (hasPendingInvites) {
            int count;
            this.joinTeamButton.m_93666_((Component)Component.m_237113_((String)("Join Team (" + count + " invite" + ((count = clientMgr.getPendingInviteCount()) > 1 ? "s" : "") + ")")));
        }
    }

    private void openJoinTeamScreen() {
        this.f_96541_.m_91152_((Screen)new TeamJoinScreen(this.parent));
    }

    private void onNameChanged(String name) {
        this.errorMessage = null;
        if (name.length() < 3) {
            this.createButton.f_93623_ = false;
            if (name.length() > 0) {
                this.errorMessage = "Name too short (min 3)";
            }
        } else if (name.length() > 32) {
            this.createButton.f_93623_ = false;
            this.errorMessage = "Name too long (max 32)";
        } else if (!name.matches("[a-zA-Z0-9 _-]+")) {
            this.createButton.f_93623_ = false;
            this.errorMessage = "Invalid characters";
        } else {
            this.createButton.f_93623_ = true;
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        graphics.m_280509_(this.leftPos, this.topPos, this.leftPos + 320, this.topPos + this.windowHeight, -872415232);
        graphics.m_280509_(this.leftPos, this.topPos, this.leftPos + 320, this.topPos + 25, -14540254);
        int titleWidth = this.f_96547_.m_92895_("Create New Team");
        graphics.m_280488_(this.f_96547_, "Create New Team", this.leftPos + (320 - titleWidth) / 2, this.topPos + 8, 0xFFFFFF);
        int labelOffset = 16;
        graphics.m_280488_(this.f_96547_, "Team Name:", this.leftPos + 16, this.nameY - 16, 0xFFFFFF);
        if (this.showFtbExtras) {
            int headerY = this.descY - 22;
            graphics.m_280488_(this.f_96547_, "\u00a77Optional settings", this.leftPos + 16, headerY, 0xAAAAAA);
        }
        int lastFieldBottom = this.showFtbExtras ? this.colorY + 20 : this.nameY + 20;
        int hintY = lastFieldBottom + 22;
        if (this.errorMessage == null) {
            graphics.m_280488_(this.f_96547_, "\u00a77(3-32 characters)", this.leftPos + 16, hintY, 0x888888);
        } else {
            graphics.m_280488_(this.f_96547_, "\u00a7c" + this.errorMessage, this.leftPos + 16, hintY, 0xFF5555);
        }
        this.teamNameBox.m_88315_(graphics, mouseX, mouseY, partialTick);
        if (this.showFtbExtras && this.descriptionBox != null) {
            this.descriptionBox.m_88315_(graphics, mouseX, mouseY, partialTick);
        }
        if (this.showFtbExtras && this.colorHexBox != null) {
            this.colorHexBox.m_88315_(graphics, mouseX, mouseY, partialTick);
        }
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
    }

    private void createTeam() {
        String colorStr;
        String teamName = this.teamNameBox.m_94155_().trim();
        String description = this.showFtbExtras && this.descriptionBox != null ? this.descriptionBox.m_94155_().trim() : "";
        String string = colorStr = this.showFtbExtras && this.colorHexBox != null ? this.colorHexBox.m_94155_().trim() : "";
        if (teamName.length() >= 3 && teamName.length() <= 32) {
            Integer colorRGB = null;
            if (this.showFtbExtras && !colorStr.isEmpty()) {
                try {
                    String s;
                    String string2 = s = colorStr.startsWith("#") ? colorStr.substring(1) : colorStr;
                    if (s.length() != 6) {
                        this.errorMessage = "Invalid color (use #RRGGBB)";
                        return;
                    }
                    int rgb = Integer.parseInt(s, 16);
                    colorRGB = rgb & 0xFFFFFF;
                }
                catch (Exception ex) {
                    this.errorMessage = "Invalid color (use #RRGGBB)";
                    return;
                }
            }
            TeamCreatePacket packet = new TeamCreatePacket(teamName, description.isEmpty() ? null : description, colorRGB);
            NetworkManager.sendToServer(packet);
            ClientTeamManager clientTeamMgr = ClientTeamManager.getInstance();
            QuestTeam tempTeam = new QuestTeam(UUID.randomUUID(), teamName, Minecraft.m_91087_().f_91074_.m_20148_());
            clientTeamMgr.setCurrentTeam(tempTeam);
            clientTeamMgr.setCurrentPlayerId(Minecraft.m_91087_().f_91074_.m_20148_());
            this.m_7379_();
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 257 && this.createButton.f_93623_) {
            this.createTeam();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    public boolean m_7043_() {
        return false;
    }
}

