/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.questory.network.NetworkManager;
import org.texboobcat.questory.network.TeamActionPacket;

public class TeamInviteDialog
extends Screen {
    private static final int WINDOW_WIDTH = 220;
    private static final int WINDOW_HEIGHT = 120;
    private final Screen parent;
    private int leftPos;
    private int topPos;
    private EditBox playerNameBox;
    private Button inviteButton;
    private Button cancelButton;
    private String errorMessage = null;

    public TeamInviteDialog(Screen parent) {
        super((Component)Component.m_237113_((String)"Invite Player"));
        this.parent = parent;
    }

    protected void m_7856_() {
        this.leftPos = (this.f_96543_ - 220) / 2;
        this.topPos = (this.f_96544_ - 120) / 2;
        this.playerNameBox = new EditBox(this.f_96547_, this.leftPos + 10, this.topPos + 45, 200, 20, (Component)Component.m_237113_((String)"Player Name"));
        this.playerNameBox.m_94199_(16);
        this.playerNameBox.m_257771_((Component)Component.m_237113_((String)"Enter player name..."));
        this.playerNameBox.m_94151_(this::onNameChanged);
        this.m_7787_((GuiEventListener)this.playerNameBox);
        this.m_264313_((GuiEventListener)this.playerNameBox);
        this.inviteButton = Button.m_253074_((Component)Component.m_237113_((String)"Invite"), btn -> this.sendInvite()).m_252987_(this.leftPos + 10, this.topPos + 120 - 30, 95, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.inviteButton);
        this.inviteButton.f_93623_ = false;
        this.cancelButton = Button.m_253074_((Component)Component.m_237113_((String)"Cancel"), btn -> this.m_7379_()).m_252987_(this.leftPos + 115, this.topPos + 120 - 30, 95, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.cancelButton);
    }

    private void onNameChanged(String name) {
        this.errorMessage = null;
        if (name.trim().isEmpty()) {
            this.inviteButton.f_93623_ = false;
        } else if (name.length() < 3 || name.length() > 16) {
            this.inviteButton.f_93623_ = false;
            if (name.length() > 0) {
                this.errorMessage = "Invalid name length (3-16)";
            }
        } else if (!name.matches("[a-zA-Z0-9_]+")) {
            this.inviteButton.f_93623_ = false;
            this.errorMessage = "Invalid characters";
        } else {
            this.inviteButton.f_93623_ = true;
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        graphics.m_280509_(this.leftPos, this.topPos, this.leftPos + 220, this.topPos + 120, -872415232);
        graphics.m_280509_(this.leftPos, this.topPos, this.leftPos + 220, this.topPos + 25, -14540254);
        int titleWidth = this.f_96547_.m_92895_("Invite Player to Team");
        graphics.m_280488_(this.f_96547_, "Invite Player to Team", this.leftPos + (220 - titleWidth) / 2, this.topPos + 8, 0xFFFFFF);
        graphics.m_280488_(this.f_96547_, "Player Name:", this.leftPos + 10, this.topPos + 33, 0xFFFFFF);
        if (this.errorMessage == null) {
            graphics.m_280488_(this.f_96547_, "\u00a77Enter the name of the player", this.leftPos + 10, this.topPos + 70, 0x888888);
            graphics.m_280488_(this.f_96547_, "\u00a77you want to invite", this.leftPos + 10, this.topPos + 82, 0x888888);
        } else {
            graphics.m_280488_(this.f_96547_, "\u00a7c" + this.errorMessage, this.leftPos + 10, this.topPos + 70, 0xFF5555);
        }
        this.playerNameBox.m_88315_(graphics, mouseX, mouseY, partialTick);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
    }

    private void sendInvite() {
        String playerName = this.playerNameBox.m_94155_().trim();
        if (!playerName.isEmpty()) {
            TeamActionPacket packet = TeamActionPacket.invite(playerName);
            NetworkManager.sendToServer(packet);
            this.m_7379_();
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 257 && this.inviteButton.f_93623_) {
            this.sendInvite();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    public boolean m_7043_() {
        return false;
    }
}

