/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.events;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import org.texboobcat.questory.client.gui.TextFormatter;
import org.texboobcat.questory.config.QuestoryConfig;
import org.texboobcat.questory.quest.Quest;
import org.texboobcat.questory.quest.Reward;

public class QuestNotifications {
    public static void notifyQuestUnlocked(ServerPlayer player, Quest quest) {
        QuestoryConfig config = QuestoryConfig.getInstance();
        if (!config.shouldNotify("unlock")) {
            return;
        }
        if (config.shouldShowChatMessage()) {
            player.m_213846_((Component)Component.m_237113_((String)"New Quest Available: ").m_130940_(ChatFormatting.GOLD).m_7220_(TextFormatter.parse(quest.getTitle())));
        }
        if (config.shouldPlaySound()) {
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 0.5f, 1.0f);
        }
    }

    public static void notifyQuestReady(ServerPlayer player, Quest quest) {
        QuestoryConfig config = QuestoryConfig.getInstance();
        if (!config.shouldNotify("ready")) {
            return;
        }
        if (config.shouldShowChatMessage()) {
            player.m_213846_((Component)Component.m_237113_((String)"\u2713 Quest Complete: ").m_130944_(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.BOLD}).m_7220_(TextFormatter.parse(quest.getTitle())));
            player.m_213846_((Component)Component.m_237113_((String)("  Run /quest complete " + quest.getId() + " to claim rewards")).m_130940_(ChatFormatting.GRAY));
        }
        if (config.shouldPlaySound()) {
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12496_, SoundSource.PLAYERS, 0.7f, 1.0f);
        }
    }

    public static void notifyQuestClaimed(ServerPlayer player, Quest quest) {
        QuestoryConfig config = QuestoryConfig.getInstance();
        if (!config.shouldNotify("complete")) {
            return;
        }
        if (config.shouldShowTitle()) {
            player.f_8906_.m_9829_((Packet)new ClientboundSetTitlesAnimationPacket(10, 40, 10));
            player.f_8906_.m_9829_((Packet)new ClientboundSetSubtitleTextPacket(TextFormatter.parse(quest.getTitle())));
            player.f_8906_.m_9829_((Packet)new ClientboundSetTitleTextPacket((Component)Component.m_237113_((String)"Quest Complete!").m_130944_(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.BOLD})));
        }
        if (config.shouldShowChatMessage()) {
            player.m_213846_((Component)Component.m_237113_((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").m_130940_(ChatFormatting.DARK_GREEN));
            player.m_213846_((Component)Component.m_237113_((String)"Quest Completed: ").m_130944_(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.BOLD}).m_7220_(TextFormatter.parse(quest.getTitle())));
            if (!quest.getRewards().isEmpty()) {
                player.m_213846_((Component)Component.m_237113_((String)"Rewards:").m_130940_(ChatFormatting.GOLD));
                for (Reward reward : quest.getRewards()) {
                    player.m_213846_((Component)Component.m_237113_((String)("  \u2713 " + reward.getDisplayString())).m_130940_(ChatFormatting.GREEN));
                }
            }
            player.m_213846_((Component)Component.m_237113_((String)"\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550").m_130940_(ChatFormatting.DARK_GREEN));
        }
        if (config.shouldPlaySound()) {
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public static void notifyProgress(ServerPlayer player, Quest quest, String progressText) {
        player.m_213846_((Component)Component.m_237113_((String)"Quest Progress: ").m_130940_(ChatFormatting.YELLOW).m_7220_(TextFormatter.parse(quest.getTitle())));
        player.m_213846_((Component)Component.m_237113_((String)("  " + progressText)).m_130940_(ChatFormatting.GRAY));
    }

    public static void notifyMissingPrerequisites(ServerPlayer player, Quest quest) {
        player.m_213846_((Component)Component.m_237113_((String)("Cannot start quest: " + quest.getTitle())).m_130940_(ChatFormatting.RED));
        player.m_213846_((Component)Component.m_237113_((String)"  Complete prerequisite quests first").m_130940_(ChatFormatting.GRAY));
    }

    public static void notifyQuestsUnlockedBatch(ServerPlayer player, List<Quest> quests) {
        QuestoryConfig config = QuestoryConfig.getInstance();
        if (!config.shouldNotify("unlock")) {
            return;
        }
        if (quests.isEmpty()) {
            return;
        }
        if (config.shouldShowChatMessage()) {
            player.m_213846_((Component)Component.m_237113_((String)"New Quests Available: ").m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237113_((String)String.valueOf(quests.size())).m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD})));
            int limit = Math.min(5, quests.size());
            for (int i = 0; i < limit; ++i) {
                player.m_213846_((Component)Component.m_237113_((String)"  \u2022 ").m_130940_(ChatFormatting.GRAY).m_7220_(TextFormatter.parse(quests.get(i).getTitle())));
            }
            if (quests.size() > limit) {
                player.m_213846_((Component)Component.m_237113_((String)("  ... and " + (quests.size() - limit) + " more")).m_130940_(ChatFormatting.GRAY));
            }
        }
        if (config.shouldPlaySound()) {
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 0.5f, 1.0f);
        }
    }
}

