/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.quest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.texboobcat.questory.quest.Quest;
import org.texboobcat.questory.quest.Requirement;
import org.texboobcat.questory.quest.Reward;

public class TagAutoDetector {
    private static final Map<String, List<Pattern>> TAG_PATTERNS = new HashMap<String, List<Pattern>>();

    private static void addTagPatterns(String tag, List<String> keywords) {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        for (String keyword : keywords) {
            patterns.add(Pattern.compile("\\b" + keyword + "\\w*\\b", 2));
        }
        TAG_PATTERNS.put(tag, patterns);
    }

    public static Set<String> suggestTags(Quest quest) {
        HashSet<String> suggestedTags = new HashSet<String>();
        TagAutoDetector.analyzeText(quest.getTitle(), suggestedTags);
        TagAutoDetector.analyzeText(quest.getDescription(), suggestedTags);
        for (Requirement req : quest.getRequirements()) {
            TagAutoDetector.analyzeRequirement(req, suggestedTags);
        }
        for (Reward reward : quest.getRewards()) {
            TagAutoDetector.analyzeReward(reward, suggestedTags);
        }
        TagAutoDetector.analyzeDifficulty(quest, suggestedTags);
        if (quest.isOptional()) {
            suggestedTags.add("optional");
        }
        if (!"default".equals(quest.getCanRepeat()) && !"false".equals(quest.getCanRepeat())) {
            suggestedTags.add("repeatable");
        }
        return suggestedTags;
    }

    private static void analyzeText(String text, Set<String> tags) {
        if (text == null || text.isEmpty()) {
            return;
        }
        block0: for (Map.Entry<String, List<Pattern>> entry : TAG_PATTERNS.entrySet()) {
            String tag = entry.getKey();
            List<Pattern> patterns = entry.getValue();
            for (Pattern pattern : patterns) {
                if (!pattern.matcher(text).find()) continue;
                tags.add(tag);
                continue block0;
            }
        }
    }

    private static void analyzeRequirement(Requirement req, Set<String> tags) {
        String type;
        switch (type = req.getType().toLowerCase()) {
            case "kill": 
            case "kill_entity": 
            case "entity_kill": {
                tags.add("combat");
                break;
            }
            case "mine": 
            case "break_block": {
                tags.add("mining");
                break;
            }
            case "place": 
            case "place_block": {
                tags.add("building");
                break;
            }
            case "craft": 
            case "craft_item": 
            case "item_craft": {
                tags.add("crafting");
                break;
            }
            case "collect": 
            case "item": 
            case "item_obtain": {
                tags.add("collection");
                break;
            }
            case "visit": 
            case "location": 
            case "dimension": 
            case "biome": {
                tags.add("exploration");
                break;
            }
            case "trade": {
                tags.add("trading");
            }
        }
    }

    private static void analyzeReward(Reward reward, Set<String> tags) {
        if ("command".equalsIgnoreCase(reward.getType())) {
            tags.add("special");
        }
        if ("xp".equalsIgnoreCase(reward.getType()) || "xp_levels".equalsIgnoreCase(reward.getType())) {
            tags.add("progression");
        }
    }

    private static void analyzeDifficulty(Quest quest, Set<String> tags) {
        int difficultyScore = 0;
        difficultyScore += quest.getDependencies().size() * 2;
        difficultyScore += quest.getRequirements().size() * 3;
        if (quest.getRewards().size() > 5) {
            difficultyScore += 2;
        }
        if (difficultyScore >= 20) {
            tags.add("hard");
        } else if (difficultyScore >= 10) {
            tags.add("medium");
        } else if (difficultyScore > 0) {
            tags.add("easy");
        } else {
            tags.add("tutorial");
        }
    }

    public static Set<String> getAppliedTags(Quest quest) {
        return new HashSet<String>(quest.getTags());
    }

    public static Set<String> getNewSuggestions(Quest quest) {
        Set<String> suggested = TagAutoDetector.suggestTags(quest);
        Set<String> existing = TagAutoDetector.getAppliedTags(quest);
        suggested.removeAll(existing);
        return suggested;
    }

    public static void applyTags(Quest quest, Set<String> tagsToApply) {
        List<String> currentTags = quest.getTags();
        for (String tag : tagsToApply) {
            if (currentTags.contains(tag)) continue;
            currentTags.add(tag);
        }
    }

    public static int autoApplyTags(Quest quest) {
        Set<String> suggestions = TagAutoDetector.getNewSuggestions(quest);
        TagAutoDetector.applyTags(quest, suggestions);
        return suggestions.size();
    }

    public static Set<String> getAllTagCategories() {
        return new HashSet<String>(TAG_PATTERNS.keySet());
    }

    static {
        TagAutoDetector.addTagPatterns("combat", Arrays.asList("kill", "defeat", "slay", "fight", "battle", "combat", "weapon", "armor", "sword", "bow", "arrow", "shield", "enemy", "mob", "boss", "pvp"));
        TagAutoDetector.addTagPatterns("mining", Arrays.asList("mine", "ore", "pickaxe", "dig", "cave", "underground", "quarry", "coal", "iron", "gold", "diamond", "emerald", "nether"));
        TagAutoDetector.addTagPatterns("building", Arrays.asList("build", "construct", "place", "house", "structure", "base", "home", "wall", "floor", "roof", "door", "window", "decoration"));
        TagAutoDetector.addTagPatterns("farming", Arrays.asList("farm", "crop", "plant", "grow", "harvest", "wheat", "carrot", "potato", "seed", "hoe", "till", "water", "animal", "breed"));
        TagAutoDetector.addTagPatterns("crafting", Arrays.asList("craft", "create", "make", "recipe", "workbench", "furnace", "smelt", "anvil", "enchant", "brew", "potion"));
        TagAutoDetector.addTagPatterns("exploration", Arrays.asList("explore", "discover", "find", "visit", "travel", "biome", "dimension", "village", "temple", "dungeon", "portal", "end", "nether"));
        TagAutoDetector.addTagPatterns("trading", Arrays.asList("trade", "buy", "sell", "merchant", "villager", "emerald", "shop", "currency", "economy", "market"));
        TagAutoDetector.addTagPatterns("magic", Arrays.asList("magic", "spell", "enchant", "potion", "brew", "alchemy", "wizard", "mana", "arcane", "mystical"));
        TagAutoDetector.addTagPatterns("technology", Arrays.asList("machine", "automation", "power", "energy", "electric", "tech", "generator", "engine", "circuit", "wire", "cable"));
        TagAutoDetector.addTagPatterns("collection", Arrays.asList("collect", "gather", "obtain", "acquire", "get", "find", "item"));
    }
}

