/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.team;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import org.texboobcat.questory.quest.Reward;
import org.texboobcat.questory.team.PendingReward;

public class PendingRewardManager {
    private static PendingRewardManager instance;
    private final Map<UUID, List<PendingReward>> pendingRewards = new ConcurrentHashMap<UUID, List<PendingReward>>();
    private final Path storagePath;
    private final Gson gson;

    private PendingRewardManager(Path dataPath) {
        this.storagePath = dataPath.resolve("teams").resolve("pending_rewards.json");
        this.gson = new GsonBuilder().setPrettyPrinting().create();
        try {
            Files.createDirectories(this.storagePath.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            System.err.println("[Questory] Failed to create pending rewards directory: " + e.getMessage());
        }
        this.loadPendingRewards();
    }

    public static void initialize(Path dataPath) {
        if (instance == null) {
            instance = new PendingRewardManager(dataPath);
        }
    }

    public static PendingRewardManager getInstance() {
        if (instance == null) {
            throw new IllegalStateException("PendingRewardManager not initialized!");
        }
        return instance;
    }

    public void addPendingReward(UUID playerId, String questId, String questTitle, Reward reward) {
        this.pendingRewards.computeIfAbsent(playerId, k -> new ArrayList()).add(new PendingReward(playerId, questId, questTitle, reward));
        this.savePendingRewards();
        System.out.println("[Questory] Added pending reward for offline player: " + String.valueOf(playerId));
    }

    public List<PendingReward> getPendingRewards(UUID playerId) {
        return new ArrayList<PendingReward>(this.pendingRewards.getOrDefault(playerId, Collections.emptyList()));
    }

    public boolean hasPendingRewards(UUID playerId) {
        List<PendingReward> rewards = this.pendingRewards.get(playerId);
        return rewards != null && !rewards.isEmpty();
    }

    public int grantPendingRewards(ServerPlayer player) {
        List<PendingReward> rewards = this.pendingRewards.remove(player.m_20148_());
        if (rewards == null || rewards.isEmpty()) {
            return 0;
        }
        int count = 0;
        for (PendingReward pending : rewards) {
            try {
                pending.getReward().grant(player);
                ++count;
                player.m_213846_((Component)Component.m_237113_((String)("\u00a76[Questory] \u00a7eReceived reward from team quest: \u00a7f" + pending.getQuestTitle())));
            }
            catch (Exception e) {
                System.err.println("[Questory] Error granting pending reward: " + e.getMessage());
            }
        }
        this.savePendingRewards();
        System.out.println("[Questory] Granted " + count + " pending rewards to: " + player.m_7755_().getString());
        return count;
    }

    public void clearPendingRewards(UUID playerId) {
        this.pendingRewards.remove(playerId);
        this.savePendingRewards();
    }

    public int getPendingRewardCount(UUID playerId) {
        List<PendingReward> rewards = this.pendingRewards.get(playerId);
        return rewards != null ? rewards.size() : 0;
    }

    private void loadPendingRewards() {
        if (!Files.exists(this.storagePath, new LinkOption[0])) {
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(this.storagePath);){
            JsonObject json = (JsonObject)this.gson.fromJson((Reader)reader, JsonObject.class);
            for (Map.Entry entry : json.entrySet()) {
                UUID playerId = UUID.fromString((String)entry.getKey());
                JsonArray rewardsArray = ((JsonElement)entry.getValue()).getAsJsonArray();
                ArrayList<PendingReward> rewards = new ArrayList<PendingReward>();
                for (JsonElement element : rewardsArray) {
                    try {
                        rewards.add(PendingReward.fromJson(element.getAsJsonObject()));
                    }
                    catch (Exception e) {
                        System.err.println("[Questory] Error loading pending reward: " + e.getMessage());
                    }
                }
                if (rewards.isEmpty()) continue;
                this.pendingRewards.put(playerId, rewards);
            }
            System.out.println("[Questory] Loaded pending rewards for " + this.pendingRewards.size() + " players");
        }
        catch (Exception e) {
            System.err.println("[Questory] Failed to load pending rewards: " + e.getMessage());
        }
    }

    private void savePendingRewards() {
        try {
            JsonObject json = new JsonObject();
            for (Map.Entry<UUID, List<PendingReward>> entry : this.pendingRewards.entrySet()) {
                JsonArray rewardsArray = new JsonArray();
                for (PendingReward reward : entry.getValue()) {
                    rewardsArray.add((JsonElement)reward.toJson());
                }
                json.add(entry.getKey().toString(), (JsonElement)rewardsArray);
            }
            try (BufferedWriter writer = Files.newBufferedWriter(this.storagePath, new OpenOption[0]);){
                this.gson.toJson((JsonElement)json, (Appendable)writer);
            }
        }
        catch (IOException e) {
            System.err.println("[Questory] Failed to save pending rewards: " + e.getMessage());
        }
    }

    public void cleanupOldRewards() {
        long cutoffTime = System.currentTimeMillis() - 2592000000L;
        boolean changed = false;
        for (Map.Entry<UUID, List<PendingReward>> entry : this.pendingRewards.entrySet()) {
            List<PendingReward> rewards = entry.getValue();
            int beforeSize = rewards.size();
            rewards.removeIf(reward -> reward.getTimestamp() < cutoffTime);
            if (rewards.size() < beforeSize) {
                changed = true;
                System.out.println("[Questory] Cleaned up " + (beforeSize - rewards.size()) + " old pending rewards for player: " + String.valueOf(entry.getKey()));
            }
            if (!rewards.isEmpty()) continue;
            this.pendingRewards.remove(entry.getKey());
        }
        if (changed) {
            this.savePendingRewards();
        }
    }
}

