/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.texboobcat.questory.client.gui.MultilineTextEditorScreen;
import org.texboobcat.questory.client.gui.NewThemeEditorScreen;
import org.texboobcat.questory.theme.QuestTheme;
import org.texboobcat.questory.theme.panel.BindingContext;
import org.texboobcat.questory.theme.panel.ButtonNode;
import org.texboobcat.questory.theme.panel.ConditionalNode;
import org.texboobcat.questory.theme.panel.DividerNode;
import org.texboobcat.questory.theme.panel.GradientParser;
import org.texboobcat.questory.theme.panel.GridNode;
import org.texboobcat.questory.theme.panel.HStackNode;
import org.texboobcat.questory.theme.panel.IconNode;
import org.texboobcat.questory.theme.panel.ImageListNode;
import org.texboobcat.questory.theme.panel.ImageNode;
import org.texboobcat.questory.theme.panel.ListNode;
import org.texboobcat.questory.theme.panel.PanelNode;
import org.texboobcat.questory.theme.panel.PanelRenderer;
import org.texboobcat.questory.theme.panel.PanelTemplate;
import org.texboobcat.questory.theme.panel.ProgressBarNode;
import org.texboobcat.questory.theme.panel.RichTextNode;
import org.texboobcat.questory.theme.panel.ScrollNode;
import org.texboobcat.questory.theme.panel.SliderNode;
import org.texboobcat.questory.theme.panel.SpacerNode;
import org.texboobcat.questory.theme.panel.StackNode;
import org.texboobcat.questory.theme.panel.TabContainerNode;
import org.texboobcat.questory.theme.panel.TextNode;
import org.texboobcat.questory.theme.panel.VStackNode;

public class BasicThemeEditorScreen
extends class_437 {
    private static final int TOP_BAR_HEIGHT = 30;
    private static final int LEFT_SIDEBAR_WIDTH = 260;
    private static final int RIGHT_SIDEBAR_WIDTH = 320;
    private static final int RIGHT_TAB_H = 20;
    private static final int RIGHT_TAB_GAP = 2;
    private static final int RIGHT_LABEL_W = 110;
    private final class_437 parent;
    private final PanelRenderer panelRenderer;
    private final BindingContext editorContext;
    private PanelNode rootNode;
    private PanelNode selectedNode;
    private String currentPanelName = "custom_panel";
    private final List<class_339> propertyWidgets = new ArrayList<class_339>();
    private final Map<class_339, Integer> propertyWidgetBaseY = new HashMap<class_339, Integer>();
    private final Map<class_339, String> propertyWidgetRowLabels = new HashMap<class_339, String>();
    private int rightSidebarScrollY = 0;
    private int maxRightSidebarScrollY = 0;
    private RightTab activeRightTab = RightTab.LAYOUT;
    private final List<class_4185> rightTabButtons = new ArrayList<class_4185>();
    private boolean sectionLayout = true;
    private boolean sectionBoxModel = true;
    private boolean sectionAppearance = true;
    private boolean sectionHover = true;
    private boolean sectionType = true;
    private boolean sectionActions = true;
    private float hierarchyScrollY = 0.0f;
    private float maxHierarchyScroll = 0.0f;
    private boolean isSelectingPanel = false;
    private double panelPickerScrollY = 0.0;
    private boolean isPickingNodeType = false;
    private double nodePickerScrollY = 0.0;
    private PanelNode nodePickerTargetParent = null;
    private static final String[] NODE_TYPES = new String[]{"vstack", "hstack", "stack", "grid", "scroll", "text", "richtext", "icon", "image", "image_list", "list", "button", "spacer", "conditional", "progress", "slider", "divider", "tabs"};
    private BackgroundMode bgMode = BackgroundMode.RAW;
    private String bgSolid = "#FF202020";
    private String bgA = "#FF202020";
    private String bgB = "#FF000000";
    private String bgAngle = "90";

    public BasicThemeEditorScreen(class_437 parent) {
        this(parent, null, null);
    }

    public BasicThemeEditorScreen(class_437 parent, PanelNode rootNode, String currentPanelName) {
        super((class_2561)class_2561.method_43470((String)"Theme Editor"));
        this.parent = parent;
        this.panelRenderer = new PanelRenderer();
        this.editorContext = new BindingContext(null, null);
        this.populateMockContext();
        if (rootNode != null) {
            this.rootNode = rootNode;
        } else {
            VStackNode root = new VStackNode();
            root.setId("root");
            root.setWidth("100%");
            root.setHeight("100%");
            root.setPadding(10);
            root.setBackground("#202020");
            this.rootNode = root;
        }
        if (currentPanelName != null && !currentPanelName.isEmpty()) {
            this.currentPanelName = currentPanelName;
        }
        this.selectedNode = this.rootNode;
    }

    private void populateMockContext() {
        HashMap<String, Object> quest = new HashMap<String, Object>();
        quest.put("title", "Example Quest Title");
        quest.put("description", "This is an example description for the quest.");
        quest.put("icon", "minecraft:diamond_sword");
        quest.put("id", "example_quest");
        quest.put("progress", 0.5);
        quest.put("isCompleted", false);
        quest.put("canComplete", true);
        ArrayList tasks = new ArrayList();
        for (int i = 1; i <= 3; ++i) {
            HashMap<String, Object> task = new HashMap<String, Object>();
            task.put("title", "Task " + i);
            task.put("icon", "minecraft:iron_ingot");
            task.put("progress", (double)i * 0.3);
            task.put("maxProgress", 1.0);
            tasks.add(task);
        }
        quest.put("tasks", tasks);
        ArrayList rewards = new ArrayList();
        for (int i = 1; i <= 2; ++i) {
            HashMap<String, Object> reward = new HashMap<String, Object>();
            reward.put("title", "Reward " + i);
            reward.put("icon", "minecraft:gold_nugget");
            rewards.add(reward);
        }
        quest.put("rewards", rewards);
        this.editorContext.put("quest", quest);
        HashMap<String, String> chapter = new HashMap<String, String>();
        chapter.put("title", "Example Chapter");
        chapter.put("description", "Chapter description goes here.");
        this.editorContext.put("chapter", chapter);
        HashMap global = new HashMap();
        global.put("inventory", Collections.emptyList());
        global.put("quests", Collections.emptyList());
        this.editorContext.put("global", global);
    }

    protected void method_25426() {
        super.method_25426();
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Save"), b -> this.savePanel()).method_46434(10, 5, 60, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Load Panel"), b -> {
            this.isSelectingPanel = true;
        }).method_46434(80, 5, 80, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Basic"), b -> {}).method_46434(this.field_22789 - 160, 5, 45, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Adv"), b -> {
            if (this.field_22787 != null) {
                this.field_22787.method_1507((class_437)new NewThemeEditorScreen(this.parent, this.rootNode, this.currentPanelName));
            }
        }).method_46434(this.field_22789 - 110, 5, 45, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Close"), b -> this.method_25419()).method_46434(this.field_22789 - 60, 5, 50, 20).method_46431());
        this.initRightTabButtons();
        this.rebuildPropertyWidgets();
    }

    private void initRightTabButtons() {
        for (class_4185 b2 : this.rightTabButtons) {
            this.method_37066((class_364)b2);
        }
        this.rightTabButtons.clear();
        int x0 = this.field_22789 - 320 + 10;
        int y0 = 70;
        int w0 = 300;
        int tabW = (w0 - 6) / 4;
        int tabW2 = (w0 - 4) / 3;
        class_4185 layout = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Layout"), b -> {
            this.activeRightTab = RightTab.LAYOUT;
            this.rightSidebarScrollY = 0;
            this.rebuildPropertyWidgets();
        }).method_46434(x0, y0, tabW, 20).method_46431();
        this.method_37063((class_364)layout);
        this.rightTabButtons.add(layout);
        class_4185 box = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Box"), b -> {
            this.activeRightTab = RightTab.BOX;
            this.rightSidebarScrollY = 0;
            this.rebuildPropertyWidgets();
        }).method_46434(x0 + tabW + 2, y0, tabW, 20).method_46431();
        this.method_37063((class_364)box);
        this.rightTabButtons.add(box);
        class_4185 app = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Look"), b -> {
            this.activeRightTab = RightTab.APPEARANCE;
            this.rightSidebarScrollY = 0;
            this.rebuildPropertyWidgets();
        }).method_46434(x0 + (tabW + 2) * 2, y0, tabW, 20).method_46431();
        this.method_37063((class_364)app);
        this.rightTabButtons.add(app);
        class_4185 hov = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Hover"), b -> {
            this.activeRightTab = RightTab.HOVER;
            this.rightSidebarScrollY = 0;
            this.rebuildPropertyWidgets();
        }).method_46434(x0 + (tabW + 2) * 3, y0, tabW, 20).method_46431();
        this.method_37063((class_364)hov);
        this.rightTabButtons.add(hov);
        int y1 = y0 + 20 + 2;
        class_4185 type = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Type"), b -> {
            this.activeRightTab = RightTab.TYPE;
            this.rightSidebarScrollY = 0;
            this.rebuildPropertyWidgets();
        }).method_46434(x0, y1, tabW2, 20).method_46431();
        this.method_37063((class_364)type);
        this.rightTabButtons.add(type);
        class_4185 actions = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Actions"), b -> {
            this.activeRightTab = RightTab.ACTIONS;
            this.rightSidebarScrollY = 0;
            this.rebuildPropertyWidgets();
        }).method_46434(x0 + tabW2 + 2, y1, tabW2, 20).method_46431();
        this.method_37063((class_364)actions);
        this.rightTabButtons.add(actions);
        class_4185 json = class_4185.method_46430((class_2561)class_2561.method_43470((String)"JSON"), b -> {
            this.activeRightTab = RightTab.JSON;
            this.rightSidebarScrollY = 0;
            this.rebuildPropertyWidgets();
        }).method_46434(x0 + (tabW2 + 2) * 2, y1, tabW2, 20).method_46431();
        this.method_37063((class_364)json);
        this.rightTabButtons.add(json);
        this.updateRightTabButtonStates();
    }

    private void updateRightTabButtonStates() {
        String activeLabel = switch (this.activeRightTab.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> "Layout";
            case 1 -> "Box";
            case 2 -> "Look";
            case 3 -> "Hover";
            case 4 -> "Type";
            case 5 -> "Actions";
            case 6 -> "JSON";
        };
        for (class_4185 b : this.rightTabButtons) {
            b.field_22763 = !activeLabel.equals(b.method_25369().getString());
        }
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }

    public void method_25394(class_332 g, int mouseX, int mouseY, float partialTick) {
        this.method_25420(g);
        this.renderTopBar(g);
        this.renderCanvas(g, mouseX, mouseY);
        this.renderLeftSidebar(g, mouseX, mouseY);
        this.renderRightSidebar(g, mouseX, mouseY);
        super.method_25394(g, mouseX, mouseY, partialTick);
        if (this.isSelectingPanel) {
            this.renderPanelSelection(g, mouseX, mouseY);
        }
        if (this.isPickingNodeType) {
            this.renderNodePicker(g, mouseX, mouseY);
        }
    }

    private void renderTopBar(class_332 g) {
        g.method_25294(0, 0, this.field_22789, 30, -14671840);
        g.method_25292(0, this.field_22789, 29, -16777216);
        Object t = "Theme Editor";
        if (this.currentPanelName != null && !this.currentPanelName.isEmpty()) {
            t = (String)t + " \u2014 " + this.currentPanelName;
        }
        g.method_25300(this.field_22793, (String)t, this.field_22789 / 2, 10, -1);
    }

    private void renderCanvas(class_332 g, int mouseX, int mouseY) {
        int x0 = 260;
        int y0 = 30;
        int w = this.field_22789 - 260 - 320;
        int h = this.field_22790 - 30;
        g.method_25294(x0, y0, x0 + w, y0 + h, -15461356);
        if (this.rootNode != null) {
            PanelTemplate template = new PanelTemplate("preview", this.rootNode);
            this.panelRenderer.setHoveredNode(this.selectedNode);
            this.panelRenderer.render(template, this.editorContext, g, x0 + 10, y0 + 10, w - 20, h - 20, mouseX, mouseY);
        }
    }

    private void renderLeftSidebar(class_332 g, int mouseX, int mouseY) {
        int x = 0;
        int y = 30;
        int w = 260;
        int h = this.field_22790 - 30;
        g.method_25294(x, y, x + w, y + h, -14013910);
        g.method_25301(x + w - 1, y, y + h, -16777216);
        g.method_25303(this.field_22793, "Hierarchy", x + 10, y + 10, -2039584);
        g.method_44379(x, y + 25, x + w, y + h);
        int contentHeight = 0;
        if (this.rootNode != null) {
            contentHeight = this.renderHierarchyNode(g, this.rootNode, x + 10, y + 30 + (int)this.hierarchyScrollY, w - 20, 0, mouseX, mouseY) - (y + 30 + (int)this.hierarchyScrollY);
        }
        g.method_44380();
        this.maxHierarchyScroll = Math.max(0, contentHeight - (h - 30));
    }

    private int renderHierarchyNode(class_332 g, PanelNode node, int x, int y, int w, int depth, int mouseX, int mouseY) {
        boolean hovered;
        int h = 20;
        int indent = depth * 10;
        boolean bl = hovered = mouseX >= x && mouseX < x + w && mouseY >= y && mouseY < y + h;
        if (node == this.selectedNode) {
            g.method_25294(x, y, x + w, y + h, -12952934);
        } else if (hovered) {
            g.method_25294(x, y, x + w, y + h, -13290187);
        }
        g.method_25303(this.field_22793, node.getType(), x + indent + 5, y + 6, -2236963);
        if (node.getId() != null && !node.getId().isEmpty()) {
            g.method_25303(this.field_22793, "#" + node.getId(), x + indent + 5 + this.field_22793.method_1727(node.getType()) + 5, y + 6, -7829368);
        }
        int currentY = y + h;
        List<PanelNode> children = this.getChildren(node);
        if (children != null) {
            for (PanelNode child : children) {
                currentY = this.renderHierarchyNode(g, child, x, currentY, w, depth + 1, mouseX, mouseY);
            }
        }
        return currentY;
    }

    private void renderRightSidebar(class_332 g, int mouseX, int mouseY) {
        int x = this.field_22789 - 320;
        int y = 30;
        int w = 320;
        int h = this.field_22790 - 30;
        g.method_25294(x, y, x + w, y + h, -14803426);
        g.method_25301(x, y, y + h, -16777216);
        g.method_25303(this.field_22793, "Basic", x + 10, y + 10, -2039584);
        if (this.selectedNode != null) {
            g.method_25303(this.field_22793, "Selected: " + this.selectedNode.getType(), x + 10, y + 24, -5592406);
        }
        int contentTop = 116;
        int contentBottom = this.field_22790 - 6;
        String tooltip = null;
        for (class_339 wid : this.propertyWidgets) {
            String label;
            boolean inBounds;
            Integer baseY = this.propertyWidgetBaseY.get(wid);
            if (baseY != null) {
                wid.method_46419(baseY - this.rightSidebarScrollY);
            }
            wid.field_22764 = inBounds = wid.method_46427() + wid.method_25364() >= contentTop && wid.method_46427() <= contentBottom;
            wid.field_22763 = inBounds;
            if (inBounds && tooltip == null && mouseX >= wid.method_46426() && mouseX < wid.method_46426() + wid.method_25368() && mouseY >= wid.method_46427() && mouseY < wid.method_46427() + wid.method_25364()) {
                label = null;
                if (wid instanceof class_342) {
                    class_342 eb = (class_342)wid;
                    label = eb.method_25369() == null ? null : eb.method_25369().getString();
                } else if (this.propertyWidgetRowLabels.containsKey(wid)) {
                    label = this.propertyWidgetRowLabels.get(wid);
                } else if (wid.method_25369() != null) {
                    label = wid.method_25369().getString();
                }
                tooltip = this.tooltipForLabel(label);
            }
            if (inBounds && wid instanceof class_342) {
                String label2;
                class_342 eb = (class_342)wid;
                String string = label2 = eb.method_25369() == null ? "" : eb.method_25369().getString();
                if (!label2.isEmpty()) {
                    int labelX = x + 10;
                    if (eb.method_46426() > labelX + 55) {
                        g.method_25303(this.field_22793, label2, labelX, eb.method_46427() + 5, -4671304);
                    } else {
                        g.method_25303(this.field_22793, label2, eb.method_46426(), eb.method_46427() - 10, -4671304);
                    }
                }
            }
            if (!inBounds || wid instanceof class_342 || !this.propertyWidgetRowLabels.containsKey(wid) || (label = this.propertyWidgetRowLabels.get(wid)) == null || label.isEmpty()) continue;
            g.method_25303(this.field_22793, label, x + 10, wid.method_46427() + 6, -4671304);
        }
        if (tooltip != null && !tooltip.isEmpty()) {
            g.method_51438(this.field_22793, (class_2561)class_2561.method_43470((String)tooltip), mouseX, mouseY);
        }
    }

    private String tooltipForLabel(String label) {
        if (label == null || label.isEmpty()) {
            return "";
        }
        if (label.startsWith("BG Mode:")) {
            return "Switch background helper mode (raw/solid/linear/radial/none).";
        }
        if (label.equals("BG Mode")) {
            return "Switch background helper mode (raw/solid/linear/radial/none).";
        }
        if (label.startsWith("Border:")) {
            return "Toggle border settings for this node.";
        }
        if (label.equals("Border")) {
            return "Toggle border settings for this node.";
        }
        if (label.equals("Add Child")) {
            return "Add a new child node to the selected container (or nearest valid parent).";
        }
        if (label.equals("JSON")) {
            return "Edit the selected node as raw JSON (escape hatch).";
        }
        if (label.equals("To Root")) {
            return "Jump selection back to the root node.";
        }
        if (label.equals("Duplicate")) {
            return "Duplicate the selected node.";
        }
        if (label.equals("Remove")) {
            return "Remove the selected node from its parent.";
        }
        if (label.equals("Up") || label.equals("Down")) {
            return "Move the selected node within its parent.";
        }
        if (label.equals("Text")) {
            return "Text contents. Use Edit to open a multiline editor.";
        }
        if (label.equals("Rich Text")) {
            return "Rich text contents. Use Edit to open the formatted editor.";
        }
        if (label.equals("Child")) {
            return "Navigate into and edit this node's child.";
        }
        if (label.equals("Item Template")) {
            return "Navigate into and edit the list's item template.";
        }
        if (label.equals("Edit Text")) {
            return "Open a multiline editor for this text node.";
        }
        if (label.equals("Edit Rich Text")) {
            return "Open a formatted multiline editor for this rich text node.";
        }
        if (label.equals("Edit Child")) {
            return "Navigate into and edit this node's child.";
        }
        if (label.equals("Edit Item Template")) {
            return "Navigate into and edit the list's item template.";
        }
        if (label.startsWith("Edit Tab ") && label.endsWith(" Content")) {
            return "Navigate into and edit this tab's content.";
        }
        if (label.startsWith("Tab ") && label.endsWith(" Id")) {
            return "Tab identifier used by selectedTab or styling.";
        }
        if (label.startsWith("Tab ") && label.endsWith(" Label")) {
            return "Text shown on the tab button.";
        }
        if (label.startsWith("Tab ") && label.endsWith(" Icon")) {
            return "Optional icon for the tab (resource path or binding).";
        }
        if (label.startsWith("Tab ") && label.endsWith(" Style")) {
            return "Optional style hint for the tab (e.g. primary/danger).";
        }
        return switch (label) {
            case "Id" -> "Optional unique id for this node.";
            case "Align" -> "Child alignment within parent (e.g. left/center/right/top/bottom).";
            case "Justify" -> "Child distribution within parent (e.g. start/center/end/space-between).";
            case "Width" -> "Node width (px like 120, or percent like 100%).";
            case "Height" -> "Node height (px like 120, or percent like 100%).";
            case "Min Width" -> "Minimum width constraint.";
            case "Max Width" -> "Maximum width constraint.";
            case "Min Height" -> "Minimum height constraint.";
            case "Max Height" -> "Maximum height constraint.";
            case "Padding" -> "Inner spacing on all sides (overridden by per-side padding if set).";
            case "Padding Top" -> "Inner spacing on top side.";
            case "Padding Right" -> "Inner spacing on right side.";
            case "Padding Bottom" -> "Inner spacing on bottom side.";
            case "Padding Left" -> "Inner spacing on left side.";
            case "Margin" -> "Outer spacing on all sides (overridden by per-side margin if set).";
            case "Margin Top" -> "Outer spacing on top side.";
            case "Margin Right" -> "Outer spacing on right side.";
            case "Margin Bottom" -> "Outer spacing on bottom side.";
            case "Margin Left" -> "Outer spacing on left side.";
            case "Background" -> "Background fill. Supports colors (#AARRGGBB), bindings, and gradients.";
            case "Color" -> "Color value (#AARRGGBB) or binding.";
            case "A" -> "Gradient start color.";
            case "B" -> "Gradient end color.";
            case "Angle" -> "Linear gradient angle in degrees.";
            case "Border Color" -> "Border color (#AARRGGBB) or binding.";
            case "Border Width" -> "Border thickness in pixels.";
            case "Border Radius" -> "Corner radius in pixels.";
            case "Shadow" -> "Shadow string (e.g. '2 2 #80000000').";
            case "Opacity" -> "Opacity 0..1.";
            case "Rotation" -> "Rotation (degrees).";
            case "Scale" -> "Scale multiplier (1.0 = normal).";
            case "Visible" -> "Visibility expression/binding (empty = visible).";
            case "Hover Background" -> "Hover-style background override.";
            case "Hover Border Color" -> "Hover-style border color override.";
            case "Hover Border Width" -> "Hover-style border width override.";
            case "Hover Border Radius" -> "Hover-style border radius override.";
            case "Hover Shadow" -> "Hover-style shadow override.";
            case "Hover Opacity" -> "Hover-style opacity override.";
            case "Hover Rotation" -> "Hover-style rotation override.";
            case "Hover Scale" -> "Hover-style scale override.";
            case "Spacing" -> "Spacing between children in vstack/hstack.";
            case "Columns" -> "Grid columns.";
            case "Rows" -> "Grid rows (blank = auto).";
            case "Gap" -> "Grid gap between cells.";
            case "Text Align" -> "Text alignment within its box (left/center/right).";
            case "Text Shadow" -> "Text shadow (e.g. '1 1 #80000000').";
            case "Font" -> "Font id (resource) or empty for default.";
            case "Font Size" -> "Text scale factor (1.0 = normal).";
            case "Bold (true/false)" -> "Set bold text.";
            case "Italic (true/false)" -> "Set italic text.";
            case "Line Height" -> "Line height (pixels or percent).";
            case "Wrap (true/false)" -> "Wrap text in its box.";
            case "Value" -> "Binding or literal value for this node.";
            case "Size" -> "Size in pixels.";
            case "Src" -> "Image resource path or binding.";
            case "Fit" -> "Image fit mode (contain/cover/fill/none).";
            case "Image Width" -> "Override drawn image width.";
            case "Image Height" -> "Override drawn image height.";
            case "Items" -> "Binding/expression that evaluates to a list.";
            case "When" -> "Expression deciding whether to render child.";
            case "Enabled" -> "Expression deciding whether button is enabled.";
            case "On Click" -> "Action string/function call for click.";
            case "Max" -> "Maximum value.";
            case "Background Color" -> "Background track color.";
            case "Direction" -> "Direction (horizontal/vertical).";
            case "Bar Height" -> "Progress bar thickness.";
            case "Min" -> "Minimum value.";
            case "Step" -> "Step increment (double).";
            case "On Change" -> "Action string/function call for change.";
            case "Track Color" -> "Slider track color.";
            case "Thumb Color" -> "Slider thumb color.";
            case "Track Height" -> "Slider track thickness.";
            case "Orientation" -> "Divider orientation (horizontal/vertical).";
            case "Thickness" -> "Divider thickness.";
            case "Style" -> "Divider style (solid/dashed/dotted).";
            case "Selected Tab" -> "Binding/literal id of selected tab.";
            case "Tab Position" -> "Tab bar position (top/bottom/left/right).";
            case "Tab Spacing" -> "Spacing between tab buttons.";
            case "Tab Background" -> "Tab background color.";
            case "Active Tab Background" -> "Active tab background color.";
            case "Tab Color" -> "Tab text/icon color.";
            case "Active Tab Color" -> "Active tab text/icon color.";
            default -> "";
        };
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        PanelNode n;
        if (this.isPickingNodeType) {
            this.handleNodePickerClick(mouseX, mouseY);
            return true;
        }
        if (this.isSelectingPanel) {
            this.handlePanelSelectionClick(mouseX, mouseY);
            return true;
        }
        if (mouseY >= 30.0 && mouseX < 260.0 && (n = this.findNodeInHierarchy(this.rootNode, (int)mouseX, (int)mouseY)) != null) {
            this.selectedNode = n;
            this.rebuildPropertyWidgets();
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    private PanelNode findNodeInHierarchy(PanelNode node, int mouseX, int mouseY) {
        if (node == null) {
            return null;
        }
        int startY = 60 + (int)this.hierarchyScrollY;
        return this.findNodeAtRecursive(node, 10, startY, 240, 0, mouseX, mouseY);
    }

    private PanelNode findNodeAtRecursive(PanelNode node, int x, int y, int w, int depth, int mouseX, int mouseY) {
        int h = 20;
        if (mouseY >= y && mouseY < y + h && mouseX >= x && mouseX < x + w) {
            return node;
        }
        int currentY = y + h;
        List<PanelNode> children = this.getChildren(node);
        if (children != null) {
            for (PanelNode child : children) {
                PanelNode found = this.findNodeAtRecursive(child, x, currentY, w, depth + 1, mouseX, mouseY);
                if (found != null) {
                    return found;
                }
                currentY = this.getSubTreeHeight(child, currentY, w, depth + 1);
            }
        }
        return null;
    }

    private int getSubTreeHeight(PanelNode node, int y, int w, int depth) {
        int h = 20;
        int currentY = y + h;
        List<PanelNode> children = this.getChildren(node);
        if (children != null) {
            for (PanelNode child : children) {
                currentY = this.getSubTreeHeight(child, currentY, w, depth + 1);
            }
        }
        return currentY;
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (this.isSelectingPanel) {
            this.panelPickerScrollY += delta * 12.0;
            if (this.panelPickerScrollY > 0.0) {
                this.panelPickerScrollY = 0.0;
            }
            return true;
        }
        if (this.isPickingNodeType) {
            this.nodePickerScrollY += delta * 12.0;
            if (this.nodePickerScrollY > 0.0) {
                this.nodePickerScrollY = 0.0;
            }
            return true;
        }
        if (mouseX < 260.0 && mouseY >= 30.0) {
            this.hierarchyScrollY += (float)(delta * 12.0);
            if (this.hierarchyScrollY > 0.0f) {
                this.hierarchyScrollY = 0.0f;
            }
            if (-this.hierarchyScrollY > this.maxHierarchyScroll) {
                this.hierarchyScrollY = -this.maxHierarchyScroll;
            }
            return true;
        }
        int rightContentTop = 116;
        if (mouseX >= (double)(this.field_22789 - 320) && mouseY >= (double)rightContentTop) {
            this.rightSidebarScrollY -= (int)(delta * 16.0);
            if (this.rightSidebarScrollY < 0) {
                this.rightSidebarScrollY = 0;
            }
            if (this.rightSidebarScrollY > this.maxRightSidebarScrollY) {
                this.rightSidebarScrollY = this.maxRightSidebarScrollY;
            }
            return true;
        }
        return super.method_25401(mouseX, mouseY, delta);
    }

    private void rebuildPropertyWidgets() {
        this.updateRightTabButtonStates();
        for (class_339 w : this.propertyWidgets) {
            this.method_37066((class_364)w);
        }
        this.propertyWidgets.clear();
        this.propertyWidgetBaseY.clear();
        this.propertyWidgetRowLabels.clear();
        this.maxRightSidebarScrollY = 0;
        if (this.rightSidebarScrollY < 0) {
            this.rightSidebarScrollY = 0;
        }
        if (this.selectedNode == null) {
            return;
        }
        this.deriveBgFromNode();
        int x = this.field_22789 - 320 + 10;
        int y = 122;
        int w = 300;
        if (this.activeRightTab == RightTab.LAYOUT) {
            class_342 idBox = this.addField(x, y, w, "Id");
            idBox.method_1852(this.selectedNode.getId() == null ? "" : this.selectedNode.getId());
            idBox.method_1863(v -> this.selectedNode.setId(v == null || v.isEmpty() ? null : v));
            class_342 alignBox = this.addField(x, y += 22, w, "Align");
            alignBox.method_1852(this.selectedNode.getAlign() == null ? "" : this.selectedNode.getAlign());
            alignBox.method_1863(v -> this.selectedNode.setAlign(v == null || v.isEmpty() ? null : v));
            class_342 justifyBox = this.addField(x, y += 22, w, "Justify");
            justifyBox.method_1852(this.selectedNode.getJustify() == null ? "" : this.selectedNode.getJustify());
            justifyBox.method_1863(v -> this.selectedNode.setJustify(v == null || v.isEmpty() ? null : v));
            class_342 widthBox = this.addField(x, y += 22, w, "Width");
            widthBox.method_1852(this.selectedNode.getWidth() == null ? "" : this.selectedNode.getWidth());
            widthBox.method_1863(v -> this.selectedNode.setWidth(v == null || v.isEmpty() ? null : v));
            class_342 heightBox = this.addField(x, y += 22, w, "Height");
            heightBox.method_1852(this.selectedNode.getHeight() == null ? "" : this.selectedNode.getHeight());
            heightBox.method_1863(v -> this.selectedNode.setHeight(v == null || v.isEmpty() ? null : v));
            class_342 minWBox = this.addField(x, y += 22, w, "Min Width");
            minWBox.method_1852(this.selectedNode.getMinWidth() == null ? "" : this.selectedNode.getMinWidth());
            minWBox.method_1863(v -> this.selectedNode.setMinWidth(v == null || v.isEmpty() ? null : v));
            class_342 maxWBox = this.addField(x, y += 22, w, "Max Width");
            maxWBox.method_1852(this.selectedNode.getMaxWidth() == null ? "" : this.selectedNode.getMaxWidth());
            maxWBox.method_1863(v -> this.selectedNode.setMaxWidth(v == null || v.isEmpty() ? null : v));
            class_342 minHBox = this.addField(x, y += 22, w, "Min Height");
            minHBox.method_1852(this.selectedNode.getMinHeight() == null ? "" : this.selectedNode.getMinHeight());
            minHBox.method_1863(v -> this.selectedNode.setMinHeight(v == null || v.isEmpty() ? null : v));
            class_342 maxHBox = this.addField(x, y += 22, w, "Max Height");
            maxHBox.method_1852(this.selectedNode.getMaxHeight() == null ? "" : this.selectedNode.getMaxHeight());
            maxHBox.method_1863(v -> this.selectedNode.setMaxHeight(v == null || v.isEmpty() ? null : v));
            y += 22;
            return;
        }
        if (this.activeRightTab == RightTab.BOX) {
            class_342 paddingBox = this.addField(x, y, w, "Padding");
            paddingBox.method_1852(this.selectedNode.getPadding() == null ? "" : String.valueOf(this.selectedNode.getPadding()));
            paddingBox.method_1863(v -> {
                Integer parsed = this.tryParseInt((String)v);
                if (v == null || v.trim().isEmpty()) {
                    this.selectedNode.setPadding(null);
                } else if (parsed != null) {
                    this.selectedNode.setPadding(parsed);
                }
            });
            class_342 padT = this.addField(x, y += 22, w, "Padding Top");
            padT.method_1852(this.selectedNode.getPaddingTopRaw() == null ? "" : String.valueOf(this.selectedNode.getPaddingTopRaw()));
            padT.method_1863(v -> {
                Integer parsed = this.tryParseInt((String)v);
                if (v == null || v.trim().isEmpty()) {
                    this.selectedNode.setPaddingTop(null);
                } else if (parsed != null) {
                    this.selectedNode.setPaddingTop(parsed);
                }
            });
            class_342 padR = this.addField(x, y += 22, w, "Padding Right");
            padR.method_1852(this.selectedNode.getPaddingRightRaw() == null ? "" : String.valueOf(this.selectedNode.getPaddingRightRaw()));
            padR.method_1863(v -> {
                Integer parsed = this.tryParseInt((String)v);
                if (v == null || v.trim().isEmpty()) {
                    this.selectedNode.setPaddingRight(null);
                } else if (parsed != null) {
                    this.selectedNode.setPaddingRight(parsed);
                }
            });
            class_342 padB = this.addField(x, y += 22, w, "Padding Bottom");
            padB.method_1852(this.selectedNode.getPaddingBottomRaw() == null ? "" : String.valueOf(this.selectedNode.getPaddingBottomRaw()));
            padB.method_1863(v -> {
                Integer parsed = this.tryParseInt((String)v);
                if (v == null || v.trim().isEmpty()) {
                    this.selectedNode.setPaddingBottom(null);
                } else if (parsed != null) {
                    this.selectedNode.setPaddingBottom(parsed);
                }
            });
            class_342 padL = this.addField(x, y += 22, w, "Padding Left");
            padL.method_1852(this.selectedNode.getPaddingLeftRaw() == null ? "" : String.valueOf(this.selectedNode.getPaddingLeftRaw()));
            padL.method_1863(v -> {
                Integer parsed = this.tryParseInt((String)v);
                if (v == null || v.trim().isEmpty()) {
                    this.selectedNode.setPaddingLeft(null);
                } else if (parsed != null) {
                    this.selectedNode.setPaddingLeft(parsed);
                }
            });
            class_342 marginBox = this.addField(x, y += 22, w, "Margin");
            marginBox.method_1852(this.selectedNode.getMargin() == null ? "" : String.valueOf(this.selectedNode.getMargin()));
            marginBox.method_1863(v -> {
                Integer parsed = this.tryParseInt((String)v);
                if (v == null || v.trim().isEmpty()) {
                    this.selectedNode.setMargin(null);
                } else if (parsed != null) {
                    this.selectedNode.setMargin(parsed);
                }
            });
            class_342 marT = this.addField(x, y += 22, w, "Margin Top");
            marT.method_1852(this.selectedNode.getMarginTopRaw() == null ? "" : String.valueOf(this.selectedNode.getMarginTopRaw()));
            marT.method_1863(v -> {
                Integer parsed = this.tryParseInt((String)v);
                if (v == null || v.trim().isEmpty()) {
                    this.selectedNode.setMarginTop(null);
                } else if (parsed != null) {
                    this.selectedNode.setMarginTop(parsed);
                }
            });
            class_342 marR = this.addField(x, y += 22, w, "Margin Right");
            marR.method_1852(this.selectedNode.getMarginRightRaw() == null ? "" : String.valueOf(this.selectedNode.getMarginRightRaw()));
            marR.method_1863(v -> {
                Integer parsed = this.tryParseInt((String)v);
                if (v == null || v.trim().isEmpty()) {
                    this.selectedNode.setMarginRight(null);
                } else if (parsed != null) {
                    this.selectedNode.setMarginRight(parsed);
                }
            });
            class_342 marB = this.addField(x, y += 22, w, "Margin Bottom");
            marB.method_1852(this.selectedNode.getMarginBottomRaw() == null ? "" : String.valueOf(this.selectedNode.getMarginBottomRaw()));
            marB.method_1863(v -> {
                Integer parsed = this.tryParseInt((String)v);
                if (v == null || v.trim().isEmpty()) {
                    this.selectedNode.setMarginBottom(null);
                } else if (parsed != null) {
                    this.selectedNode.setMarginBottom(parsed);
                }
            });
            class_342 marL = this.addField(x, y += 22, w, "Margin Left");
            marL.method_1852(this.selectedNode.getMarginLeftRaw() == null ? "" : String.valueOf(this.selectedNode.getMarginLeftRaw()));
            marL.method_1863(v -> {
                Integer parsed = this.tryParseInt((String)v);
                if (v == null || v.trim().isEmpty()) {
                    this.selectedNode.setMarginLeft(null);
                } else if (parsed != null) {
                    this.selectedNode.setMarginLeft(parsed);
                }
            });
            y += 22;
        } else if (this.activeRightTab == RightTab.APPEARANCE) {
            class_342 shadowBox = this.addField(x, y, w, "Shadow");
            shadowBox.method_1852(this.selectedNode.getShadow() == null ? "" : this.selectedNode.getShadow());
            shadowBox.method_1863(v -> this.selectedNode.setShadow(v == null || v.isEmpty() ? null : v));
            class_342 opacityBox = this.addField(x, y += 22, w, "Opacity");
            opacityBox.method_1852(this.selectedNode.getOpacity() == null ? "" : String.valueOf(this.selectedNode.getOpacity()));
            opacityBox.method_1863(v -> {
                Float parsed = this.tryParseFloat((String)v);
                if (v == null || v.trim().isEmpty()) {
                    this.selectedNode.setOpacity(null);
                } else if (parsed != null) {
                    this.selectedNode.setOpacity(parsed);
                }
            });
            class_342 rotationBox = this.addField(x, y += 22, w, "Rotation");
            rotationBox.method_1852(this.selectedNode.getRotation() == null ? "" : String.valueOf(this.selectedNode.getRotation()));
            rotationBox.method_1863(v -> {
                Float parsed = this.tryParseFloat((String)v);
                if (v == null || v.trim().isEmpty()) {
                    this.selectedNode.setRotation(null);
                } else if (parsed != null) {
                    this.selectedNode.setRotation(parsed);
                }
            });
            class_342 scaleBox = this.addField(x, y += 22, w, "Scale");
            scaleBox.method_1852(this.selectedNode.getScale() == null ? "" : String.valueOf(this.selectedNode.getScale()));
            scaleBox.method_1863(v -> {
                Float parsed = this.tryParseFloat((String)v);
                if (v == null || v.trim().isEmpty()) {
                    this.selectedNode.setScale(null);
                } else if (parsed != null) {
                    this.selectedNode.setScale(parsed);
                }
            });
            class_342 visibleBox = this.addField(x, y += 22, w, "Visible");
            visibleBox.method_1852(this.selectedNode.getVisible() == null ? "" : this.selectedNode.getVisible());
            visibleBox.method_1863(v -> this.selectedNode.setVisible(v == null || v.isEmpty() ? null : v));
            class_342 bgRaw = this.addField(x, y += 22, w, "Background");
            bgRaw.method_1852(this.selectedNode.getBackground() == null ? "" : this.selectedNode.getBackground());
            bgRaw.method_1863(v -> {
                this.selectedNode.setBackground(v == null || v.isEmpty() ? null : v);
                this.deriveBgFromNode();
            });
            this.addRowButton(x, y += 22, w, "BG Mode", BasicThemeEditorScreen.bgModeLabel(this.bgMode), b -> {
                this.bgMode = BasicThemeEditorScreen.nextBgMode(this.bgMode);
                this.applyBgToNode();
                this.rebuildPropertyWidgets();
            });
            y += 24;
            if (this.bgMode == BackgroundMode.SOLID) {
                class_342 solid = this.addField(x, y, w, "Color");
                solid.method_1852(this.bgSolid);
                solid.method_1863(v -> {
                    this.bgSolid = v;
                    this.applyBgToNode();
                });
                y += 22;
            } else if (this.bgMode == BackgroundMode.LINEAR || this.bgMode == BackgroundMode.RADIAL) {
                class_342 a = this.addField(x, y, w, "A");
                a.method_1852(this.bgA);
                a.method_1863(v -> {
                    this.bgA = v;
                    this.applyBgToNode();
                });
                class_342 b2 = this.addField(x, y += 22, w, "B");
                b2.method_1852(this.bgB);
                b2.method_1863(v -> {
                    this.bgB = v;
                    this.applyBgToNode();
                });
                y += 22;
                if (this.bgMode == BackgroundMode.LINEAR) {
                    class_342 ang = this.addField(x, y, w, "Angle");
                    ang.method_1852(this.bgAngle);
                    ang.method_1863(v -> {
                        this.bgAngle = v;
                        this.applyBgToNode();
                    });
                    y += 22;
                }
            }
            boolean borderOn = this.selectedNode.getBorderColor() != null && !this.selectedNode.getBorderColor().isEmpty();
            this.addRowButton(x, y += 4, w, "Border", borderOn ? "On" : "Off", b -> {
                if (this.selectedNode.getBorderColor() == null || this.selectedNode.getBorderColor().isEmpty()) {
                    this.selectedNode.setBorderColor("#FF888888");
                    if (this.selectedNode.getBorderWidth() == null) {
                        this.selectedNode.setBorderWidth(1);
                    }
                    if (this.selectedNode.getBorderRadius() == null) {
                        this.selectedNode.setBorderRadius(0);
                    }
                } else {
                    this.selectedNode.setBorderColor(null);
                    this.selectedNode.setBorderWidth(null);
                    this.selectedNode.setBorderRadius(null);
                }
                this.rebuildPropertyWidgets();
            });
            y += 24;
            if (this.selectedNode.getBorderColor() != null && !this.selectedNode.getBorderColor().isEmpty()) {
                class_342 bc = this.addField(x, y, w, "Border Color");
                bc.method_1852(this.selectedNode.getBorderColor());
                bc.method_1863(v -> this.selectedNode.setBorderColor(v == null || v.isEmpty() ? null : v));
                class_342 bw = this.addField(x, y += 22, w, "Border Width");
                bw.method_1852(this.selectedNode.getBorderWidth() == null ? "" : String.valueOf(this.selectedNode.getBorderWidth()));
                bw.method_1863(v -> {
                    Integer parsed = this.tryParseInt((String)v);
                    if (v == null || v.trim().isEmpty()) {
                        this.selectedNode.setBorderWidth(null);
                    } else if (parsed != null) {
                        this.selectedNode.setBorderWidth(parsed);
                    }
                });
                class_342 br = this.addField(x, y += 22, w, "Border Radius");
                br.method_1852(this.selectedNode.getBorderRadius() == null ? "" : String.valueOf(this.selectedNode.getBorderRadius()));
                br.method_1863(v -> {
                    Integer parsed = this.tryParseInt((String)v);
                    if (v == null || v.trim().isEmpty()) {
                        this.selectedNode.setBorderRadius(null);
                    } else if (parsed != null) {
                        this.selectedNode.setBorderRadius(parsed);
                    }
                });
                y += 22;
            }
        } else if (this.activeRightTab == RightTab.HOVER) {
            class_342 hoverBg = this.addField(x, y, w, "Hover Background");
            hoverBg.method_1852(this.getHoverValue("background"));
            hoverBg.method_1863(v -> this.setHoverValue("background", (String)v));
            class_342 hoverBorder = this.addField(x, y += 22, w, "Hover Border Color");
            hoverBorder.method_1852(this.getHoverValue("borderColor"));
            hoverBorder.method_1863(v -> this.setHoverValue("borderColor", (String)v));
            class_342 hoverBorderWidth = this.addField(x, y += 22, w, "Hover Border Width");
            hoverBorderWidth.method_1852(this.getHoverValue("borderWidth"));
            hoverBorderWidth.method_1863(v -> this.setHoverValue("borderWidth", (String)v));
            class_342 hoverBorderRadius = this.addField(x, y += 22, w, "Hover Border Radius");
            hoverBorderRadius.method_1852(this.getHoverValue("borderRadius"));
            hoverBorderRadius.method_1863(v -> this.setHoverValue("borderRadius", (String)v));
            class_342 hoverShadow = this.addField(x, y += 22, w, "Hover Shadow");
            hoverShadow.method_1852(this.getHoverValue("shadow"));
            hoverShadow.method_1863(v -> this.setHoverValue("shadow", (String)v));
            class_342 hoverOpacity = this.addField(x, y += 22, w, "Hover Opacity");
            hoverOpacity.method_1852(this.getHoverValue("opacity"));
            hoverOpacity.method_1863(v -> this.setHoverValue("opacity", (String)v));
            class_342 hoverRotation = this.addField(x, y += 22, w, "Hover Rotation");
            hoverRotation.method_1852(this.getHoverValue("rotation"));
            hoverRotation.method_1863(v -> this.setHoverValue("rotation", (String)v));
            class_342 hoverScale = this.addField(x, y += 22, w, "Hover Scale");
            hoverScale.method_1852(this.getHoverValue("scale"));
            hoverScale.method_1863(v -> this.setHoverValue("scale", (String)v));
            y += 26;
        } else if (this.activeRightTab == RightTab.TYPE) {
            PanelNode panelNode = this.selectedNode;
            if (panelNode instanceof VStackNode) {
                VStackNode v2 = (VStackNode)panelNode;
                spacing = this.addField(x, y, w, "Spacing");
                spacing.method_1852(v2.getSpacing() == null ? "" : String.valueOf(v2.getSpacing()));
                spacing.method_1863(val -> {
                    Integer parsed = this.tryParseInt((String)val);
                    if (val == null || val.trim().isEmpty()) {
                        v2.setSpacing(null);
                    } else if (parsed != null) {
                        v2.setSpacing(parsed);
                    }
                });
                y += 22;
            } else {
                spacing = this.selectedNode;
                if (spacing instanceof HStackNode) {
                    HStackNode h = (HStackNode)spacing;
                    spacing = this.addField(x, y, w, "Spacing");
                    spacing.method_1852(h.getSpacing() == null ? "" : String.valueOf(h.getSpacing()));
                    spacing.method_1863(val -> {
                        Integer parsed = this.tryParseInt((String)val);
                        if (val == null || val.trim().isEmpty()) {
                            h.setSpacing(null);
                        } else if (parsed != null) {
                            h.setSpacing(parsed);
                        }
                    });
                    y += 22;
                } else {
                    spacing = this.selectedNode;
                    if (spacing instanceof GridNode) {
                        GridNode g = (GridNode)spacing;
                        cols = this.addField(x, y, w, "Columns");
                        cols.method_1852(g.getColumns() == null ? "" : String.valueOf(g.getColumns()));
                        cols.method_1863(val -> {
                            Integer parsed = this.tryParseInt((String)val);
                            if (val == null || val.trim().isEmpty()) {
                                g.setColumns(null);
                            } else if (parsed != null) {
                                g.setColumns(parsed);
                            }
                        });
                        class_342 rows = this.addField(x, y += 22, w, "Rows");
                        rows.method_1852(g.getRows() == null ? "" : String.valueOf(g.getRows()));
                        rows.method_1863(val -> {
                            Integer parsed = this.tryParseInt((String)val);
                            if (val == null || val.trim().isEmpty()) {
                                g.setRows(null);
                            } else if (parsed != null) {
                                g.setRows(parsed);
                            }
                        });
                        class_342 gap = this.addField(x, y += 22, w, "Gap");
                        gap.method_1852(g.getGap() == null ? "" : String.valueOf(g.getGap()));
                        gap.method_1863(val -> {
                            Integer parsed = this.tryParseInt((String)val);
                            if (val == null || val.trim().isEmpty()) {
                                g.setGap(null);
                            } else if (parsed != null) {
                                g.setGap(parsed);
                            }
                        });
                        y += 22;
                    } else {
                        cols = this.selectedNode;
                        if (cols instanceof TextNode) {
                            TextNode t = (TextNode)cols;
                            this.addRowButton(x, y, w, "Text", "Edit", b -> {
                                if (this.field_22787 != null) {
                                    MultilineTextEditorScreen ed = new MultilineTextEditorScreen(this, t.getText(), out -> {
                                        t.setText((String)out);
                                        if (this.field_22787 != null) {
                                            this.field_22787.method_1507((class_437)this);
                                        }
                                    });
                                    ed.setMode(MultilineTextEditorScreen.EditorMode.TEXT);
                                    this.field_22787.method_1507((class_437)ed);
                                }
                            });
                            color = this.addField(x, y += 24, w, "Color");
                            color.method_1852(t.getColor() == null ? "" : t.getColor());
                            color.method_1863(val -> t.setColor(val == null || val.isEmpty() ? null : val));
                            class_342 font = this.addField(x, y += 22, w, "Font");
                            font.method_1852(t.getFont() == null ? "" : t.getFont());
                            font.method_1863(val -> t.setFont(val == null || val.isEmpty() ? null : val));
                            class_342 textAlign = this.addField(x, y += 22, w, "Text Align");
                            textAlign.method_1852(t.getTextAlign() == null ? "" : t.getTextAlign());
                            textAlign.method_1863(val -> t.setTextAlign(val == null || val.isEmpty() ? null : val));
                            class_342 textShadow = this.addField(x, y += 22, w, "Text Shadow");
                            textShadow.method_1852(t.getTextShadow() == null ? "" : t.getTextShadow());
                            textShadow.method_1863(val -> t.setTextShadow(val == null || val.isEmpty() ? null : val));
                            class_342 fontSize = this.addField(x, y += 22, w, "Font Size");
                            fontSize.method_1852(t.getFontSize() == null ? "" : String.valueOf(t.getFontSize()));
                            fontSize.method_1863(val -> {
                                Float parsed = this.tryParseFloat((String)val);
                                if (val == null || val.trim().isEmpty()) {
                                    t.setFontSize(null);
                                } else if (parsed != null) {
                                    t.setFontSize(parsed);
                                }
                            });
                            class_342 bold = this.addField(x, y += 22, w, "Bold (true/false)");
                            bold.method_1852(t.getBold() == null ? "" : String.valueOf(t.getBold()));
                            bold.method_1863(val -> {
                                if (val == null || val.trim().isEmpty()) {
                                    t.setBold(null);
                                } else {
                                    t.setBold(Boolean.parseBoolean(val.trim()));
                                }
                            });
                            class_342 italic = this.addField(x, y += 22, w, "Italic (true/false)");
                            italic.method_1852(t.getItalic() == null ? "" : String.valueOf(t.getItalic()));
                            italic.method_1863(val -> {
                                if (val == null || val.trim().isEmpty()) {
                                    t.setItalic(null);
                                } else {
                                    t.setItalic(Boolean.parseBoolean(val.trim()));
                                }
                            });
                            class_342 lineHeight = this.addField(x, y += 22, w, "Line Height");
                            lineHeight.method_1852(t.getLineHeight() == null ? "" : t.getLineHeight());
                            lineHeight.method_1863(val -> t.setLineHeight(val == null || val.isEmpty() ? null : val));
                            class_342 wrap = this.addField(x, y += 22, w, "Wrap (true/false)");
                            wrap.method_1852(t.getWrap() == null ? "" : String.valueOf(t.getWrap()));
                            wrap.method_1863(val -> {
                                if (val == null || val.trim().isEmpty()) {
                                    t.setWrap(null);
                                } else {
                                    t.setWrap(Boolean.parseBoolean(val.trim()));
                                }
                            });
                            y += 22;
                        } else {
                            color = this.selectedNode;
                            if (color instanceof RichTextNode) {
                                RichTextNode rt = (RichTextNode)color;
                                this.addRowButton(x, y, w, "Rich Text", "Edit", b -> {
                                    if (this.field_22787 != null) {
                                        MultilineTextEditorScreen ed = new MultilineTextEditorScreen(this, rt.getText(), out -> {
                                            rt.setText((String)out);
                                            if (this.field_22787 != null) {
                                                this.field_22787.method_1507((class_437)this);
                                            }
                                        });
                                        ed.setMode(MultilineTextEditorScreen.EditorMode.FORMATTED);
                                        this.field_22787.method_1507((class_437)ed);
                                    }
                                });
                                color = this.addField(x, y += 24, w, "Color");
                                color.method_1852(rt.getColor() == null ? "" : rt.getColor());
                                color.method_1863(val -> rt.setColor(val == null || val.isEmpty() ? null : val));
                                y += 22;
                            } else {
                                color = this.selectedNode;
                                if (color instanceof IconNode) {
                                    IconNode ic = (IconNode)color;
                                    valBox = this.addField(x, y, w, "Value");
                                    valBox.method_1852(ic.getValue() == null ? "" : ic.getValue());
                                    valBox.method_1863(val -> ic.setValue(val == null || val.isEmpty() ? null : val));
                                    class_342 size = this.addField(x, y += 22, w, "Size");
                                    size.method_1852(ic.getSize() == null ? "" : String.valueOf(ic.getSize()));
                                    size.method_1863(val -> {
                                        Integer parsed = this.tryParseInt((String)val);
                                        if (val == null || val.trim().isEmpty()) {
                                            ic.setSize(null);
                                        } else if (parsed != null) {
                                            ic.setSize(parsed);
                                        }
                                    });
                                    y += 22;
                                } else {
                                    valBox = this.selectedNode;
                                    if (valBox instanceof ImageNode) {
                                        ImageNode im = (ImageNode)valBox;
                                        src = this.addField(x, y, w, "Src");
                                        src.method_1852(im.getSrc() == null ? "" : im.getSrc());
                                        src.method_1863(val -> im.setSrc(val == null || val.isEmpty() ? null : val));
                                        class_342 fit = this.addField(x, y += 22, w, "Fit");
                                        fit.method_1852(im.getFit() == null ? "" : im.getFit());
                                        fit.method_1863(val -> im.setFit(val == null || val.isEmpty() ? null : val));
                                        class_342 iw = this.addField(x, y += 22, w, "Image Width");
                                        iw.method_1852(im.getImageWidth() == null ? "" : String.valueOf(im.getImageWidth()));
                                        iw.method_1863(val -> {
                                            Integer parsed = this.tryParseInt((String)val);
                                            if (val == null || val.trim().isEmpty()) {
                                                im.setImageWidth(null);
                                            } else if (parsed != null) {
                                                im.setImageWidth(parsed);
                                            }
                                        });
                                        class_342 ih = this.addField(x, y += 22, w, "Image Height");
                                        ih.method_1852(im.getImageHeight() == null ? "" : String.valueOf(im.getImageHeight()));
                                        ih.method_1863(val -> {
                                            Integer parsed = this.tryParseInt((String)val);
                                            if (val == null || val.trim().isEmpty()) {
                                                im.setImageHeight(null);
                                            } else if (parsed != null) {
                                                im.setImageHeight(parsed);
                                            }
                                        });
                                        y += 22;
                                    } else {
                                        src = this.selectedNode;
                                        if (src instanceof ImageListNode) {
                                            ImageListNode il = (ImageListNode)src;
                                            items = this.addField(x, y, w, "Items");
                                            items.method_1852(il.getItems() == null ? "" : il.getItems());
                                            items.method_1863(val -> il.setItems(val == null || val.isEmpty() ? null : val));
                                            class_342 maxW = this.addField(x, y += 22, w, "Max Width");
                                            maxW.method_1852(il.getMaxWidth() == null ? "" : il.getMaxWidth());
                                            maxW.method_1863(val -> il.setMaxWidth(val == null || val.isEmpty() ? null : val));
                                            y += 22;
                                        } else {
                                            items = this.selectedNode;
                                            if (items instanceof ListNode) {
                                                ListNode ln = (ListNode)items;
                                                items = this.addField(x, y, w, "Items");
                                                items.method_1852(ln.getItems() == null ? "" : ln.getItems());
                                                items.method_1863(val -> ln.setItems(val == null || val.isEmpty() ? null : val));
                                                this.addRowButton(x, y += 22, w, "Item Template", "Edit", b -> {
                                                    if (ln.getItemTemplate() == null) {
                                                        VStackNode root = new VStackNode();
                                                        root.setId("item");
                                                        ln.setItemTemplate(root);
                                                    }
                                                    this.selectedNode = ln.getItemTemplate();
                                                    this.rebuildPropertyWidgets();
                                                });
                                                y += 24;
                                            } else {
                                                items = this.selectedNode;
                                                if (items instanceof ScrollNode) {
                                                    ScrollNode sc = (ScrollNode)items;
                                                    this.addRowButton(x, y, w, "Child", "Edit", b -> {
                                                        if (sc.getChild() == null) {
                                                            VStackNode root = new VStackNode();
                                                            root.setId("scroll_child");
                                                            sc.setChild(root);
                                                        }
                                                        this.selectedNode = sc.getChild();
                                                        this.rebuildPropertyWidgets();
                                                    });
                                                    y += 24;
                                                } else {
                                                    items = this.selectedNode;
                                                    if (items instanceof ConditionalNode) {
                                                        ConditionalNode cn = (ConditionalNode)items;
                                                        when = this.addField(x, y, w, "When");
                                                        when.method_1852(cn.getWhen() == null ? "" : cn.getWhen());
                                                        when.method_1863(val -> cn.setWhen(val == null || val.isEmpty() ? null : val));
                                                        this.addRowButton(x, y += 22, w, "Child", "Edit", b -> {
                                                            if (cn.getChild() == null) {
                                                                VStackNode root = new VStackNode();
                                                                root.setId("cond_child");
                                                                cn.setChild(root);
                                                            }
                                                            this.selectedNode = cn.getChild();
                                                            this.rebuildPropertyWidgets();
                                                        });
                                                        y += 24;
                                                    } else {
                                                        when = this.selectedNode;
                                                        if (when instanceof ButtonNode) {
                                                            ButtonNode bn = (ButtonNode)when;
                                                            text = this.addField(x, y, w, "Text");
                                                            text.method_1852(bn.getText() == null ? "" : bn.getText());
                                                            text.method_1863(val -> bn.setText(val == null || val.isEmpty() ? null : val));
                                                            class_342 enabled = this.addField(x, y += 22, w, "Enabled");
                                                            enabled.method_1852(bn.getEnabled() == null ? "" : bn.getEnabled());
                                                            enabled.method_1863(val -> bn.setEnabled(val == null || val.isEmpty() ? null : val));
                                                            class_342 onClick = this.addField(x, y += 22, w, "On Click");
                                                            onClick.method_1852(bn.getOnClick() == null ? "" : bn.getOnClick());
                                                            onClick.method_1863(val -> bn.setOnClick(val == null || val.isEmpty() ? null : val));
                                                            y += 22;
                                                        } else {
                                                            text = this.selectedNode;
                                                            if (text instanceof SpacerNode) {
                                                                SpacerNode sp = (SpacerNode)text;
                                                                size = this.addField(x, y, w, "Size");
                                                                size.method_1852(sp.getSize() == null ? "" : String.valueOf(sp.getSize()));
                                                                size.method_1863(val -> {
                                                                    Integer parsed = this.tryParseInt((String)val);
                                                                    if (val == null || val.trim().isEmpty()) {
                                                                        sp.setSize(null);
                                                                    } else if (parsed != null) {
                                                                        sp.setSize(parsed);
                                                                    }
                                                                });
                                                                y += 22;
                                                            } else {
                                                                size = this.selectedNode;
                                                                if (size instanceof ProgressBarNode) {
                                                                    ProgressBarNode pb = (ProgressBarNode)size;
                                                                    value = this.addField(x, y, w, "Value");
                                                                    value.method_1852(pb.getValue() == null ? "" : pb.getValue());
                                                                    value.method_1863(val -> pb.setValue(val == null || val.isEmpty() ? null : val));
                                                                    class_342 max = this.addField(x, y += 22, w, "Max");
                                                                    max.method_1852(pb.getMax() == null ? "" : pb.getMax());
                                                                    max.method_1863(val -> pb.setMax(val == null || val.isEmpty() ? null : val));
                                                                    class_342 color = this.addField(x, y += 22, w, "Color");
                                                                    color.method_1852(pb.getColor() == null ? "" : pb.getColor());
                                                                    color.method_1863(val -> pb.setColor(val == null || val.isEmpty() ? null : val));
                                                                    class_342 bg = this.addField(x, y += 22, w, "Background Color");
                                                                    bg.method_1852(pb.getBackgroundColor() == null ? "" : pb.getBackgroundColor());
                                                                    bg.method_1863(val -> pb.setBackgroundColor(val == null || val.isEmpty() ? null : val));
                                                                    class_342 dir = this.addField(x, y += 22, w, "Direction");
                                                                    dir.method_1852(pb.getDirection() == null ? "" : pb.getDirection());
                                                                    dir.method_1863(val -> pb.setDirection(val == null || val.isEmpty() ? null : val));
                                                                    class_342 barH = this.addField(x, y += 22, w, "Bar Height");
                                                                    barH.method_1852(pb.getBarHeight() == null ? "" : String.valueOf(pb.getBarHeight()));
                                                                    barH.method_1863(val -> {
                                                                        Integer parsed = this.tryParseInt((String)val);
                                                                        if (val == null || val.trim().isEmpty()) {
                                                                            pb.setBarHeight(null);
                                                                        } else if (parsed != null) {
                                                                            pb.setBarHeight(parsed);
                                                                        }
                                                                    });
                                                                    y += 22;
                                                                } else {
                                                                    value = this.selectedNode;
                                                                    if (value instanceof SliderNode) {
                                                                        SliderNode sl = (SliderNode)value;
                                                                        min = this.addField(x, y, w, "Min");
                                                                        min.method_1852(sl.getMin() == null ? "" : sl.getMin());
                                                                        min.method_1863(val -> sl.setMin(val == null || val.isEmpty() ? null : val));
                                                                        class_342 max = this.addField(x, y += 22, w, "Max");
                                                                        max.method_1852(sl.getMax() == null ? "" : sl.getMax());
                                                                        max.method_1863(val -> sl.setMax(val == null || val.isEmpty() ? null : val));
                                                                        class_342 value = this.addField(x, y += 22, w, "Value");
                                                                        value.method_1852(sl.getValue() == null ? "" : sl.getValue());
                                                                        value.method_1863(val -> sl.setValue(val == null || val.isEmpty() ? null : val));
                                                                        class_342 step = this.addField(x, y += 22, w, "Step");
                                                                        step.method_1852(sl.getStep() == null ? "" : String.valueOf(sl.getStep()));
                                                                        step.method_1863(val -> {
                                                                            Double parsed = this.tryParseDouble((String)val);
                                                                            if (val == null || val.trim().isEmpty()) {
                                                                                sl.setStep(null);
                                                                            } else if (parsed != null) {
                                                                                sl.setStep(parsed);
                                                                            }
                                                                        });
                                                                        class_342 onChange = this.addField(x, y += 22, w, "On Change");
                                                                        onChange.method_1852(sl.getOnChange() == null ? "" : sl.getOnChange());
                                                                        onChange.method_1863(val -> sl.setOnChange(val == null || val.isEmpty() ? null : val));
                                                                        class_342 trackColor = this.addField(x, y += 22, w, "Track Color");
                                                                        trackColor.method_1852(sl.getTrackColor() == null ? "" : sl.getTrackColor());
                                                                        trackColor.method_1863(val -> sl.setTrackColor(val == null || val.isEmpty() ? null : val));
                                                                        class_342 thumbColor = this.addField(x, y += 22, w, "Thumb Color");
                                                                        thumbColor.method_1852(sl.getThumbColor() == null ? "" : sl.getThumbColor());
                                                                        thumbColor.method_1863(val -> sl.setThumbColor(val == null || val.isEmpty() ? null : val));
                                                                        class_342 trackH = this.addField(x, y += 22, w, "Track Height");
                                                                        trackH.method_1852(sl.getTrackHeight() == null ? "" : String.valueOf(sl.getTrackHeight()));
                                                                        trackH.method_1863(val -> {
                                                                            Integer parsed = this.tryParseInt((String)val);
                                                                            if (val == null || val.trim().isEmpty()) {
                                                                                sl.setTrackHeight(null);
                                                                            } else if (parsed != null) {
                                                                                sl.setTrackHeight(parsed);
                                                                            }
                                                                        });
                                                                        y += 22;
                                                                    } else {
                                                                        min = this.selectedNode;
                                                                        if (min instanceof DividerNode) {
                                                                            DividerNode dv = (DividerNode)min;
                                                                            orientation = this.addField(x, y, w, "Orientation");
                                                                            orientation.method_1852(dv.getOrientation() == null ? "" : dv.getOrientation());
                                                                            orientation.method_1863(val -> dv.setOrientation(val == null || val.isEmpty() ? null : val));
                                                                            class_342 thickness = this.addField(x, y += 22, w, "Thickness");
                                                                            thickness.method_1852(dv.getThickness() == null ? "" : String.valueOf(dv.getThickness()));
                                                                            thickness.method_1863(val -> {
                                                                                Integer parsed = this.tryParseInt((String)val);
                                                                                if (val == null || val.trim().isEmpty()) {
                                                                                    dv.setThickness(null);
                                                                                } else if (parsed != null) {
                                                                                    dv.setThickness(parsed);
                                                                                }
                                                                            });
                                                                            class_342 color = this.addField(x, y += 22, w, "Color");
                                                                            color.method_1852(dv.getColor() == null ? "" : dv.getColor());
                                                                            color.method_1863(val -> dv.setColor(val == null || val.isEmpty() ? null : val));
                                                                            class_342 style = this.addField(x, y += 22, w, "Style");
                                                                            style.method_1852(dv.getStyle() == null ? "" : dv.getStyle());
                                                                            style.method_1863(val -> dv.setStyle(val == null || val.isEmpty() ? null : val));
                                                                            y += 22;
                                                                        } else {
                                                                            orientation = this.selectedNode;
                                                                            if (orientation instanceof TabContainerNode) {
                                                                                TabContainerNode tc = (TabContainerNode)orientation;
                                                                                class_342 selectedTab = new class_342(this.field_22793, x, y, w, 18, (class_2561)class_2561.method_43470((String)"Selected Tab"));
                                                                                selectedTab.method_1852(tc.getSelectedTab() == null ? "" : tc.getSelectedTab());
                                                                                selectedTab.method_1863(val -> tc.setSelectedTab(val == null || val.isEmpty() ? null : val));
                                                                                this.addProp((class_339)selectedTab);
                                                                                class_342 tabPosition = new class_342(this.field_22793, x, y += 22, w, 18, (class_2561)class_2561.method_43470((String)"Tab Position"));
                                                                                tabPosition.method_1852(tc.getTabPosition() == null ? "" : tc.getTabPosition());
                                                                                tabPosition.method_1863(val -> tc.setTabPosition(val == null || val.isEmpty() ? null : val));
                                                                                this.addProp((class_339)tabPosition);
                                                                                class_342 tabSpacing = new class_342(this.field_22793, x, y += 22, w, 18, (class_2561)class_2561.method_43470((String)"Tab Spacing"));
                                                                                tabSpacing.method_1852(tc.getTabSpacing() == null ? "" : String.valueOf(tc.getTabSpacing()));
                                                                                tabSpacing.method_1863(val -> {
                                                                                    Integer parsed = this.tryParseInt((String)val);
                                                                                    if (val == null || val.trim().isEmpty()) {
                                                                                        tc.setTabSpacing(null);
                                                                                    } else if (parsed != null) {
                                                                                        tc.setTabSpacing(parsed);
                                                                                    }
                                                                                });
                                                                                this.addProp((class_339)tabSpacing);
                                                                                class_342 tabBg = new class_342(this.field_22793, x, y += 22, w, 18, (class_2561)class_2561.method_43470((String)"Tab Background"));
                                                                                tabBg.method_1852(tc.getTabBackground() == null ? "" : tc.getTabBackground());
                                                                                tabBg.method_1863(val -> tc.setTabBackground(val == null || val.isEmpty() ? null : val));
                                                                                this.addProp((class_339)tabBg);
                                                                                class_342 activeTabBg = new class_342(this.field_22793, x, y += 22, w, 18, (class_2561)class_2561.method_43470((String)"Active Tab Background"));
                                                                                activeTabBg.method_1852(tc.getActiveTabBackground() == null ? "" : tc.getActiveTabBackground());
                                                                                activeTabBg.method_1863(val -> tc.setActiveTabBackground(val == null || val.isEmpty() ? null : val));
                                                                                this.addProp((class_339)activeTabBg);
                                                                                class_342 tabColor = new class_342(this.field_22793, x, y += 22, w, 18, (class_2561)class_2561.method_43470((String)"Tab Color"));
                                                                                tabColor.method_1852(tc.getTabColor() == null ? "" : tc.getTabColor());
                                                                                tabColor.method_1863(val -> tc.setTabColor(val == null || val.isEmpty() ? null : val));
                                                                                this.addProp((class_339)tabColor);
                                                                                class_342 activeTabColor = new class_342(this.field_22793, x, y += 22, w, 18, (class_2561)class_2561.method_43470((String)"Active Tab Color"));
                                                                                activeTabColor.method_1852(tc.getActiveTabColor() == null ? "" : tc.getActiveTabColor());
                                                                                activeTabColor.method_1863(val -> tc.setActiveTabColor(val == null || val.isEmpty() ? null : val));
                                                                                this.addProp((class_339)activeTabColor);
                                                                                y += 22;
                                                                                if (tc.getTabs() != null) {
                                                                                    for (int i = 0; i < tc.getTabs().size(); ++i) {
                                                                                        TabContainerNode.Tab tab = tc.getTabs().get(i);
                                                                                        if (tab == null) continue;
                                                                                        class_342 tabId = new class_342(this.field_22793, x, y, w, 18, (class_2561)class_2561.method_43470((String)("Tab " + (i + 1) + " Id")));
                                                                                        tabId.method_1852(tab.id == null ? "" : tab.id);
                                                                                        tabId.method_1863(val -> {
                                                                                            tab.id = val == null || val.isEmpty() ? null : val;
                                                                                        });
                                                                                        this.addProp((class_339)tabId);
                                                                                        class_342 tabLabel = new class_342(this.field_22793, x, y += 22, w, 18, (class_2561)class_2561.method_43470((String)("Tab " + (i + 1) + " Label")));
                                                                                        tabLabel.method_1852(tab.label == null ? "" : tab.label);
                                                                                        tabLabel.method_1863(val -> {
                                                                                            tab.label = val == null || val.isEmpty() ? null : val;
                                                                                        });
                                                                                        this.addProp((class_339)tabLabel);
                                                                                        class_342 tabIcon = new class_342(this.field_22793, x, y += 22, w, 18, (class_2561)class_2561.method_43470((String)("Tab " + (i + 1) + " Icon")));
                                                                                        tabIcon.method_1852(tab.icon == null ? "" : tab.icon);
                                                                                        tabIcon.method_1863(val -> {
                                                                                            tab.icon = val == null || val.isEmpty() ? null : val;
                                                                                        });
                                                                                        this.addProp((class_339)tabIcon);
                                                                                        class_342 tabStyle = new class_342(this.field_22793, x, y += 22, w, 18, (class_2561)class_2561.method_43470((String)("Tab " + (i + 1) + " Style")));
                                                                                        tabStyle.method_1852(tab.style == null ? "" : tab.style);
                                                                                        tabStyle.method_1863(val -> {
                                                                                            tab.style = val == null || val.isEmpty() ? null : val;
                                                                                        });
                                                                                        this.addProp((class_339)tabStyle);
                                                                                        class_4185 editContent = class_4185.method_46430((class_2561)class_2561.method_43470((String)("Edit Tab " + (i + 1) + " Content")), b -> {
                                                                                            if (tab.content == null) {
                                                                                                VStackNode root = new VStackNode();
                                                                                                root.setId((tab.id == null ? "tab" : tab.id) + "_content");
                                                                                                tab.content = root;
                                                                                            }
                                                                                            this.selectedNode = tab.content;
                                                                                            this.rebuildPropertyWidgets();
                                                                                        }).method_46434(x, y += 22, w, 20).method_46431();
                                                                                        this.addProp((class_339)editContent);
                                                                                        class_4185 tabUp = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Up"), b -> {
                                                                                            int idx = tc.getTabs().indexOf(tab);
                                                                                            if (idx > 0) {
                                                                                                Collections.swap(tc.getTabs(), idx, idx - 1);
                                                                                                this.rebuildPropertyWidgets();
                                                                                            }
                                                                                        }).method_46434(x, y += 24, 50, 20).method_46431();
                                                                                        this.addProp((class_339)tabUp);
                                                                                        class_4185 tabDown = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Down"), b -> {
                                                                                            int idx = tc.getTabs().indexOf(tab);
                                                                                            if (idx >= 0 && idx < tc.getTabs().size() - 1) {
                                                                                                Collections.swap(tc.getTabs(), idx, idx + 1);
                                                                                                this.rebuildPropertyWidgets();
                                                                                            }
                                                                                        }).method_46434(x + 55, y, 60, 20).method_46431();
                                                                                        this.addProp((class_339)tabDown);
                                                                                        class_4185 tabRemove = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Remove"), b -> {
                                                                                            tc.getTabs().remove(tab);
                                                                                            this.rebuildPropertyWidgets();
                                                                                        }).method_46434(x + 120, y, w - 120, 20).method_46431();
                                                                                        this.addProp((class_339)tabRemove);
                                                                                        y += 24;
                                                                                    }
                                                                                }
                                                                                class_4185 addTab = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Add Tab"), b -> {
                                                                                    TabContainerNode.Tab tab = new TabContainerNode.Tab();
                                                                                    int n = (tc.getTabs() == null ? 0 : tc.getTabs().size()) + 1;
                                                                                    tab.id = "tab" + n;
                                                                                    tab.label = "Tab " + n;
                                                                                    tab.content = new VStackNode();
                                                                                    if (tc.getTabs() != null) {
                                                                                        tc.getTabs().add(tab);
                                                                                    }
                                                                                    this.rebuildPropertyWidgets();
                                                                                }).method_46434(x, y, w, 20).method_46431();
                                                                                this.addProp((class_339)addTab);
                                                                                y += 24;
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else if (this.activeRightTab == RightTab.ACTIONS) {
            this.addRowButton(x, y, w, "Add Child", "Add", b -> {
                this.nodePickerTargetParent = this.pickAddTarget();
                this.isPickingNodeType = true;
                this.nodePickerScrollY = 0.0;
            });
            this.addRowButton(x, y += 24, w, "Up", "Move Up", b -> {
                this.moveSelected(-1);
                this.rebuildPropertyWidgets();
            });
            this.addRowButton(x, y += 24, w, "Down", "Move Down", b -> {
                this.moveSelected(1);
                this.rebuildPropertyWidgets();
            });
            this.addRowButton(x, y += 24, w, "Remove", "Remove", b -> {
                this.removeSelected();
                this.rebuildPropertyWidgets();
            });
            this.addRowButton(x, y += 24, w, "Duplicate", "Duplicate", b -> {
                this.duplicateSelected();
                this.rebuildPropertyWidgets();
            });
            this.addRowButton(x, y += 24, w, "To Root", "To Root", b -> {
                this.selectedNode = this.rootNode;
                this.rebuildPropertyWidgets();
            });
            y += 24;
        } else if (this.activeRightTab == RightTab.JSON) {
            class_4185 jsonBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Edit JSON"), b -> this.openJsonEditor()).method_46434(x, y, w, 20).method_46431();
            this.addProp((class_339)jsonBtn);
            y += 24;
        }
        int bottomY = y + 24;
        int contentTop = 116;
        int visibleH = this.field_22790 - contentTop;
        int contentH = bottomY - 122;
        this.maxRightSidebarScrollY = Math.max(0, contentH - visibleH);
        if (this.rightSidebarScrollY > this.maxRightSidebarScrollY) {
            this.rightSidebarScrollY = this.maxRightSidebarScrollY;
        }
    }

    private Integer tryParseInt(String v) {
        try {
            if (v == null) {
                return null;
            }
            String t = v.trim();
            if (t.isEmpty()) {
                return null;
            }
            return Integer.parseInt(t);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private Float tryParseFloat(String v) {
        try {
            if (v == null) {
                return null;
            }
            String t = v.trim();
            if (t.isEmpty()) {
                return null;
            }
            return Float.valueOf(Float.parseFloat(t));
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private Double tryParseDouble(String v) {
        try {
            if (v == null) {
                return null;
            }
            String t = v.trim();
            if (t.isEmpty()) {
                return null;
            }
            return Double.parseDouble(t);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private void addProp(class_339 w) {
        this.method_37063((class_364)w);
        this.propertyWidgets.add(w);
        this.propertyWidgetBaseY.put(w, w.method_46427());
    }

    private class_342 addField(int x, int y, int w, String label) {
        int fx = x + 110;
        int fw = Math.max(20, w - 110);
        class_342 box = new class_342(this.field_22793, fx, y, fw, 18, (class_2561)class_2561.method_43470((String)label));
        box.method_1880(256);
        this.addProp((class_339)box);
        return box;
    }

    private class_4185 addRowButton(int x, int y, int w, String label, String buttonText, class_4185.class_4241 onPress) {
        int fx = x + 110;
        int fw = Math.max(20, w - 110);
        class_4185 btn = class_4185.method_46430((class_2561)class_2561.method_43470((String)buttonText), (class_4185.class_4241)onPress).method_46434(fx, y, fw, 20).method_46431();
        this.addProp((class_339)btn);
        this.propertyWidgetRowLabels.put((class_339)btn, label);
        return btn;
    }

    private String getHoverValue(String key) {
        if (this.selectedNode == null || key == null) {
            return "";
        }
        JsonObject hover = this.selectedNode.getHoverStyle();
        if (hover == null || !hover.has(key)) {
            return "";
        }
        try {
            return hover.get(key).getAsString();
        }
        catch (Exception e) {
            return hover.get(key).toString();
        }
    }

    private void setHoverValue(String key, String value) {
        if (this.selectedNode == null || key == null) {
            return;
        }
        JsonObject hover = this.selectedNode.getHoverStyle();
        if (hover == null) {
            hover = new JsonObject();
            this.selectedNode.setHoverStyle(hover);
        }
        if (value == null || value.isEmpty()) {
            hover.remove(key);
            if (hover.size() == 0) {
                this.selectedNode.setHoverStyle(null);
            }
            return;
        }
        try {
            if ("borderWidth".equals(key) || "borderRadius".equals(key)) {
                hover.addProperty(key, (Number)Integer.parseInt(value.trim()));
                return;
            }
            if ("opacity".equals(key) || "rotation".equals(key) || "scale".equals(key)) {
                hover.addProperty(key, (Number)Float.valueOf(Float.parseFloat(value.trim())));
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        hover.addProperty(key, value);
    }

    private PanelNode pickAddTarget() {
        if (this.selectedNode == null) {
            return this.rootNode;
        }
        if (this.canContainChildren(this.selectedNode)) {
            return this.selectedNode;
        }
        PanelNode parent = this.findParent(this.rootNode, this.selectedNode);
        return parent != null ? parent : this.rootNode;
    }

    private boolean canContainChildren(PanelNode node) {
        return node instanceof VStackNode || node instanceof HStackNode || node instanceof StackNode || node instanceof GridNode || node instanceof ScrollNode || node instanceof ConditionalNode || node instanceof ListNode || node instanceof TabContainerNode;
    }

    private void moveSelected(int delta) {
        if (this.selectedNode == null || this.selectedNode == this.rootNode) {
            return;
        }
        PanelNode parent = this.findParent(this.rootNode, this.selectedNode);
        if (parent == null) {
            return;
        }
        List<PanelNode> list = this.getMutableChildrenList(parent);
        if (list == null) {
            return;
        }
        int idx = list.indexOf(this.selectedNode);
        int j = idx + delta;
        if (idx < 0 || j < 0 || j >= list.size()) {
            return;
        }
        Collections.swap(list, idx, j);
    }

    private List<PanelNode> getMutableChildrenList(PanelNode node) {
        if (node instanceof VStackNode) {
            VStackNode v = (VStackNode)node;
            return v.getChildren();
        }
        if (node instanceof HStackNode) {
            HStackNode h = (HStackNode)node;
            return h.getChildren();
        }
        if (node instanceof StackNode) {
            StackNode s = (StackNode)node;
            return s.getChildren();
        }
        if (node instanceof GridNode) {
            GridNode g = (GridNode)node;
            return g.getChildren();
        }
        return null;
    }

    private void openJsonEditor() {
        if (this.selectedNode == null || this.field_22787 == null) {
            return;
        }
        String json = new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)this.selectedNode.toJson());
        MultilineTextEditorScreen editor = new MultilineTextEditorScreen(this, json, updated -> {
            this.applyNodeJson((String)updated);
            if (this.field_22787 != null) {
                this.field_22787.method_1507((class_437)this);
            }
        });
        editor.setMode(MultilineTextEditorScreen.EditorMode.JSON);
        editor.setCustomTitle((class_2561)class_2561.method_43470((String)"Node JSON"));
        this.field_22787.method_1507((class_437)editor);
    }

    private void applyNodeJson(String updated) {
        try {
            JsonObject obj = JsonParser.parseString((String)updated).getAsJsonObject();
            PanelNode parsed = PanelNode.fromJson(obj);
            if (parsed == null) {
                return;
            }
            this.replaceNode(this.selectedNode, parsed);
            this.selectedNode = parsed;
            this.rebuildPropertyWidgets();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void replaceNode(PanelNode target, PanelNode replacement) {
        int idx;
        if (target == null || replacement == null) {
            return;
        }
        if (target == this.rootNode) {
            this.rootNode = replacement;
            return;
        }
        PanelNode parent = this.findParent(this.rootNode, target);
        if (parent == null) {
            return;
        }
        List<PanelNode> list = this.getMutableChildrenList(parent);
        if (list != null && (idx = list.indexOf(target)) >= 0) {
            list.set(idx, replacement);
            return;
        }
        if (parent instanceof ScrollNode) {
            ScrollNode sc = (ScrollNode)parent;
            if (sc.getChild() == target) {
                sc.setChild(replacement);
            }
            return;
        }
        if (parent instanceof ConditionalNode) {
            ConditionalNode cn = (ConditionalNode)parent;
            if (cn.getChild() == target) {
                cn.setChild(replacement);
            }
            return;
        }
        if (parent instanceof ListNode) {
            ListNode ln = (ListNode)parent;
            if (ln.getItemTemplate() == target) {
                ln.setItemTemplate(replacement);
            }
            return;
        }
        if (parent instanceof TabContainerNode) {
            TabContainerNode tc = (TabContainerNode)parent;
            for (TabContainerNode.Tab tab : tc.getTabs()) {
                if (tab == null || tab.content != target) continue;
                tab.content = replacement;
                return;
            }
        }
    }

    private void renderNodePicker(class_332 g, int mouseX, int mouseY) {
        g.method_51448().method_22903();
        g.method_51448().method_46416(0.0f, 0.0f, 850.0f);
        g.method_25294(0, 0, this.field_22789, this.field_22790, -872415232);
        int w = 260;
        int listH = 240;
        int x = (this.field_22789 - w) / 2;
        int y = (this.field_22790 - (listH + 40)) / 2;
        g.method_25294(x, y, x + w, y + listH + 40, -14671840);
        g.method_49601(x, y, w, listH + 40, -1);
        g.method_25303(this.field_22793, "Add Node", x + 10, y + 10, -1);
        int listX = x + 10;
        int listY = y + 28;
        int listW = w - 20;
        int itemH = 22;
        g.method_44379(listX, listY, listX + listW, listY + listH);
        int itemY = listY + (int)this.nodePickerScrollY;
        for (String type : NODE_TYPES) {
            boolean hovered = mouseX >= listX && mouseX < listX + listW && mouseY >= itemY && mouseY < itemY + itemH;
            g.method_25294(listX, itemY, listX + listW, itemY + itemH, hovered ? -12566464 : -13619152);
            g.method_25303(this.field_22793, type, listX + 6, itemY + 6, -3355444);
            itemY += itemH + 2;
        }
        g.method_44380();
        g.method_25303(this.field_22793, "Click outside to close", x + 10, y + listH + 20, -5592406);
        g.method_51448().method_22909();
    }

    private void handleNodePickerClick(double mouseX, double mouseY) {
        int idx;
        int w = 260;
        int listH = 240;
        int x = (this.field_22789 - w) / 2;
        int y = (this.field_22790 - (listH + 40)) / 2;
        int listX = x + 10;
        int listY = y + 28;
        int listW = w - 20;
        int itemH = 22;
        if (mouseX >= (double)listX && mouseX < (double)(listX + listW) && mouseY >= (double)listY && mouseY < (double)(listY + listH) && (idx = (int)((mouseY - (double)listY - this.nodePickerScrollY) / (double)(itemH + 2))) >= 0 && idx < NODE_TYPES.length) {
            PanelNode newNode = this.createNode(NODE_TYPES[idx]);
            if (newNode != null) {
                this.addNodeToTarget(this.nodePickerTargetParent, newNode);
                this.selectedNode = newNode;
                this.rebuildPropertyWidgets();
            }
            this.isPickingNodeType = false;
            this.nodePickerTargetParent = null;
            return;
        }
        if (mouseX < (double)x || mouseX > (double)(x + w) || mouseY < (double)y || mouseY > (double)(y + listH + 40)) {
            this.isPickingNodeType = false;
            this.nodePickerTargetParent = null;
        }
    }

    private PanelNode createNode(String type) {
        return switch (type) {
            case "vstack" -> new VStackNode();
            case "hstack" -> new HStackNode();
            case "stack" -> new StackNode();
            case "grid" -> new GridNode();
            case "scroll" -> new ScrollNode();
            case "text" -> {
                TextNode t = new TextNode();
                t.setText("Label");
                yield t;
            }
            case "richtext" -> {
                RichTextNode t = new RichTextNode();
                t.setText("Rich Text");
                yield t;
            }
            case "icon" -> {
                IconNode n = new IconNode();
                n.setValue("minecraft:apple");
                n.setSize(16);
                yield n;
            }
            case "image" -> {
                ImageNode n = new ImageNode();
                n.setSrc("minecraft:textures/item/apple.png");
                yield n;
            }
            case "image_list" -> {
                ImageListNode n = new ImageListNode();
                n.setItems("global.inventory");
                yield n;
            }
            case "list" -> {
                ListNode n = new ListNode();
                n.setItems("global.quests");
                yield n;
            }
            case "button" -> {
                ButtonNode n = new ButtonNode();
                n.setText("Button");
                yield n;
            }
            case "spacer" -> {
                SpacerNode n = new SpacerNode();
                n.setSize(10);
                yield n;
            }
            case "conditional" -> new ConditionalNode();
            case "progress" -> new ProgressBarNode();
            case "slider" -> new SliderNode();
            case "divider" -> new DividerNode();
            case "tabs" -> new TabContainerNode();
            default -> null;
        };
    }

    private void addNodeToTarget(PanelNode parent, PanelNode child) {
        if (parent == null || child == null) {
            return;
        }
        if (parent instanceof VStackNode) {
            VStackNode v = (VStackNode)parent;
            v.getChildren().add(child);
            return;
        }
        if (parent instanceof HStackNode) {
            HStackNode h = (HStackNode)parent;
            h.getChildren().add(child);
            return;
        }
        if (parent instanceof StackNode) {
            StackNode s = (StackNode)parent;
            s.getChildren().add(child);
            return;
        }
        if (parent instanceof GridNode) {
            GridNode g = (GridNode)parent;
            g.getChildren().add(child);
            return;
        }
        if (parent instanceof ScrollNode) {
            ScrollNode sc = (ScrollNode)parent;
            sc.setChild(child);
            return;
        }
        if (parent instanceof ConditionalNode) {
            ConditionalNode cn = (ConditionalNode)parent;
            cn.setChild(child);
            return;
        }
        if (parent instanceof ListNode) {
            ListNode ln = (ListNode)parent;
            ln.setItemTemplate(child);
            return;
        }
        if (parent instanceof TabContainerNode) {
            TabContainerNode.Tab tab;
            TabContainerNode tc = (TabContainerNode)parent;
            if (tc.getTabs().isEmpty()) {
                tab = new TabContainerNode.Tab();
                tab.id = "tab1";
                tab.label = "Tab 1";
                tab.content = new VStackNode();
                tc.getTabs().add(tab);
            }
            tab = tc.getTabs().get(0);
            if (tab.content == null) {
                tab.content = child;
            } else {
                PanelNode panelNode = tab.content;
                if (panelNode instanceof VStackNode) {
                    VStackNode vv = (VStackNode)panelNode;
                    vv.getChildren().add(child);
                } else {
                    panelNode = tab.content;
                    if (panelNode instanceof HStackNode) {
                        HStackNode hh = (HStackNode)panelNode;
                        hh.getChildren().add(child);
                    } else {
                        panelNode = tab.content;
                        if (panelNode instanceof StackNode) {
                            StackNode ss = (StackNode)panelNode;
                            ss.getChildren().add(child);
                        } else {
                            panelNode = tab.content;
                            if (panelNode instanceof GridNode) {
                                GridNode gg = (GridNode)panelNode;
                                gg.getChildren().add(child);
                            } else {
                                tab.content = child;
                            }
                        }
                    }
                }
            }
        }
    }

    private static String bgModeLabel(BackgroundMode m) {
        return switch (m.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> "None";
            case 1 -> "Solid";
            case 2 -> "Linear";
            case 3 -> "Radial";
            case 4 -> "Raw";
        };
    }

    private static BackgroundMode nextBgMode(BackgroundMode m) {
        return switch (m.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 4 -> BackgroundMode.SOLID;
            case 1 -> BackgroundMode.LINEAR;
            case 2 -> BackgroundMode.RADIAL;
            case 3 -> BackgroundMode.AUTO;
            case 0 -> BackgroundMode.RAW;
        };
    }

    private void deriveBgFromNode() {
        String bg = this.selectedNode.getBackground();
        if (bg == null || bg.isEmpty()) {
            this.bgMode = BackgroundMode.AUTO;
            return;
        }
        String s = bg.trim();
        if (s.startsWith("linear-gradient")) {
            try {
                GradientParser.GradientData data = GradientParser.parse(s, this.editorContext);
                if (data != null && data.colors().length == 2) {
                    this.bgMode = BackgroundMode.LINEAR;
                    this.bgA = String.format(Locale.ROOT, "#%08X", data.colors()[0]);
                    this.bgB = String.format(Locale.ROOT, "#%08X", data.colors()[1]);
                    this.bgAngle = String.valueOf((int)data.angle());
                    return;
                }
            }
            catch (Throwable data) {
                // empty catch block
            }
            this.bgMode = BackgroundMode.RAW;
            return;
        }
        if (s.startsWith("radial-gradient")) {
            try {
                GradientParser.GradientData data = GradientParser.parse(s, this.editorContext);
                if (data != null && data.colors().length == 2) {
                    this.bgMode = BackgroundMode.RADIAL;
                    this.bgA = String.format(Locale.ROOT, "#%08X", data.colors()[0]);
                    this.bgB = String.format(Locale.ROOT, "#%08X", data.colors()[1]);
                    return;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.bgMode = BackgroundMode.RAW;
            return;
        }
        if (s.startsWith("#") || s.startsWith("0x") || s.startsWith("0X")) {
            this.bgMode = BackgroundMode.SOLID;
            this.bgSolid = s;
            return;
        }
        this.bgMode = BackgroundMode.RAW;
    }

    private void applyBgToNode() {
        switch (this.bgMode.ordinal()) {
            case 0: {
                this.selectedNode.setBackground(null);
                break;
            }
            case 1: {
                this.selectedNode.setBackground(this.bgSolid == null || this.bgSolid.isEmpty() ? null : this.bgSolid);
                break;
            }
            case 2: {
                String a = this.bgA == null || this.bgA.isEmpty() ? "#FF202020" : this.bgA.trim();
                String b = this.bgB == null || this.bgB.isEmpty() ? "#FF000000" : this.bgB.trim();
                String ang = this.bgAngle == null || this.bgAngle.isEmpty() ? "90" : this.bgAngle.trim();
                this.selectedNode.setBackground("linear-gradient(" + ang + "deg, " + a + ", " + b + ")");
                break;
            }
            case 3: {
                String a = this.bgA == null || this.bgA.isEmpty() ? "#FF202020" : this.bgA.trim();
                String b = this.bgB == null || this.bgB.isEmpty() ? "#FF000000" : this.bgB.trim();
                this.selectedNode.setBackground("radial-gradient(" + a + ", " + b + ")");
                break;
            }
        }
    }

    private void addDefaultChild() {
        PanelNode panelNode = this.selectedNode;
        if (panelNode instanceof VStackNode) {
            VStackNode v = (VStackNode)panelNode;
            t = new TextNode();
            ((TextNode)t).setText("Label");
            v.getChildren().add(t);
        } else {
            t = this.selectedNode;
            if (t instanceof HStackNode) {
                HStackNode h = (HStackNode)t;
                t = new TextNode();
                ((TextNode)t).setText("Label");
                h.getChildren().add(t);
            } else {
                t = this.selectedNode;
                if (t instanceof StackNode) {
                    StackNode s = (StackNode)t;
                    t = new TextNode();
                    ((TextNode)t).setText("Label");
                    s.getChildren().add(t);
                }
            }
        }
    }

    private void removeSelected() {
        block4: {
            PanelNode parent;
            block10: {
                block9: {
                    block8: {
                        block7: {
                            block6: {
                                block5: {
                                    block3: {
                                        if (this.selectedNode == null || this.selectedNode == this.rootNode) {
                                            return;
                                        }
                                        parent = this.findParent(this.rootNode, this.selectedNode);
                                        if (!(parent instanceof VStackNode)) break block3;
                                        VStackNode v = (VStackNode)parent;
                                        v.getChildren().remove(this.selectedNode);
                                        break block4;
                                    }
                                    if (!(parent instanceof HStackNode)) break block5;
                                    HStackNode h = (HStackNode)parent;
                                    h.getChildren().remove(this.selectedNode);
                                    break block4;
                                }
                                if (!(parent instanceof StackNode)) break block6;
                                StackNode s = (StackNode)parent;
                                s.getChildren().remove(this.selectedNode);
                                break block4;
                            }
                            if (!(parent instanceof GridNode)) break block7;
                            GridNode g = (GridNode)parent;
                            g.getChildren().remove(this.selectedNode);
                            break block4;
                        }
                        if (!(parent instanceof ScrollNode)) break block8;
                        ScrollNode sc = (ScrollNode)parent;
                        if (sc.getChild() != this.selectedNode) break block4;
                        sc.setChild(null);
                        break block4;
                    }
                    if (!(parent instanceof ConditionalNode)) break block9;
                    ConditionalNode cn = (ConditionalNode)parent;
                    if (cn.getChild() != this.selectedNode) break block4;
                    cn.setChild(null);
                    break block4;
                }
                if (!(parent instanceof ListNode)) break block10;
                ListNode ln = (ListNode)parent;
                if (ln.getItemTemplate() != this.selectedNode) break block4;
                ln.setItemTemplate(null);
                break block4;
            }
            if (parent instanceof TabContainerNode) {
                TabContainerNode tc = (TabContainerNode)parent;
                for (TabContainerNode.Tab tab : tc.getTabs()) {
                    if (tab == null || tab.content != this.selectedNode) continue;
                    tab.content = null;
                    break;
                }
            }
        }
        this.selectedNode = this.rootNode;
    }

    private void duplicateSelected() {
        block5: {
            PanelNode parent;
            PanelNode copy;
            block11: {
                block10: {
                    block9: {
                        block8: {
                            block7: {
                                block6: {
                                    block4: {
                                        if (this.selectedNode == null) {
                                            return;
                                        }
                                        copy = this.selectedNode.deepCopy();
                                        if (this.selectedNode == this.rootNode) {
                                            this.selectedNode = this.rootNode = copy;
                                            return;
                                        }
                                        parent = this.findParent(this.rootNode, this.selectedNode);
                                        if (!(parent instanceof VStackNode)) break block4;
                                        VStackNode v = (VStackNode)parent;
                                        int idx = v.getChildren().indexOf(this.selectedNode);
                                        if (idx < 0) break block5;
                                        v.getChildren().add(idx + 1, copy);
                                        this.selectedNode = copy;
                                        break block5;
                                    }
                                    if (!(parent instanceof HStackNode)) break block6;
                                    HStackNode h = (HStackNode)parent;
                                    int idx = h.getChildren().indexOf(this.selectedNode);
                                    if (idx < 0) break block5;
                                    h.getChildren().add(idx + 1, copy);
                                    this.selectedNode = copy;
                                    break block5;
                                }
                                if (!(parent instanceof StackNode)) break block7;
                                StackNode s = (StackNode)parent;
                                s.getChildren().add(copy);
                                this.selectedNode = copy;
                                break block5;
                            }
                            if (!(parent instanceof GridNode)) break block8;
                            GridNode g = (GridNode)parent;
                            int idx = g.getChildren().indexOf(this.selectedNode);
                            if (idx < 0) break block5;
                            g.getChildren().add(idx + 1, copy);
                            this.selectedNode = copy;
                            break block5;
                        }
                        if (!(parent instanceof ScrollNode)) break block9;
                        ScrollNode sc = (ScrollNode)parent;
                        if (sc.getChild() != this.selectedNode) break block5;
                        sc.setChild(copy);
                        this.selectedNode = copy;
                        break block5;
                    }
                    if (!(parent instanceof ConditionalNode)) break block10;
                    ConditionalNode cn = (ConditionalNode)parent;
                    if (cn.getChild() != this.selectedNode) break block5;
                    cn.setChild(copy);
                    this.selectedNode = copy;
                    break block5;
                }
                if (!(parent instanceof ListNode)) break block11;
                ListNode ln = (ListNode)parent;
                if (ln.getItemTemplate() != this.selectedNode) break block5;
                ln.setItemTemplate(copy);
                this.selectedNode = copy;
                break block5;
            }
            if (parent instanceof TabContainerNode) {
                TabContainerNode tc = (TabContainerNode)parent;
                for (TabContainerNode.Tab tab : tc.getTabs()) {
                    if (tab == null || tab.content != this.selectedNode) continue;
                    tab.content = copy;
                    this.selectedNode = copy;
                    break;
                }
            }
        }
    }

    private List<PanelNode> getChildren(PanelNode node) {
        if (node instanceof VStackNode) {
            VStackNode v = (VStackNode)node;
            return v.getChildren();
        }
        if (node instanceof HStackNode) {
            HStackNode h = (HStackNode)node;
            return h.getChildren();
        }
        if (node instanceof StackNode) {
            StackNode s = (StackNode)node;
            return s.getChildren();
        }
        if (node instanceof GridNode) {
            GridNode g = (GridNode)node;
            return g.getChildren();
        }
        if (node instanceof ScrollNode) {
            ScrollNode sc = (ScrollNode)node;
            return sc.getChild() == null ? List.of() : List.of(sc.getChild());
        }
        if (node instanceof ConditionalNode) {
            ConditionalNode c = (ConditionalNode)node;
            return c.getChild() == null ? List.of() : List.of(c.getChild());
        }
        if (node instanceof ListNode) {
            ListNode l = (ListNode)node;
            return l.getItemTemplate() == null ? List.of() : List.of(l.getItemTemplate());
        }
        if (node instanceof TabContainerNode) {
            TabContainerNode t = (TabContainerNode)node;
            ArrayList<PanelNode> out = new ArrayList<PanelNode>();
            if (t.getTabs() != null) {
                for (TabContainerNode.Tab tab : t.getTabs()) {
                    if (tab == null || tab.content == null) continue;
                    out.add(tab.content);
                }
            }
            return out;
        }
        return null;
    }

    private PanelNode findParent(PanelNode root, PanelNode target) {
        if (root == null || target == null) {
            return null;
        }
        List<PanelNode> children = this.getChildren(root);
        if (children == null) {
            return null;
        }
        for (PanelNode child : children) {
            if (child == target) {
                return root;
            }
            PanelNode p = this.findParent(child, target);
            if (p == null) continue;
            return p;
        }
        return null;
    }

    private void savePanel() {
        if (this.rootNode == null || this.currentPanelName == null) {
            return;
        }
        try {
            Path configDir = Paths.get("config", "questory", "themes", "default", "panels");
            Files.createDirectories(configDir, new FileAttribute[0]);
            Path file = configDir.resolve(this.currentPanelName + ".json");
            JsonObject json = this.rootNode.toJson();
            Files.writeString(file, (CharSequence)new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)json), new OpenOption[0]);
            if (QuestTheme.instance != null) {
                QuestTheme.instance.addPanel(this.currentPanelName, new PanelTemplate(this.currentPanelName, this.rootNode.deepCopy()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void renderPanelSelection(class_332 g, int mouseX, int mouseY) {
        g.method_51448().method_22903();
        g.method_51448().method_46416(0.0f, 0.0f, 800.0f);
        g.method_25294(0, 0, this.field_22789, this.field_22790, -872415232);
        int w = 280;
        int listH = 220;
        int x = (this.field_22789 - w) / 2;
        int y = (this.field_22790 - (listH + 40)) / 2;
        g.method_25294(x, y, x + w, y + listH + 40, -14671840);
        g.method_49601(x, y, w, listH + 40, -1);
        g.method_25303(this.field_22793, "Panels", x + 10, y + 10, -1);
        int listX = x + 10;
        int listY = y + 28;
        int listW = w - 20;
        int itemH = 22;
        g.method_44379(listX, listY, listX + listW, listY + listH);
        int itemY = listY + (int)this.panelPickerScrollY;
        QuestTheme theme = QuestTheme.instance;
        if (theme != null && theme.getPanels() != null) {
            for (String name : theme.getPanels().keySet()) {
                boolean hovered = mouseX >= listX && mouseX < listX + listW && mouseY >= itemY && mouseY < itemY + itemH;
                g.method_25294(listX, itemY, listX + listW, itemY + itemH, hovered ? -12566464 : -13619152);
                g.method_25303(this.field_22793, name, listX + 6, itemY + 6, -3355444);
                itemY += itemH + 2;
            }
        }
        g.method_44380();
        g.method_25303(this.field_22793, "Click outside to close", x + 10, y + listH + 20, -5592406);
        g.method_51448().method_22909();
    }

    private void handlePanelSelectionClick(double mouseX, double mouseY) {
        int w = 280;
        int listH = 220;
        int x = (this.field_22789 - w) / 2;
        int y = (this.field_22790 - (listH + 40)) / 2;
        int listX = x + 10;
        int listY = y + 28;
        int listW = w - 20;
        int itemH = 22;
        if (mouseX >= (double)listX && mouseX < (double)(listX + listW) && mouseY >= (double)listY && mouseY < (double)(listY + listH)) {
            int idx = (int)((mouseY - (double)listY - this.panelPickerScrollY) / (double)(itemH + 2));
            int i = 0;
            QuestTheme theme = QuestTheme.instance;
            if (theme != null && theme.getPanels() != null) {
                for (String name : theme.getPanels().keySet()) {
                    if (i == idx) {
                        this.loadPanel(name);
                        this.isSelectingPanel = false;
                        return;
                    }
                    ++i;
                }
            }
        }
        if (mouseX < (double)x || mouseX > (double)(x + w) || mouseY < (double)y || mouseY > (double)(y + listH + 40)) {
            this.isSelectingPanel = false;
        }
    }

    private void loadPanel(String name) {
        QuestTheme theme = QuestTheme.instance;
        if (theme == null) {
            return;
        }
        PanelTemplate template = theme.getPanel(name);
        if (template != null && template.getRoot() != null) {
            this.rootNode = template.getRoot().deepCopy();
            this.currentPanelName = name;
            this.selectedNode = this.rootNode;
            this.rebuildPropertyWidgets();
        }
    }

    public boolean method_25421() {
        return false;
    }

    private static enum RightTab {
        LAYOUT,
        BOX,
        APPEARANCE,
        HOVER,
        TYPE,
        ACTIONS,
        JSON;

    }

    private static enum BackgroundMode {
        AUTO,
        SOLID,
        LINEAR,
        RADIAL,
        RAW;

    }
}

