/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.texboobcat.questory.modpack.ModpackDetector;
import org.texboobcat.questory.modpack.ModpackInfo;
import org.texboobcat.questory.telemetry.TelemetryManager;

public class ConsentScreen
extends class_437 {
    private final class_437 parent;
    private final Runnable onComplete;
    private Page page = Page.OVERVIEW;
    private int scrollOffset = 0;
    private int contentHeight = 0;
    private int cardX;
    private int cardY;
    private int cardW;
    private int cardH;
    private int headerH;
    private int footerH;
    private int contentX;
    private int contentY;
    private int contentW;
    private int contentH;
    private class_4185 overviewTab;
    private class_4185 dataTab;
    private class_4185 privacyTab;

    public ConsentScreen(class_437 parent, Runnable onComplete) {
        super((class_2561)class_2561.method_43470((String)"Questify Telemetry"));
        this.parent = parent;
        this.onComplete = onComplete;
    }

    protected void method_25426() {
        super.method_25426();
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        this.cardW = Math.min(460, this.field_22789 - 40);
        this.cardH = Math.min(260, this.field_22790 - 80);
        this.cardX = centerX - this.cardW / 2;
        this.cardY = centerY - this.cardH / 2 - 10;
        this.headerH = 54;
        this.footerH = 44;
        int pad = 14;
        this.contentX = this.cardX + pad;
        this.contentY = this.cardY + this.headerH + 8;
        this.contentW = this.cardW - pad * 2;
        this.contentH = this.cardH - this.headerH - this.footerH - 10;
        int tabY = this.cardY + 28;
        int tabH = 18;
        int tabW = 92;
        int tabGap = 6;
        this.overviewTab = class_4185.method_46430((class_2561)this.tabLabel(Page.OVERVIEW), btn -> this.setPage(Page.OVERVIEW)).method_46434(this.cardX + 14, tabY, tabW, tabH).method_46431();
        this.method_37063((class_364)this.overviewTab);
        this.dataTab = class_4185.method_46430((class_2561)this.tabLabel(Page.DATA), btn -> this.setPage(Page.DATA)).method_46434(this.cardX + 14 + tabW + tabGap, tabY, tabW, tabH).method_46431();
        this.method_37063((class_364)this.dataTab);
        this.privacyTab = class_4185.method_46430((class_2561)this.tabLabel(Page.PRIVACY), btn -> this.setPage(Page.PRIVACY)).method_46434(this.cardX + 14 + (tabW + tabGap) * 2, tabY, tabW, tabH).method_46431();
        this.method_37063((class_364)this.privacyTab);
        int buttonWidth = 120;
        int buttonHeight = 20;
        int bottomY = this.cardY + this.cardH - 28;
        class_4185 optInButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u00a7a\u2713 Opt In"), btn -> {
            TelemetryManager.getInstance().enableTelemetry();
            this.method_25419();
        }).method_46434(centerX - buttonWidth - 10, bottomY, buttonWidth, buttonHeight).method_46431();
        this.method_37063((class_364)optInButton);
        class_4185 noThanksButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u00a77No Thanks"), btn -> {
            TelemetryManager.getInstance().disableTelemetry();
            this.method_25419();
        }).method_46434(centerX + 10, bottomY, buttonWidth, buttonHeight).method_46431();
        this.method_37063((class_364)noThanksButton);
        this.updateTabLabels();
    }

    private void setPage(Page newPage) {
        this.page = newPage;
        this.scrollOffset = 0;
        this.updateTabLabels();
    }

    private void updateTabLabels() {
        if (this.overviewTab != null) {
            this.overviewTab.method_25355(this.tabLabel(Page.OVERVIEW));
        }
        if (this.dataTab != null) {
            this.dataTab.method_25355(this.tabLabel(Page.DATA));
        }
        if (this.privacyTab != null) {
            this.privacyTab.method_25355(this.tabLabel(Page.PRIVACY));
        }
    }

    private class_2561 tabLabel(Page p) {
        boolean active = this.page == p;
        String label = switch (p.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> "Overview";
            case 1 -> "Data";
            case 2 -> "Privacy";
        };
        return class_2561.method_43470((String)(active ? "\u00a76\u00a7l" + label : "\u00a77" + label));
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (mouseX >= (double)this.contentX && mouseX <= (double)(this.contentX + this.contentW) && mouseY >= (double)this.contentY && mouseY <= (double)(this.contentY + this.contentH)) {
            int maxScroll = Math.max(0, this.contentHeight - this.contentH);
            this.scrollOffset = ConsentScreen.clamp(this.scrollOffset - (int)(delta * 12.0), 0, maxScroll);
            return true;
        }
        return super.method_25401(mouseX, mouseY, delta);
    }

    private static int clamp(int v, int min, int max) {
        if (v < min) {
            return min;
        }
        if (v > max) {
            return max;
        }
        return v;
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        graphics.method_25294(0, 0, this.field_22789, this.field_22790, -536870912);
        graphics.method_25294(this.cardX, this.cardY, this.cardX + this.cardW, this.cardY + this.cardH, -267119594);
        graphics.method_25294(this.cardX, this.cardY, this.cardX + this.cardW, this.cardY + this.headerH, -14935008);
        graphics.method_25294(this.cardX, this.cardY + this.cardH - this.footerH, this.cardX + this.cardW, this.cardY + this.cardH, -14935008);
        graphics.method_25300(this.field_22793, "\u00a7l\u00a76Questify Telemetry", this.field_22789 / 2, this.cardY + 8, 0xFFFFFF);
        int clipX1 = this.contentX;
        int clipY1 = this.contentY;
        int clipX2 = this.contentX + this.contentW;
        int clipY2 = this.contentY + this.contentH;
        graphics.method_44379(clipX1, clipY1, clipX2, clipY2);
        int y = this.contentY - this.scrollOffset;
        this.contentHeight = this.renderPageContent(graphics, this.contentX, y, this.contentW);
        graphics.method_44380();
        int maxScroll = Math.max(0, this.contentHeight - this.contentH);
        if (maxScroll > 0) {
            int barH = Math.max(12, (int)((double)this.contentH / (double)this.contentHeight * (double)this.contentH));
            int barX = this.cardX + this.cardW - 6;
            int barY = this.contentY + (int)((double)this.scrollOffset / (double)maxScroll * (double)(this.contentH - barH));
            graphics.method_25294(barX, this.contentY, barX + 2, this.contentY + this.contentH, -14013904);
            graphics.method_25294(barX, barY, barX + 2, barY + barH, -9539976);
        }
        super.method_25394(graphics, mouseX, mouseY, partialTick);
    }

    private int renderPageContent(class_332 graphics, int x, int y, int w) {
        int lineHeight = 10;
        int curY = y;
        ModpackInfo modpack = ModpackDetector.detect();
        String modpackName = modpack.getName();
        if (this.page == Page.OVERVIEW) {
            curY = this.drawWrapped(graphics, (class_2561)class_2561.method_43470((String)"\u00a7fWhat this is"), x, curY, w);
            curY += 2;
            curY = this.drawWrapped(graphics, (class_2561)class_2561.method_43470((String)"\u00a77Questify can collect anonymous quest interaction data to improve quest design, balance, and pacing."), x, curY, w);
            curY += lineHeight;
            curY = this.drawWrapped(graphics, (class_2561)class_2561.method_43470((String)"\u00a7fWhy we ask"), x, curY, w);
            curY += 2;
            curY = this.drawWrapped(graphics, (class_2561)class_2561.method_43470((String)"\u00a77Opting in helps us find confusing quests, overly grindy steps, and content players skip. We use it for aggregated analytics \u2014 not profiling."), x, curY, w);
            curY += lineHeight;
            curY = this.drawWrapped(graphics, (class_2561)class_2561.method_43470((String)"\u00a7fDetected modpack"), x, curY, w);
            curY += 2;
            curY = this.drawWrapped(graphics, (class_2561)class_2561.method_43470((String)("\u00a7e" + modpackName + " \u00a77(" + modpack.getId() + " v" + modpack.getVersion() + ")")), x, curY, w);
            curY += lineHeight;
            curY = this.drawWrapped(graphics, (class_2561)class_2561.method_43470((String)"\u00a7aWhat we collect (summary)"), x, curY, w);
            curY += 2;
            curY = this.drawWrapped(graphics, (class_2561)class_2561.method_43470((String)"\u00a77- Quest events (opened / viewed / completed)"), x, curY, w);
            curY = this.drawWrapped(graphics, (class_2561)class_2561.method_43470((String)"\u00a77- Completion time for completed quests"), x, curY, w);
            curY = this.drawWrapped(graphics, (class_2561)class_2561.method_43470((String)"\u00a77- Modpack id + version"), x, curY, w);
            curY = this.drawWrapped(graphics, (class_2561)class_2561.method_43470((String)"\u00a77- Anonymous session id"), x, curY, w);
            curY += lineHeight;
            curY = this.drawWrapped(graphics, (class_2561)class_2561.method_43470((String)"\u00a7cWhat we do NOT collect"), x, curY, w);
            curY += 2;
            curY = this.drawWrapped(graphics, (class_2561)class_2561.method_43470((String)"\u00a77- Minecraft username / account identifiers"), x, curY, w);
            curY = this.drawWrapped(graphics, (class_2561)class_2561.method_43470((String)"\u00a77- IP address"), x, curY, w);
            curY = this.drawWrapped(graphics, (class_2561)class_2561.method_43470((String)"\u00a77- Chat messages, world seeds, files, or inventory"), x, curY, w);
            curY = this.drawWrapped(graphics, (class_2561)class_2561.method_43470((String)"\u00a77- Any directly identifying personal information"), x, curY, w);
            curY += lineHeight;
            curY = this.drawWrapped(graphics, (class_2561)class_2561.method_43470((String)"\u00a77You can change this later:"), x, curY, w);
            curY = this.drawWrapped(graphics, (class_2561)class_2561.method_43470((String)"\u00a7f/questify telemetry optin \u00a77or \u00a7f/questify telemetry optout"), x, curY, w);
            curY = this.drawWrapped(graphics, (class_2561)class_2561.method_43470((String)"\u00a77Testing: \u00a7f/questify tele reset"), x, curY, w);
        } else if (this.page == Page.DATA) {
            curY = this.drawWrapped(graphics, (class_2561)class_2561.method_43470((String)"\u00a7fData Collected (every field explained)"), x, curY, w);
            curY += lineHeight;
            curY = this.drawWrapped(graphics, (class_2561)class_2561.method_43470((String)"\u00a7eConsent record"), x, curY, w);
            curY += 2;
            curY = this.drawWrapped(graphics, (class_2561)class_2561.method_43470((String)"\u00a77- \u00a7fhardware_id\u00a77: a salted one-way hash created on your device. Used only to store consent and deduplicate devices."), x, curY, w);
            curY = this.drawWrapped(graphics, (class_2561)class_2561.method_43470((String)"\u00a77- \u00a7fconsented\u00a77: true/false opt-in status."), x, curY, w);
            curY = this.drawWrapped(graphics, (class_2561)class_2561.method_43470((String)"\u00a77- \u00a7fconsent_version\u00a77: allows re-prompting if the policy changes."), x, curY, w);
            curY += lineHeight;
            curY = this.drawWrapped(graphics, (class_2561)class_2561.method_43470((String)"\u00a7eTelemetry event record"), x, curY, w);
            curY += 2;
            curY = this.drawWrapped(graphics, (class_2561)class_2561.method_43470((String)"\u00a77- \u00a7fplayer_uuid\u00a77: derived from hardware_id (UUID generated from the hash). Not your Minecraft UUID."), x, curY, w);
            curY = this.drawWrapped(graphics, (class_2561)class_2561.method_43470((String)"\u00a77- \u00a7fsession_id\u00a77: random UUID per game session. Lets us group events from one play session."), x, curY, w);
            curY = this.drawWrapped(graphics, (class_2561)class_2561.method_43470((String)"\u00a77- \u00a7fevent_type\u00a77: what happened (session_start/session_end/quest_opened/quest_viewed/quest_completed)."), x, curY, w);
            curY = this.drawWrapped(graphics, (class_2561)class_2561.method_43470((String)"\u00a77- \u00a7fquest_id\u00a77: internal quest identifier involved in the event."), x, curY, w);
            curY = this.drawWrapped(graphics, (class_2561)class_2561.method_43470((String)"\u00a77- \u00a7fmodpack_id\u00a77: detected modpack identifier."), x, curY, w);
            curY = this.drawWrapped(graphics, (class_2561)class_2561.method_43470((String)"\u00a77- \u00a7fmodpack_version\u00a77: detected modpack version."), x, curY, w);
            curY = this.drawWrapped(graphics, (class_2561)class_2561.method_43470((String)"\u00a77- \u00a7ftimestamp\u00a77: time the event occurred (ISO-8601)."), x, curY, w);
            curY = this.drawWrapped(graphics, (class_2561)class_2561.method_43470((String)"\u00a77- \u00a7fmetadata\u00a77: optional extra fields depending on event type."), x, curY, w);
            curY += 2;
            curY = this.drawWrapped(graphics, (class_2561)class_2561.method_43470((String)"\u00a77  - For \u00a7fquest_completed\u00a77: \u00a7fcompletion_time_ms\u00a77 (how long it took to complete the quest)."), x, curY, w);
            curY += lineHeight;
            curY = this.drawWrapped(graphics, (class_2561)class_2561.method_43470((String)"\u00a77We intentionally avoid collecting anything that can directly identify you."), x, curY, w);
        } else {
            curY = this.drawWrapped(graphics, (class_2561)class_2561.method_43470((String)"\u00a7fPrivacy & Data Protection"), x, curY, w);
            curY += lineHeight;
            curY = this.drawWrapped(graphics, (class_2561)class_2561.method_43470((String)"\u00a7eAnonymization"), x, curY, w);
            curY += 2;
            curY = this.drawWrapped(graphics, (class_2561)class_2561.method_43470((String)"\u00a77- Hardware ID is a salted hash and is not linked to your Minecraft account."), x, curY, w);
            curY = this.drawWrapped(graphics, (class_2561)class_2561.method_43470((String)"\u00a77- We do not upload usernames, UUIDs, IP addresses, chat, or files."), x, curY, w);
            curY += lineHeight;
            curY = this.drawWrapped(graphics, (class_2561)class_2561.method_43470((String)"\u00a7eControls"), x, curY, w);
            curY += 2;
            curY = this.drawWrapped(graphics, (class_2561)class_2561.method_43470((String)"\u00a77- Opt in: \u00a7f/questify telemetry optin"), x, curY, w);
            curY = this.drawWrapped(graphics, (class_2561)class_2561.method_43470((String)"\u00a77- Opt out: \u00a7f/questify telemetry optout"), x, curY, w);
            curY = this.drawWrapped(graphics, (class_2561)class_2561.method_43470((String)"\u00a77- Status: \u00a7f/questify telemetry status"), x, curY, w);
            curY = this.drawWrapped(graphics, (class_2561)class_2561.method_43470((String)"\u00a77- Data access: \u00a7f/questify telemetry export"), x, curY, w);
            curY = this.drawWrapped(graphics, (class_2561)class_2561.method_43470((String)"\u00a77- Data deletion: \u00a7f/questify telemetry delete"), x, curY, w);
            curY += lineHeight;
            curY = this.drawWrapped(graphics, (class_2561)class_2561.method_43470((String)"\u00a7eHow data is used"), x, curY, w);
            curY += 2;
            curY = this.drawWrapped(graphics, (class_2561)class_2561.method_43470((String)"\u00a77- Aggregate analytics (e.g., which quests are commonly completed or abandoned)."), x, curY, w);
            curY = this.drawWrapped(graphics, (class_2561)class_2561.method_43470((String)"\u00a77- Improving pacing and identifying pain points."), x, curY, w);
            curY = this.drawWrapped(graphics, (class_2561)class_2561.method_43470((String)"\u00a77- We do not sell or share telemetry with third parties."), x, curY, w);
        }
        return Math.max(0, curY - y);
    }

    private int drawWrapped(class_332 graphics, class_2561 component, int x, int y, int w) {
        List lines = this.field_22793.method_1728((class_5348)component, w);
        int lineHeight = 10;
        for (class_5481 line : lines) {
            graphics.method_51430(this.field_22793, line, x, y, 0xE6E6E6, false);
            y += lineHeight;
        }
        return y;
    }

    public void method_25419() {
        if (this.onComplete != null) {
            this.onComplete.run();
        }
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }

    public boolean method_25421() {
        return true;
    }

    private static enum Page {
        OVERVIEW,
        DATA,
        PRIVACY;

    }
}

