/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2522;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.texboobcat.questory.client.gui.ExamplePickerScreen;
import org.texboobcat.questory.client.gui.GenericTriggerHelpScreen;
import org.texboobcat.questory.client.gui.IconPickerScreen;
import org.texboobcat.questory.client.gui.TriggerPickerScreen;
import org.texboobcat.questory.manager.TriggerListenerManager;
import org.texboobcat.questory.quest.AdvancementRequirement;
import org.texboobcat.questory.quest.BiomeRequirement;
import org.texboobcat.questory.quest.CheckmarkRequirement;
import org.texboobcat.questory.quest.CommandRequirement;
import org.texboobcat.questory.quest.CraftingRequirement;
import org.texboobcat.questory.quest.CurrencyRequirement;
import org.texboobcat.questory.quest.CustomRequirement;
import org.texboobcat.questory.quest.DimensionRequirement;
import org.texboobcat.questory.quest.EnergyRequirement;
import org.texboobcat.questory.quest.EntityKillRequirement;
import org.texboobcat.questory.quest.EquipItemRequirement;
import org.texboobcat.questory.quest.FluidRequirement;
import org.texboobcat.questory.quest.GenericTriggerRequirement;
import org.texboobcat.questory.quest.ItemRequirement;
import org.texboobcat.questory.quest.ItemTagRequirement;
import org.texboobcat.questory.quest.LocationRequirement;
import org.texboobcat.questory.quest.ObservationRequirement;
import org.texboobcat.questory.quest.RegionRequirement;
import org.texboobcat.questory.quest.Requirement;
import org.texboobcat.questory.quest.StageRequirement;
import org.texboobcat.questory.quest.StatisticRequirement;
import org.texboobcat.questory.quest.StructureRequirement;
import org.texboobcat.questory.quest.TimeRequirement;
import org.texboobcat.questory.quest.WeatherRequirement;
import org.texboobcat.questory.quest.XpRequirement;

public class RequirementEditorScreen
extends class_437 {
    private static final int PANEL_WIDTH = 500;
    private static final int PANEL_HEIGHT = 250;
    private static final int FIELD_HEIGHT = 18;
    private static final int FIELD_SPACING = 24;
    private static final int LABEL_OFFSET = 12;
    private static final int BUTTON_HEIGHT = 20;
    private final class_437 parent;
    private final Requirement requirement;
    private final Consumer<Requirement> onSave;
    private final List<class_342> fields = new ArrayList<class_342>();
    private class_4185 saveBtn;
    private class_4185 cancelBtn;
    private class_4185 toggleBtn;
    private boolean toggleState = false;
    private String tempCycleValue = null;
    private boolean onlyFromCraftingState = false;
    private boolean taskScreenOnlyState = false;
    private String matchComponentsValue = "none";
    private String customNameValue = "";
    private String hoveredTooltip = null;
    private int tooltipX = 0;
    private int tooltipY = 0;
    private final List<EquipmentSlotEntry> equipmentEntries = new ArrayList<EquipmentSlotEntry>();
    private class_4185 addEquipmentBtn;
    private float equipmentScrollOffset = 0.0f;
    private int totalEquipmentEntries = 0;
    private static final int MAX_VISIBLE_EQUIPMENT_ENTRIES = 3;
    private boolean isAdvancedMode = false;
    private final List<ConditionEntry> conditionEntries = new ArrayList<ConditionEntry>();
    private class_4185 addConditionBtn;

    public RequirementEditorScreen(class_437 parent, Requirement requirement, Consumer<Requirement> onSave) {
        super((class_2561)class_2561.method_43470((String)("Edit " + requirement.getType().toUpperCase() + " Requirement")));
        this.parent = parent;
        this.requirement = requirement;
        this.onSave = onSave;
    }

    protected void method_25426() {
        super.method_25426();
        this.fields.clear();
        int panelX = (this.field_22789 - 500) / 2;
        int startY = (this.field_22790 - 250) / 2 + 40;
        this.initFieldsForRequirement(panelX, startY);
        this.initControlButtons(panelX);
    }

    private void initFieldsForRequirement(int x, int y) {
        Requirement requirement = this.requirement;
        if (requirement instanceof ItemRequirement) {
            ItemRequirement ir = (ItemRequirement)requirement;
            this.initItemRequirement(ir, x, y);
        } else {
            requirement = this.requirement;
            if (requirement instanceof EntityKillRequirement) {
                EntityKillRequirement kr = (EntityKillRequirement)requirement;
                this.initEntityKillRequirement(kr, x, y);
            } else {
                requirement = this.requirement;
                if (requirement instanceof LocationRequirement) {
                    LocationRequirement lr = (LocationRequirement)requirement;
                    this.initLocationRequirement(lr, x, y);
                } else {
                    requirement = this.requirement;
                    if (requirement instanceof XpRequirement) {
                        XpRequirement xr = (XpRequirement)requirement;
                        this.initXpRequirement(xr, x, y);
                    } else {
                        requirement = this.requirement;
                        if (requirement instanceof CraftingRequirement) {
                            CraftingRequirement cr = (CraftingRequirement)requirement;
                            this.initCraftingRequirement(cr, x, y);
                        } else {
                            requirement = this.requirement;
                            if (requirement instanceof StageRequirement) {
                                StageRequirement sr = (StageRequirement)requirement;
                                this.initStageRequirement(sr, x, y);
                            } else {
                                requirement = this.requirement;
                                if (requirement instanceof ObservationRequirement) {
                                    ObservationRequirement or = (ObservationRequirement)requirement;
                                    this.initObservationRequirement(or, x, y);
                                } else {
                                    requirement = this.requirement;
                                    if (requirement instanceof StructureRequirement) {
                                        StructureRequirement sr = (StructureRequirement)requirement;
                                        this.initStructureRequirement(sr, x, y);
                                    } else {
                                        requirement = this.requirement;
                                        if (requirement instanceof RegionRequirement) {
                                            RegionRequirement rr = (RegionRequirement)requirement;
                                            this.initRegionRequirement(rr, x, y);
                                        } else {
                                            requirement = this.requirement;
                                            if (requirement instanceof ItemTagRequirement) {
                                                ItemTagRequirement tr = (ItemTagRequirement)requirement;
                                                this.initItemTagRequirement(tr, x, y);
                                            } else {
                                                requirement = this.requirement;
                                                if (requirement instanceof AdvancementRequirement) {
                                                    AdvancementRequirement ar = (AdvancementRequirement)requirement;
                                                    this.initAdvancementRequirement(ar, x, y);
                                                } else {
                                                    requirement = this.requirement;
                                                    if (requirement instanceof BiomeRequirement) {
                                                        BiomeRequirement br = (BiomeRequirement)requirement;
                                                        this.initBiomeRequirement(br, x, y);
                                                    } else {
                                                        requirement = this.requirement;
                                                        if (requirement instanceof DimensionRequirement) {
                                                            DimensionRequirement dr = (DimensionRequirement)requirement;
                                                            this.initDimensionRequirement(dr, x, y);
                                                        } else {
                                                            requirement = this.requirement;
                                                            if (requirement instanceof WeatherRequirement) {
                                                                WeatherRequirement wr = (WeatherRequirement)requirement;
                                                                this.initWeatherRequirement(wr, x, y);
                                                            } else {
                                                                requirement = this.requirement;
                                                                if (requirement instanceof TimeRequirement) {
                                                                    TimeRequirement tr = (TimeRequirement)requirement;
                                                                    this.initTimeRequirement(tr, x, y);
                                                                } else {
                                                                    requirement = this.requirement;
                                                                    if (requirement instanceof CommandRequirement) {
                                                                        CommandRequirement cr = (CommandRequirement)requirement;
                                                                        this.initCommandRequirement(cr, x, y);
                                                                    } else {
                                                                        requirement = this.requirement;
                                                                        if (requirement instanceof CheckmarkRequirement) {
                                                                            CheckmarkRequirement ckr = (CheckmarkRequirement)requirement;
                                                                            this.initCheckmarkRequirement(ckr, x, y);
                                                                        } else {
                                                                            requirement = this.requirement;
                                                                            if (requirement instanceof CustomRequirement) {
                                                                                CustomRequirement cur = (CustomRequirement)requirement;
                                                                                this.initCustomRequirement(cur, x, y);
                                                                            } else {
                                                                                requirement = this.requirement;
                                                                                if (requirement instanceof StatisticRequirement) {
                                                                                    StatisticRequirement sr = (StatisticRequirement)requirement;
                                                                                    this.initStatisticRequirement(sr, x, y);
                                                                                } else {
                                                                                    requirement = this.requirement;
                                                                                    if (requirement instanceof EnergyRequirement) {
                                                                                        EnergyRequirement er = (EnergyRequirement)requirement;
                                                                                        this.initEnergyRequirement(er, x, y);
                                                                                    } else {
                                                                                        requirement = this.requirement;
                                                                                        if (requirement instanceof FluidRequirement) {
                                                                                            FluidRequirement fr = (FluidRequirement)requirement;
                                                                                            this.initFluidRequirement(fr, x, y);
                                                                                        } else {
                                                                                            requirement = this.requirement;
                                                                                            if (requirement instanceof CurrencyRequirement) {
                                                                                                CurrencyRequirement cr = (CurrencyRequirement)requirement;
                                                                                                this.initCurrencyRequirement(cr, x, y);
                                                                                            } else {
                                                                                                requirement = this.requirement;
                                                                                                if (requirement instanceof GenericTriggerRequirement) {
                                                                                                    GenericTriggerRequirement gtr = (GenericTriggerRequirement)requirement;
                                                                                                    this.initGenericTriggerRequirement(gtr, x, y);
                                                                                                } else {
                                                                                                    requirement = this.requirement;
                                                                                                    if (requirement instanceof EquipItemRequirement) {
                                                                                                        EquipItemRequirement eir = (EquipItemRequirement)requirement;
                                                                                                        this.initEquipItemRequirement(eir, x, y);
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private class_342 createField(int x, int y, int width, String initialValue, String hint) {
        class_342 field = new class_342(this.field_22793, x, y, width, 18, (class_2561)class_2561.method_43470((String)hint));
        field.method_1852(initialValue);
        field.method_47404((class_2561)class_2561.method_43470((String)hint));
        field.method_1880(500);
        this.method_37063((class_364)field);
        this.fields.add(field);
        return field;
    }

    private void initItemRequirement(ItemRequirement ir, int x, int y) {
        this.createField(x + 100, y, 380, ir.getItem(), "minecraft:item_id");
        this.createField(x + 100, y + 24, 100, String.valueOf(ir.getCount()), "Amount");
        this.toggleState = ir.shouldConsume();
        this.toggleBtn = this.createToggleButton("Consume", this.toggleState, x + 100, y + 48);
        this.onlyFromCraftingState = ir.isOnlyFromCrafting();
        class_4185 craftingBtn = this.createToggleButton("Only Crafting", this.onlyFromCraftingState, x + 230, y + 48);
        craftingBtn.method_25355((class_2561)class_2561.method_43470((String)("Crafting: " + (this.onlyFromCraftingState ? "Yes" : "No"))));
        this.taskScreenOnlyState = ir.isTaskScreenOnly();
        class_4185 screenOnlyBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)("Screen Only: " + (this.taskScreenOnlyState ? "Yes" : "No"))), b -> {
            this.taskScreenOnlyState = !this.taskScreenOnlyState;
            b.method_25355((class_2561)class_2561.method_43470((String)("Screen Only: " + (this.taskScreenOnlyState ? "Yes" : "No"))));
        }).method_46434(x + 100, y + 72, 120, 20).method_46431();
        this.method_37063((class_364)screenOnlyBtn);
        this.matchComponentsValue = ir.getMatchComponents();
        class_4185 matchBtn = this.createCycleButton("Match", this.matchComponentsValue, new String[]{"none", "fuzzy", "strict"}, x + 230, y + 72);
    }

    private void initEntityKillRequirement(EntityKillRequirement kr, int x, int y) {
        this.createField(x + 100, y, 380, kr.getEntity(), "minecraft:entity_id or #tag");
        this.createField(x + 100, y + 24, 100, String.valueOf(kr.getCount()), "Amount to kill");
        this.customNameValue = kr.getCustomName() != null ? kr.getCustomName() : "";
        class_342 customNameField = this.createField(x + 100, y + 48, 200, this.customNameValue, "Custom name filter (optional)");
        customNameField.method_1863(val -> {
            this.customNameValue = val;
        });
    }

    private void initLocationRequirement(LocationRequirement lr, int x, int y) {
        this.createField(x + 100, y, 100, String.valueOf(lr.getX()), "X");
        this.createField(x + 210, y, 100, String.valueOf(lr.getY()), "Y");
        this.createField(x + 320, y, 100, String.valueOf(lr.getZ()), "Z");
        this.createField(x + 100, y + 24, 100, String.valueOf(lr.getRange()), "Radius");
    }

    private void initXpRequirement(XpRequirement xr, int x, int y) {
        this.createField(x + 100, y, 150, String.valueOf(xr.getAmount()), "XP amount");
        this.toggleState = xr.isLevels();
        this.toggleBtn = this.createToggleButton("Type", this.toggleState, "Levels", "Points", x + 260, y);
    }

    private void initCraftingRequirement(CraftingRequirement cr, int x, int y) {
        this.createField(x + 100, y, 380, cr.getItem(), "minecraft:item_id");
        this.createField(x + 100, y + 24, 100, String.valueOf(cr.getCount()), "Amount to craft");
    }

    private void initStageRequirement(StageRequirement sr, int x, int y) {
        this.createField(x + 100, y, 380, sr.getStage(), "stage_name");
    }

    private void initObservationRequirement(ObservationRequirement or, int x, int y) {
        this.createField(x + 100, y, 380, or.getTargetId(), "minecraft:entity_id | minecraft:block_id | minecraft:item_id");
        this.createField(x + 100, y + 24, 100, String.valueOf(or.getTimer()), "Ticks");
        this.tempCycleValue = or.getObserveType();
        if (this.tempCycleValue == null || this.tempCycleValue.isBlank()) {
            this.tempCycleValue = "entity";
        }
        this.toggleBtn = this.createCycleButton("Type", this.tempCycleValue, new String[]{"entity", "block", "item_hand", "item_entity"}, x + 210, y + 24);
    }

    private void initStructureRequirement(StructureRequirement sr, int x, int y) {
        this.createField(x + 100, y, 380, sr.getStructureId(), "minecraft:structure_id or #namespace:tag");
    }

    private void initRegionRequirement(RegionRequirement rr, int x, int y) {
        this.createField(x + 100, y, 200, rr.getDimension(), "minecraft:overworld");
        this.createField(x + 100, y + 24, 60, String.valueOf(rr.getMinX()), "x1");
        this.createField(x + 164, y + 24, 60, String.valueOf(rr.getMinY()), "y1");
        this.createField(x + 228, y + 24, 60, String.valueOf(rr.getMinZ()), "z1");
        this.createField(x + 100, y + 48, 60, String.valueOf(rr.getMaxX()), "x2");
        this.createField(x + 164, y + 48, 60, String.valueOf(rr.getMaxY()), "y2");
        this.createField(x + 228, y + 48, 60, String.valueOf(rr.getMaxZ()), "z2");
    }

    private void initItemTagRequirement(ItemTagRequirement tr, int x, int y) {
        this.createField(x + 100, y, 380, "#" + tr.getTag(), "#namespace:path");
        this.createField(x + 100, y + 24, 100, String.valueOf(tr.getCount()), "Amount");
        this.toggleState = tr.shouldConsume();
        this.toggleBtn = this.createToggleButton("Consume", this.toggleState, x + 100, y + 48);
    }

    private void initAdvancementRequirement(AdvancementRequirement ar, int x, int y) {
        this.createField(x + 100, y, 380, ar.getAdvancement(), "minecraft:story/mine_stone");
    }

    private void initBiomeRequirement(BiomeRequirement br, int x, int y) {
        this.createField(x + 100, y, 380, br.getBiomeId(), "minecraft:plains or #namespace:tag");
    }

    private void initDimensionRequirement(DimensionRequirement dr, int x, int y) {
        this.createField(x + 100, y, 380, dr.getDimensionId(), "minecraft:the_nether");
    }

    private void initWeatherRequirement(WeatherRequirement wr, int x, int y) {
        String[] modes = new String[]{"CLEAR", "RAIN", "THUNDER"};
        String initial = wr.getMode().name();
        this.toggleBtn = this.createCycleButton("Mode", initial, modes, x + 100, y);
    }

    private void initTimeRequirement(TimeRequirement tr, int x, int y) {
        this.createField(x + 100, y, 100, String.valueOf(tr.getStart()), "0..23999");
        this.createField(x + 210, y, 100, String.valueOf(tr.getEnd()), "0..23999");
    }

    private void initCommandRequirement(CommandRequirement cr, int x, int y) {
        this.createField(x + 100, y, 260, cr.getRequirementId(), "unique_id");
        this.createField(x + 100, y + 24, 380, cr.getDescription(), "Shown in UI");
    }

    private void initCheckmarkRequirement(CheckmarkRequirement ckr, int x, int y) {
        this.createField(x + 100, y, 260, ckr.getRequirementId(), "unique_id");
        this.createField(x + 100, y + 24, 380, ckr.getDescription(), "Shown in UI");
    }

    private void initCustomRequirement(CustomRequirement cur, int x, int y) {
        this.createField(x + 100, y, 260, cur.getTaskId(), "task_key");
        this.createField(x + 100, y + 24, 380, "", "Description");
        this.createField(x + 100, y + 48, 100, String.valueOf(cur.getMaxProgress()), "Max progress");
    }

    private void initStatisticRequirement(StatisticRequirement sr, int x, int y) {
        this.createField(x + 100, y, 380, sr.getStatistic(), "minecraft:walk_one_cm");
        this.createField(x + 100, y + 24, 100, String.valueOf(sr.getTargetValue()), "Target value");
    }

    private void initEnergyRequirement(EnergyRequirement er, int x, int y) {
        this.createField(x + 100, y, 150, String.valueOf(er.getAmount()), "FE");
    }

    private void initFluidRequirement(FluidRequirement fr, int x, int y) {
        this.createField(x + 100, y, 280, fr.getFluidId(), "minecraft:water");
        this.createField(x + 100, y + 24, 100, String.valueOf(fr.getAmount()), "1000 = 1 bucket");
        this.createField(x + 100, y + 48, 380, fr.getNbt() != null ? fr.getNbt().toString() : "", "NBT (optional)");
    }

    private void initCurrencyRequirement(CurrencyRequirement cr, int x, int y) {
        this.createField(x + 100, y, 200, cr.getCurrencyId(), "coins");
        this.createField(x + 100, y + 24, 100, String.valueOf(cr.getAmount()), "Amount");
    }

    private void initEquipItemRequirement(EquipItemRequirement eir, int x, int y) {
        ArrayList<TempEquipmentData> tempData = new ArrayList<TempEquipmentData>();
        for (EquipmentSlotEntry entry : this.equipmentEntries) {
            tempData.add(new TempEquipmentData(entry.currentSlot, entry.itemField.method_1882(), entry.nbtField.method_1882(), entry.showNbt));
        }
        this.equipmentEntries.clear();
        int startY = y + 24;
        this.totalEquipmentEntries = tempData.isEmpty() ? eir.getEntries().size() : tempData.size();
        int scrollStartEntry = (int)(this.equipmentScrollOffset * (float)Math.max(0, tempData.isEmpty() ? eir.getEntries().size() : tempData.size()));
        if (!tempData.isEmpty()) {
            currentY = startY;
            int entryIndex = 0;
            for (TempEquipmentData data : tempData) {
                if (entryIndex >= scrollStartEntry && entryIndex < scrollStartEntry + 3) {
                    this.addEquipmentSlotEntry(x, currentY, data.slot, data.itemId, data.nbt, data.showNbt);
                    boolean isCustom = !Arrays.asList("HEAD", "CHEST", "LEGS", "FEET", "MAINHAND", "OFFHAND").contains(data.slot.toUpperCase());
                    int linesNeeded = isCustom && data.showNbt ? 3 : 2;
                    currentY += 24 * linesNeeded;
                }
                ++entryIndex;
            }
        } else {
            currentY = startY;
            int entryIndex = 0;
            for (EquipItemRequirement.EquipmentEntry entry : eir.getEntries()) {
                if (entryIndex >= scrollStartEntry && entryIndex < scrollStartEntry + 3) {
                    this.addEquipmentSlotEntry(x, currentY, entry.getSlotName(), entry.getItemId(), entry.getNbt() != null ? entry.getNbt().toString() : "", false);
                    boolean isCustom = !Arrays.asList("HEAD", "CHEST", "LEGS", "FEET", "MAINHAND", "OFFHAND").contains(entry.getSlotName().toUpperCase());
                    int linesNeeded = isCustom && entry.getNbt() != null ? 3 : 2;
                    currentY += 24 * linesNeeded;
                }
                ++entryIndex;
            }
        }
        if (this.equipmentEntries.isEmpty() && scrollStartEntry == 0) {
            this.addEquipmentSlotEntry(x, startY, "HEAD", "minecraft:", "", false);
        }
        int btnY = startY + Math.min(3, this.equipmentEntries.size()) * 24 * 2;
        this.addEquipmentBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"+ Add Slot"), b -> {
            String newSlot = this.equipmentEntries.isEmpty() ? "HEAD" : "CHEST";
            this.addEquipmentSlotEntry(x, startY + this.equipmentEntries.size() * 24 * 2, newSlot, "minecraft:", "", false);
            this.method_25423(this.field_22787, this.field_22789, this.field_22790);
        }).method_46434(x + 100, btnY, 80, 18).method_46431();
        this.method_37063((class_364)this.addEquipmentBtn);
    }

    private void addEquipmentSlotEntry(int x, int y, String initialSlot, String itemId, String nbtStr, boolean initialShowNbt) {
        int slotIndex;
        String[] slots = new String[]{"HEAD", "CHEST", "LEGS", "FEET", "MAINHAND", "OFFHAND", "CUSTOM"};
        boolean isCustom = !Arrays.asList("HEAD", "CHEST", "LEGS", "FEET", "MAINHAND", "OFFHAND").contains(initialSlot.toUpperCase());
        int n = slotIndex = isCustom ? 6 : Arrays.asList(slots).indexOf(initialSlot.toUpperCase());
        if (slotIndex == -1) {
            slotIndex = 0;
        }
        int[] currentIndex = new int[]{slotIndex};
        String[] customSlotValue = new String[]{isCustom ? initialSlot : ""};
        class_4185 slotBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)this.formatSlotLabel(slots[currentIndex[0]])), b -> {
            currentIndex[0] = (currentIndex[0] + 1) % slots.length;
            b.method_25355((class_2561)class_2561.method_43470((String)this.formatSlotLabel(slots[currentIndex[0]])));
            for (EquipmentSlotEntry entry : this.equipmentEntries) {
                if (entry.slotBtn != b) continue;
                if (currentIndex[0] == 6) {
                    entry.isCustomSlot = true;
                    entry.currentSlot = entry.customSlotField.method_1882().isEmpty() ? "CUSTOM" : entry.customSlotField.method_1882();
                } else {
                    entry.isCustomSlot = false;
                    entry.currentSlot = slots[currentIndex[0]];
                }
                this.method_25423(this.field_22787, this.field_22789, this.field_22790);
                break;
            }
        }).method_46434(x + 100, y, 80, 18).method_46431();
        class_342 customSlotField = new class_342(this.field_22793, x + 100, y + 24, 80, 18, (class_2561)class_2561.method_43470((String)"Slot ID"));
        customSlotField.method_1852(isCustom ? initialSlot : "");
        customSlotField.method_47404((class_2561)class_2561.method_43470((String)"curios:ring"));
        customSlotField.method_1880(100);
        customSlotField.method_1862(isCustom);
        customSlotField.method_1863(val -> {
            for (EquipmentSlotEntry entry : this.equipmentEntries) {
                if (entry.customSlotField != customSlotField) continue;
                entry.currentSlot = val.isEmpty() ? "CUSTOM" : val;
                customSlotValue[0] = val;
                break;
            }
        });
        class_342 itemField = new class_342(this.field_22793, x + 185, y, 175, 18, (class_2561)class_2561.method_43470((String)"Item ID"));
        itemField.method_1852(itemId);
        itemField.method_47404((class_2561)class_2561.method_43470((String)"minecraft:diamond_helmet"));
        itemField.method_1880(500);
        class_4185 browseBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\ud83d\udd0d"), b -> {
            String currentValue = itemField.method_1882();
            this.field_22787.method_1507((class_437)new IconPickerScreen(this, currentValue.isEmpty() ? "minecraft:" : currentValue, newValue -> {
                itemField.method_1852(newValue);
                this.field_22787.method_1507((class_437)this);
            }));
        }).method_46434(x + 365, y, 20, 18).method_46431();
        int nbtY = isCustom ? y + 48 : y + 24;
        class_342 nbtField = new class_342(this.field_22793, x + 185, nbtY, 200, 18, (class_2561)class_2561.method_43470((String)"NBT"));
        nbtField.method_1852(nbtStr);
        nbtField.method_47404((class_2561)class_2561.method_43470((String)"{Enchantments:[...]} (optional)"));
        nbtField.method_1880(500);
        nbtField.method_1862(initialShowNbt);
        class_4185 toggleNbtBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"NBT"), b -> {
            for (EquipmentSlotEntry entry : this.equipmentEntries) {
                if (entry.toggleNbtBtn != b) continue;
                entry.showNbt = !entry.showNbt;
                this.method_25423(this.field_22787, this.field_22789, this.field_22790);
                break;
            }
        }).method_46434(x + 390, y, 35, 18).method_46431();
        class_4185 removeBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"X"), b -> {
            for (int i = 0; i < this.equipmentEntries.size(); ++i) {
                if (this.equipmentEntries.get((int)i).removeBtn != b) continue;
                this.equipmentEntries.remove(i);
                this.method_25423(this.field_22787, this.field_22789, this.field_22790);
                break;
            }
        }).method_46434(x + 430, y, 20, 18).method_46431();
        EquipmentSlotEntry entry = new EquipmentSlotEntry(itemField, nbtField, customSlotField, slotBtn, removeBtn, toggleNbtBtn, isCustom ? initialSlot : slots[currentIndex[0]], isCustom);
        entry.showNbt = initialShowNbt;
        this.equipmentEntries.add(entry);
        this.method_37063((class_364)slotBtn);
        this.method_37063((class_364)customSlotField);
        this.method_37063((class_364)itemField);
        this.method_37063((class_364)browseBtn);
        this.method_37063((class_364)nbtField);
        this.method_37063((class_364)toggleNbtBtn);
        this.method_37063((class_364)removeBtn);
    }

    private String formatSlotLabel(String slot) {
        return switch (slot) {
            case "HEAD" -> "\u26d1 Head";
            case "CHEST" -> "\ud83d\udee1 Chest";
            case "LEGS" -> "\ud83d\udc56 Legs";
            case "FEET" -> "\ud83d\udc62 Feet";
            case "MAINHAND" -> "\u2694 Main";
            case "OFFHAND" -> "\ud83d\udee1 Off";
            case "CUSTOM" -> "\u270f Custom";
            default -> slot;
        };
    }

    private void initGenericTriggerRequirement(GenericTriggerRequirement gtr, int x, int y) {
        int panelY = (this.field_22790 - 250) / 2;
        class_4185 helpBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"?"), b -> this.field_22787.method_1507((class_437)new GenericTriggerHelpScreen(this))).method_46434(x + 500 - 25, panelY + 10, 20, 20).method_46431();
        this.method_37063((class_364)helpBtn);
        class_4185 loadExampleBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Examples"), b -> this.field_22787.method_1507((class_437)new ExamplePickerScreen(this, example -> {
            this.applyExample(gtr, (String)example);
            this.method_25423(this.field_22787, this.field_22789, this.field_22790);
        }))).method_46434(x + 500 - 105, panelY + 10, 75, 20).method_46431();
        this.method_37063((class_364)loadExampleBtn);
        class_342 triggerIdField = this.createField(x + 100, y, 260, gtr.getTriggerId(), "e.g., minecraft:placed_block");
        List<class_2960> knownTriggers = TriggerListenerManager.getInstance().getKnownTriggerIds();
        if (!knownTriggers.isEmpty()) {
            class_4185 pickBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Pick"), b -> this.field_22787.method_1507((class_437)new TriggerPickerScreen(this, selected -> {
                try {
                    Field triggerIdFieldRef = GenericTriggerRequirement.class.getDeclaredField("triggerId");
                    triggerIdFieldRef.setAccessible(true);
                    triggerIdFieldRef.set(gtr, selected);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }))).method_46434(x + 370, y, 50, 20).method_46431();
            this.method_37063((class_364)pickBtn);
        }
        class_4185 modeBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)("Mode: " + (this.isAdvancedMode ? "JSON" : "Simple"))), b -> {
            boolean bl = this.isAdvancedMode = !this.isAdvancedMode;
            if (this.isAdvancedMode) {
                String json = this.buildJsonFromEntries();
                try {
                    Field conditionsField = GenericTriggerRequirement.class.getDeclaredField("conditions");
                    conditionsField.setAccessible(true);
                    conditionsField.set(gtr, JsonParser.parseString((String)json).getAsJsonObject());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.method_25423(this.field_22787, this.field_22789, this.field_22790);
            } else {
                String jsonStr = this.getFieldValue(1);
                if (this.canParseToSimple(jsonStr)) {
                    try {
                        Field conditionsField = GenericTriggerRequirement.class.getDeclaredField("conditions");
                        conditionsField.setAccessible(true);
                        conditionsField.set(gtr, JsonParser.parseString((String)jsonStr).getAsJsonObject());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.method_25423(this.field_22787, this.field_22789, this.field_22790);
                } else {
                    this.isAdvancedMode = true;
                }
            }
        }).method_46434(x + 100, y + 24, 120, 20).method_46431();
        this.method_37063((class_364)modeBtn);
        if (this.isAdvancedMode) {
            class_342 class_3422 = this.createField(x + 100, y + 24, 380, gtr.getConditions().toString(), "{\"block\": \"minecraft:stone\"}");
        } else {
            int startY;
            if (this.conditionEntries.isEmpty() && !gtr.getConditions().entrySet().isEmpty()) {
                this.parseJsonToEntries(gtr.getConditions(), x, y);
            }
            int currentY = startY = y + 48;
            if (this.conditionEntries.isEmpty()) {
                // empty if block
            }
            for (ConditionEntry entry : this.conditionEntries) {
                entry.keyField.method_47404((class_2561)class_2561.method_43470((String)"property (e.g., block, item)"));
                entry.valueField.method_47404((class_2561)class_2561.method_43470((String)"expected value"));
                this.method_37063((class_364)entry.keyField);
                this.method_37063((class_364)entry.valueField);
                this.method_37063((class_364)entry.removeBtn);
                entry.keyField.method_46421(x + 100);
                entry.keyField.method_46419(currentY);
                entry.valueField.method_46421(x + 230);
                entry.valueField.method_46419(currentY);
                entry.removeBtn.method_46421(x + 360);
                entry.removeBtn.method_46419(currentY);
                currentY += 24;
            }
            this.addConditionBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"+ Add"), b -> {
                int newY = startY + this.conditionEntries.size() * 24;
                this.addConditionEntry(x, newY);
            }).method_46434(x + 100, currentY, 60, 20).method_46431();
            this.method_37063((class_364)this.addConditionBtn);
        }
    }

    private void applyExample(GenericTriggerRequirement gtr, String exampleType) {
        try {
            Field triggerField = GenericTriggerRequirement.class.getDeclaredField("triggerId");
            Field conditionsField = GenericTriggerRequirement.class.getDeclaredField("conditions");
            triggerField.setAccessible(true);
            conditionsField.setAccessible(true);
            JsonObject conditions = new JsonObject();
            switch (exampleType) {
                case "Place Block": {
                    triggerField.set(gtr, "minecraft:placed_block");
                    conditions.addProperty("block", "minecraft:stone");
                    break;
                }
                case "Use Item": {
                    triggerField.set(gtr, "minecraft:item_used_on_block");
                    conditions.addProperty("item", "minecraft:diamond_pickaxe");
                    break;
                }
                case "Kill Entity": {
                    triggerField.set(gtr, "minecraft:player_killed_entity");
                    JsonObject entity = new JsonObject();
                    entity.addProperty("type", "minecraft:zombie");
                    conditions.add("entity", (JsonElement)entity);
                    break;
                }
                case "Enter Structure": {
                    triggerField.set(gtr, "minecraft:location");
                    JsonObject location = new JsonObject();
                    location.addProperty("structure", "minecraft:village");
                    conditions.add("location", (JsonElement)location);
                    break;
                }
                case "Clear": {
                    conditions = new JsonObject();
                }
            }
            conditionsField.set(gtr, conditions);
            this.conditionEntries.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addConditionEntry(int x, int y) {
        class_342 key = new class_342(this.field_22793, x + 100, y, 120, 18, (class_2561)class_2561.method_43470((String)"Property"));
        key.method_47404((class_2561)class_2561.method_43470((String)"block, item, entity..."));
        class_342 value = new class_342(this.field_22793, x + 230, y, 120, 18, (class_2561)class_2561.method_43470((String)"Value"));
        value.method_47404((class_2561)class_2561.method_43470((String)"expected value"));
        class_4185 remove = class_4185.method_46430((class_2561)class_2561.method_43470((String)"X"), b -> {
            this.conditionEntries.removeIf(e -> e.removeBtn == b);
            this.method_25423(this.field_22787, this.field_22789, this.field_22790);
        }).method_46434(x + 360, y, 20, 18).method_46431();
        this.conditionEntries.add(new ConditionEntry(key, value, remove));
        this.method_37063((class_364)key);
        this.method_37063((class_364)value);
        this.method_37063((class_364)remove);
        if (this.addConditionBtn != null) {
            this.addConditionBtn.method_46419(y + 24);
        }
    }

    private void parseJsonToEntries(JsonObject json, int x, int y) {
        this.conditionEntries.clear();
        for (String key : json.keySet()) {
            class_4185 r;
            class_342 v;
            class_342 k;
            JsonElement el = json.get(key);
            if (el.isJsonPrimitive()) {
                k = new class_342(this.field_22793, 0, 0, 120, 18, (class_2561)class_2561.method_43470((String)"Property"));
                k.method_1852(key);
                k.method_47404((class_2561)class_2561.method_43470((String)"block, item, entity..."));
                v = new class_342(this.field_22793, 0, 0, 120, 18, (class_2561)class_2561.method_43470((String)"Value"));
                v.method_1852(el.getAsString());
                v.method_47404((class_2561)class_2561.method_43470((String)"expected value"));
                r = class_4185.method_46430((class_2561)class_2561.method_43470((String)"X"), b -> {
                    this.conditionEntries.removeIf(e -> e.removeBtn == b);
                    this.method_25423(this.field_22787, this.field_22789, this.field_22790);
                }).method_46434(0, 0, 20, 18).method_46431();
                this.conditionEntries.add(new ConditionEntry(k, v, r));
                continue;
            }
            k = new class_342(this.field_22793, 0, 0, 120, 18, (class_2561)class_2561.method_43470((String)"Property"));
            k.method_1852(key);
            k.method_47404((class_2561)class_2561.method_43470((String)"block, item, entity..."));
            v = new class_342(this.field_22793, 0, 0, 120, 18, (class_2561)class_2561.method_43470((String)"Value"));
            v.method_1852(el.toString());
            v.method_47404((class_2561)class_2561.method_43470((String)"expected value"));
            r = class_4185.method_46430((class_2561)class_2561.method_43470((String)"X"), b -> {
                this.conditionEntries.removeIf(e -> e.removeBtn == b);
                this.method_25423(this.field_22787, this.field_22789, this.field_22790);
            }).method_46434(0, 0, 20, 18).method_46431();
            this.conditionEntries.add(new ConditionEntry(k, v, r));
        }
    }

    private String buildJsonFromEntries() {
        JsonObject json = new JsonObject();
        for (ConditionEntry entry : this.conditionEntries) {
            String k = entry.keyField.method_1882();
            String v = entry.valueField.method_1882();
            if (k.isBlank()) continue;
            if (v.equalsIgnoreCase("true")) {
                json.addProperty(k, Boolean.valueOf(true));
                continue;
            }
            if (v.equalsIgnoreCase("false")) {
                json.addProperty(k, Boolean.valueOf(false));
                continue;
            }
            try {
                if (v.contains(".")) {
                    json.addProperty(k, (Number)Double.parseDouble(v));
                    continue;
                }
                json.addProperty(k, (Number)Long.parseLong(v));
            }
            catch (NumberFormatException e) {
                json.addProperty(k, v);
            }
        }
        return json.toString();
    }

    private boolean canParseToSimple(String jsonStr) {
        try {
            JsonObject json = JsonParser.parseString((String)jsonStr).getAsJsonObject();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private class_4185 createToggleButton(String label, boolean initialState, int x, int y) {
        return this.createToggleButton(label, initialState, "Yes", "No", x, y);
    }

    private class_4185 createToggleButton(String label, boolean initialState, String trueText, String falseText, int x, int y) {
        class_4185 btn = class_4185.method_46430((class_2561)class_2561.method_43470((String)(label + ": " + (initialState ? trueText : falseText))), b -> {
            this.toggleState = !this.toggleState;
            b.method_25355((class_2561)class_2561.method_43470((String)(label + ": " + (this.toggleState ? trueText : falseText))));
        }).method_46434(x, y, 120, 20).method_46431();
        this.method_37063((class_364)btn);
        return btn;
    }

    private class_4185 createCycleButton(String label, String initialValue, String[] options, int x, int y) {
        int[] indexRef = new int[]{this.findIndex(options, initialValue)};
        class_4185 btn = class_4185.method_46430((class_2561)class_2561.method_43470((String)(label + ": " + options[indexRef[0]])), b -> {
            indexRef[0] = (indexRef[0] + 1) % options.length;
            this.tempCycleValue = options[indexRef[0]];
            b.method_25355((class_2561)class_2561.method_43470((String)(label + ": " + this.tempCycleValue)));
        }).method_46434(x, y, 130, 20).method_46431();
        this.method_37063((class_364)btn);
        return btn;
    }

    private int findIndex(String[] array, String value) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equalsIgnoreCase(value)) continue;
            return i;
        }
        return 0;
    }

    private void initControlButtons(int panelX) {
        int btnY = this.field_22790 / 2 + 100;
        this.saveBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Save"), b -> this.save()).method_46434(panelX + 500 - 140, btnY, 60, 20).method_46431();
        this.method_37063((class_364)this.saveBtn);
        this.cancelBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Cancel"), b -> this.field_22787.method_1507(this.parent)).method_46434(panelX + 500 - 70, btnY, 60, 20).method_46431();
        this.method_37063((class_364)this.cancelBtn);
    }

    private void save() {
        try {
            Requirement updated = this.buildUpdatedRequirement();
            if (updated != null) {
                this.onSave.accept(updated);
                this.method_25395(null);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private Requirement buildUpdatedRequirement() {
        Requirement tr;
        if (this.requirement instanceof ItemRequirement) {
            ItemRequirement ir = new ItemRequirement(this.getFieldValue(0), this.parseInt(1));
            ir.setConsume(this.toggleState);
            ir.setOnlyFromCrafting(this.onlyFromCraftingState);
            ir.setTaskScreenOnly(this.taskScreenOnlyState);
            ir.setMatchComponents(this.matchComponentsValue);
            return ir;
        }
        if (this.requirement instanceof EntityKillRequirement) {
            EntityKillRequirement kr = new EntityKillRequirement(this.getFieldValue(0), this.parseInt(1));
            if (!this.customNameValue.isEmpty()) {
                kr.setCustomName(this.customNameValue);
            }
            return kr;
        }
        Requirement kr = this.requirement;
        if (kr instanceof LocationRequirement) {
            LocationRequirement lr = (LocationRequirement)kr;
            lr.setX(this.parseInt(0));
            lr.setY(this.parseInt(1));
            lr.setZ(this.parseInt(2));
            lr.setRange(this.parseInt(3));
            return lr;
        }
        kr = this.requirement;
        if (kr instanceof XpRequirement) {
            XpRequirement xr = (XpRequirement)kr;
            xr.setAmount(this.parseLong(0));
            xr.setLevels(this.toggleState);
            return xr;
        }
        if (this.requirement instanceof CraftingRequirement) {
            return new CraftingRequirement(this.getFieldValue(0), this.parseInt(1));
        }
        kr = this.requirement;
        if (kr instanceof StageRequirement) {
            StageRequirement sr = (StageRequirement)kr;
            sr.setStage(this.getFieldValue(0));
            return sr;
        }
        kr = this.requirement;
        if (kr instanceof ObservationRequirement) {
            ObservationRequirement or = (ObservationRequirement)kr;
            or.setTargetId(this.getFieldValue(0));
            or.setTimer(this.parseInt(1));
            or.setObserveType(this.tempCycleValue != null ? this.tempCycleValue : "entity");
            return or;
        }
        kr = this.requirement;
        if (kr instanceof StructureRequirement) {
            StructureRequirement sr = (StructureRequirement)kr;
            sr.setStructureId(this.getFieldValue(0));
            return sr;
        }
        if (this.requirement instanceof RegionRequirement) {
            return new RegionRequirement(this.getFieldValue(0), this.parseInt(1), this.parseInt(2), this.parseInt(3), this.parseInt(4), this.parseInt(5), this.parseInt(6));
        }
        if (this.requirement instanceof ItemTagRequirement) {
            tr = new ItemTagRequirement(this.getFieldValue(0), this.parseInt(1));
            ((ItemTagRequirement)tr).setConsume(this.toggleState);
            return tr;
        }
        if (this.requirement instanceof AdvancementRequirement) {
            return new AdvancementRequirement(this.getFieldValue(0));
        }
        tr = this.requirement;
        if (tr instanceof BiomeRequirement) {
            BiomeRequirement br = (BiomeRequirement)tr;
            br.setBiomeId(this.getFieldValue(0));
            return br;
        }
        tr = this.requirement;
        if (tr instanceof DimensionRequirement) {
            DimensionRequirement dr = (DimensionRequirement)tr;
            dr.setDimensionId(this.getFieldValue(0));
            return dr;
        }
        if (this.requirement instanceof WeatherRequirement) {
            String modeStr = this.tempCycleValue != null ? this.tempCycleValue : "CLEAR";
            WeatherRequirement.Mode mode = WeatherRequirement.Mode.valueOf(modeStr);
            return new WeatherRequirement(mode);
        }
        if (this.requirement instanceof TimeRequirement) {
            return new TimeRequirement(this.parseLong(0), this.parseLong(1));
        }
        if (this.requirement instanceof CommandRequirement) {
            return new CommandRequirement(this.getFieldValue(0), this.getFieldValue(1));
        }
        if (this.requirement instanceof CheckmarkRequirement) {
            return new CheckmarkRequirement(this.getFieldValue(0), this.getFieldValue(1));
        }
        if (this.requirement instanceof CustomRequirement) {
            return new CustomRequirement(this.getFieldValue(0), this.getFieldValue(1), this.parseLong(2));
        }
        if (this.requirement instanceof StatisticRequirement) {
            return new StatisticRequirement(this.getFieldValue(0), this.parseInt(1));
        }
        if (this.requirement instanceof EnergyRequirement) {
            return new EnergyRequirement(this.parseLong(0));
        }
        if (this.requirement instanceof FluidRequirement) {
            FluidRequirement fr = new FluidRequirement(this.getFieldValue(0), this.parseLong(1));
            String nbt = this.getFieldValue(2);
            if (!nbt.isBlank()) {
                try {
                    fr.setNbt(class_2522.method_10718((String)nbt));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return fr;
        }
        if (this.requirement instanceof CurrencyRequirement) {
            return new CurrencyRequirement(this.getFieldValue(0), this.parseLong(1));
        }
        if (this.requirement instanceof GenericTriggerRequirement) {
            JsonObject conditions;
            String triggerId = this.getFieldValue(0);
            if (this.isAdvancedMode) {
                String jsonStr = this.getFieldValue(1);
                try {
                    conditions = JsonParser.parseString((String)jsonStr).getAsJsonObject();
                }
                catch (Exception e) {
                    return null;
                }
            } else {
                conditions = new JsonObject();
                for (ConditionEntry entry : this.conditionEntries) {
                    String k = entry.keyField.method_1882();
                    String v = entry.valueField.method_1882();
                    if (k.isBlank()) continue;
                    if (v.equalsIgnoreCase("true")) {
                        conditions.addProperty(k, Boolean.valueOf(true));
                        continue;
                    }
                    if (v.equalsIgnoreCase("false")) {
                        conditions.addProperty(k, Boolean.valueOf(false));
                        continue;
                    }
                    try {
                        if (v.contains(".")) {
                            conditions.addProperty(k, (Number)Double.parseDouble(v));
                            continue;
                        }
                        conditions.addProperty(k, (Number)Long.parseLong(v));
                    }
                    catch (NumberFormatException e) {
                        conditions.addProperty(k, v);
                    }
                }
            }
            return new GenericTriggerRequirement(triggerId, conditions);
        }
        if (this.requirement instanceof EquipItemRequirement) {
            EquipItemRequirement eir = new EquipItemRequirement();
            for (EquipmentSlotEntry entry : this.equipmentEntries) {
                EquipItemRequirement.EquipmentEntry equipEntry = new EquipItemRequirement.EquipmentEntry(entry.currentSlot, entry.itemField.method_1882());
                String nbt = entry.nbtField.method_1882().trim();
                if (!nbt.isBlank()) {
                    try {
                        equipEntry.setNbt(class_2522.method_10718((String)nbt));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                eir.addEntry(equipEntry);
            }
            return eir;
        }
        return this.requirement;
    }

    private String getFieldValue(int index) {
        return this.fields.get(index).method_1882().trim();
    }

    private int parseInt(int index) {
        return Integer.parseInt(this.getFieldValue(index));
    }

    private long parseLong(int index) {
        return Long.parseLong(this.getFieldValue(index));
    }

    public void method_25394(class_332 g, int mouseX, int mouseY, float partialTick) {
        this.method_25420(g);
        int panelX = (this.field_22789 - 500) / 2;
        int panelY = (this.field_22790 - 250) / 2;
        g.method_25294(panelX, panelY, panelX + 500, panelY + 250, -535818224);
        g.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, panelY + 12, -1);
        this.renderLabels(g, panelX, panelY + 40);
        super.method_25394(g, mouseX, mouseY, partialTick);
    }

    private void renderLabels(class_332 g, int x, int y) {
        if (this.requirement instanceof ItemRequirement) {
            this.drawLabel(g, "Item ID:", x, y);
            this.drawLabel(g, "Count:", x, y + 24);
            this.drawLabel(g, "Consume:", x, y + 48);
        } else if (this.requirement instanceof EntityKillRequirement) {
            this.drawLabel(g, "Entity ID:", x, y);
            this.drawLabel(g, "Count:", x, y + 24);
            this.drawLabel(g, "Name Filter:", x, y + 48);
        } else if (this.requirement instanceof LocationRequirement) {
            this.drawLabel(g, "X:", x, y);
            this.drawLabel(g, "Y:", x + 110, y);
            this.drawLabel(g, "Z:", x + 220, y);
            this.drawLabel(g, "Radius:", x, y + 24);
        } else if (this.requirement instanceof XpRequirement) {
            this.drawLabel(g, "Amount:", x, y);
        } else if (this.requirement instanceof CraftingRequirement) {
            this.drawLabel(g, "Item ID:", x, y);
            this.drawLabel(g, "Count:", x, y + 24);
        } else if (this.requirement instanceof StageRequirement) {
            this.drawLabel(g, "Stage Name:", x, y);
        } else if (this.requirement instanceof ObservationRequirement) {
            this.drawLabel(g, "Target ID:", x, y);
            this.drawLabel(g, "Timer (ticks):", x, y + 24);
        } else if (this.requirement instanceof StructureRequirement) {
            this.drawLabel(g, "Structure:", x, y);
        } else if (this.requirement instanceof RegionRequirement) {
            this.drawLabel(g, "Dimension:", x, y);
            this.drawLabel(g, "x1:", x, y + 24);
            this.drawLabel(g, "y1:", x + 134, y + 24);
            this.drawLabel(g, "z1:", x + 198, y + 24);
            this.drawLabel(g, "x2:", x, y + 48);
            this.drawLabel(g, "y2:", x + 134, y + 48);
            this.drawLabel(g, "z2:", x + 198, y + 48);
        } else if (this.requirement instanceof ItemTagRequirement) {
            this.drawLabel(g, "Tag:", x, y);
            this.drawLabel(g, "Count:", x, y + 24);
            this.drawLabel(g, "Consume:", x, y + 48);
        } else if (this.requirement instanceof AdvancementRequirement) {
            this.drawLabel(g, "Advancement ID:", x, y);
        } else if (this.requirement instanceof BiomeRequirement) {
            this.drawLabel(g, "Biome or Tag:", x, y);
        } else if (this.requirement instanceof DimensionRequirement) {
            this.drawLabel(g, "Dimension ID:", x, y);
        } else if (this.requirement instanceof WeatherRequirement) {
            this.drawLabel(g, "Weather Mode:", x, y);
        } else if (this.requirement instanceof TimeRequirement) {
            this.drawLabel(g, "Start:", x, y);
            this.drawLabel(g, "End:", x + 200, y);
        } else if (this.requirement instanceof CommandRequirement) {
            this.drawLabel(g, "Command ID:", x, y);
            this.drawLabel(g, "Description:", x, y + 24);
        } else if (this.requirement instanceof CustomRequirement) {
            this.drawLabel(g, "Task ID:", x, y);
            this.drawLabel(g, "Description:", x, y + 24);
            this.drawLabel(g, "Max:", x, y + 48);
        } else if (this.requirement instanceof StatisticRequirement) {
            this.drawLabel(g, "Statistic:", x, y);
            this.drawLabel(g, "Target:", x, y + 24);
        } else if (this.requirement instanceof EnergyRequirement) {
            this.drawLabel(g, "Amount (FE):", x, y);
        } else if (this.requirement instanceof FluidRequirement) {
            this.drawLabel(g, "Fluid ID:", x, y);
            this.drawLabel(g, "Amount (mB):", x, y + 24);
            this.drawLabel(g, "NBT:", x, y + 48);
        } else if (this.requirement instanceof CurrencyRequirement) {
            this.drawLabel(g, "Currency ID:", x, y);
            this.drawLabel(g, "Amount:", x, y + 24);
        } else if (this.requirement instanceof GenericTriggerRequirement) {
            this.drawLabel(g, "Trigger ID:", x, y);
            g.method_25303(this.field_22793, "(?)", x + 70, y + 5, 0x888888);
            if (this.isAdvancedMode) {
                this.drawLabel(g, "Conditions (JSON):", x, y + 24);
                if (this.fields.size() > 1) {
                    String jsonStr = this.fields.get(1).method_1882();
                    boolean valid = this.isValidJson(jsonStr);
                    String indicator = valid ? "\u2713 Valid" : "\u2717 Invalid JSON";
                    int color = valid ? 0x55FF55 : 0xFF5555;
                    g.method_25303(this.field_22793, indicator, x + 400, y + 24 + 5, color);
                }
            } else {
                this.drawLabel(g, "Conditions:", x, y + 24);
                if (this.conditionEntries.isEmpty()) {
                    g.method_25303(this.field_22793, "(empty = triggers on any occurrence)", x + 100, y + 48 + 5, 0x888888);
                }
            }
        } else if (this.requirement instanceof EquipItemRequirement) {
            this.drawLabel(g, "Equipment Slots:", x, y);
        }
    }

    private void drawLabel(class_332 g, String text, int x, int y) {
        g.method_25303(this.field_22793, text, x + 12, y + 5, -1);
    }

    private boolean isValidJson(String jsonStr) {
        if (jsonStr == null || jsonStr.trim().isEmpty()) {
            return true;
        }
        try {
            JsonParser.parseString((String)jsonStr);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (this.requirement instanceof EquipItemRequirement && this.totalEquipmentEntries > 3) {
            int maxScroll = this.totalEquipmentEntries - 3;
            float scrollStep = 1.0f / (float)maxScroll;
            this.equipmentScrollOffset = Math.max(0.0f, Math.min(1.0f, this.equipmentScrollOffset - (float)delta * scrollStep));
            this.method_25423(this.field_22787, this.field_22789, this.field_22790);
            return true;
        }
        return super.method_25401(mouseX, mouseY, delta);
    }

    public boolean method_25421() {
        return false;
    }

    private static class EquipmentSlotEntry {
        class_342 itemField;
        class_342 nbtField;
        class_342 customSlotField;
        class_4185 slotBtn;
        class_4185 removeBtn;
        class_4185 toggleNbtBtn;
        String currentSlot;
        boolean showNbt;
        boolean isCustomSlot;

        EquipmentSlotEntry(class_342 item, class_342 nbt, class_342 customSlot, class_4185 slot, class_4185 remove, class_4185 toggleNbt, String initialSlot, boolean isCustom) {
            this.itemField = item;
            this.nbtField = nbt;
            this.customSlotField = customSlot;
            this.slotBtn = slot;
            this.removeBtn = remove;
            this.toggleNbtBtn = toggleNbt;
            this.currentSlot = initialSlot;
            this.showNbt = false;
            this.isCustomSlot = isCustom;
        }
    }

    private static class TempEquipmentData {
        String slot;
        String itemId;
        String nbt;
        boolean showNbt;

        TempEquipmentData(String slot, String itemId, String nbt, boolean showNbt) {
            this.slot = slot;
            this.itemId = itemId;
            this.nbt = nbt;
            this.showNbt = showNbt;
        }
    }

    private static class ConditionEntry {
        class_342 keyField;
        class_342 valueField;
        class_4185 removeBtn;

        ConditionEntry(class_342 key, class_342 value, class_4185 remove) {
            this.keyField = key;
            this.valueField = value;
            this.removeBtn = remove;
        }
    }
}

