/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.texboobcat.questory.client.gui.QuestEditorScreen;
import org.texboobcat.questory.client.gui.RequirementEditorScreen;
import org.texboobcat.questory.client.gui.RequirementTypePickerScreen;
import org.texboobcat.questory.client.gui.TabPanel;
import org.texboobcat.questory.quest.AdvancementRequirement;
import org.texboobcat.questory.quest.BiomeRequirement;
import org.texboobcat.questory.quest.CheckmarkRequirement;
import org.texboobcat.questory.quest.CommandRequirement;
import org.texboobcat.questory.quest.CraftingRequirement;
import org.texboobcat.questory.quest.CurrencyRequirement;
import org.texboobcat.questory.quest.CustomRequirement;
import org.texboobcat.questory.quest.DimensionRequirement;
import org.texboobcat.questory.quest.EnergyRequirement;
import org.texboobcat.questory.quest.EntityKillRequirement;
import org.texboobcat.questory.quest.EquipItemRequirement;
import org.texboobcat.questory.quest.FluidRequirement;
import org.texboobcat.questory.quest.GenericTriggerRequirement;
import org.texboobcat.questory.quest.ItemRequirement;
import org.texboobcat.questory.quest.ItemTagRequirement;
import org.texboobcat.questory.quest.LocationRequirement;
import org.texboobcat.questory.quest.ObservationRequirement;
import org.texboobcat.questory.quest.Quest;
import org.texboobcat.questory.quest.RegionRequirement;
import org.texboobcat.questory.quest.Requirement;
import org.texboobcat.questory.quest.StageRequirement;
import org.texboobcat.questory.quest.StatisticRequirement;
import org.texboobcat.questory.quest.StructureRequirement;
import org.texboobcat.questory.quest.TimeRequirement;
import org.texboobcat.questory.quest.WeatherRequirement;
import org.texboobcat.questory.quest.XpRequirement;

public class RequirementsTabPanel
extends TabPanel {
    private static final int LINE_HEIGHT = 40;
    private static final int BUTTON_HEIGHT = 20;
    private static final int PADDING = 12;
    private static final Map<String, RequirementFactory> REQUIREMENT_FACTORIES = Map.ofEntries(Map.entry("item", () -> new ItemRequirement("minecraft:dirt", 1)), Map.entry("kill", () -> new EntityKillRequirement("minecraft:zombie", 10)), Map.entry("checkmark", () -> new CheckmarkRequirement("check_" + System.currentTimeMillis(), "Click to complete")), Map.entry("location", () -> new LocationRequirement(0, 64, 0, 10, "minecraft:overworld")), Map.entry("xp", () -> new XpRequirement(100L, false)), Map.entry("advancement", () -> new AdvancementRequirement("minecraft:story/mine_stone")), Map.entry("biome", () -> new BiomeRequirement("minecraft:plains")), Map.entry("dimension", () -> new DimensionRequirement("minecraft:the_nether")), Map.entry("crafting", () -> new CraftingRequirement("minecraft:crafting_table", 1)), Map.entry("fluid", () -> new FluidRequirement("minecraft:water", 1000L)), Map.entry("energy", () -> new EnergyRequirement(10000L)), Map.entry("currency", () -> new CurrencyRequirement("coins", 100L)), Map.entry("statistic", () -> new StatisticRequirement("minecraft:walk_one_cm", 100000)), Map.entry("custom", () -> new CustomRequirement("custom_task", "Complete custom task", 1L)), Map.entry("command", () -> new CommandRequirement("cmd_" + System.currentTimeMillis(), "Triggered by command")), Map.entry("time", () -> new TimeRequirement(0L, 12000L)), Map.entry("weather", () -> new WeatherRequirement(WeatherRequirement.Mode.CLEAR)), Map.entry("structure", () -> new StructureRequirement("minecraft:village")), Map.entry("stage", () -> new StageRequirement("stage_name")), Map.entry("region", () -> new RegionRequirement("minecraft:overworld", 0, 0, 0, 100, 100, 100)), Map.entry("observation", () -> new ObservationRequirement("minecraft:cow", "entity", 100)), Map.entry("item_tag", () -> new ItemTagRequirement("#minecraft:logs", 64)), Map.entry("generic_trigger", () -> new GenericTriggerRequirement("minecraft:placed_block")), Map.entry("equip_item", () -> new EquipItemRequirement()));
    private final List<Requirement> requirements = new ArrayList<Requirement>();
    private int selectedIndex = -1;
    private int listScroll = 0;
    private boolean sequential = false;
    private class_4185 addBtn;
    private class_4185 editBtn;
    private class_4185 removeBtn;
    private class_4185 moveUpBtn;
    private class_4185 moveDownBtn;
    private class_4185 sequentialBtn;

    public RequirementsTabPanel(QuestEditorScreen editor, int x, int y, int w, int h) {
        super(editor, x, y, w, h);
        this.initWidgets();
    }

    private void initWidgets() {
        int btnY = this.y + this.h - 32;
        this.addBtn = this.createButton("+ Add", btnY, this.x + 12, 60, this::openAddDialog);
        this.editBtn = this.createButton("Edit", btnY, this.x + 76, 60, this::openEditDialog);
        this.removeBtn = this.createButton("Remove", btnY, this.x + 140, 70, this::removeSelected);
        this.moveUpBtn = this.createButton("\u2191", btnY, this.x + 214, 30, this::moveUp);
        this.moveDownBtn = this.createButton("\u2193", btnY, this.x + 248, 30, this::moveDown);
        this.sequentialBtn = this.createButton("Sequential: No", btnY, this.x + this.w - 150, 140, this::toggleSequential);
    }

    private class_4185 createButton(String label, int y, int x, int width, Runnable action) {
        return class_4185.method_46430((class_2561)class_2561.method_43470((String)label), b -> action.run()).method_46434(x, y, width, 20).method_46431();
    }

    private void toggleSequential() {
        this.sequential = !this.sequential;
        this.sequentialBtn.method_25355((class_2561)class_2561.method_43470((String)("Sequential: " + (this.sequential ? "Yes" : "No"))));
        this.editor.saveCurrentTabToQuest();
    }

    private void openAddDialog() {
        this.getMinecraft().method_1507((class_437)new RequirementTypePickerScreen(this.editor, type -> {
            Requirement req = this.createRequirement((String)type);
            if (req != null) {
                this.requirements.add(req);
                this.editor.saveCurrentTabToQuest();
            }
            this.getMinecraft().method_1507((class_437)this.editor);
        }));
    }

    private Requirement createRequirement(String type) {
        RequirementFactory factory = REQUIREMENT_FACTORIES.get(type);
        if (factory != null) {
            return (Requirement)factory.get();
        }
        return null;
    }

    private void openEditDialog() {
        if (!this.isValidSelection()) {
            return;
        }
        Requirement req = this.requirements.get(this.selectedIndex);
        this.getMinecraft().method_1507((class_437)new RequirementEditorScreen(this.editor, req, updated -> {
            this.requirements.set(this.selectedIndex, (Requirement)updated);
            this.editor.saveCurrentTabToQuest();
            this.getMinecraft().method_1507((class_437)this.editor);
        }));
    }

    private void removeSelected() {
        if (this.isValidSelection()) {
            this.requirements.remove(this.selectedIndex);
            this.selectedIndex = -1;
            this.editor.saveCurrentTabToQuest();
        }
    }

    private void moveUp() {
        if (this.selectedIndex > 0) {
            this.swapRequirements(this.selectedIndex, this.selectedIndex - 1);
            --this.selectedIndex;
            this.editor.saveCurrentTabToQuest();
        }
    }

    private void moveDown() {
        if (this.selectedIndex >= 0 && this.selectedIndex < this.requirements.size() - 1) {
            this.swapRequirements(this.selectedIndex, this.selectedIndex + 1);
            ++this.selectedIndex;
            this.editor.saveCurrentTabToQuest();
        }
    }

    private void swapRequirements(int idx1, int idx2) {
        Requirement temp = this.requirements.get(idx1);
        this.requirements.set(idx1, this.requirements.get(idx2));
        this.requirements.set(idx2, temp);
    }

    private boolean isValidSelection() {
        return this.selectedIndex >= 0 && this.selectedIndex < this.requirements.size();
    }

    @Override
    public void loadFromQuest(Quest quest) {
        this.requirements.clear();
        this.requirements.addAll(quest.getRequirements());
        this.sequential = "true".equals(quest.getRequireSequentialTasks());
        this.sequentialBtn.method_25355((class_2561)class_2561.method_43470((String)("Sequential: " + (this.sequential ? "Yes" : "No"))));
        this.selectedIndex = -1;
        this.listScroll = 0;
    }

    @Override
    public void saveToQuest(Quest quest) {
        quest.getRequirements().clear();
        quest.getRequirements().addAll(this.requirements);
        quest.setRequireSequentialTasks(this.sequential ? "true" : "default");
    }

    @Override
    public void render(class_332 g, int mouseX, int mouseY, float partialTick) {
        int listX = this.x + 12;
        int listY = this.y + 12;
        int listW = this.w - 24;
        int listH = this.h - 60;
        this.renderHeader(g, listX, listY);
        this.renderList(g, listX, listY += 20, listW, listH -= 20, mouseX, mouseY);
        this.renderButtons(g, mouseX, mouseY, partialTick);
    }

    private void renderHeader(class_332 g, int x, int y) {
        g.method_25303(this.getFont(), "\u00a7lRequirements (" + this.requirements.size() + ")", x, y, -86);
    }

    private void renderList(class_332 g, int listX, int listY, int listW, int listH, int mouseX, int mouseY) {
        g.method_25294(listX, listY, listX + listW, listY + listH, -803200992);
        g.method_44379(listX, listY, listX + listW, listY + listH);
        int maxVisible = Math.max(1, listH / 40);
        this.listScroll = this.clampScroll(this.listScroll, this.requirements.size(), maxVisible);
        for (int i = 0; i < Math.min(maxVisible, this.requirements.size() - this.listScroll); ++i) {
            this.renderRequirementLine(g, listX, listY, listW, i, mouseX, mouseY);
        }
        g.method_44380();
    }

    private void renderRequirementLine(class_332 g, int listX, int listY, int listW, int offset, int mouseX, int mouseY) {
        int index = this.listScroll + offset;
        Requirement req = this.requirements.get(index);
        int itemY = listY + 4 + offset * 40;
        boolean selected = index == this.selectedIndex;
        boolean hover = this.isHovering(mouseX, mouseY, listX, itemY, listW, 40);
        if (selected) {
            g.method_25294(listX + 2, itemY, listX + listW - 2, itemY + 40 - 2, -12952966);
        } else if (hover) {
            g.method_25294(listX + 2, itemY, listX + listW - 2, itemY + 40 - 2, -14013910);
        }
        String typeLabel = "[" + req.getType().toUpperCase() + "]";
        String summary = RequirementFormatter.getSummary(req);
        g.method_25303(this.getFont(), index + 1 + ". " + typeLabel + " " + summary, listX + 8, itemY + 4, -1);
        String details = RequirementFormatter.getDetails(req);
        g.method_25303(this.getFont(), "  \u2514\u2500 " + details, listX + 12, itemY + 18, -3355444);
    }

    private boolean isHovering(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY < y + height;
    }

    private int clampScroll(int scroll, int totalItems, int maxVisible) {
        return Math.max(0, Math.min(scroll, Math.max(0, totalItems - maxVisible)));
    }

    private void renderButtons(class_332 g, int mouseX, int mouseY, float partialTick) {
        this.addBtn.method_25394(g, mouseX, mouseY, partialTick);
        this.editBtn.field_22763 = this.isValidSelection();
        this.editBtn.method_25394(g, mouseX, mouseY, partialTick);
        this.removeBtn.field_22763 = this.isValidSelection();
        this.removeBtn.method_25394(g, mouseX, mouseY, partialTick);
        this.moveUpBtn.field_22763 = this.selectedIndex > 0;
        this.moveUpBtn.method_25394(g, mouseX, mouseY, partialTick);
        this.moveDownBtn.field_22763 = this.selectedIndex >= 0 && this.selectedIndex < this.requirements.size() - 1;
        this.moveDownBtn.method_25394(g, mouseX, mouseY, partialTick);
        this.sequentialBtn.method_25394(g, mouseX, mouseY, partialTick);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.addBtn.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (this.editBtn.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (this.removeBtn.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (this.moveUpBtn.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (this.moveDownBtn.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (this.sequentialBtn.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        return this.handleListClick(mouseX, mouseY) || super.mouseClicked(mouseX, mouseY, button);
    }

    private boolean handleListClick(double mouseX, double mouseY) {
        int listX = this.x + 12;
        int listY = this.y + 32;
        int listW = this.w - 24;
        int listH = this.h - 80;
        if (mouseX >= (double)listX && mouseX <= (double)(listX + listW) && mouseY >= (double)listY && mouseY < (double)(listY + listH)) {
            int index = this.listScroll + ((int)mouseY - listY - 4) / 40;
            if (index >= 0 && index < this.requirements.size()) {
                this.selectedIndex = index;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        int listX = this.x + 12;
        int listY = this.y + 32;
        int listW = this.w - 24;
        int listH = this.h - 80;
        if (mouseX >= (double)listX && mouseX <= (double)(listX + listW) && mouseY >= (double)listY && mouseY < (double)(listY + listH)) {
            this.listScroll = (int)Math.max(0.0, (double)this.listScroll - Math.signum(delta));
            return true;
        }
        return false;
    }

    @FunctionalInterface
    private static interface RequirementFactory
    extends Supplier<Requirement> {
    }

    private static class RequirementFormatter {
        private RequirementFormatter() {
        }

        static String getSummary(Requirement req) {
            if (req instanceof ItemRequirement) {
                ItemRequirement ir = (ItemRequirement)req;
                return "Collect " + ir.getCount() + " " + Requirement.resolveItemName(ir.getItem(), ir.getNbt());
            }
            if (req instanceof EntityKillRequirement) {
                EntityKillRequirement kr = (EntityKillRequirement)req;
                return "Kill " + kr.getCount() + " " + kr.getEntity();
            }
            if (req instanceof LocationRequirement) {
                return "Reach location";
            }
            if (req instanceof XpRequirement) {
                XpRequirement xr = (XpRequirement)req;
                return "Collect " + xr.getAmount() + " " + (xr.isLevels() ? "levels" : "XP");
            }
            if (req instanceof AdvancementRequirement) {
                return "Complete advancement";
            }
            if (req instanceof BiomeRequirement) {
                return "Visit biome";
            }
            if (req instanceof DimensionRequirement) {
                return "Enter dimension";
            }
            if (req instanceof CraftingRequirement) {
                CraftingRequirement cr = (CraftingRequirement)req;
                return "Craft " + cr.getCount() + " " + Requirement.resolveItemName(cr.getItem());
            }
            if (req instanceof ObservationRequirement) {
                return RequirementFormatter.getObservationSummary((ObservationRequirement)req);
            }
            if (req instanceof StructureRequirement) {
                return "Find structure";
            }
            if (req instanceof RegionRequirement) {
                return "Enter region";
            }
            if (req instanceof ItemTagRequirement) {
                return "Collect items by tag";
            }
            if (req instanceof WeatherRequirement) {
                return "Weather state";
            }
            if (req instanceof TimeRequirement) {
                return "Time window";
            }
            if (req instanceof CommandRequirement) {
                return "Triggered by command";
            }
            if (req instanceof CustomRequirement) {
                return "Custom task";
            }
            if (req instanceof StatisticRequirement) {
                return "Statistic";
            }
            if (req instanceof EnergyRequirement) {
                return "Energy";
            }
            if (req instanceof FluidRequirement) {
                return "Fluid";
            }
            if (req instanceof CurrencyRequirement) {
                return "Currency";
            }
            if (req instanceof GenericTriggerRequirement) {
                return "Generic Trigger";
            }
            if (req instanceof EquipItemRequirement) {
                return "Equip Items";
            }
            return req.getType() + " requirement";
        }

        private static String getObservationSummary(ObservationRequirement or) {
            return switch (or.getObserveType().toLowerCase()) {
                case "entity" -> "Observe entity";
                case "block" -> "Observe block";
                case "item_hand" -> "Observe item in hand";
                case "item_entity" -> "Observe dropped item";
                default -> "Observation";
            };
        }

        static String getDetails(Requirement req) {
            if (req instanceof ItemRequirement) {
                return RequirementFormatter.formatItem((ItemRequirement)req);
            }
            if (req instanceof EntityKillRequirement) {
                return RequirementFormatter.formatEntityKill((EntityKillRequirement)req);
            }
            if (req instanceof LocationRequirement) {
                return RequirementFormatter.formatLocation((LocationRequirement)req);
            }
            if (req instanceof XpRequirement) {
                return RequirementFormatter.formatXp((XpRequirement)req);
            }
            if (req instanceof AdvancementRequirement) {
                AdvancementRequirement ar = (AdvancementRequirement)req;
                return "Advancement: " + ar.getAdvancement();
            }
            if (req instanceof BiomeRequirement) {
                return RequirementFormatter.formatBiome((BiomeRequirement)req);
            }
            if (req instanceof DimensionRequirement) {
                DimensionRequirement dr = (DimensionRequirement)req;
                return "Dimension: " + dr.getDimensionId();
            }
            if (req instanceof CraftingRequirement) {
                return RequirementFormatter.formatCrafting((CraftingRequirement)req);
            }
            if (req instanceof ObservationRequirement) {
                return RequirementFormatter.formatObservation((ObservationRequirement)req);
            }
            if (req instanceof StructureRequirement) {
                StructureRequirement sr = (StructureRequirement)req;
                return "Structure: " + sr.getStructureId();
            }
            if (req instanceof RegionRequirement) {
                return RequirementFormatter.formatRegion((RegionRequirement)req);
            }
            if (req instanceof ItemTagRequirement) {
                return RequirementFormatter.formatItemTag((ItemTagRequirement)req);
            }
            if (req instanceof WeatherRequirement) {
                WeatherRequirement wr = (WeatherRequirement)req;
                return "Mode: " + String.valueOf((Object)wr.getMode());
            }
            if (req instanceof TimeRequirement) {
                return RequirementFormatter.formatTime((TimeRequirement)req);
            }
            if (req instanceof CommandRequirement) {
                return RequirementFormatter.formatCommand((CommandRequirement)req);
            }
            if (req instanceof CustomRequirement) {
                return RequirementFormatter.formatCustom((CustomRequirement)req);
            }
            if (req instanceof StatisticRequirement) {
                return RequirementFormatter.formatStatistic((StatisticRequirement)req);
            }
            if (req instanceof EnergyRequirement) {
                EnergyRequirement er = (EnergyRequirement)req;
                return "Amount: " + er.getAmount() + " FE";
            }
            if (req instanceof FluidRequirement) {
                return RequirementFormatter.formatFluid((FluidRequirement)req);
            }
            if (req instanceof CurrencyRequirement) {
                return RequirementFormatter.formatCurrency((CurrencyRequirement)req);
            }
            if (req instanceof GenericTriggerRequirement) {
                return RequirementFormatter.formatGenericTrigger((GenericTriggerRequirement)req);
            }
            if (req instanceof EquipItemRequirement) {
                return RequirementFormatter.formatEquipItem((EquipItemRequirement)req);
            }
            return "Type: " + req.getType();
        }

        private static String formatItem(ItemRequirement ir) {
            return String.format("Item: %s | Count: %d | Consume: %s", Requirement.resolveItemName(ir.getItem(), ir.getNbt()), ir.getCount(), ir.shouldConsume() ? "Yes" : "No");
        }

        private static String formatEntityKill(EntityKillRequirement kr) {
            return String.format("Entity: %s | Count: %d", kr.getEntity(), kr.getCount());
        }

        private static String formatLocation(LocationRequirement lr) {
            return String.format("X: %d, Y: %d, Z: %d | Range: %d | Dim: %s", lr.getX(), lr.getY(), lr.getZ(), lr.getRange(), lr.getDimension());
        }

        private static String formatXp(XpRequirement xr) {
            return String.format("Amount: %d | Type: %s", xr.getAmount(), xr.isLevels() ? "Levels" : "Points");
        }

        private static String formatBiome(BiomeRequirement br) {
            return "Biome: " + br.getBiomeId() + (br.isTag() ? " (tag)" : "");
        }

        private static String formatCrafting(CraftingRequirement cr) {
            return String.format("Item: %s | Count: %d", cr.getItem(), cr.getCount());
        }

        private static String formatObservation(ObservationRequirement or) {
            return String.format("Type: %s | Target: %s | Timer: %d ticks", or.getObserveType(), or.getTargetId(), or.getTimer());
        }

        private static String formatRegion(RegionRequirement rr) {
            return String.format("Dim: %s | [%d,%d,%d]-[%d,%d,%d]", rr.getDimension(), rr.getMinX(), rr.getMinY(), rr.getMinZ(), rr.getMaxX(), rr.getMaxY(), rr.getMaxZ());
        }

        private static String formatItemTag(ItemTagRequirement tr) {
            return String.format("Tag: #%s | Count: %d | Consume: %s", tr.getTag(), tr.getCount(), tr.shouldConsume() ? "Yes" : "No");
        }

        private static String formatTime(TimeRequirement tr) {
            return String.format("Start: %d | End: %d", tr.getStart(), tr.getEnd());
        }

        private static String formatCommand(CommandRequirement cr) {
            return String.format("ID: %s | %s", cr.getRequirementId(), cr.getDescription());
        }

        private static String formatCustom(CustomRequirement cu) {
            return String.format("Task: %s | Max: %d", cu.getTaskId(), cu.getMaxProgress());
        }

        private static String formatStatistic(StatisticRequirement sr) {
            return String.format("Stat: %s | Target: %d", sr.getStatistic(), sr.getTargetValue());
        }

        private static String formatFluid(FluidRequirement fr) {
            return String.format("Fluid: %s | Amount: %d mB", fr.getFluidId(), fr.getAmount());
        }

        private static String formatCurrency(CurrencyRequirement cr) {
            return String.format("Currency: %s | Amount: %d", cr.getCurrencyId(), cr.getAmount());
        }

        private static String formatGenericTrigger(GenericTriggerRequirement gtr) {
            return String.format("Trigger: %s", gtr.getTriggerId());
        }

        private static String formatEquipItem(EquipItemRequirement eir) {
            int count = eir.getEntries().size();
            if (count == 1) {
                EquipItemRequirement.EquipmentEntry entry = eir.getEntries().get(0);
                return String.format("Equip %s in %s", entry.getItemId(), entry.getSlotName());
            }
            return String.format("Equip %d pieces of gear", count);
        }
    }
}

