/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.texboobcat.questory.client.ClientTeamManager;
import org.texboobcat.questory.client.gui.ConfirmationDialog;
import org.texboobcat.questory.client.gui.TeamInviteDialog;
import org.texboobcat.questory.client.gui.TransferOwnershipDialog;
import org.texboobcat.questory.network.NetworkManager;
import org.texboobcat.questory.network.TeamActionPacket;
import org.texboobcat.questory.network.TeamSettingsPacket;
import org.texboobcat.questory.team.QuestTeam;

public class TeamManagementScreen
extends class_437 {
    private static final int WINDOW_WIDTH = 260;
    private static final int WINDOW_HEIGHT = 220;
    private final class_437 parent;
    private int leftPos;
    private int topPos;
    private TeamTab currentTab = TeamTab.INFO;
    private class_4185 infoTabButton;
    private class_4185 membersTabButton;
    private class_4185 invitesTabButton;
    private class_4185 settingsTabButton;
    private class_4185 leaveButton;
    private class_4185 closeButton;
    private class_4185 inviteButton;
    private List<MemberEntry> memberEntries = new ArrayList<MemberEntry>();
    private int memberListScroll = 0;
    private class_4185 transferOwnershipButton;
    private class_4185 disbandTeamButton;
    private class_342 maxMembersField;
    private class_4185 saveMaxMembersButton;

    public TeamManagementScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Team Management"));
        this.parent = parent;
    }

    protected void method_25426() {
        this.leftPos = (this.field_22789 - 260) / 2;
        this.topPos = (this.field_22790 - 220) / 2;
        int tabY = this.topPos + 30;
        int tabWidth = 60;
        this.infoTabButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Info"), btn -> this.switchTab(TeamTab.INFO)).method_46434(this.leftPos + 5, tabY, tabWidth, 20).method_46431();
        this.method_37063((class_364)this.infoTabButton);
        this.membersTabButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Members"), btn -> this.switchTab(TeamTab.MEMBERS)).method_46434(this.leftPos + 5 + tabWidth + 2, tabY, tabWidth, 20).method_46431();
        this.method_37063((class_364)this.membersTabButton);
        this.invitesTabButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Invites"), btn -> this.switchTab(TeamTab.INVITES)).method_46434(this.leftPos + 5 + (tabWidth + 2) * 2, tabY, tabWidth, 20).method_46431();
        this.method_37063((class_364)this.invitesTabButton);
        this.settingsTabButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Settings"), btn -> this.switchTab(TeamTab.SETTINGS)).method_46434(this.leftPos + 5 + (tabWidth + 2) * 3, tabY, tabWidth, 20).method_46431();
        this.method_37063((class_364)this.settingsTabButton);
        this.leaveButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Leave"), btn -> this.leaveTeam()).method_46434(this.leftPos + 260 - 80, this.topPos + 5, 35, 20).method_46431();
        this.method_37063((class_364)this.leaveButton);
        this.closeButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"X"), btn -> this.method_25419()).method_46434(this.leftPos + 260 - 40, this.topPos + 5, 35, 20).method_46431();
        this.method_37063((class_364)this.closeButton);
        this.inviteButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Invite Player"), btn -> this.openInviteDialog()).method_46434(this.leftPos + 10, this.topPos + 220 - 30, 100, 20).method_46431();
        this.method_37063((class_364)this.inviteButton);
        this.initSettingsWidgets();
        this.updateButtonStates();
    }

    private void initSettingsWidgets() {
        int contentY;
        int settingsX = this.leftPos + 10;
        int titleY = contentY = this.topPos + 55;
        int ownerLabelY = titleY + 20;
        int ownerButtonY = ownerLabelY + 12;
        int maxLabelY = ownerButtonY + 23;
        int maxFieldY = maxLabelY + 12;
        int dangerLabelY = maxFieldY + 28;
        int disbandButtonY = dangerLabelY + 12;
        this.transferOwnershipButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Transfer Ownership..."), btn -> this.transferOwnership()).method_46434(settingsX, ownerButtonY, 150, 20).method_46431();
        this.method_37063((class_364)this.transferOwnershipButton);
        this.maxMembersField = new class_342(this.field_22793, settingsX, maxFieldY, 60, 20, (class_2561)class_2561.method_43470((String)"Max Members"));
        this.maxMembersField.method_1880(2);
        this.maxMembersField.method_1852("10");
        this.maxMembersField.method_1863(this::onMaxMembersChanged);
        this.method_25429((class_364)this.maxMembersField);
        this.saveMaxMembersButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Save"), btn -> this.saveMaxMembers()).method_46434(settingsX + 65, maxFieldY, 45, 20).method_46431();
        this.method_37063((class_364)this.saveMaxMembersButton);
        this.disbandTeamButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Disband Team"), btn -> this.disbandTeam()).method_46434(settingsX, disbandButtonY, 150, 20).method_46431();
        this.method_37063((class_364)this.disbandTeamButton);
        this.loadTeamSettings();
        this.updateSettingsVisibility();
    }

    private void updateSettingsVisibility() {
        boolean showSettings;
        this.transferOwnershipButton.field_22764 = showSettings = this.currentTab == TeamTab.SETTINGS && ClientTeamManager.getInstance().isTeamOwner();
        this.maxMembersField.method_1862(showSettings);
        this.saveMaxMembersButton.field_22764 = showSettings;
        this.disbandTeamButton.field_22764 = showSettings;
    }

    private void loadTeamSettings() {
        QuestTeam team = ClientTeamManager.getInstance().getCurrentTeam();
        if (team != null && team.getSettings() != null) {
            this.maxMembersField.method_1852(String.valueOf(team.getSettings().getMaxMembers()));
        }
    }

    private void onMaxMembersChanged(String value) {
        if (!value.isEmpty() && !value.matches("\\d+")) {
            value = value.replaceAll("[^\\d]", "");
            this.maxMembersField.method_1852(value);
        }
    }

    private void switchTab(TeamTab tab) {
        this.currentTab = tab;
        this.updateButtonStates();
        this.updateSettingsVisibility();
    }

    private void updateButtonStates() {
        this.infoTabButton.field_22763 = this.currentTab != TeamTab.INFO;
        this.membersTabButton.field_22763 = this.currentTab != TeamTab.MEMBERS;
        this.invitesTabButton.field_22763 = this.currentTab != TeamTab.INVITES;
        this.settingsTabButton.field_22763 = this.currentTab != TeamTab.SETTINGS;
        boolean inTeam = ClientTeamManager.getInstance().isInTeam();
        boolean isOwner = ClientTeamManager.getInstance().isTeamOwner();
        this.leaveButton.field_22763 = inTeam;
        boolean bl = this.inviteButton.field_22763 = inTeam && isOwner;
        if (this.transferOwnershipButton != null) {
            this.transferOwnershipButton.field_22763 = isOwner;
        }
        if (this.disbandTeamButton != null) {
            this.disbandTeamButton.field_22763 = isOwner;
        }
        if (this.maxMembersField != null) {
            this.maxMembersField.method_1888(isOwner);
        }
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.method_25420(graphics);
        graphics.method_25294(this.leftPos, this.topPos, this.leftPos + 260, this.topPos + 220, -872415232);
        graphics.method_25294(this.leftPos, this.topPos, this.leftPos + 260, this.topPos + 28, -14540254);
        String teamName = ClientTeamManager.getInstance().getTeamName();
        if (teamName != null) {
            graphics.method_25303(this.field_22793, "Team: " + teamName, this.leftPos + 5, this.topPos + 10, 0xFFFFFF);
        } else {
            graphics.method_25303(this.field_22793, "No Team", this.leftPos + 5, this.topPos + 10, 0x888888);
        }
        this.renderTabContent(graphics, mouseX, mouseY);
        super.method_25394(graphics, mouseX, mouseY, partialTick);
    }

    private void renderTabContent(class_332 graphics, int mouseX, int mouseY) {
        int contentX = this.leftPos + 10;
        int contentY = this.topPos + 55;
        int contentWidth = 240;
        int contentHeight = 130;
        switch (this.currentTab.ordinal()) {
            case 0: {
                this.renderInfoTab(graphics, contentX, contentY, contentWidth, contentHeight);
                break;
            }
            case 1: {
                this.renderMembersTab(graphics, contentX, contentY, contentWidth, contentHeight);
                break;
            }
            case 2: {
                this.renderInvitesTab(graphics, contentX, contentY, contentWidth, contentHeight);
                break;
            }
            case 3: {
                this.renderSettingsTab(graphics, contentX, contentY, contentWidth, contentHeight);
            }
        }
    }

    private void renderInfoTab(class_332 graphics, int x, int y, int width, int height) {
        QuestTeam team = ClientTeamManager.getInstance().getCurrentTeam();
        if (team == null) {
            graphics.method_25303(this.field_22793, "You are not in a team", x, y, 0x888888);
            graphics.method_25303(this.field_22793, "Create or join a team to", x, y + 15, 0x888888);
            graphics.method_25303(this.field_22793, "complete quests together!", x, y + 30, 0x888888);
            return;
        }
        int lineY = y;
        graphics.method_25303(this.field_22793, "\u00a7eTeam: \u00a7f" + team.getTeamName(), x, lineY, 0xFFFFFF);
        String ownerName = this.getPlayerName(team.getOwner());
        graphics.method_25303(this.field_22793, "\u00a7eOwner: \u00a7f" + ownerName, x, lineY += 15, 0xFFFFFF);
        graphics.method_25303(this.field_22793, "\u00a7eMembers: \u00a7f" + team.getMemberCount() + "/10", x, lineY += 15, 0xFFFFFF);
        lineY += 15;
        int pendingRewards = ClientTeamManager.getInstance().getPendingRewardCount();
        if (pendingRewards > 0) {
            graphics.method_25303(this.field_22793, "\u00a76Pending Rewards: \u00a7f" + pendingRewards, x, lineY, 0xFFFFFF);
            lineY += 15;
        }
        graphics.method_25303(this.field_22793, "\u00a77Complete quests with your", x, lineY += 10, 0x888888);
        graphics.method_25303(this.field_22793, "\u00a77team to share progress and", x, lineY += 12, 0x888888);
        graphics.method_25303(this.field_22793, "\u00a77earn rewards together!", x, lineY += 12, 0x888888);
    }

    private void renderMembersTab(class_332 graphics, int x, int y, int width, int height) {
        QuestTeam team = ClientTeamManager.getInstance().getCurrentTeam();
        if (team == null) {
            graphics.method_25303(this.field_22793, "Not in a team", x, y, 0x888888);
            return;
        }
        int lineY = y;
        for (UUID memberId : team.getMembers()) {
            if (lineY > y + height - 20) break;
            String name = this.getPlayerName(memberId);
            boolean isOwner = memberId.equals(team.getOwner());
            boolean isOnline = this.isPlayerOnline(memberId);
            String status = isOnline ? "\u00a7a\u25cf" : "\u00a77\u25cf";
            String role = isOwner ? " \u00a76[Owner]" : "";
            graphics.method_25303(this.field_22793, status + " \u00a7f" + name + role, x, lineY, 0xFFFFFF);
            lineY += 18;
        }
    }

    private void renderInvitesTab(class_332 graphics, int x, int y, int width, int height) {
        int pendingInvites = ClientTeamManager.getInstance().getPendingInviteCount();
        if (pendingInvites == 0) {
            graphics.method_25303(this.field_22793, "No pending invites", x, y + 35, 0x888888);
        } else {
            graphics.method_25303(this.field_22793, "\u00a7ePending Invites: \u00a7f" + pendingInvites, x, y + 35, 0xFFFFFF);
            graphics.method_25303(this.field_22793, "\u00a77Use /questory team accept", x, y + 50, 0x888888);
            graphics.method_25303(this.field_22793, "\u00a77to join a team", x, y + 62, 0x888888);
        }
    }

    private void renderSettingsTab(class_332 graphics, int x, int y, int width, int height) {
        QuestTeam team = ClientTeamManager.getInstance().getCurrentTeam();
        boolean isOwner = ClientTeamManager.getInstance().isTeamOwner();
        if (team == null) {
            graphics.method_25303(this.field_22793, "Not in a team", x, y, 0x888888);
            return;
        }
        int lineY = y;
        if (!isOwner) {
            graphics.method_25303(this.field_22793, "\u00a7eTeam Settings", x, lineY, 0xFFFFFF);
            graphics.method_25303(this.field_22793, "\u00a77Only the team owner can", x, lineY += 20, 0x888888);
            graphics.method_25303(this.field_22793, "\u00a77modify team settings.", x, lineY += 12, 0x888888);
            return;
        }
        graphics.method_25303(this.field_22793, "\u00a7eTeam Settings", x, lineY, 0xFFFFFF);
        graphics.method_25303(this.field_22793, "\u00a76Team Owner:", x, lineY += 20, 0xFFFFFF);
        graphics.method_25303(this.field_22793, "\u00a76Max Members:", x, (lineY += 32) + 3, 0xFFFFFF);
        graphics.method_25303(this.field_22793, "\u00a7c\u00a7lDanger Zone:", x, (lineY += 40) + 3, 0xFF5555);
        graphics.method_25303(this.field_22793, "\u00a77This cannot be undone!", x, (lineY += 32) + 5, 0x888888);
    }

    private void saveMaxMembers() {
        block5: {
            try {
                int maxMembers = Integer.parseInt(this.maxMembersField.method_1882());
                if (maxMembers < 1 || maxMembers > 100) {
                    if (this.field_22787.field_1724 != null) {
                        this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)"\u00a7c[Questory] Max members must be between 1 and 100"));
                    }
                    return;
                }
                TeamSettingsPacket packet = TeamSettingsPacket.setMaxMembers(maxMembers);
                NetworkManager.sendToServer(packet);
                if (this.field_22787.field_1724 != null) {
                    this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)"\u00a7a[Questory] Updating team settings..."));
                }
            }
            catch (NumberFormatException e) {
                if (this.field_22787.field_1724 == null) break block5;
                this.field_22787.field_1724.method_43496((class_2561)class_2561.method_43470((String)"\u00a7c[Questory] Invalid number"));
            }
        }
    }

    private void leaveTeam() {
        if (ClientTeamManager.getInstance().isInTeam()) {
            TeamActionPacket packet = TeamActionPacket.leave();
            NetworkManager.sendToServer(packet);
            this.method_25419();
        }
    }

    private void openInviteDialog() {
        this.field_22787.method_1507((class_437)new TeamInviteDialog(this));
    }

    private void transferOwnership() {
        this.field_22787.method_1507((class_437)new TransferOwnershipDialog(this));
    }

    private void disbandTeam() {
        QuestTeam team = ClientTeamManager.getInstance().getCurrentTeam();
        if (team == null) {
            return;
        }
        String message = "Are you sure you want to disband team '" + team.getTeamName() + "'? All members will be removed and all team progress will be lost. This cannot be undone!";
        this.field_22787.method_1507((class_437)new ConfirmationDialog(this, "Disband Team", message, "Disband", "Cancel", this::sendDisbandPacket, true));
    }

    private void sendDisbandPacket() {
        TeamSettingsPacket packet = TeamSettingsPacket.disbandTeam();
        NetworkManager.sendToServer(packet);
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    private String getPlayerName(UUID playerId) {
        class_1657 player = class_310.method_1551().field_1687.method_18470(playerId);
        if (player != null) {
            return player.method_5477().getString();
        }
        return playerId.toString().substring(0, 8);
    }

    private boolean isPlayerOnline(UUID playerId) {
        return class_310.method_1551().field_1687.method_18470(playerId) != null;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.currentTab == TeamTab.SETTINGS && this.maxMembersField != null && this.maxMembersField.method_25370() && this.maxMembersField.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char codePoint, int modifiers) {
        if (this.currentTab == TeamTab.SETTINGS && this.maxMembersField != null && this.maxMembersField.method_25370() && this.maxMembersField.method_25400(codePoint, modifiers)) {
            return true;
        }
        return super.method_25400(codePoint, modifiers);
    }

    public boolean method_25421() {
        return false;
    }

    static enum TeamTab {
        INFO,
        MEMBERS,
        INVITES,
        SETTINGS;

    }

    static class MemberEntry {
        UUID playerId;
        String name;
        boolean isOwner;
        boolean isOnline;

        MemberEntry(UUID playerId, String name, boolean isOwner, boolean isOnline) {
            this.playerId = playerId;
            this.name = name;
            this.isOwner = isOwner;
            this.isOnline = isOnline;
        }
    }
}

