/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.client.gui.editor;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;

public class CloseConfirmationDialog
extends class_437 {
    private static final int DIALOG_WIDTH = 400;
    private static final int DIALOG_HEIGHT = 300;
    private static final int PADDING = 12;
    private static final int BUTTON_HEIGHT = 20;
    private static final int BUTTON_WIDTH = 90;
    private final class_437 parent;
    private final class_437 returnScreen;
    private final List<UnsavedEntity> unsavedEntities;
    private final Runnable onSaveAll;
    private final Runnable onDiscard;
    private final Runnable onCancel;
    private int dialogX;
    private int dialogY;
    private int listScroll = 0;
    private boolean discardConfirmPending = false;

    public CloseConfirmationDialog(class_437 parent, class_437 returnScreen, List<UnsavedEntity> unsavedEntities, Runnable onSaveAll, Runnable onDiscard, Runnable onCancel) {
        super((class_2561)class_2561.method_43470((String)"Unsaved Changes"));
        this.parent = parent;
        this.returnScreen = returnScreen;
        this.unsavedEntities = new ArrayList<UnsavedEntity>(unsavedEntities);
        this.onSaveAll = onSaveAll;
        this.onDiscard = onDiscard;
        this.onCancel = onCancel;
    }

    protected void method_25426() {
        super.method_25426();
        this.dialogX = (this.field_22789 - 400) / 2;
        this.dialogY = (this.field_22790 - 300) / 2;
        int buttonY = this.dialogY + 300 - 12 - 20;
        int centerX = this.dialogX + 200;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Save All"), b -> {
            if (this.onSaveAll != null) {
                this.onSaveAll.run();
            }
            if (this.field_22787 != null) {
                this.field_22787.method_1507(this.returnScreen);
            }
        }).method_46434(centerX - 90 - 4 - 90 - 4, buttonY, 90, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)(this.discardConfirmPending ? "\u00a7cConfirm?" : "Discard")), b -> {
            if (!this.discardConfirmPending) {
                this.discardConfirmPending = true;
                b.method_25355((class_2561)class_2561.method_43470((String)"\u00a7cConfirm?"));
            } else {
                if (this.onDiscard != null) {
                    this.onDiscard.run();
                }
                if (this.field_22787 != null) {
                    this.field_22787.method_1507(this.returnScreen);
                }
            }
        }).method_46434(centerX - 45, buttonY, 90, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Cancel"), b -> {
            if (this.onCancel != null) {
                this.onCancel.run();
            }
            if (this.field_22787 != null) {
                this.field_22787.method_1507(this.parent);
            }
        }).method_46434(centerX + 45 + 4, buttonY, 90, 20).method_46431());
    }

    public void method_25394(class_332 g, int mouseX, int mouseY, float partialTick) {
        this.method_25420(g);
        g.method_25294(0, 0, this.field_22789, this.field_22790, Integer.MIN_VALUE);
        g.method_25294(this.dialogX, this.dialogY, this.dialogX + 400, this.dialogY + 300, -267382768);
        g.method_25294(this.dialogX, this.dialogY, this.dialogX + 400, this.dialogY + 2, -22016);
        g.method_25294(this.dialogX, this.dialogY, this.dialogX + 2, this.dialogY + 300, -7829368);
        g.method_25294(this.dialogX + 400 - 2, this.dialogY, this.dialogX + 400, this.dialogY + 300, -7829368);
        g.method_25294(this.dialogX, this.dialogY + 300 - 2, this.dialogX + 400, this.dialogY + 300, -7829368);
        g.method_27534(this.field_22793, this.field_22785, this.dialogX + 200, this.dialogY + 12, -1);
        int textY = this.dialogY + 12 + 16;
        String desc = "You have " + this.unsavedEntities.size() + " unsaved " + (this.unsavedEntities.size() == 1 ? "change" : "changes") + ":";
        g.method_25303(this.field_22793, desc, this.dialogX + 12, textY, -3355444);
        int listY = textY + 16;
        int listHeight = 300 - (listY - this.dialogY) - 12 - 20 - 12 - 4;
        int listX = this.dialogX + 12;
        int listW = 376;
        g.method_25294(listX, listY, listX + listW, listY + listHeight, -15066598);
        this.renderEntityList(g, listX, listY, listW, listHeight, mouseX, mouseY);
        int warningY = this.dialogY + 300 - 12 - 20 - 12 - 12;
        String warning = "\u00a7eChoose an action:";
        g.method_25300(this.field_22793, warning, this.dialogX + 200, warningY, -1);
        super.method_25394(g, mouseX, mouseY, partialTick);
    }

    private void renderEntityList(class_332 g, int x, int y, int w, int h, int mouseX, int mouseY) {
        if (this.unsavedEntities.isEmpty()) {
            return;
        }
        g.method_44379(x, y, x + w, y + h);
        int lineHeight = 18;
        int maxLines = h / lineHeight;
        int startIndex = Math.max(0, Math.min(this.listScroll, this.unsavedEntities.size() - maxLines));
        int endIndex = Math.min(this.unsavedEntities.size(), startIndex + maxLines);
        int itemY = y + 4;
        for (int i = startIndex; i < endIndex; ++i) {
            UnsavedEntity entity = this.unsavedEntities.get(i);
            g.method_25303(this.field_22793, "\u2022", x + 4, itemY, -22016);
            Object label = entity.getDisplayName();
            if (entity.getType() != null && !entity.getType().isEmpty()) {
                label = entity.getType() + ": " + (String)label;
            }
            int maxWidth = w - 60;
            if (this.field_22793.method_1727((String)label) > maxWidth) {
                label = this.field_22793.method_27523((String)label, maxWidth - 20) + "...";
            }
            g.method_25303(this.field_22793, (String)label, x + 16, itemY, -1);
            String age = entity.getAgeString();
            int ageX = x + w - this.field_22793.method_1727(age) - 8;
            g.method_25303(this.field_22793, age, ageX, itemY, -7829368);
            itemY += lineHeight;
        }
        g.method_44380();
        if (this.unsavedEntities.size() > maxLines) {
            int scrollBarH = Math.max(20, maxLines * h / this.unsavedEntities.size());
            int scrollBarY = y + (h - scrollBarH) * startIndex / Math.max(1, this.unsavedEntities.size() - maxLines);
            g.method_25294(x + w - 4, scrollBarY, x + w - 2, scrollBarY + scrollBarH, -7829368);
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        int listY = this.dialogY + 12 + 32;
        int listHeight = 300 - (listY - this.dialogY) - 12 - 20 - 12 - 4;
        int listX = this.dialogX + 12;
        int listW = 376;
        if (mouseX >= (double)listX && mouseX <= (double)(listX + listW) && mouseY >= (double)listY && mouseY <= (double)(listY + listHeight)) {
            int lineHeight = 18;
            int maxLines = listHeight / lineHeight;
            int maxScroll = Math.max(0, this.unsavedEntities.size() - maxLines);
            this.listScroll = Math.max(0, Math.min(maxScroll, this.listScroll - (int)Math.signum(delta)));
            return true;
        }
        return super.method_25401(mouseX, mouseY, delta);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            if (this.onCancel != null) {
                this.onCancel.run();
            }
            if (this.field_22787 != null) {
                this.field_22787.method_1507(this.parent);
            }
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25421() {
        return true;
    }

    public static class UnsavedEntity {
        private final String displayName;
        private final String type;
        private final long lastModified;

        public UnsavedEntity(String displayName, String type, long lastModified) {
            this.displayName = displayName;
            this.type = type;
            this.lastModified = lastModified;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getType() {
            return this.type;
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public String getAgeString() {
            long ageMs = System.currentTimeMillis() - this.lastModified;
            long seconds = ageMs / 1000L;
            long minutes = seconds / 60L;
            long hours = minutes / 60L;
            if (hours > 0L) {
                return hours + "h ago";
            }
            if (minutes > 0L) {
                return minutes + "m ago";
            }
            return seconds + "s ago";
        }
    }
}

