/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.integration;

import dev.ftb.mods.ftbteams.api.event.TeamEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.texboobcat.questory.network.NetworkManager;
import org.texboobcat.questory.network.TeamSyncPacket;
import org.texboobcat.questory.team.PendingRewardManager;
import org.texboobcat.questory.team.QuestTeam;
import org.texboobcat.questory.team.TeamInviteInfo;
import org.texboobcat.questory.team.TeamManager;

public class FTBTeamsIntegration {
    public static void init() {
        TeamEvent.PLAYER_LOGGED_IN.register(e -> {
            class_3222 player = e.getPlayer();
            if (player != null) {
                FTBTeamsIntegration.syncTeamToPlayer(player);
            }
        });
        TeamEvent.PLAYER_CHANGED.register(e -> {
            class_3222 player = e.getPlayer();
            if (player != null) {
                FTBTeamsIntegration.syncTeamToPlayer(player);
                TeamManager tm = TeamManager.getInstance();
                UUID teamId = tm.getPlayerTeamId(player.method_5667());
                if (teamId != null) {
                    for (UUID memberId : tm.getTeamMembers(teamId)) {
                        class_3222 member;
                        if (memberId.equals(player.method_5667()) || (member = player.method_5682().method_3760().method_14602(memberId)) == null) continue;
                        FTBTeamsIntegration.syncTeamToPlayer(member);
                    }
                }
                e.getPreviousTeam().ifPresent(prev -> {
                    HashSet prevMembers = new HashSet(prev.getMembers());
                    for (UUID memberId : prevMembers) {
                        class_3222 member = player.method_5682().method_3760().method_14602(memberId);
                        if (member == null) continue;
                        FTBTeamsIntegration.syncTeamToPlayer(member);
                    }
                });
            }
        });
    }

    private static void broadcastToTeamMembers(class_3222 player) {
        TeamManager tm = TeamManager.getInstance();
        UUID teamId = tm.getPlayerTeamId(player.method_5667());
        if (teamId != null) {
            for (UUID memberId : tm.getTeamMembers(teamId)) {
                class_3222 member;
                if (memberId.equals(player.method_5667()) || (member = player.method_5682().method_3760().method_14602(memberId)) == null) continue;
                FTBTeamsIntegration.syncTeamToPlayer(member);
            }
        }
    }

    private static void syncTeamToPlayer(class_3222 player) {
        TeamManager teamMgr = TeamManager.getInstance();
        PendingRewardManager pendingMgr = PendingRewardManager.getInstance();
        UUID teamId = teamMgr.getPlayerTeamId(player.method_5667());
        QuestTeam team = null;
        if (teamId != null && (team = teamMgr.getTeam(teamId)) == null) {
            team = teamMgr.buildExternalTeamSnapshot(teamId);
        }
        Set<UUID> inviteIds = teamMgr.getPendingInvites(player.method_5667());
        ArrayList<TeamInviteInfo> inviteInfos = new ArrayList<TeamInviteInfo>();
        for (UUID inviteTeamId : inviteIds) {
            QuestTeam inviteTeam = teamMgr.getTeam(inviteTeamId);
            if (inviteTeam == null) {
                inviteTeam = teamMgr.buildExternalTeamSnapshot(inviteTeamId);
            }
            if (inviteTeam == null) continue;
            String ownerName = FTBTeamsIntegration.getPlayerName(player.method_5682(), inviteTeam.getOwner());
            TeamInviteInfo info = new TeamInviteInfo(inviteTeamId, inviteTeam.getTeamName(), ownerName, inviteTeam.getMemberCount());
            inviteInfos.add(info);
        }
        int rewardCount = pendingMgr.getPendingRewardCount(player.method_5667());
        TeamSyncPacket syncPacket = new TeamSyncPacket(team, player.method_5667(), inviteInfos, rewardCount);
        NetworkManager.sendToClient(player, syncPacket);
    }

    private static String getPlayerName(MinecraftServer server, UUID playerId) {
        class_3222 p = server.method_3760().method_14602(playerId);
        if (p != null) {
            return p.method_5477().getString();
        }
        return playerId.toString().substring(0, 8);
    }
}

