/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.network;

import net.minecraft.class_2540;
import net.minecraft.class_2561;
import org.texboobcat.questory.client.ClientTelemetryBridge;
import org.texboobcat.questory.telemetry.HardwareIdGenerator;
import org.texboobcat.questory.telemetry.SupabaseClient;
import org.texboobcat.questory.telemetry.TelemetryManager;

public class TelemetryActionPacket {
    private final Action action;

    public TelemetryActionPacket(Action action) {
        this.action = action;
    }

    public static void encode(TelemetryActionPacket packet, class_2540 buf) {
        buf.method_10817((Enum)packet.action);
    }

    public static TelemetryActionPacket decode(class_2540 buf) {
        return new TelemetryActionPacket((Action)buf.method_10818(Action.class));
    }

    public void handle() {
        ClientTelemetryBridge.runOnClient(() -> {
            try {
                switch (this.action.ordinal()) {
                    case 0: {
                        TelemetryActionPacket.showStatus();
                        break;
                    }
                    case 1: {
                        TelemetryManager.getInstance().enableTelemetry();
                        ClientTelemetryBridge.sendClientMessage((class_2561)class_2561.method_43470((String)"\u00a7a\u2713 Telemetry enabled!"));
                        break;
                    }
                    case 2: {
                        TelemetryManager.getInstance().disableTelemetry();
                        ClientTelemetryBridge.sendClientMessage((class_2561)class_2561.method_43470((String)"\u00a77Telemetry disabled."));
                        break;
                    }
                    case 3: {
                        String hwid = HardwareIdGenerator.getHardwareId();
                        ClientTelemetryBridge.sendClientMessage((class_2561)class_2561.method_43470((String)"\u00a76\u00a7l=== GDPR Data Export ==="));
                        ClientTelemetryBridge.sendClientMessage((class_2561)class_2561.method_43470((String)("\u00a77Your hardware ID: \u00a7f" + hwid)));
                        break;
                    }
                    case 4: {
                        try {
                            SupabaseClient.getInstance().deletePlayerData(HardwareIdGenerator.getHardwareId());
                            TelemetryManager.getInstance().disableTelemetry();
                            ClientTelemetryBridge.sendClientMessage((class_2561)class_2561.method_43470((String)"\u00a7a\u2713 Data deleted successfully."));
                            ClientTelemetryBridge.sendClientMessage((class_2561)class_2561.method_43470((String)"\u00a77You have been opted out of telemetry."));
                        }
                        catch (Exception e) {
                            ClientTelemetryBridge.sendClientMessage((class_2561)class_2561.method_43470((String)("\u00a7cFailed to delete data: " + e.getMessage())));
                        }
                        break;
                    }
                    case 5: {
                        TelemetryManager.getInstance().resetConsentForTesting();
                        ClientTelemetryBridge.showConsentPrompt();
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
    }

    private static void showStatus() {
        TelemetryManager tm = TelemetryManager.getInstance();
        boolean enabled = tm.isEnabled();
        String hwid = HardwareIdGenerator.getHardwareId();
        ClientTelemetryBridge.sendClientMessage((class_2561)class_2561.method_43470((String)"\u00a76\u00a7l=== Questify Telemetry Status ==="));
        ClientTelemetryBridge.sendClientMessage((class_2561)class_2561.method_43470((String)("\u00a77Status: " + (enabled ? "\u00a7aEnabled" : "\u00a7cDisabled"))));
        ClientTelemetryBridge.sendClientMessage((class_2561)class_2561.method_43470((String)("\u00a77Hardware ID: \u00a7e" + hwid)));
        if (enabled) {
            ClientTelemetryBridge.sendClientMessage((class_2561)class_2561.method_43470((String)("\u00a77Session ID: \u00a7f" + String.valueOf(tm.getSessionId()))));
        }
    }

    public Action getAction() {
        return this.action;
    }

    public static enum Action {
        STATUS,
        OPTIN,
        OPTOUT,
        EXPORT,
        DELETE,
        RESET;

    }
}

