/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.quest;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.texboobcat.questory.quest.QuestProgress;
import org.texboobcat.questory.quest.Requirement;

public class EquipItemRequirement
extends Requirement {
    private List<EquipmentEntry> entries;

    public EquipItemRequirement() {
        super("equip_item");
        this.entries = new ArrayList<EquipmentEntry>();
    }

    public EquipItemRequirement(List<EquipmentEntry> entries) {
        super("equip_item");
        this.entries = entries;
    }

    public List<EquipmentEntry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<EquipmentEntry> entries) {
        this.entries = entries;
    }

    public void addEntry(EquipmentEntry entry) {
        this.entries.add(entry);
    }

    public void removeEntry(int index) {
        if (index >= 0 && index < this.entries.size()) {
            this.entries.remove(index);
        }
    }

    public boolean isEquipped(class_1657 player) {
        if (this.entries.isEmpty()) {
            return false;
        }
        for (EquipmentEntry entry : this.entries) {
            class_1304 slot;
            class_1799 equipped;
            if (entry.matches(equipped = player.method_6118(slot = entry.getSlot()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isMet(QuestProgress progress, String questId) {
        return progress.getRequirementProgress(questId, this) >= this.entries.size();
    }

    @Override
    public String getProgressDisplay(QuestProgress progress, String questId) {
        int current = progress.getRequirementProgress(questId, this);
        if (this.entries.size() == 1) {
            EquipmentEntry entry = this.entries.get(0);
            String slotLabel = this.formatSlotName(entry.getSlotName());
            String itemName = EquipItemRequirement.resolveItemName(entry.getItemId(), entry.getNbt());
            return (current > 0 ? "\u2713" : "\u2717") + " Equip " + itemName + " in " + slotLabel;
        }
        return current + "/" + this.entries.size() + " pieces equipped";
    }

    private String formatSlotName(String slot) {
        return switch (slot.toUpperCase()) {
            case "HEAD" -> "Helmet";
            case "CHEST" -> "Chestplate";
            case "LEGS" -> "Leggings";
            case "FEET" -> "Boots";
            case "MAINHAND" -> "Main Hand";
            case "OFFHAND" -> "Off Hand";
            default -> slot;
        };
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = super.toJson();
        JsonArray entriesArray = new JsonArray();
        for (EquipmentEntry entry : this.entries) {
            entriesArray.add((JsonElement)entry.toJson());
        }
        json.add("entries", (JsonElement)entriesArray);
        return json;
    }

    public static EquipItemRequirement fromJson(JsonObject json) {
        EquipItemRequirement req = new EquipItemRequirement();
        if (json.has("entries")) {
            JsonArray entriesArray = json.getAsJsonArray("entries");
            for (int i = 0; i < entriesArray.size(); ++i) {
                JsonObject entryJson = entriesArray.get(i).getAsJsonObject();
                req.addEntry(EquipmentEntry.fromJson(entryJson));
            }
        }
        return req;
    }

    public static class EquipmentEntry {
        private String slotName;
        private String itemId;
        private class_2487 nbt;

        public EquipmentEntry(String slotName, String itemId) {
            this.slotName = slotName;
            this.itemId = itemId;
            this.nbt = null;
        }

        public String getSlotName() {
            return this.slotName;
        }

        public void setSlotName(String slotName) {
            this.slotName = slotName;
        }

        public String getItemId() {
            return this.itemId;
        }

        public void setItemId(String itemId) {
            this.itemId = itemId;
        }

        public class_2487 getNbt() {
            return this.nbt;
        }

        public void setNbt(class_2487 nbt) {
            this.nbt = nbt;
        }

        public boolean matches(class_1799 stack) {
            if (stack.method_7960()) {
                return false;
            }
            class_2960 stackId = class_7923.field_41178.method_10221((Object)stack.method_7909());
            if (!stackId.toString().equals(this.itemId)) {
                return false;
            }
            if (this.nbt != null) {
                class_2487 stackNbt = stack.method_7969();
                if (stackNbt == null) {
                    return false;
                }
                return this.nbtMatches(stackNbt, this.nbt);
            }
            return true;
        }

        private boolean nbtMatches(class_2487 stackNbt, class_2487 requiredNbt) {
            for (String key : requiredNbt.method_10541()) {
                if (!stackNbt.method_10545(key)) {
                    return false;
                }
                if (stackNbt.method_10580(key).equals((Object)requiredNbt.method_10580(key))) continue;
                return false;
            }
            return true;
        }

        public class_1304 getSlot() {
            try {
                return class_1304.valueOf((String)this.slotName.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return class_1304.field_6173;
            }
        }

        public JsonObject toJson() {
            JsonObject json = new JsonObject();
            json.addProperty("slot", this.slotName);
            json.addProperty("item", this.itemId);
            if (this.nbt != null) {
                json.addProperty("nbt", this.nbt.toString());
            }
            return json;
        }

        public static EquipmentEntry fromJson(JsonObject json) {
            String slot = json.get("slot").getAsString();
            String item = json.get("item").getAsString();
            EquipmentEntry entry = new EquipmentEntry(slot, item);
            if (json.has("nbt")) {
                try {
                    class_2487 nbt = class_2522.method_10718((String)json.get("nbt").getAsString());
                    entry.setNbt(nbt);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return entry;
        }
    }
}

