/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.telemetry;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.util.Enumeration;
import java.util.List;
import java.util.UUID;

public class HardwareIdGenerator {
    private static String cachedHwid = null;
    private static final String SALT = "Questory-Telemetry-v1-7f3e8b2a-4d1c-9e5f-6a0b-8c7d4e9f1a3b";

    public static String getHardwareId() {
        if (cachedHwid != null) {
            return cachedHwid;
        }
        try {
            StringBuilder sb = new StringBuilder();
            String macAddress = HardwareIdGenerator.getMacAddress();
            if (macAddress != null && !macAddress.isEmpty()) {
                sb.append(macAddress);
            } else {
                String platformId = HardwareIdGenerator.getPlatformId();
                if (platformId != null && !platformId.isEmpty()) {
                    sb.append(platformId);
                } else {
                    sb.append(System.getProperty("os.name", "unknown"));
                    sb.append(System.getProperty("os.arch", "unknown"));
                    sb.append(System.getProperty("os.version", "unknown"));
                    sb.append(System.getProperty("user.name", "unknown"));
                    sb.append(System.getProperty("java.home", "unknown"));
                    try {
                        String hostname = InetAddress.getLocalHost().getHostName();
                        sb.append(hostname);
                    }
                    catch (Exception hostname) {
                        // empty catch block
                    }
                }
            }
            String combined = sb.toString() + SALT;
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(combined.getBytes(StandardCharsets.UTF_8));
            cachedHwid = HardwareIdGenerator.bytesToHex(hash);
            return cachedHwid;
        }
        catch (Exception e) {
            cachedHwid = UUID.randomUUID().toString().replace("-", "");
            return cachedHwid;
        }
    }

    private static String getMacAddress() {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                byte[] mac;
                NetworkInterface iface = interfaces.nextElement();
                if (iface.isLoopback() || !iface.isUp()) continue;
                try {
                    if (iface.isVirtual() || iface.isPointToPoint()) {
                        continue;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String name = "";
                String displayName = "";
                try {
                    name = String.valueOf(iface.getName()).toLowerCase();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    displayName = String.valueOf(iface.getDisplayName()).toLowerCase();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (name.contains("docker") || name.contains("vbox") || name.contains("vmnet") || name.contains("virbr") || name.contains("veth") || name.contains("wg") || name.contains("tun") || name.contains("tap") || displayName.contains("virtual") || displayName.contains("vmware") || displayName.contains("hyper-v") || displayName.contains("loopback") || displayName.contains("docker") || displayName.contains("vpn") || (mac = iface.getHardwareAddress()) == null || mac.length <= 0 || HardwareIdGenerator.isAllZero(mac)) continue;
                StringBuilder sb = new StringBuilder();
                for (byte b : mac) {
                    sb.append(String.format("%02X", b));
                }
                return sb.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static boolean isAllZero(byte[] mac) {
        for (byte b : mac) {
            if (b == 0) continue;
            return false;
        }
        return true;
    }

    private static String getPlatformId() {
        String osName = System.getProperty("os.name", "").toLowerCase();
        if (osName.contains("linux")) {
            String machineId = HardwareIdGenerator.readFirstLine("/etc/machine-id");
            if (machineId == null || machineId.isEmpty()) {
                machineId = HardwareIdGenerator.readFirstLine("/var/lib/dbus/machine-id");
            }
            if (machineId != null && !machineId.isEmpty()) {
                return "linux-" + machineId.trim();
            }
        }
        return null;
    }

    private static String readFirstLine(String filePath) {
        try {
            Path path = Paths.get(filePath, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                return null;
            }
            List<String> lines = Files.readAllLines(path, StandardCharsets.UTF_8);
            if (!lines.isEmpty()) {
                return lines.get(0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuilder hexString = new StringBuilder();
        for (byte b : bytes) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    public static void clearCache() {
        cachedHwid = null;
    }
}

