/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.theme.panel;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.texboobcat.questory.theme.panel.ButtonNode;
import org.texboobcat.questory.theme.panel.ConditionalNode;
import org.texboobcat.questory.theme.panel.DividerNode;
import org.texboobcat.questory.theme.panel.GridNode;
import org.texboobcat.questory.theme.panel.HStackNode;
import org.texboobcat.questory.theme.panel.IconNode;
import org.texboobcat.questory.theme.panel.ImageListNode;
import org.texboobcat.questory.theme.panel.ImageNode;
import org.texboobcat.questory.theme.panel.ListNode;
import org.texboobcat.questory.theme.panel.ProgressBarNode;
import org.texboobcat.questory.theme.panel.RichTextNode;
import org.texboobcat.questory.theme.panel.ScrollNode;
import org.texboobcat.questory.theme.panel.SliderNode;
import org.texboobcat.questory.theme.panel.SpacerNode;
import org.texboobcat.questory.theme.panel.StackNode;
import org.texboobcat.questory.theme.panel.TabContainerNode;
import org.texboobcat.questory.theme.panel.TextNode;
import org.texboobcat.questory.theme.panel.VStackNode;

public abstract class PanelNode {
    protected String id;
    protected Integer padding;
    protected Integer paddingTop;
    protected Integer paddingRight;
    protected Integer paddingBottom;
    protected Integer paddingLeft;
    protected Integer margin;
    protected Integer marginTop;
    protected Integer marginRight;
    protected Integer marginBottom;
    protected Integer marginLeft;
    protected String align;
    protected String justify;
    protected String width;
    protected String height;
    protected String minWidth;
    protected String maxWidth;
    protected String minHeight;
    protected String maxHeight;
    protected String background;
    protected String borderColor;
    protected Integer borderWidth;
    protected Integer borderRadius;
    protected String shadow;
    protected Float opacity;
    protected Float rotation;
    protected Float scale;
    protected String visible;
    protected JsonObject hoverStyle;

    public void applyCommonProperties(JsonObject json) {
        if (json.has("id")) {
            this.id = json.get("id").getAsString();
        }
        if (json.has("padding")) {
            this.padding = json.get("padding").getAsInt();
        }
        if (json.has("paddingTop")) {
            this.paddingTop = json.get("paddingTop").getAsInt();
        }
        if (json.has("paddingRight")) {
            this.paddingRight = json.get("paddingRight").getAsInt();
        }
        if (json.has("paddingBottom")) {
            this.paddingBottom = json.get("paddingBottom").getAsInt();
        }
        if (json.has("paddingLeft")) {
            this.paddingLeft = json.get("paddingLeft").getAsInt();
        }
        if (json.has("margin")) {
            this.margin = json.get("margin").getAsInt();
        }
        if (json.has("marginTop")) {
            this.marginTop = json.get("marginTop").getAsInt();
        }
        if (json.has("marginRight")) {
            this.marginRight = json.get("marginRight").getAsInt();
        }
        if (json.has("marginBottom")) {
            this.marginBottom = json.get("marginBottom").getAsInt();
        }
        if (json.has("marginLeft")) {
            this.marginLeft = json.get("marginLeft").getAsInt();
        }
        if (json.has("align")) {
            this.align = json.get("align").getAsString();
        }
        if (json.has("justify")) {
            this.justify = json.get("justify").getAsString();
        }
        if (json.has("width")) {
            this.width = json.get("width").getAsString();
        }
        if (json.has("height")) {
            this.height = json.get("height").getAsString();
        }
        if (json.has("minWidth")) {
            this.minWidth = json.get("minWidth").getAsString();
        }
        if (json.has("maxWidth")) {
            this.maxWidth = json.get("maxWidth").getAsString();
        }
        if (json.has("minHeight")) {
            this.minHeight = json.get("minHeight").getAsString();
        }
        if (json.has("maxHeight")) {
            this.maxHeight = json.get("maxHeight").getAsString();
        }
        if (json.has("background")) {
            this.background = json.get("background").getAsString();
        }
        if (json.has("borderColor")) {
            this.borderColor = json.get("borderColor").getAsString();
        }
        if (json.has("borderWidth")) {
            this.borderWidth = json.get("borderWidth").getAsInt();
        }
        if (json.has("borderRadius")) {
            this.borderRadius = json.get("borderRadius").getAsInt();
        }
        if (json.has("shadow")) {
            this.shadow = json.get("shadow").getAsString();
        }
        if (json.has("opacity")) {
            this.opacity = Float.valueOf(json.get("opacity").getAsFloat());
        }
        if (json.has("rotation")) {
            this.rotation = Float.valueOf(json.get("rotation").getAsFloat());
        }
        if (json.has("scale")) {
            this.scale = Float.valueOf(json.get("scale").getAsFloat());
        }
        if (json.has("visible")) {
            this.visible = json.get("visible").getAsString();
        }
        if (json.has("hoverStyle") && json.get("hoverStyle").isJsonObject()) {
            this.hoverStyle = json.get("hoverStyle").getAsJsonObject();
        }
    }

    public abstract String getType();

    public int getPaddingTop() {
        if (this.paddingTop != null) {
            return this.paddingTop;
        }
        return this.padding != null ? this.padding : 0;
    }

    public int getPaddingRight() {
        if (this.paddingRight != null) {
            return this.paddingRight;
        }
        return this.padding != null ? this.padding : 0;
    }

    public int getPaddingBottom() {
        if (this.paddingBottom != null) {
            return this.paddingBottom;
        }
        return this.padding != null ? this.padding : 0;
    }

    public int getPaddingLeft() {
        if (this.paddingLeft != null) {
            return this.paddingLeft;
        }
        return this.padding != null ? this.padding : 0;
    }

    public int getMarginTop() {
        if (this.marginTop != null) {
            return this.marginTop;
        }
        return this.margin != null ? this.margin : 0;
    }

    public int getMarginRight() {
        if (this.marginRight != null) {
            return this.marginRight;
        }
        return this.margin != null ? this.margin : 0;
    }

    public int getMarginBottom() {
        if (this.marginBottom != null) {
            return this.marginBottom;
        }
        return this.margin != null ? this.margin : 0;
    }

    public int getMarginLeft() {
        if (this.marginLeft != null) {
            return this.marginLeft;
        }
        return this.margin != null ? this.margin : 0;
    }

    public String getId() {
        return this.id;
    }

    public Integer getPadding() {
        return this.padding;
    }

    public Integer getPaddingTopRaw() {
        return this.paddingTop;
    }

    public Integer getPaddingRightRaw() {
        return this.paddingRight;
    }

    public Integer getPaddingBottomRaw() {
        return this.paddingBottom;
    }

    public Integer getPaddingLeftRaw() {
        return this.paddingLeft;
    }

    public Integer getMargin() {
        return this.margin;
    }

    public Integer getMarginTopRaw() {
        return this.marginTop;
    }

    public Integer getMarginRightRaw() {
        return this.marginRight;
    }

    public Integer getMarginBottomRaw() {
        return this.marginBottom;
    }

    public Integer getMarginLeftRaw() {
        return this.marginLeft;
    }

    public String getAlign() {
        return this.align;
    }

    public String getJustify() {
        return this.justify;
    }

    public String getBackground() {
        return this.background;
    }

    public String getBorderColor() {
        return this.borderColor;
    }

    public String getWidth() {
        return this.width;
    }

    public String getHeight() {
        return this.height;
    }

    public String getVisible() {
        return this.visible;
    }

    public String getMinWidth() {
        return this.minWidth;
    }

    public String getMaxWidth() {
        return this.maxWidth;
    }

    public String getMinHeight() {
        return this.minHeight;
    }

    public String getMaxHeight() {
        return this.maxHeight;
    }

    public Integer getBorderWidth() {
        return this.borderWidth;
    }

    public Integer getBorderRadius() {
        return this.borderRadius;
    }

    public String getShadow() {
        return this.shadow;
    }

    public Float getOpacity() {
        return this.opacity;
    }

    public Float getRotation() {
        return this.rotation;
    }

    public Float getScale() {
        return this.scale;
    }

    public JsonObject getHoverStyle() {
        return this.hoverStyle;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setPadding(Integer padding) {
        this.padding = padding;
    }

    public void setPaddingTop(Integer paddingTop) {
        this.paddingTop = paddingTop;
    }

    public void setPaddingRight(Integer paddingRight) {
        this.paddingRight = paddingRight;
    }

    public void setPaddingBottom(Integer paddingBottom) {
        this.paddingBottom = paddingBottom;
    }

    public void setPaddingLeft(Integer paddingLeft) {
        this.paddingLeft = paddingLeft;
    }

    public void setMargin(Integer margin) {
        this.margin = margin;
    }

    public void setMarginTop(Integer marginTop) {
        this.marginTop = marginTop;
    }

    public void setMarginRight(Integer marginRight) {
        this.marginRight = marginRight;
    }

    public void setMarginBottom(Integer marginBottom) {
        this.marginBottom = marginBottom;
    }

    public void setMarginLeft(Integer marginLeft) {
        this.marginLeft = marginLeft;
    }

    public void setAlign(String align) {
        this.align = align;
    }

    public void setJustify(String justify) {
        this.justify = justify;
    }

    public void setBackground(String background) {
        this.background = background;
    }

    public void setBorderColor(String borderColor) {
        this.borderColor = borderColor;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public void setMinWidth(String minWidth) {
        this.minWidth = minWidth;
    }

    public void setMaxWidth(String maxWidth) {
        this.maxWidth = maxWidth;
    }

    public void setMinHeight(String minHeight) {
        this.minHeight = minHeight;
    }

    public void setMaxHeight(String maxHeight) {
        this.maxHeight = maxHeight;
    }

    public void setBorderWidth(Integer borderWidth) {
        this.borderWidth = borderWidth;
    }

    public void setBorderRadius(Integer borderRadius) {
        this.borderRadius = borderRadius;
    }

    public void setShadow(String shadow) {
        this.shadow = shadow;
    }

    public void setOpacity(Float opacity) {
        this.opacity = opacity;
    }

    public void setRotation(Float rotation) {
        this.rotation = rotation;
    }

    public void setScale(Float scale) {
        this.scale = scale;
    }

    public void setVisible(String visible) {
        this.visible = visible;
    }

    public void setHoverStyle(JsonObject hoverStyle) {
        this.hoverStyle = hoverStyle;
    }

    public static PanelNode fromJson(JsonObject json) {
        PanelNode node;
        String type;
        if (!json.has("type")) {
            return null;
        }
        switch (type = json.get("type").getAsString()) {
            case "vstack": {
                PanelNode panelNode = new VStackNode();
                break;
            }
            case "hstack": {
                PanelNode panelNode = new HStackNode();
                break;
            }
            case "stack": {
                PanelNode panelNode = new StackNode();
                break;
            }
            case "scroll": {
                PanelNode panelNode = new ScrollNode();
                break;
            }
            case "text": {
                PanelNode panelNode = new TextNode();
                break;
            }
            case "richtext": {
                PanelNode panelNode = new RichTextNode();
                break;
            }
            case "icon": {
                PanelNode panelNode = new IconNode();
                break;
            }
            case "image": {
                PanelNode panelNode = new ImageNode();
                break;
            }
            case "image_list": {
                PanelNode panelNode = new ImageListNode();
                break;
            }
            case "list": {
                PanelNode panelNode = new ListNode();
                break;
            }
            case "button": {
                PanelNode panelNode = new ButtonNode();
                break;
            }
            case "spacer": {
                PanelNode panelNode = new SpacerNode();
                break;
            }
            case "conditional": {
                PanelNode panelNode = new ConditionalNode();
                break;
            }
            case "grid": {
                PanelNode panelNode = new GridNode();
                break;
            }
            case "progress": {
                PanelNode panelNode = new ProgressBarNode();
                break;
            }
            case "slider": {
                PanelNode panelNode = new SliderNode();
                break;
            }
            case "divider": {
                PanelNode panelNode = new DividerNode();
                break;
            }
            case "tabs": {
                PanelNode panelNode = new TabContainerNode();
                break;
            }
            default: {
                PanelNode panelNode = node = null;
            }
        }
        if (node != null) {
            node.applyCommonProperties(json);
            node.parseSpecificProperties(json);
        }
        return node;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", this.getType());
        if (this.id != null) {
            json.addProperty("id", this.id);
        }
        if (this.padding != null) {
            json.addProperty("padding", (Number)this.padding);
        }
        if (this.paddingTop != null) {
            json.addProperty("paddingTop", (Number)this.paddingTop);
        }
        if (this.paddingRight != null) {
            json.addProperty("paddingRight", (Number)this.paddingRight);
        }
        if (this.paddingBottom != null) {
            json.addProperty("paddingBottom", (Number)this.paddingBottom);
        }
        if (this.paddingLeft != null) {
            json.addProperty("paddingLeft", (Number)this.paddingLeft);
        }
        if (this.margin != null) {
            json.addProperty("margin", (Number)this.margin);
        }
        if (this.marginTop != null) {
            json.addProperty("marginTop", (Number)this.marginTop);
        }
        if (this.marginRight != null) {
            json.addProperty("marginRight", (Number)this.marginRight);
        }
        if (this.marginBottom != null) {
            json.addProperty("marginBottom", (Number)this.marginBottom);
        }
        if (this.marginLeft != null) {
            json.addProperty("marginLeft", (Number)this.marginLeft);
        }
        if (this.align != null) {
            json.addProperty("align", this.align);
        }
        if (this.justify != null) {
            json.addProperty("justify", this.justify);
        }
        if (this.width != null) {
            json.addProperty("width", this.width);
        }
        if (this.height != null) {
            json.addProperty("height", this.height);
        }
        if (this.minWidth != null) {
            json.addProperty("minWidth", this.minWidth);
        }
        if (this.maxWidth != null) {
            json.addProperty("maxWidth", this.maxWidth);
        }
        if (this.minHeight != null) {
            json.addProperty("minHeight", this.minHeight);
        }
        if (this.maxHeight != null) {
            json.addProperty("maxHeight", this.maxHeight);
        }
        if (this.background != null) {
            json.addProperty("background", this.background);
        }
        if (this.borderColor != null) {
            json.addProperty("borderColor", this.borderColor);
        }
        if (this.borderWidth != null) {
            json.addProperty("borderWidth", (Number)this.borderWidth);
        }
        if (this.borderRadius != null) {
            json.addProperty("borderRadius", (Number)this.borderRadius);
        }
        if (this.shadow != null) {
            json.addProperty("shadow", this.shadow);
        }
        if (this.opacity != null) {
            json.addProperty("opacity", (Number)this.opacity);
        }
        if (this.rotation != null) {
            json.addProperty("rotation", (Number)this.rotation);
        }
        if (this.scale != null) {
            json.addProperty("scale", (Number)this.scale);
        }
        if (this.visible != null) {
            json.addProperty("visible", this.visible);
        }
        if (this.hoverStyle != null) {
            json.add("hoverStyle", (JsonElement)this.hoverStyle);
        }
        this.addSpecificProperties(json);
        return json;
    }

    protected abstract void addSpecificProperties(JsonObject var1);

    public abstract PanelNode deepCopy();

    protected void copyCommonProperties(PanelNode target) {
        target.id = this.id;
        target.padding = this.padding;
        target.paddingTop = this.paddingTop;
        target.paddingRight = this.paddingRight;
        target.paddingBottom = this.paddingBottom;
        target.paddingLeft = this.paddingLeft;
        target.margin = this.margin;
        target.marginTop = this.marginTop;
        target.marginRight = this.marginRight;
        target.marginBottom = this.marginBottom;
        target.marginLeft = this.marginLeft;
        target.align = this.align;
        target.justify = this.justify;
        target.background = this.background;
        target.borderColor = this.borderColor;
        target.width = this.width;
        target.height = this.height;
        target.minWidth = this.minWidth;
        target.maxWidth = this.maxWidth;
        target.minHeight = this.minHeight;
        target.maxHeight = this.maxHeight;
        target.borderWidth = this.borderWidth;
        target.borderRadius = this.borderRadius;
        target.shadow = this.shadow;
        target.opacity = this.opacity;
        target.rotation = this.rotation;
        target.scale = this.scale;
        target.visible = this.visible;
        target.hoverStyle = this.hoverStyle;
    }

    protected abstract void parseSpecificProperties(JsonObject var1);
}

