/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.theme.panel;

import com.google.gson.JsonObject;
import com.mojang.blaze3d.systems.RenderSystem;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_757;
import net.minecraft.class_7833;
import org.joml.Matrix4f;
import org.texboobcat.questory.client.gui.QuestIconRenderer;
import org.texboobcat.questory.client.gui.TextFormatter;
import org.texboobcat.questory.client.rendering.ThemeIconRenderer;
import org.texboobcat.questory.theme.panel.BindingContext;
import org.texboobcat.questory.theme.panel.ButtonNode;
import org.texboobcat.questory.theme.panel.ConditionalNode;
import org.texboobcat.questory.theme.panel.DividerNode;
import org.texboobcat.questory.theme.panel.Expression;
import org.texboobcat.questory.theme.panel.GradientParser;
import org.texboobcat.questory.theme.panel.GridNode;
import org.texboobcat.questory.theme.panel.HStackNode;
import org.texboobcat.questory.theme.panel.IconNode;
import org.texboobcat.questory.theme.panel.ImageListNode;
import org.texboobcat.questory.theme.panel.ImageNode;
import org.texboobcat.questory.theme.panel.ListNode;
import org.texboobcat.questory.theme.panel.PanelNode;
import org.texboobcat.questory.theme.panel.PanelTemplate;
import org.texboobcat.questory.theme.panel.ProgressBarNode;
import org.texboobcat.questory.theme.panel.RichTextNode;
import org.texboobcat.questory.theme.panel.ScrollNode;
import org.texboobcat.questory.theme.panel.SliderNode;
import org.texboobcat.questory.theme.panel.SpacerNode;
import org.texboobcat.questory.theme.panel.StackNode;
import org.texboobcat.questory.theme.panel.TabContainerNode;
import org.texboobcat.questory.theme.panel.TextNode;
import org.texboobcat.questory.theme.panel.VStackNode;
import org.texboobcat.questory.theme.property.IconProperty;
import org.texboobcat.questory.theme.property.ThemeProperties;

public class PanelRenderer {
    private final class_327 font;
    private int scrollOffset = 0;
    private final Map<PanelNode, Rect> nodeBounds = new HashMap<PanelNode, Rect>();
    private final List<ButtonTarget> buttonTargets = new ArrayList<ButtonTarget>();
    private final Map<String, Runnable> eventHandlers = new HashMap<String, Runnable>();
    private final List<PanelNode> drawOrder = new ArrayList<PanelNode>();
    private PanelNode hoveredNode;

    public Rect getNodeBounds(PanelNode node) {
        return this.nodeBounds.get(node);
    }

    public PanelRenderer() {
        this.font = class_310.method_1551().field_1772;
    }

    public void setScrollOffset(int offset) {
        this.scrollOffset = offset;
    }

    public int getScrollOffset() {
        return this.scrollOffset;
    }

    public void setHoveredNode(PanelNode hoveredNode) {
        this.hoveredNode = hoveredNode;
    }

    public void registerEventHandler(String event, Runnable handler) {
        this.eventHandlers.put(event, handler);
    }

    public void render(PanelTemplate template, BindingContext context, class_332 graphics, int x, int y, int width, int height) {
        this.render(template, context, graphics, x, y, width, height, -1, -1);
    }

    public void render(PanelTemplate template, BindingContext context, class_332 graphics, int x, int y, int width, int height, int mouseX, int mouseY) {
        if (template == null || template.getRoot() == null) {
            return;
        }
        this.buttonTargets.clear();
        this.nodeBounds.clear();
        this.drawOrder.clear();
        this.renderNode(template.getRoot(), context, graphics, x, y, width, height, mouseX, mouseY);
    }

    private int renderNode(PanelNode node, BindingContext context, class_332 graphics, int x, int y, int availWidth, int availHeight) {
        return this.renderNode(node, context, graphics, x, y, availWidth, availHeight, -1, -1);
    }

    private int renderNode(PanelNode node, BindingContext context, class_332 graphics, int x, int y, int availWidth, int availHeight, int mouseX, int mouseY) {
        int c;
        float scale;
        if (node == null) {
            return 0;
        }
        if (node.getVisible() != null && !Expression.evaluateBoolean(node.getVisible(), context)) {
            return 0;
        }
        int pTop = node.getPaddingTop();
        int pRight = node.getPaddingRight();
        int pBottom = node.getPaddingBottom();
        int pLeft = node.getPaddingLeft();
        int mTop = node.getMarginTop();
        int mRight = node.getMarginRight();
        int mBottom = node.getMarginBottom();
        int mLeft = node.getMarginLeft();
        int contentX = x + pLeft + mLeft;
        int contentY = y + pTop + mTop;
        int contentWidth = availWidth - pLeft - pRight - mLeft - mRight;
        int contentHeight = availHeight - pTop - pBottom - mTop - mBottom;
        String background = node.getBackground();
        String borderColor = node.getBorderColor();
        Integer borderWidth = node.getBorderWidth();
        Integer borderRadius = node.getBorderRadius();
        String shadow = node.getShadow();
        float opacity = node.getOpacity() != null ? node.getOpacity().floatValue() : 1.0f;
        float rotation = node.getRotation() != null ? node.getRotation().floatValue() : 0.0f;
        float f = scale = node.getScale() != null ? node.getScale().floatValue() : 1.0f;
        if (this.hoveredNode != null && this.hoveredNode == node && node.getHoverStyle() != null) {
            JsonObject hover = node.getHoverStyle();
            if (hover.has("background")) {
                background = hover.get("background").getAsString();
            }
            if (hover.has("borderColor")) {
                borderColor = hover.get("borderColor").getAsString();
            }
            if (hover.has("borderWidth")) {
                try {
                    borderWidth = hover.get("borderWidth").getAsInt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (hover.has("borderRadius")) {
                try {
                    borderRadius = hover.get("borderRadius").getAsInt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (hover.has("shadow")) {
                shadow = hover.get("shadow").getAsString();
            }
            if (hover.has("opacity")) {
                try {
                    opacity = hover.get("opacity").getAsFloat();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (hover.has("rotation")) {
                try {
                    rotation = hover.get("rotation").getAsFloat();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (hover.has("scale")) {
                try {
                    scale = hover.get("scale").getAsFloat();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        class_4587 pose = graphics.method_51448();
        boolean transformed = false;
        if (rotation != 0.0f || scale != 1.0f) {
            transformed = true;
            pose.method_22903();
            float centerX = (float)x + (float)availWidth / 2.0f;
            float centerY = (float)y + (float)availHeight / 2.0f;
            pose.method_46416(centerX, centerY, 0.0f);
            if (rotation != 0.0f) {
                pose.method_22907(class_7833.field_40718.rotationDegrees(rotation));
            }
            if (scale != 1.0f) {
                pose.method_22905(scale, scale, 1.0f);
            }
            pose.method_46416(-centerX, -centerY, 0.0f);
        }
        if (shadow != null && !shadow.isEmpty()) {
            this.renderShadow(graphics, shadow, x, y, availWidth, availHeight, context);
        }
        if (background != null) {
            int br = borderRadius != null ? borderRadius : 0;
            this.renderBackground(graphics, background, x, y, availWidth, availHeight, opacity, br, context);
        }
        this.drawOrder.add(node);
        int renderedHeight = switch (node.getType()) {
            case "vstack" -> this.renderVStack((VStackNode)node, context, graphics, contentX, contentY, contentWidth, contentHeight, mouseX, mouseY);
            case "hstack" -> this.renderHStack((HStackNode)node, context, graphics, contentX, contentY, contentWidth, contentHeight, mouseX, mouseY);
            case "stack" -> this.renderStack((StackNode)node, context, graphics, contentX, contentY, contentWidth, contentHeight, mouseX, mouseY);
            case "scroll" -> this.renderScroll((ScrollNode)node, context, graphics, contentX, contentY, contentWidth, contentHeight, mouseX, mouseY);
            case "text" -> this.renderText((TextNode)node, context, graphics, contentX, contentY, contentWidth);
            case "richtext" -> this.renderRichText((RichTextNode)node, context, graphics, contentX, contentY, contentWidth);
            case "icon" -> this.renderIcon((IconNode)node, context, graphics, contentX, contentY);
            case "list" -> this.renderList((ListNode)node, context, graphics, contentX, contentY, contentWidth, contentHeight, mouseX, mouseY);
            case "button" -> this.renderButton((ButtonNode)node, context, graphics, contentX, contentY);
            case "spacer" -> this.renderSpacer((SpacerNode)node);
            case "conditional" -> this.renderConditional((ConditionalNode)node, context, graphics, contentX, contentY, contentWidth, contentHeight, mouseX, mouseY);
            case "image" -> this.renderImage((ImageNode)node, context, graphics, contentX, contentY, contentWidth, contentHeight);
            case "image_list" -> this.renderImageList((ImageListNode)node, context, graphics, contentX, contentY, contentWidth, contentHeight);
            case "grid" -> this.renderGrid((GridNode)node, context, graphics, contentX, contentY, contentWidth, contentHeight, mouseX, mouseY);
            case "progress" -> this.renderProgressBar((ProgressBarNode)node, context, graphics, contentX, contentY, contentWidth, contentHeight);
            case "slider" -> this.renderSlider((SliderNode)node, context, graphics, contentX, contentY, contentWidth);
            case "divider" -> this.renderDivider((DividerNode)node, context, graphics, contentX, contentY, contentWidth, contentHeight);
            case "tabs" -> this.renderTabs((TabContainerNode)node, context, graphics, contentX, contentY, contentWidth, contentHeight, mouseX, mouseY);
            default -> 0;
        };
        int totalHeight = renderedHeight + pTop + pBottom + mTop + mBottom;
        this.nodeBounds.put(node, new Rect(x, y, availWidth, totalHeight));
        if (borderColor != null && (c = Expression.evaluateColor(borderColor, context, 0)) >>> 24 != 0) {
            int bw = borderWidth != null ? borderWidth : 1;
            int br = borderRadius != null ? borderRadius : 0;
            this.renderBorder(graphics, x, y, availWidth, totalHeight, c, bw, br);
        }
        if (transformed) {
            pose.method_22909();
        }
        return totalHeight;
    }

    private void renderShadow(class_332 graphics, String shadow, int x, int y, int w, int h, BindingContext context) {
        String[] parts = shadow.trim().split("\\s+");
        if (parts.length < 4) {
            return;
        }
        try {
            int layers;
            int offsetX = Integer.parseInt(parts[0]);
            int offsetY = Integer.parseInt(parts[1]);
            int blur = Integer.parseInt(parts[2]);
            int color = Expression.evaluateColor(parts[3], context, Integer.MIN_VALUE);
            int i = layers = Math.max(1, blur / 2);
            while (i >= 0) {
                int alpha = (color >>> 24) / (layers + 1) * (layers - i + 1);
                int layerColor = alpha << 24 | color & 0xFFFFFF;
                int expand = i--;
                graphics.method_25294(x + offsetX - expand, y + offsetY - expand, x + w + offsetX + expand, y + h + offsetY + expand, layerColor);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void renderBackground(class_332 graphics, String background, int x, int y, int w, int h, float opacity, int borderRadius, BindingContext context) {
        IconProperty themeBg = this.tryResolveThemeIconProperty(background, context);
        if (themeBg != null) {
            ThemeIconRenderer.draw(graphics, themeBg, x, y, w, h);
            return;
        }
        if (background.startsWith("linear-gradient") || background.startsWith("radial-gradient")) {
            this.renderGradient(graphics, background, x, y, w, h, opacity, borderRadius, context);
            return;
        }
        Object bgObj = Expression.evaluateBinding(background, context);
        if (bgObj instanceof IconProperty.IconData) {
            IconProperty.IconData data = (IconProperty.IconData)bgObj;
            ThemeIconRenderer.draw(graphics, data, x, y, w, h);
            return;
        }
        int bgColor = Expression.evaluateColor(background, context, Integer.MIN_VALUE);
        if (opacity < 1.0f) {
            int alpha = (int)((float)(bgColor >>> 24 & 0xFF) * opacity);
            bgColor = alpha << 24 | bgColor & 0xFFFFFF;
        }
        if (borderRadius > 0) {
            this.fillRoundedRect(graphics, x, y, w, h, borderRadius, bgColor);
        } else {
            graphics.method_25294(x, y, x + w, y + h, bgColor);
        }
    }

    private void renderGradient(class_332 graphics, String gradient, int x, int y, int w, int h, float opacity, int borderRadius, BindingContext context) {
        GradientParser.GradientData data = GradientParser.parse(gradient, context);
        if (data == null || data.colors().length < 2) {
            return;
        }
        int[] colors = data.colors();
        float angle = data.angle();
        if (opacity < 1.0f) {
            for (int i = 0; i < colors.length; ++i) {
                int alpha = (int)((float)(colors[i] >>> 24 & 0xFF) * opacity);
                colors[i] = alpha << 24 | colors[i] & 0xFFFFFF;
            }
        }
        if (data.isRadial()) {
            this.fillRadialGradient(graphics, x, y, w, h, colors, borderRadius);
        } else {
            this.fillLinearGradient(graphics, x, y, w, h, colors, angle, borderRadius);
        }
    }

    private void fillLinearGradient(class_332 graphics, int x, int y, int w, int h, int[] colors, float angle, int radius) {
        int steps;
        if (w <= 0 || h <= 0 || colors.length < 2) {
            return;
        }
        int startColor = colors[0];
        int endColor = colors[colors.length - 1];
        boolean horizontal = angle >= 45.0f && angle < 135.0f || angle >= 225.0f && angle < 315.0f;
        int n = steps = horizontal ? w : h;
        if (steps <= 0) {
            return;
        }
        if (horizontal) {
            this.fillGradientQuad(graphics, x, y, x + w, y + h, startColor, endColor, endColor, startColor);
        } else {
            this.fillGradientQuad(graphics, x, y, x + w, y + h, startColor, startColor, endColor, endColor);
        }
    }

    private void fillGradientQuad(class_332 graphics, int x1, int y1, int x2, int y2, int colorTL, int colorTR, int colorBR, int colorBL) {
        if (x2 <= x1 || y2 <= y1) {
            return;
        }
        Matrix4f pose = graphics.method_51448().method_23760().method_23761();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        class_287 buffer = class_289.method_1348().method_1349();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        this.putVertex(buffer, pose, x1, y1, colorTL);
        this.putVertex(buffer, pose, x2, y1, colorTR);
        this.putVertex(buffer, pose, x2, y2, colorBR);
        this.putVertex(buffer, pose, x1, y2, colorBL);
        class_286.method_43433((class_287.class_7433)buffer.method_1326());
        RenderSystem.disableBlend();
    }

    private void putVertex(class_287 buffer, Matrix4f pose, int x, int y, int argb) {
        float a = (float)(argb >>> 24 & 0xFF) / 255.0f;
        float r = (float)(argb >>> 16 & 0xFF) / 255.0f;
        float g = (float)(argb >>> 8 & 0xFF) / 255.0f;
        float b = (float)(argb & 0xFF) / 255.0f;
        buffer.method_22918(pose, (float)x, (float)y, 0.0f).method_22915(r, g, b, a).method_1344();
    }

    private void fillRadialGradient(class_332 graphics, int x, int y, int w, int h, int[] colors, int radius) {
        int steps;
        if (w <= 0 || h <= 0 || colors.length < 2) {
            return;
        }
        int centerColor = colors[0];
        int edgeColor = colors[colors.length - 1];
        int cx = x + w / 2;
        int cy = y + h / 2;
        int maxRadius = (int)Math.sqrt(w * w + h * h) / 2;
        if (maxRadius <= 0) {
            graphics.method_25294(x, y, x + w, y + h, centerColor);
            return;
        }
        for (int i = steps = Math.min(maxRadius, 32); i >= 0; --i) {
            float t = (float)i / (float)steps;
            int color = this.interpolateColor(centerColor, edgeColor, t);
            int rx = (int)((float)w * t / 2.0f);
            int ry = (int)((float)h * t / 2.0f);
            graphics.method_25294(cx - rx, cy - ry, cx + rx, cy + ry, color);
        }
    }

    private int interpolateColor(int c1, int c2, float t) {
        int a1 = c1 >>> 24 & 0xFF;
        int r1 = c1 >>> 16 & 0xFF;
        int g1 = c1 >>> 8 & 0xFF;
        int b1 = c1 & 0xFF;
        int a2 = c2 >>> 24 & 0xFF;
        int r2 = c2 >>> 16 & 0xFF;
        int g2 = c2 >>> 8 & 0xFF;
        int b2 = c2 & 0xFF;
        int a = (int)((float)a1 + (float)(a2 - a1) * t);
        int r = (int)((float)r1 + (float)(r2 - r1) * t);
        int g = (int)((float)g1 + (float)(g2 - g1) * t);
        int b = (int)((float)b1 + (float)(b2 - b1) * t);
        return a << 24 | r << 16 | g << 8 | b;
    }

    private void fillRoundedRect(class_332 graphics, int x, int y, int w, int h, int radius, int color) {
        radius = Math.min(radius, Math.min(w / 2, h / 2));
        graphics.method_25294(x + radius, y, x + w - radius, y + h, color);
        graphics.method_25294(x, y + radius, x + radius, y + h - radius, color);
        graphics.method_25294(x + w - radius, y + radius, x + w, y + h - radius, color);
        this.fillCircleQuadrant(graphics, x + radius, y + radius, radius, color, 2);
        this.fillCircleQuadrant(graphics, x + w - radius - 1, y + radius, radius, color, 1);
        this.fillCircleQuadrant(graphics, x + radius, y + h - radius - 1, radius, color, 3);
        this.fillCircleQuadrant(graphics, x + w - radius - 1, y + h - radius - 1, radius, color, 0);
    }

    private void fillCircleQuadrant(class_332 graphics, int cx, int cy, int r, int color, int quadrant) {
        for (int dy = 0; dy <= r; ++dy) {
            block7: for (int dx = 0; dx <= r; ++dx) {
                int py;
                int px;
                if (dx * dx + dy * dy > r * r) continue;
                switch (quadrant) {
                    case 0: {
                        px = cx + dx;
                        py = cy + dy;
                        break;
                    }
                    case 1: {
                        px = cx + dx;
                        py = cy - dy;
                        break;
                    }
                    case 2: {
                        px = cx - dx;
                        py = cy - dy;
                        break;
                    }
                    case 3: {
                        px = cx - dx;
                        py = cy + dy;
                        break;
                    }
                    default: {
                        continue block7;
                    }
                }
                graphics.method_25294(px, py, px + 1, py + 1, color);
            }
        }
    }

    private void renderBorder(class_332 graphics, int x, int y, int w, int h, int color, int width, int radius) {
        if (radius > 0) {
            for (int i = 0; i < width; ++i) {
                this.drawRoundedOutline(graphics, x + i, y + i, w - 2 * i, h - 2 * i, Math.max(0, radius - i), color);
            }
        } else {
            graphics.method_25294(x, y, x + w, y + width, color);
            graphics.method_25294(x, y + h - width, x + w, y + h, color);
            graphics.method_25294(x, y + width, x + width, y + h - width, color);
            graphics.method_25294(x + w - width, y + width, x + w, y + h - width, color);
        }
    }

    private void drawRoundedOutline(class_332 graphics, int x, int y, int w, int h, int radius, int color) {
        radius = Math.min(radius, Math.min(w / 2, h / 2));
        graphics.method_25294(x + radius, y, x + w - radius, y + 1, color);
        graphics.method_25294(x + radius, y + h - 1, x + w - radius, y + h, color);
        graphics.method_25294(x, y + radius, x + 1, y + h - radius, color);
        graphics.method_25294(x + w - 1, y + radius, x + w, y + h - radius, color);
        this.drawArc(graphics, x + radius, y + radius, radius, color, 2);
        this.drawArc(graphics, x + w - radius - 1, y + radius, radius, color, 1);
        this.drawArc(graphics, x + radius, y + h - radius - 1, radius, color, 3);
        this.drawArc(graphics, x + w - radius - 1, y + h - radius - 1, radius, color, 0);
    }

    private void drawArc(class_332 graphics, int cx, int cy, int r, int color, int quadrant) {
        for (int i = 0; i <= 90; ++i) {
            double angle = Math.toRadians(i + quadrant * 90);
            int px = cx + (int)((double)r * Math.cos(angle));
            int py = cy - (int)((double)r * Math.sin(angle));
            graphics.method_25294(px, py, px + 1, py + 1, color);
        }
    }

    private int renderDivider(DividerNode node, BindingContext context, class_332 graphics, int x, int y, int width, int height) {
        boolean horizontal = !"vertical".equalsIgnoreCase(node.getOrientation());
        int thickness = node.getThickness() != null ? node.getThickness() : 1;
        int color = Expression.evaluateColor(node.getColor(), context, -1);
        if (horizontal) {
            int lineY = y + height / 2 - thickness / 2;
            graphics.method_25294(x, lineY, x + width, lineY + thickness, color);
            return thickness;
        }
        int lineX = x + width / 2 - thickness / 2;
        graphics.method_25294(lineX, y, lineX + thickness, y + height, color);
        return height;
    }

    private int renderTabs(TabContainerNode node, BindingContext context, class_332 graphics, int x, int y, int width, int height, int mouseX, int mouseY) {
        List<TabContainerNode.Tab> tabs = node.getTabs();
        if (tabs == null || tabs.isEmpty()) {
            return 0;
        }
        int tabSpacing = node.getTabSpacing() != null ? node.getTabSpacing() : 2;
        int tabHeight = 20;
        int selectedIndex = 0;
        String selectedTab = node.getSelectedTab();
        if (selectedTab != null) {
            try {
                selectedIndex = Integer.parseInt(selectedTab);
            }
            catch (NumberFormatException e) {
                for (int i = 0; i < tabs.size(); ++i) {
                    if (!selectedTab.equals(tabs.get((int)i).id)) continue;
                    selectedIndex = i;
                    break;
                }
            }
        }
        selectedIndex = Math.max(0, Math.min(selectedIndex, tabs.size() - 1));
        int tabBg = Expression.evaluateColor(node.getTabBackground() != null ? node.getTabBackground() : "#FF404040", context, -12566464);
        int activeTabBg = Expression.evaluateColor(node.getActiveTabBackground() != null ? node.getActiveTabBackground() : "#FF606060", context, -10461088);
        int tabColor = Expression.evaluateColor(node.getTabColor() != null ? node.getTabColor() : "#FFFFFFFF", context, -1);
        int activeTabColor = Expression.evaluateColor(node.getActiveTabColor() != null ? node.getActiveTabColor() : "#FFFFFFFF", context, -1);
        int tabX = x;
        for (int i = 0; i < tabs.size(); ++i) {
            TabContainerNode.Tab tab = tabs.get(i);
            String label = tab.label != null ? tab.label : "Tab " + (i + 1);
            int labelWidth = this.font.method_1727(label);
            int tabWidth = labelWidth + 12;
            boolean hasIcon = tab.icon != null && !tab.icon.isEmpty();
            int iconSize = 12;
            int iconPadding = hasIcon ? iconSize + 4 : 0;
            tabWidth += iconPadding;
            int tabBgLocal = tabBg;
            int activeTabBgLocal = activeTabBg;
            int tabColorLocal = tabColor;
            int activeTabColorLocal = activeTabColor;
            if (tab.style != null && !tab.style.isEmpty()) {
                String style;
                switch (style = tab.style.toLowerCase(Locale.ROOT)) {
                    case "primary": {
                        activeTabBgLocal = -12952934;
                        activeTabColorLocal = -1;
                        break;
                    }
                    case "danger": {
                        activeTabBgLocal = -5225404;
                        activeTabColorLocal = -1;
                        break;
                    }
                    case "success": {
                        activeTabBgLocal = -12809668;
                        activeTabColorLocal = -1;
                        break;
                    }
                    case "warning": {
                        activeTabBgLocal = -2056192;
                        activeTabColorLocal = -15000805;
                        break;
                    }
                }
                if (!style.equals("none")) {
                    tabBgLocal = this.darkenColor(activeTabBgLocal, 0.6f);
                }
            }
            boolean isActive = i == selectedIndex;
            boolean isHovered = mouseX >= tabX && mouseX < tabX + tabWidth && mouseY >= y && mouseY < y + tabHeight;
            int bg = isActive ? activeTabBgLocal : tabBgLocal;
            int fg = isActive ? activeTabColorLocal : tabColorLocal;
            graphics.method_25294(tabX, y, tabX + tabWidth, y + tabHeight, bg);
            if (isHovered && !isActive) {
                graphics.method_25294(tabX, y + tabHeight - 2, tabX + tabWidth, y + tabHeight, -2130706433);
            }
            int contentLeft = tabX + 6;
            if (hasIcon) {
                try {
                    String iconExpr = tab.icon;
                    if (iconExpr != null && !iconExpr.isEmpty()) {
                        QuestIconRenderer.render(graphics, iconExpr, contentLeft, y + (tabHeight - iconSize) / 2, iconSize);
                        contentLeft += iconSize + 4;
                    }
                }
                catch (Throwable iconExpr) {
                    // empty catch block
                }
            }
            int labelX = contentLeft + Math.max(0, (tabWidth - (contentLeft - tabX) - 6 - labelWidth) / 2);
            Objects.requireNonNull(this.font);
            int labelY = y + (tabHeight - 9) / 2;
            graphics.method_51433(this.font, label, labelX, labelY, fg, false);
            this.buttonTargets.add(new ButtonTarget(tabX, y, tabWidth, tabHeight, "select_tab_" + i));
            tabX += tabWidth + tabSpacing;
        }
        int contentY = y + tabHeight + 2;
        int contentHeight = height - tabHeight - 2;
        graphics.method_25294(x, contentY, x + width, contentY + contentHeight, tabBg);
        if (selectedIndex >= 0 && selectedIndex < tabs.size()) {
            TabContainerNode.Tab activeTab = tabs.get(selectedIndex);
            if (activeTab.content != null) {
                this.renderNode(activeTab.content, context, graphics, x + 2, contentY + 2, width - 4, contentHeight - 4, mouseX, mouseY);
            }
        }
        return height;
    }

    private int darkenColor(int color, float factor) {
        int a = color >>> 24 & 0xFF;
        int r = (int)((float)(color >>> 16 & 0xFF) * factor);
        int g = (int)((float)(color >>> 8 & 0xFF) * factor);
        int b = (int)((float)(color & 0xFF) * factor);
        return a << 24 | r << 16 | g << 8 | b;
    }

    private int renderVStack(VStackNode node, BindingContext context, class_332 graphics, int x, int y, int width, int height, int mouseX, int mouseY) {
        int spacing = node.getSpacing() != null ? node.getSpacing() : 0;
        int count = node.getChildren().size();
        if (count == 0) {
            return 0;
        }
        int[] allocH = new int[count];
        int totalFixed = 0;
        int fillCount = 0;
        for (int i = 0; i < count; ++i) {
            String hspec = node.getChildren().get(i).getHeight();
            if (hspec == null || this.isAuto(hspec)) {
                allocH[i] = -1;
                continue;
            }
            if (this.isFill(hspec)) {
                allocH[i] = -2;
                ++fillCount;
                continue;
            }
            Integer px = this.parseSize(hspec, height);
            int n = allocH[i] = px != null ? Math.max(0, px) : -1;
            if (allocH[i] < 0) continue;
            totalFixed += allocH[i];
        }
        int totalSpacing = spacing * Math.max(0, count - 1);
        int remaining = Math.max(0, height - totalFixed - totalSpacing);
        int perFill = fillCount > 0 ? remaining / fillCount : 0;
        for (int i = 0; i < count; ++i) {
            if (allocH[i] != -2) continue;
            allocH[i] = perFill;
            remaining -= perFill;
        }
        int autos = 0;
        for (int v : allocH) {
            if (v >= 0) continue;
            ++autos;
        }
        int perAuto = autos > 0 ? remaining / autos : 0;
        for (int i = 0; i < count; ++i) {
            if (allocH[i] >= 0) continue;
            allocH[i] = perAuto;
            remaining -= perAuto;
        }
        int blockHeight = 0;
        for (int v : allocH) {
            blockHeight += v;
        }
        blockHeight += spacing * (count - 1);
        String justify = node.getJustify() != null ? node.getJustify() : "start";
        int offsetY = 0;
        if (justify.equals("center")) {
            offsetY = Math.max(0, (height - blockHeight) / 2);
        } else if (justify.equals("end") || justify.equals("bottom")) {
            offsetY = Math.max(0, height - blockHeight);
        } else if (justify.equals("space_between") && count > 1) {
            int extra = Math.max(0, height - blockHeight);
            spacing += extra / (count - 1);
        }
        String align = node.getAlign() != null ? node.getAlign() : "start";
        int currentY = y + offsetY;
        int maxY = 0;
        for (int i = 0; i < count; ++i) {
            PanelNode child = node.getChildren().get(i);
            int childWidth = this.resolveWidth(child.getWidth(), width);
            int childX = switch (align) {
                case "center" -> x + (width - childWidth) / 2;
                case "end", "right" -> x + (width - childWidth);
                default -> x;
            };
            int used = this.renderNode(child, context, graphics, childX, currentY, childWidth, allocH[i], mouseX, mouseY);
            maxY = currentY += used + spacing;
        }
        return Math.max(0, maxY - y - spacing);
    }

    private int renderHStack(HStackNode node, BindingContext context, class_332 graphics, int x, int y, int width, int height, int mouseX, int mouseY) {
        int spacing = node.getSpacing() != null ? node.getSpacing() : 0;
        int count = node.getChildren().size();
        if (count == 0) {
            return 0;
        }
        int[] allocW = new int[count];
        int fixedW = 0;
        int fills = 0;
        for (int i = 0; i < count; ++i) {
            String wspec = node.getChildren().get(i).getWidth();
            if (wspec == null || this.isAuto(wspec)) {
                allocW[i] = -1;
                continue;
            }
            if (this.isFill(wspec)) {
                allocW[i] = -2;
                ++fills;
                continue;
            }
            Integer px = this.parseSize(wspec, width);
            int n = allocW[i] = px != null ? Math.max(0, px) : -1;
            if (allocW[i] < 0) continue;
            fixedW += allocW[i];
        }
        int totalSpacing = spacing * Math.max(0, count - 1);
        int remaining = Math.max(0, width - fixedW - totalSpacing);
        int perFill = fills > 0 ? remaining / fills : 0;
        for (int i = 0; i < count; ++i) {
            if (allocW[i] != -2) continue;
            allocW[i] = perFill;
            remaining -= perFill;
        }
        int autos = 0;
        for (int v : allocW) {
            if (v >= 0) continue;
            ++autos;
        }
        int perAuto = autos > 0 ? remaining / autos : 0;
        for (int i = 0; i < count; ++i) {
            if (allocW[i] >= 0) continue;
            allocW[i] = perAuto;
            remaining -= perAuto;
        }
        int blockWidth = 0;
        for (int v : allocW) {
            blockWidth += v;
        }
        blockWidth += spacing * (count - 1);
        String justify = node.getJustify() != null ? node.getJustify() : "start";
        int offsetX = 0;
        if (justify.equals("center")) {
            offsetX = Math.max(0, (width - blockWidth) / 2);
        } else if (justify.equals("end") || justify.equals("right")) {
            offsetX = Math.max(0, width - blockWidth);
        } else if (justify.equals("space_between") && count > 1) {
            int extra = Math.max(0, width - blockWidth);
            spacing += extra / (count - 1);
        }
        String align = node.getAlign() != null ? node.getAlign() : "start";
        int currentX = x + offsetX;
        int maxH = 0;
        for (int i = 0; i < count; ++i) {
            PanelNode child = node.getChildren().get(i);
            int chAlloc = this.resolveHeight(child.getHeight(), height);
            int childHeight = this.resolveHeight(child.getHeight(), height);
            int childY = switch (align) {
                case "center" -> y + (height - childHeight) / 2;
                case "end", "bottom" -> y + (height - childHeight);
                default -> y;
            };
            int used = this.renderNode(child, context, graphics, currentX, childY, allocW[i], childHeight, mouseX, mouseY);
            currentX += allocW[i] + spacing;
            maxH = Math.max(maxH, used);
        }
        return maxH;
    }

    private int renderStack(StackNode node, BindingContext context, class_332 graphics, int x, int y, int width, int height, int mouseX, int mouseY) {
        int maxHeight = 0;
        for (PanelNode child : node.getChildren()) {
            int cw = this.resolveWidth(child.getWidth(), width);
            int ch = this.resolveHeight(child.getHeight(), height);
            int used = this.renderNode(child, context, graphics, x, y, cw, ch, mouseX, mouseY);
            maxHeight = Math.max(maxHeight, used);
        }
        return maxHeight;
    }

    private int renderScroll(ScrollNode node, BindingContext context, class_332 graphics, int x, int y, int width, int height, int mouseX, int mouseY) {
        if (node.getChild() == null) {
            return 0;
        }
        graphics.method_44379(x, y, x + width, y + height);
        int contentHeight = this.renderNode(node.getChild(), context, graphics, x, y - this.scrollOffset, width, height + this.scrollOffset, mouseX, mouseY);
        graphics.method_44380();
        return height;
    }

    private int renderText(TextNode node, BindingContext context, class_332 graphics, int x, int y, int width) {
        String[] parts;
        int textX;
        boolean wrap;
        Object text = Expression.evaluate(node.getText(), context);
        if (text == null || ((String)text).isEmpty()) {
            return 0;
        }
        int color = Expression.evaluateInt(node.getColor(), context, -1);
        float fontSize = node.getFontSize() != null ? node.getFontSize().floatValue() : 1.0f;
        String textAlign = node.getTextAlign() != null ? node.getTextAlign() : "left";
        String textShadow = node.getTextShadow();
        boolean bold = node.getBold() != null && node.getBold() != false;
        boolean italic = node.getItalic() != null && node.getItalic() != false;
        boolean bl = wrap = node.getWrap() == null || node.getWrap() != false;
        if (bold || italic) {
            StringBuilder prefix = new StringBuilder("\u00a7");
            if (bold) {
                prefix.append("l");
            }
            if (italic) {
                prefix.append("o");
            }
            text = String.valueOf(prefix) + (String)text + "\u00a7r";
        }
        class_4587 pose = graphics.method_51448();
        boolean scaled = fontSize != 1.0f;
        int textWidth = this.font.method_1727((String)text);
        int scaledWidth = (int)((float)textWidth * fontSize);
        switch (textAlign) {
            case "center": {
                int n = x + (width - scaledWidth) / 2;
                break;
            }
            case "right": {
                int n = x + width - scaledWidth;
                break;
            }
            default: {
                int n = textX = x;
            }
        }
        if (scaled) {
            pose.method_22903();
            pose.method_46416((float)textX, (float)y, 0.0f);
            pose.method_22905(fontSize, fontSize, 1.0f);
            pose.method_46416((float)(-textX), (float)(-y), 0.0f);
        }
        if (textShadow != null && !textShadow.isEmpty() && (parts = textShadow.trim().split("\\s+")).length >= 3) {
            try {
                int shadowX = Integer.parseInt(parts[0]);
                int shadowY = Integer.parseInt(parts[1]);
                int shadowColor = Expression.evaluateColor(parts[2], context, Integer.MIN_VALUE);
                graphics.method_51433(this.font, (String)text, textX + shadowX, y + shadowY, shadowColor, false);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        graphics.method_51433(this.font, (String)text, textX, y, color, false);
        if (scaled) {
            pose.method_22909();
        }
        Objects.requireNonNull(this.font);
        return (int)(9.0f * fontSize);
    }

    private int renderRichText(RichTextNode node, BindingContext context, class_332 graphics, int x, int y, int width) {
        String text = Expression.evaluate(node.getText(), context);
        int color = Expression.evaluateInt(node.getColor(), context, -1);
        class_2561 formatted = TextFormatter.parse(text);
        List lines = this.font.method_1728((class_5348)formatted, width);
        int currentY = y;
        for (class_5481 line : lines) {
            graphics.method_35720(this.font, line, x, currentY, color);
            Objects.requireNonNull(this.font);
            currentY += 9;
        }
        int n = lines.size();
        Objects.requireNonNull(this.font);
        return n * 9;
    }

    private int renderIcon(IconNode node, BindingContext context, class_332 graphics, int x, int y) {
        int size = node.getSize() != null ? node.getSize() : 16;
        String expr = node.getValue();
        if (expr == null || expr.isEmpty()) {
            return size;
        }
        IconProperty themeProp = this.tryResolveThemeIconProperty(expr, context);
        if (themeProp != null) {
            ThemeIconRenderer.draw(graphics, themeProp, x, y, size, size);
            return size;
        }
        if (expr.contains("${")) {
            Object v = Expression.evaluateBinding(expr, context);
            if (v instanceof IconProperty.IconData) {
                IconProperty.IconData data = (IconProperty.IconData)v;
                ThemeIconRenderer.draw(graphics, data, x, y, size, size);
                return size;
            }
            String s = Expression.evaluate(expr, context);
            if (s != null && !s.isEmpty()) {
                QuestIconRenderer.render(graphics, s, x, y, size);
            }
            return size;
        }
        QuestIconRenderer.render(graphics, expr, x, y, size);
        return size;
    }

    private int renderList(ListNode node, BindingContext context, class_332 graphics, int x, int y, int width, int height, int mouseX, int mouseY) {
        String itemsPath = node.getItems();
        Object itemsObj = Expression.evaluateBinding(itemsPath, context);
        if (!(itemsObj instanceof List)) {
            return 0;
        }
        List items = (List)itemsObj;
        int currentY = y;
        int totalHeight = 0;
        for (Object item : items) {
            context.put("item", item);
            if (node.getItemTemplate() == null) continue;
            int itemHeight = this.renderNode(node.getItemTemplate(), context, graphics, x, currentY, width, height - totalHeight, mouseX, mouseY);
            currentY += itemHeight;
            totalHeight += itemHeight;
        }
        context.put("item", null);
        return totalHeight;
    }

    private int renderButton(ButtonNode node, BindingContext context, class_332 graphics, int x, int y) {
        String text = Expression.evaluate(node.getText(), context);
        boolean enabled = node.getEnabled() == null || Expression.evaluateBoolean(node.getEnabled(), context);
        int textWidth = this.font.method_1727(text);
        int buttonWidth = textWidth + 8;
        Objects.requireNonNull(this.font);
        int buttonHeight = 9 + 4;
        int bgColor = enabled ? -12303292 : -14540254;
        int textColor = enabled ? -1 : -7829368;
        graphics.method_25294(x, y, x + buttonWidth, y + buttonHeight, bgColor);
        graphics.method_25303(this.font, text, x + 4, y + 2, textColor);
        if (enabled && node.getOnClick() != null) {
            String eventName = Expression.evaluate(node.getOnClick(), context);
            this.buttonTargets.add(new ButtonTarget(x, y, buttonWidth, buttonHeight, eventName));
        }
        return buttonHeight;
    }

    private int renderSpacer(SpacerNode node) {
        return node.getSize() != null ? node.getSize() : 8;
    }

    private int renderConditional(ConditionalNode node, BindingContext context, class_332 graphics, int x, int y, int width, int height, int mouseX, int mouseY) {
        boolean condition = Expression.evaluateBoolean(node.getWhen(), context);
        if (condition && node.getChild() != null) {
            return this.renderNode(node.getChild(), context, graphics, x, y, width, height, mouseX, mouseY);
        }
        return 0;
    }

    private int renderImage(ImageNode node, BindingContext context, class_332 graphics, int x, int y, int width, int height) {
        int max;
        int size;
        String texture = Expression.evaluate(node.getSrc(), context);
        if (texture == null || texture.isEmpty()) {
            return 0;
        }
        int n = width > 0 ? width : (size = height > 0 ? height : 32);
        if (node.getWidth() != null) {
            size = Expression.evaluateInt(node.getWidth(), context, size);
        } else if (node.getHeight() != null) {
            size = Expression.evaluateInt(node.getHeight(), context, size);
        }
        if (node.getMaxWidth() != null && size > (max = Expression.evaluateInt(node.getMaxWidth(), context, Integer.MAX_VALUE))) {
            size = max;
        }
        QuestIconRenderer.render(graphics, texture, x, y, size);
        return size;
    }

    private int renderImageList(ImageListNode node, BindingContext context, class_332 graphics, int x, int y, int width, int height) {
        String itemsPath = node.getItems();
        Object itemsObj = Expression.evaluateBinding(itemsPath, context);
        if (!(itemsObj instanceof List)) {
            return 0;
        }
        List items = (List)itemsObj;
        int currentX = x;
        int currentY = y;
        int itemSize = 16;
        int spacing = 2;
        int actualWidth = width;
        if (node.getMaxWidth() != null) {
            try {
                int max = Integer.parseInt(node.getMaxWidth());
                if (actualWidth > max) {
                    actualWidth = max;
                }
            }
            catch (NumberFormatException max) {
                // empty catch block
            }
        }
        int maxHeight = itemSize;
        for (Object item : items) {
            context.put("item", item);
            String texture = item.toString();
            if (currentX + itemSize > x + actualWidth) {
                currentX = x;
                currentY += itemSize + spacing;
                maxHeight += itemSize + spacing;
            }
            QuestIconRenderer.render(graphics, texture, currentX, currentY, itemSize);
            currentX += itemSize + spacing;
        }
        context.put("item", null);
        return maxHeight;
    }

    public boolean handleClick(int mouseX, int mouseY) {
        for (ButtonTarget target : this.buttonTargets) {
            if (!target.contains(mouseX, mouseY)) continue;
            this.handleEvent(target.onClick);
            return true;
        }
        return false;
    }

    private void handleEvent(String eventName) {
        if (eventName == null) {
            return;
        }
        Runnable handler = this.eventHandlers.get(eventName);
        if (handler != null) {
            handler.run();
        }
    }

    public void handleScroll(double delta) {
        this.scrollOffset = Math.max(0, this.scrollOffset - (int)(delta * 10.0));
    }

    private boolean isFill(String spec) {
        return spec != null && spec.equalsIgnoreCase("fill");
    }

    private boolean isAuto(String spec) {
        return spec == null || spec.isEmpty() || spec.equalsIgnoreCase("auto");
    }

    private Integer parseSize(String spec, int parent) {
        if (spec == null) {
            return null;
        }
        String s = spec.trim();
        if (s.endsWith("%")) {
            try {
                double p = Double.parseDouble(s.substring(0, s.length() - 1));
                return (int)Math.round((double)parent * (p / 100.0));
            }
            catch (Exception ignored) {
                return null;
            }
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private int resolveWidth(String spec, int parent) {
        if (this.isAuto(spec) || this.isFill(spec)) {
            return parent;
        }
        Integer px = this.parseSize(spec, parent);
        return px != null ? Math.max(0, px) : parent;
    }

    private int resolveHeight(String spec, int parent) {
        if (this.isAuto(spec) || this.isFill(spec)) {
            return parent;
        }
        Integer px = this.parseSize(spec, parent);
        return px != null ? Math.max(0, px) : parent;
    }

    private IconProperty tryResolveThemeIconProperty(String expr, BindingContext context) {
        if (expr == null) {
            return null;
        }
        String raw = expr.trim();
        if (!raw.startsWith("${") || !raw.endsWith("}")) {
            return null;
        }
        String inner = raw.substring(2, raw.length() - 1).trim();
        if (inner.contains(" ? ") && inner.contains(" : ")) {
            int qm = inner.indexOf(" ? ");
            int col = inner.indexOf(" : ", qm + 3);
            if (qm > 0 && col > qm) {
                String cond = inner.substring(0, qm);
                String whenTrue = inner.substring(qm + 3, col).trim();
                String whenFalse = inner.substring(col + 3).trim();
                boolean pickTrue = Expression.evaluateBoolean(cond, context);
                String string = inner = pickTrue ? whenTrue : whenFalse;
            }
        }
        if (inner.startsWith("theme.")) {
            String key = inner.substring("theme.".length());
            try {
                Field fld = ThemeProperties.class.getField(key.toUpperCase());
                Object v = fld.get(null);
                if (v instanceof IconProperty) {
                    IconProperty ip = (IconProperty)v;
                    return ip;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public PanelNode findTopmostNodeAtPoint(int px, int py) {
        for (int i = this.drawOrder.size() - 1; i >= 0; --i) {
            PanelNode n = this.drawOrder.get(i);
            Rect r = this.nodeBounds.get(n);
            if (r == null || px < r.x() || px > r.x() + r.width() || py < r.y() || py > r.y() + r.height()) continue;
            return n;
        }
        return null;
    }

    private int renderGrid(GridNode node, BindingContext context, class_332 graphics, int x, int y, int width, int height, int mouseX, int mouseY) {
        int columns = node.getColumns() != null ? node.getColumns() : 2;
        int gap = node.getGap() != null ? node.getGap() : 4;
        List<PanelNode> children = node.getChildren();
        if (children.isEmpty()) {
            return 0;
        }
        int cellWidth = (width - (columns - 1) * gap) / columns;
        int currentX = x;
        int currentY = y;
        int rowHeight = 0;
        int maxY = y;
        int col = 0;
        for (PanelNode child : children) {
            int childHeight = this.resolveHeight(child.getHeight(), height);
            int used = this.renderNode(child, context, graphics, currentX, currentY, cellWidth, childHeight, mouseX, mouseY);
            rowHeight = Math.max(rowHeight, used);
            if (++col >= columns) {
                col = 0;
                currentX = x;
                maxY = currentY += rowHeight + gap;
                rowHeight = 0;
                continue;
            }
            currentX += cellWidth + gap;
        }
        if (col > 0) {
            maxY = currentY + rowHeight;
        }
        return Math.max(0, maxY - y);
    }

    private int renderProgressBar(ProgressBarNode node, BindingContext context, class_332 graphics, int x, int y, int width, int height) {
        boolean horizontal;
        double value = Expression.evaluateInt(node.getValue(), context, 0);
        double max = Expression.evaluateInt(node.getMax(), context, 100);
        if (max <= 0.0) {
            max = 100.0;
        }
        double ratio = Math.max(0.0, Math.min(1.0, value / max));
        int barHeight = node.getBarHeight() != null ? node.getBarHeight() : 8;
        int bgColor = Expression.evaluateColor(node.getBackgroundColor(), context, -13619152);
        int fillColor = Expression.evaluateColor(node.getColor(), context, -10167196);
        boolean bl = horizontal = !"vertical".equalsIgnoreCase(node.getDirection());
        if (horizontal) {
            graphics.method_25294(x, y, x + width, y + barHeight, bgColor);
            int fillWidth = (int)((double)width * ratio);
            graphics.method_25294(x, y, x + fillWidth, y + barHeight, fillColor);
            return barHeight;
        }
        int barWidth = barHeight;
        graphics.method_25294(x, y, x + barWidth, y + height, bgColor);
        int fillHeight = (int)((double)height * ratio);
        graphics.method_25294(x, y + height - fillHeight, x + barWidth, y + height, fillColor);
        return height;
    }

    private int renderSlider(SliderNode node, BindingContext context, class_332 graphics, int x, int y, int width) {
        int thumbHeight;
        double min = Expression.evaluateInt(node.getMin(), context, 0);
        double max = Expression.evaluateInt(node.getMax(), context, 100);
        double value = Expression.evaluateInt(node.getValue(), context, 50);
        if (max <= min) {
            max = min + 1.0;
        }
        double ratio = Math.max(0.0, Math.min(1.0, (value - min) / (max - min)));
        int trackHeight = node.getTrackHeight() != null ? node.getTrackHeight() : 6;
        int thumbWidth = 8;
        int totalHeight = thumbHeight = trackHeight + 6;
        int trackColor = Expression.evaluateColor(node.getTrackColor(), context, -12566464);
        int thumbColor = Expression.evaluateColor(node.getThumbColor(), context, -1);
        int trackY = y + (totalHeight - trackHeight) / 2;
        graphics.method_25294(x, trackY, x + width, trackY + trackHeight, trackColor);
        int thumbX = x + (int)((double)(width - thumbWidth) * ratio);
        int thumbY = y;
        graphics.method_25294(thumbX, thumbY, thumbX + thumbWidth, thumbY + thumbHeight, thumbColor);
        graphics.method_49601(thumbX, thumbY, thumbWidth, thumbHeight, -16777216);
        return totalHeight;
    }

    public record Rect(int x, int y, int width, int height) {
    }

    public static class ButtonTarget {
        public final int x;
        public final int y;
        public final int width;
        public final int height;
        public final String onClick;

        public ButtonTarget(int x, int y, int width, int height, String onClick) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.onClick = onClick;
        }

        public boolean contains(int mx, int my) {
            return mx >= this.x && mx <= this.x + this.width && my >= this.y && my <= this.y + this.height;
        }
    }
}

