/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.theme.panel;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import org.texboobcat.questory.theme.panel.PanelNode;

public class TabContainerNode
extends PanelNode {
    private List<Tab> tabs = new ArrayList<Tab>();
    private String selectedTab;
    private String tabPosition = "top";
    private Integer tabSpacing = 2;
    private String tabBackground;
    private String activeTabBackground;
    private String tabColor;
    private String activeTabColor;

    @Override
    public String getType() {
        return "tabs";
    }

    @Override
    protected void parseSpecificProperties(JsonObject json) {
        if (json.has("selectedTab")) {
            this.selectedTab = json.get("selectedTab").getAsString();
        }
        if (json.has("tabPosition")) {
            this.tabPosition = json.get("tabPosition").getAsString();
        }
        if (json.has("tabSpacing")) {
            this.tabSpacing = json.get("tabSpacing").getAsInt();
        }
        if (json.has("tabBackground")) {
            this.tabBackground = json.get("tabBackground").getAsString();
        }
        if (json.has("activeTabBackground")) {
            this.activeTabBackground = json.get("activeTabBackground").getAsString();
        }
        if (json.has("tabColor")) {
            this.tabColor = json.get("tabColor").getAsString();
        }
        if (json.has("activeTabColor")) {
            this.activeTabColor = json.get("activeTabColor").getAsString();
        }
        if (json.has("tabs") && json.get("tabs").isJsonArray()) {
            JsonArray tabsArray = json.getAsJsonArray("tabs");
            for (JsonElement el : tabsArray) {
                if (!el.isJsonObject()) continue;
                this.tabs.add(Tab.fromJson(el.getAsJsonObject()));
            }
        }
    }

    @Override
    protected void addSpecificProperties(JsonObject json) {
        if (this.selectedTab != null) {
            json.addProperty("selectedTab", this.selectedTab);
        }
        if (this.tabPosition != null) {
            json.addProperty("tabPosition", this.tabPosition);
        }
        if (this.tabSpacing != null) {
            json.addProperty("tabSpacing", (Number)this.tabSpacing);
        }
        if (this.tabBackground != null) {
            json.addProperty("tabBackground", this.tabBackground);
        }
        if (this.activeTabBackground != null) {
            json.addProperty("activeTabBackground", this.activeTabBackground);
        }
        if (this.tabColor != null) {
            json.addProperty("tabColor", this.tabColor);
        }
        if (this.activeTabColor != null) {
            json.addProperty("activeTabColor", this.activeTabColor);
        }
        if (!this.tabs.isEmpty()) {
            JsonArray arr = new JsonArray();
            for (Tab tab : this.tabs) {
                arr.add((JsonElement)tab.toJson());
            }
            json.add("tabs", (JsonElement)arr);
        }
    }

    @Override
    public PanelNode deepCopy() {
        TabContainerNode copy = new TabContainerNode();
        this.copyCommonProperties(copy);
        copy.selectedTab = this.selectedTab;
        copy.tabPosition = this.tabPosition;
        copy.tabSpacing = this.tabSpacing;
        copy.tabBackground = this.tabBackground;
        copy.activeTabBackground = this.activeTabBackground;
        copy.tabColor = this.tabColor;
        copy.activeTabColor = this.activeTabColor;
        for (Tab tab : this.tabs) {
            Tab copyTab = new Tab();
            copyTab.id = tab.id;
            copyTab.label = tab.label;
            copyTab.icon = tab.icon;
            copyTab.style = tab.style;
            copyTab.content = tab.content != null ? tab.content.deepCopy() : null;
            copy.tabs.add(copyTab);
        }
        return copy;
    }

    public List<Tab> getTabs() {
        return this.tabs;
    }

    public void setTabs(List<Tab> tabs) {
        this.tabs = tabs;
    }

    public String getSelectedTab() {
        return this.selectedTab;
    }

    public void setSelectedTab(String selectedTab) {
        this.selectedTab = selectedTab;
    }

    public String getTabPosition() {
        return this.tabPosition;
    }

    public void setTabPosition(String tabPosition) {
        this.tabPosition = tabPosition;
    }

    public Integer getTabSpacing() {
        return this.tabSpacing;
    }

    public void setTabSpacing(Integer tabSpacing) {
        this.tabSpacing = tabSpacing;
    }

    public String getTabBackground() {
        return this.tabBackground;
    }

    public void setTabBackground(String tabBackground) {
        this.tabBackground = tabBackground;
    }

    public String getActiveTabBackground() {
        return this.activeTabBackground;
    }

    public void setActiveTabBackground(String activeTabBackground) {
        this.activeTabBackground = activeTabBackground;
    }

    public String getTabColor() {
        return this.tabColor;
    }

    public void setTabColor(String tabColor) {
        this.tabColor = tabColor;
    }

    public String getActiveTabColor() {
        return this.activeTabColor;
    }

    public void setActiveTabColor(String activeTabColor) {
        this.activeTabColor = activeTabColor;
    }

    public static class Tab {
        public String label;
        public String id;
        public PanelNode content;
        public String icon;
        public String style;

        public Tab() {
        }

        public Tab(String id, String label, PanelNode content) {
            this.id = id;
            this.label = label;
            this.content = content;
        }

        public JsonObject toJson() {
            JsonObject json = new JsonObject();
            if (this.id != null) {
                json.addProperty("id", this.id);
            }
            if (this.label != null) {
                json.addProperty("label", this.label);
            }
            if (this.icon != null) {
                json.addProperty("icon", this.icon);
            }
            if (this.style != null) {
                json.addProperty("style", this.style);
            }
            if (this.content != null) {
                json.add("content", (JsonElement)this.content.toJson());
            }
            return json;
        }

        public static Tab fromJson(JsonObject json) {
            Tab tab = new Tab();
            if (json.has("id")) {
                tab.id = json.get("id").getAsString();
            }
            if (json.has("label")) {
                tab.label = json.get("label").getAsString();
            }
            if (json.has("icon")) {
                tab.icon = json.get("icon").getAsString();
            }
            if (json.has("style")) {
                tab.style = json.get("style").getAsString();
            }
            if (json.has("content") && json.get("content").isJsonObject()) {
                tab.content = PanelNode.fromJson(json.get("content").getAsJsonObject());
            }
            return tab;
        }
    }
}

