/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.questory.theme.property;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import org.texboobcat.questory.theme.property.ColorProperty;
import org.texboobcat.questory.theme.property.ThemeProperty;

public class IconProperty
extends ThemeProperty<IconData> {
    private static final ColorProperty COLOR_PARSER = new ColorProperty("temp");

    public IconProperty(String name) {
        super(name, new IconData("", new HashMap<String, String>()));
    }

    public IconProperty(String name, String defaultValue) {
        super(name, new IconData(defaultValue, new HashMap<String, String>()));
    }

    @Override
    public IconData parse(String string) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        if ((string = string.trim()).equals("none") || string.equals("builtin")) {
            return new IconData(string, new HashMap<String, String>());
        }
        if (string.startsWith("item:") || string.startsWith("tag:")) {
            return new IconData(string, new HashMap<String, String>());
        }
        HashMap<String, String> modifiers = new HashMap<String, String>();
        if (string.startsWith("#") || string.startsWith("0x") || string.startsWith("0X")) {
            modifiers.put("color", string);
            return new IconData("", modifiers);
        }
        if (string.contains(" + ")) {
            modifiers.put("composite", "true");
            modifiers.put("raw", string);
            String firstPart = string.split("\\+")[0].trim();
            if (firstPart.contains(";")) {
                firstPart = firstPart.split(";")[0].trim();
            }
            return new IconData(firstPart, modifiers);
        }
        if (string.startsWith("hollow_rectangle:") || string.startsWith("rectangle:") || string.startsWith("filled_rectangle:") || string.startsWith("circle:") || string.startsWith("filled_circle:")) {
            int colonIdx = string.indexOf(58);
            String shapeType = string.substring(0, colonIdx);
            String colorPart = string.substring(colonIdx + 1).trim();
            modifiers.put("shape", shapeType);
            modifiers.put("shape_color", colorPart);
            return new IconData(shapeType, modifiers);
        }
        if (string.startsWith("part:")) {
            String partDef = string.substring(5).trim();
            String[] parts = partDef.split(";");
            String texPath = parts[0].trim();
            for (int i = 1; i < parts.length; ++i) {
                String part = parts[i].trim();
                String[] keyValue = part.split("=", 2);
                if (keyValue.length != 2) continue;
                modifiers.put(keyValue[0].trim(), keyValue[1].trim());
            }
            modifiers.put("part", "true");
            return new IconData(texPath, modifiers);
        }
        if (string.startsWith("round_edges")) {
            modifiers.put("round_edges", "true");
            String rest = string.substring("round_edges".length()).trim();
            if (rest.startsWith("+")) {
                rest = rest.substring(1).trim();
            }
            if (!rest.isEmpty()) {
                modifiers.put("raw", rest);
            }
            return new IconData("round_edges", modifiers);
        }
        String texturePath = string;
        if (string.startsWith("texture:")) {
            texturePath = string.substring("texture:".length()).trim();
        }
        String[] parts = texturePath.split(";");
        String path = parts[0].trim();
        for (int i = 1; i < parts.length; ++i) {
            String part = parts[i].trim();
            String[] keyValue = part.split("=", 2);
            if (keyValue.length != 2) continue;
            modifiers.put(keyValue[0].trim(), keyValue[1].trim());
        }
        return new IconData(path, modifiers);
    }

    public String getTexturePath() {
        IconData data = (IconData)this.get();
        return data != null ? data.path : "";
    }

    public String getModifier(String key) {
        IconData data = (IconData)this.get();
        return data != null && data.modifiers != null ? data.modifiers.get(key) : null;
    }

    public Integer getColorModifier() {
        String colorStr = this.getModifier("color");
        if (colorStr != null) {
            return COLOR_PARSER.parse(colorStr);
        }
        return null;
    }

    public Integer getTileSize() {
        String sizeStr = this.getModifier("tile_size");
        if (sizeStr != null) {
            try {
                return Integer.parseInt(sizeStr);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    public Integer getPadding() {
        String paddingStr = this.getModifier("padding");
        if (paddingStr != null) {
            try {
                return Integer.parseInt(paddingStr);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    public class_2960 getResourceLocation() {
        String value = this.getTexturePath();
        if (value == null || value.isEmpty() || value.equals("none") || value.equals("builtin")) {
            return null;
        }
        if (value.startsWith("item:") || value.startsWith("tag:")) {
            return null;
        }
        String lowerValue = value.toLowerCase();
        if (lowerValue.startsWith("hollow_rectangle") || lowerValue.startsWith("rectangle") || lowerValue.startsWith("square") || lowerValue.startsWith("filled_rectangle") || lowerValue.startsWith("circle") || lowerValue.startsWith("filled_circle")) {
            return null;
        }
        try {
            String namespace = "minecraft";
            Object path = value;
            if (value.contains(":")) {
                String[] parts = value.split(":", 2);
                namespace = parts[0];
                path = parts[1];
            } else {
                try {
                    namespace = "ftbquests";
                }
                catch (Exception ignored) {
                    namespace = "minecraft";
                }
            }
            if (!((String)path).startsWith("textures/")) {
                path = "textures/" + (String)path;
            }
            if (!((String)path).endsWith(".png")) {
                path = (String)path + ".png";
            }
            return new class_2960(namespace, (String)path);
        }
        catch (Exception e) {
            System.err.println("Failed to parse icon ResourceLocation: " + value);
            return null;
        }
    }

    public static class IconData {
        public final String path;
        public final Map<String, String> modifiers;

        public IconData(String path, Map<String, String> modifiers) {
            this.path = path;
            this.modifiers = modifiers;
        }

        public boolean isComposite() {
            return "true".equals(this.modifiers.get("composite"));
        }

        public boolean isShape() {
            return this.modifiers.containsKey("shape");
        }

        public String getShapeType() {
            return this.modifiers.get("shape");
        }

        public String getShapeColor() {
            return this.modifiers.get("shape_color");
        }

        public boolean isPart() {
            return "true".equals(this.modifiers.get("part"));
        }

        public boolean hasRoundEdges() {
            return "true".equals(this.modifiers.get("round_edges"));
        }

        public String getRaw() {
            return this.modifiers.get("raw");
        }

        public int[] getPartPosition() {
            String pos = this.modifiers.get("pos");
            if (pos == null) {
                return null;
            }
            try {
                String[] parts = pos.split(",");
                if (parts.length >= 4) {
                    return new int[]{Integer.parseInt(parts[0].trim()), Integer.parseInt(parts[1].trim()), Integer.parseInt(parts[2].trim()), Integer.parseInt(parts[3].trim())};
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return null;
        }

        public Integer getCorner() {
            String corner = this.modifiers.get("corner");
            if (corner != null) {
                try {
                    return Integer.parseInt(corner.trim());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return null;
        }

        public String toString() {
            if (this.modifiers.isEmpty()) {
                return this.path;
            }
            StringBuilder sb = new StringBuilder(this.path);
            for (Map.Entry<String, String> entry : this.modifiers.entrySet()) {
                sb.append("; ").append(entry.getKey()).append("=").append(entry.getValue());
            }
            return sb.toString();
        }
    }
}

